/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;

@Dependent
@Alternative
@Priority(value=1000)
public class DateGsonConverter
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    public JsonElement serialize(Date date, Type typeOfSrc, JsonSerializationContext context) {
        String dateString = this.getFormat().format(date);
        return new JsonPrimitive(dateString);
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return this.getFormat().parse(json.getAsString());
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(json.getAsString(), (Throwable)e);
        }
    }

    protected DateFormat getFormat() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    }
}

