/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.gson;

import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.serialization.Serializee;
import br.com.caelum.vraptor.serialization.SkipSerialization;
import br.com.caelum.vraptor.serialization.gson.GsonSerializer;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import java.lang.reflect.Field;
import java.util.Map;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class Exclusions
implements ExclusionStrategy {
    private final Serializee serializee;
    private final ReflectionProvider reflectionProvider;

    public Exclusions(Serializee serializee, ReflectionProvider reflectionProvider) {
        this.serializee = serializee;
        this.reflectionProvider = reflectionProvider;
    }

    public boolean shouldSkipField(FieldAttributes f) {
        SkipSerialization annotation = (SkipSerialization)f.getAnnotation(SkipSerialization.class);
        if (annotation != null) {
            return true;
        }
        String fieldName = f.getName();
        Class definedIn = f.getDeclaringClass();
        for (Map.Entry include : this.serializee.getIncludes().entries()) {
            if (!this.isCompatiblePath(include, definedIn, fieldName)) continue;
            return false;
        }
        for (Map.Entry exclude : this.serializee.getExcludes().entries()) {
            if (!this.isCompatiblePath(exclude, definedIn, fieldName)) continue;
            return true;
        }
        Field field = this.reflectionProvider.getField(definedIn, fieldName);
        return !this.serializee.isRecursive() && !GsonSerializer.shouldSerializeField(field.getType());
    }

    private boolean isCompatiblePath(Map.Entry<String, Class<?>> path, Class<?> definedIn, String fieldName) {
        return path.getValue().equals(definedIn) && (path.getKey().equals(fieldName) || path.getKey().endsWith("." + fieldName));
    }

    public boolean shouldSkipClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(SkipSerialization.class);
    }
}

