/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.gson;

import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.proxy.CDIProxies;
import br.com.caelum.vraptor.serialization.Serializee;
import br.com.caelum.vraptor.serialization.gson.Exclusions;
import br.com.caelum.vraptor.serialization.gson.GsonDeserializerBuilder;
import br.com.caelum.vraptor.serialization.gson.GsonSerializerBuilder;
import br.com.caelum.vraptor.serialization.gson.RegisterStrategy;
import br.com.caelum.vraptor.serialization.gson.RegisterType;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;

@Dependent
public class GsonBuilderWrapper
implements GsonSerializerBuilder,
GsonDeserializerBuilder {
    private final GsonBuilder builder = new GsonBuilder();
    private boolean withoutRoot;
    private String alias;
    private final List<ExclusionStrategy> exclusions;
    private final Serializee serializee;
    private final Iterable<JsonSerializer<?>> jsonSerializers;
    private final Iterable<JsonDeserializer<?>> jsonDeserializers;

    @Inject
    public GsonBuilderWrapper(@Any Instance<JsonSerializer<?>> jsonSerializers, @Any Instance<JsonDeserializer<?>> jsonDeserializers, Serializee serializee, ReflectionProvider reflectionProvider) {
        this.jsonSerializers = jsonSerializers;
        this.jsonDeserializers = jsonDeserializers;
        this.serializee = serializee;
        Exclusions exclusion = new Exclusions(serializee, reflectionProvider);
        this.exclusions = Collections.singletonList(exclusion);
    }

    @Override
    public Gson create() {
        for (JsonSerializer<?> jsonSerializer : this.jsonSerializers) {
            this.registerAdapter(this.getAdapterType(jsonSerializer), jsonSerializer);
        }
        for (JsonDeserializer jsonDeserializer : this.jsonDeserializers) {
            this.registerAdapter(this.getAdapterType(jsonDeserializer), jsonDeserializer);
        }
        for (ExclusionStrategy exclusionStrategy : this.exclusions) {
            this.getGsonBuilder().addSerializationExclusionStrategy(exclusionStrategy);
        }
        return this.getGsonBuilder().create();
    }

    protected void registerAdapter(Class<?> adapterType, Object adapter) {
        RegisterStrategy registerStrategy = adapter.getClass().getAnnotation(RegisterStrategy.class);
        if (registerStrategy != null && registerStrategy.value().equals((Object)RegisterType.SINGLE)) {
            this.getGsonBuilder().registerTypeAdapter(adapterType, adapter);
        } else {
            this.getGsonBuilder().registerTypeHierarchyAdapter(adapterType, adapter);
        }
    }

    private Class<?> getAdapterType(Object adapter) {
        Class<?> klazz = CDIProxies.extractRawTypeIfPossible(adapter.getClass());
        Type[] genericInterfaces = klazz.getGenericInterfaces();
        ParameterizedType type = (ParameterizedType)genericInterfaces[0];
        Type actualType = type.getActualTypeArguments()[0];
        if (actualType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)actualType).getRawType();
        }
        return (Class)actualType;
    }

    @Override
    public Serializee getSerializee() {
        return this.serializee;
    }

    @Override
    public boolean isWithoutRoot() {
        return this.withoutRoot;
    }

    @Override
    public void setWithoutRoot(boolean withoutRoot) {
        this.withoutRoot = withoutRoot;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public void indented() {
        this.getGsonBuilder().setPrettyPrinting();
    }

    @Override
    public void setExclusionStrategies(ExclusionStrategy ... strategies) {
        this.getGsonBuilder().setExclusionStrategies(strategies);
    }

    protected GsonBuilder getGsonBuilder() {
        return this.builder;
    }

    @Override
    public void version(double versionNumber) {
        this.getGsonBuilder().setVersion(versionNumber);
    }

    @Override
    public void serializeNulls() {
        this.getGsonBuilder().serializeNulls();
    }
}

