/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.gson;

import br.com.caelum.vraptor.Consumes;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.ioc.Container;
import br.com.caelum.vraptor.serialization.Deserializee;
import br.com.caelum.vraptor.serialization.Deserializer;
import br.com.caelum.vraptor.serialization.DeserializerConfig;
import br.com.caelum.vraptor.serialization.Deserializes;
import br.com.caelum.vraptor.serialization.gson.GsonDeserializerBuilder;
import br.com.caelum.vraptor.view.ResultException;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.Charset;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deserializes(value={"application/json", "json"})
public class GsonDeserialization
implements Deserializer {
    private static final Logger logger = LoggerFactory.getLogger(GsonDeserialization.class);
    private final GsonDeserializerBuilder builder;
    private final ParameterNameProvider paramNameProvider;
    private final HttpServletRequest request;
    private final Container container;
    private final Instance<Deserializee> deserializeeInstance;

    protected GsonDeserialization() {
        this(null, null, null, null, null);
    }

    @Inject
    public GsonDeserialization(GsonDeserializerBuilder builder, ParameterNameProvider paramNameProvider, HttpServletRequest request, Container container, Instance<Deserializee> deserializeeInstance) {
        this.builder = builder;
        this.paramNameProvider = paramNameProvider;
        this.request = request;
        this.container = container;
        this.deserializeeInstance = deserializeeInstance;
    }

    @Override
    public Object[] deserialize(InputStream inputStream, ControllerMethod method) {
        Object[] values;
        block11: {
            Class<?>[] types = this.getTypes(method);
            if (types.length == 0) {
                throw new IllegalArgumentException("Methods that consumes representations must receive just one argument");
            }
            Gson gson = this.builder.create();
            Parameter[] parameterNames = this.paramNameProvider.parametersFor(method.getMethod());
            values = new Object[parameterNames.length];
            Deserializee deserializee = (Deserializee)this.deserializeeInstance.get();
            try {
                String content = this.getContentOfStream(inputStream);
                logger.debug("json retrieved: {}", (Object)content);
                if (Strings.isNullOrEmpty((String)content)) break block11;
                JsonParser parser = new JsonParser();
                JsonElement jsonElement = parser.parse(content);
                if (jsonElement.isJsonObject()) {
                    JsonObject root = jsonElement.getAsJsonObject();
                    deserializee.setWithoutRoot(GsonDeserialization.isWithoutRoot(parameterNames, root));
                    for (Class<? extends DeserializerConfig> option : method.getMethod().getAnnotation(Consumes.class).options()) {
                        DeserializerConfig config = this.container.instanceFor(option);
                        config.config(deserializee);
                    }
                    for (int i = 0; i < types.length; ++i) {
                        Parameter parameter = parameterNames[i];
                        JsonElement node = root.get(parameter.getName());
                        if (deserializee.isWithoutRoot()) {
                            values[i] = gson.fromJson((JsonElement)root, GsonDeserialization.fallbackTo(parameter.getParameterizedType(), types[i]));
                            logger.debug("json without root deserialized");
                            break block11;
                        }
                        if (node == null) continue;
                        if (node.isJsonArray()) {
                            JsonArray jsonArray = node.getAsJsonArray();
                            Type type = parameter.getParameterizedType();
                            if (type instanceof ParameterizedType) {
                                values[i] = gson.fromJson((JsonElement)jsonArray, type);
                                continue;
                            }
                            values[i] = gson.fromJson((JsonElement)jsonArray, types[i]);
                            continue;
                        }
                        values[i] = gson.fromJson(node, types[i]);
                    }
                    break block11;
                }
                if (jsonElement.isJsonArray()) {
                    if (parameterNames.length != 1 || !(parameterNames[0].getParameterizedType() instanceof ParameterizedType)) {
                        throw new IllegalArgumentException("Methods that consumes an array representation must receive only just one collection generic typed argument");
                    }
                    JsonArray jsonArray = jsonElement.getAsJsonArray();
                    values[0] = gson.fromJson((JsonElement)jsonArray, parameterNames[0].getParameterizedType());
                    break block11;
                }
                throw new IllegalArgumentException("This is an invalid or not supported json content");
            }
            catch (Exception e) {
                throw new ResultException("Unable to deserialize data", e);
            }
        }
        logger.debug("json deserialized: {}", (Object)values);
        return values;
    }

    private static Type fallbackTo(Type parameterizedType, Class<?> type) {
        if (parameterizedType instanceof TypeVariable) {
            return type;
        }
        return parameterizedType;
    }

    private String getContentOfStream(InputStream input) throws IOException {
        Charset charset = Charset.forName(this.getRequestCharset());
        logger.debug("Using charset {}", (Object)charset);
        return CharStreams.toString((Readable)new InputStreamReader(input, charset));
    }

    private String getRequestCharset() {
        String charset = (String)Objects.firstNonNull((Object)this.request.getHeader("Accept-Charset"), (Object)"UTF-8");
        return charset.split(",")[0];
    }

    private static boolean isWithoutRoot(Parameter[] parameters, JsonObject root) {
        for (Parameter parameter : parameters) {
            if (root.get(parameter.getName()) == null) continue;
            return false;
        }
        return true;
    }

    protected Class<?>[] getTypes(ControllerMethod method) {
        Class<?>[] parameterTypes = method.getMethod().getParameterTypes();
        Type genericType = GsonDeserialization.getGenericSuperClass(method);
        if (genericType != null) {
            return GsonDeserialization.parseGenericParameters(parameterTypes, genericType);
        }
        return parameterTypes;
    }

    private static Class<?>[] parseGenericParameters(Class<?>[] parameterTypes, Type genericType) {
        Class type = (Class)GsonDeserialization.getGenericType(genericType);
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!parameterTypes[i].isAssignableFrom(type)) continue;
            parameterTypes[i] = type;
        }
        return parameterTypes;
    }

    private static Type getGenericSuperClass(ControllerMethod method) {
        Type genericType = method.getController().getType().getGenericSuperclass();
        if (genericType instanceof ParameterizedType) {
            return genericType;
        }
        return null;
    }

    private static Type getGenericType(Type type) {
        ParameterizedType paramType = (ParameterizedType)type;
        return paramType.getActualTypeArguments()[0];
    }
}

