/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.gson;

import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.serialization.gson.Exclusions;
import br.com.caelum.vraptor.serialization.gson.GsonSerializerBuilder;
import com.google.gson.Gson;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class GsonSerializer
implements SerializerBuilder {
    private final GsonSerializerBuilder builder;
    private final Writer writer;
    private final TypeNameExtractor extractor;
    private final ReflectionProvider reflectionProvider;

    public GsonSerializer(GsonSerializerBuilder builder, Writer writer, TypeNameExtractor extractor, ReflectionProvider reflectionProvider) {
        this.writer = writer;
        this.extractor = extractor;
        this.builder = builder;
        this.reflectionProvider = reflectionProvider;
    }

    @Override
    public Serializer exclude(String ... names) {
        this.builder.getSerializee().excludeAll(names);
        return this;
    }

    @Override
    public Serializer excludeAll() {
        this.builder.getSerializee().excludeAll();
        return this;
    }

    private void preConfigure(Object obj, String alias) {
        Objects.requireNonNull(obj, "You can't serialize null objects");
        this.builder.getSerializee().setRootClass(obj.getClass());
        if (alias == null) {
            alias = Collection.class.isInstance(obj) && List.class.isInstance(obj) ? "list" : this.extractor.nameFor(this.builder.getSerializee().getRootClass());
        }
        this.builder.setAlias(alias);
        this.setRoot(obj);
    }

    private void setRoot(Object obj) {
        if (Collection.class.isInstance(obj)) {
            this.builder.getSerializee().setRoot(this.normalizeList(obj));
        } else {
            this.builder.getSerializee().setRoot(obj);
        }
    }

    private Collection<Object> normalizeList(Object obj) {
        Collection list = (Collection)obj;
        this.builder.getSerializee().setElementTypes(this.findElementTypes(list));
        return list;
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.preConfigure(object, alias);
        return this;
    }

    @Override
    public <T> Serializer from(T object) {
        this.preConfigure(object, null);
        return this;
    }

    private Set<Class<?>> findElementTypes(Collection<Object> list) {
        HashSet set = new HashSet();
        for (Object element : list) {
            if (element == null || GsonSerializer.shouldSerializeField(element.getClass())) continue;
            set.add(element.getClass());
        }
        return set;
    }

    @Override
    public Serializer include(String ... fields) {
        this.builder.getSerializee().includeAll(fields);
        return this;
    }

    @Override
    public void serialize() {
        this.builder.setExclusionStrategies(new Exclusions(this.builder.getSerializee(), this.reflectionProvider));
        Gson gson = this.builder.create();
        String alias = this.builder.getAlias();
        Object root = this.builder.getSerializee().getRoot();
        if (this.builder.isWithoutRoot()) {
            gson.toJson(root, (Appendable)this.writer);
        } else {
            gson.toJson(Collections.singletonMap(alias, root), (Appendable)this.writer);
        }
    }

    @Override
    public Serializer recursive() {
        this.builder.getSerializee().setRecursive(true);
        return this;
    }

    static boolean shouldSerializeField(Class<?> type) {
        return type.isPrimitive() || type.isEnum() || Number.class.isAssignableFrom(type) || type.equals(String.class) || Date.class.isAssignableFrom(type) || Calendar.class.isAssignableFrom(type) || Boolean.class.equals(type) || Character.class.equals(type);
    }
}

