/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.core.DefaultReflectionProvider;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.interceptor.DefaultTypeNameExtractor;
import br.com.caelum.vraptor.interceptor.TypeNameExtractor;
import br.com.caelum.vraptor.serialization.Serializee;
import br.com.caelum.vraptor.serialization.xstream.VRaptorXStream;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamConverters;
import br.com.caelum.vraptor.util.test.MockInstanceImpl;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;

@Dependent
public class XStreamBuilderImpl
implements XStreamBuilder {
    private final XStreamConverters converters;
    private final TypeNameExtractor extractor;
    private final Serializee serializee;
    private final ReflectionProvider reflectionProvider;
    private boolean indented;
    private boolean recursive;

    protected XStreamBuilderImpl() {
        this(null, null, null, null);
    }

    @Inject
    public XStreamBuilderImpl(XStreamConverters converters, TypeNameExtractor extractor, Serializee serializee, ReflectionProvider reflectionProvider) {
        this.converters = converters;
        this.extractor = extractor;
        this.serializee = serializee;
        this.reflectionProvider = reflectionProvider;
    }

    public static XStreamBuilder cleanInstance(Converter ... converters) {
        MockInstanceImpl<Converter> convertersInst = new MockInstanceImpl<Converter>(converters);
        MockInstanceImpl<SingleValueConverter> singleValueConverters = new MockInstanceImpl<SingleValueConverter>(new SingleValueConverter[0]);
        XStreamConverters xStreamConverters = new XStreamConverters(convertersInst, singleValueConverters);
        return new XStreamBuilderImpl(xStreamConverters, new DefaultTypeNameExtractor(), new Serializee(new DefaultReflectionProvider()), new DefaultReflectionProvider());
    }

    @Override
    public XStream xmlInstance() {
        VRaptorXStream xstream = new VRaptorXStream(this.extractor, this.serializee, this.reflectionProvider);
        this.serializee.setRecursive(this.recursive);
        return this.configure(xstream);
    }

    @Override
    public XStream configure(XStream xstream) {
        this.converters.registerComponents(xstream);
        return xstream;
    }

    @Override
    public XStreamBuilder indented() {
        this.indented = true;
        return this;
    }

    boolean isIndented() {
        return this.indented;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public XStreamBuilder recursive() {
        this.recursive = true;
        return this;
    }
}

