/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class XStreamConverters {
    private final Iterable<Converter> converters;
    private final Iterable<SingleValueConverter> singleValueConverters;
    private static final Logger logger = LoggerFactory.getLogger(XStreamConverters.class);

    protected XStreamConverters() {
        this(null, null);
    }

    @Inject
    public XStreamConverters(@Any Instance<Converter> converters, @Any Instance<SingleValueConverter> singleValueConverters) {
        this.converters = converters;
        this.singleValueConverters = singleValueConverters;
    }

    public void registerComponents(XStream xstream) {
        for (Converter converter : this.converters) {
            xstream.registerConverter(converter);
            logger.debug("registered Xstream converter for {}", (Object)converter.getClass().getName());
        }
        for (SingleValueConverter singleValueConverter : this.singleValueConverters) {
            xstream.registerConverter(singleValueConverter);
            logger.debug("registered Xstream converter for {}", (Object)singleValueConverter.getClass().getName());
        }
    }
}

