/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.serialization.Serializee;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.serialization.xstream.VRaptorClassMapper;
import br.com.caelum.vraptor.serialization.xstream.VRaptorXStream;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class XStreamSerializer
implements SerializerBuilder {
    private final XStream xstream;
    private final HierarchicalStreamWriter writer;
    private final Serializee serializee;

    public XStreamSerializer(XStream xstream, HierarchicalStreamWriter writer) {
        this.xstream = xstream;
        this.writer = writer;
        this.serializee = ((VRaptorXStream)xstream).getVRaptorMapper().getSerializee();
    }

    public XStreamSerializer(XStream xstream, Writer writer) {
        this(xstream, (HierarchicalStreamWriter)new PrettyPrintWriter(writer));
    }

    @Override
    public Serializer exclude(String ... names) {
        this.serializee.excludeAll(names);
        return this;
    }

    @Override
    public Serializer excludeAll() {
        this.serializee.excludeAll();
        return this;
    }

    private void preConfigure(Object obj, String alias) {
        Objects.requireNonNull(obj, "You can't serialize null objects");
        this.xstream.processAnnotations(obj.getClass());
        this.serializee.setRootClass(obj.getClass());
        this.setRoot(obj);
        this.setAlias(obj, alias);
    }

    private void setRoot(Object obj) {
        if (Collection.class.isInstance(obj)) {
            this.serializee.setRoot(this.normalizeList(obj));
        } else {
            this.serializee.setRoot(obj);
        }
    }

    private Collection<Object> normalizeList(Object obj) {
        ArrayList<Object> list = this.hasDefaultConverter() ? new ArrayList<Object>((Collection)obj) : (ArrayList<Object>)obj;
        this.serializee.setElementTypes(this.findElementTypes(list));
        return list;
    }

    private boolean hasDefaultConverter() {
        return this.xstream.getConverterLookup().lookupConverterForType(this.serializee.getRootClass()).equals(this.xstream.getConverterLookup().lookupConverterForType(Object.class));
    }

    private void setAlias(Object obj, String alias) {
        if (alias != null) {
            if (Collection.class.isInstance(obj) && (List.class.isInstance(obj) || this.hasDefaultConverter())) {
                this.xstream.alias(alias, List.class);
            }
            this.xstream.alias(alias, obj.getClass());
        }
    }

    @Override
    public <T> Serializer from(T object, String alias) {
        this.preConfigure(object, alias);
        return this;
    }

    @Override
    public <T> Serializer from(T object) {
        this.preConfigure(object, null);
        return this;
    }

    private Set<Class<?>> findElementTypes(Collection<Object> list) {
        HashSet set = new HashSet();
        for (Object element : list) {
            if (element == null || VRaptorClassMapper.isPrimitive(element.getClass())) continue;
            set.add(element.getClass());
        }
        return set;
    }

    @Override
    public Serializer include(String ... fields) {
        this.serializee.includeAll(fields);
        return this;
    }

    @Override
    public void serialize() {
        this.xstream.marshal(this.serializee.getRoot(), this.writer);
    }

    @Override
    public Serializer recursive() {
        this.serializee.setRecursive(true);
        return this;
    }
}

