/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.serialization.xstream;

import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.http.Parameter;
import br.com.caelum.vraptor.http.ParameterNameProvider;
import br.com.caelum.vraptor.serialization.Deserializer;
import br.com.caelum.vraptor.serialization.Deserializes;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilder;
import com.thoughtworks.xstream.XStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;

@RequestScoped
@Deserializes(value={"application/xml", "xml", "text/xml"})
public class XStreamXMLDeserializer
implements Deserializer {
    private final ParameterNameProvider provider;
    private final XStreamBuilder builder;

    protected XStreamXMLDeserializer() {
        this(null, null);
    }

    @Inject
    public XStreamXMLDeserializer(ParameterNameProvider provider, XStreamBuilder builder) {
        this.provider = provider;
        this.builder = builder;
    }

    @Override
    public Object[] deserialize(InputStream inputStream, ControllerMethod method) {
        Method javaMethod = method.getMethod();
        Class<?>[] types = javaMethod.getParameterTypes();
        if (types.length == 0) {
            throw new IllegalArgumentException("Methods that consumes xml must receive just one argument: the xml root element");
        }
        XStream xStream = this.getConfiguredXStream(javaMethod, types);
        Object[] params = new Object[types.length];
        XStreamXMLDeserializer.chooseParam(types, params, xStream.fromXML(inputStream));
        return params;
    }

    public XStream getConfiguredXStream(Method javaMethod, Class<?>[] types) {
        XStream xStream = this.builder.recursive().xmlInstance();
        xStream.processAnnotations((Class[])types);
        this.aliasParams(javaMethod, xStream);
        return xStream;
    }

    private static void chooseParam(Class<?>[] types, Object[] params, Object deserialized) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].isInstance(deserialized)) continue;
            params[i] = deserialized;
        }
    }

    private void aliasParams(Method method, XStream deserializer) {
        for (Parameter param : this.provider.parametersFor(method)) {
            deserializer.alias(param.getName(), param.getType());
        }
    }
}

