/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util;

import com.thoughtworks.xstream.InitializationException;
import java.util.ArrayList;
import javax.enterprise.inject.Vetoed;

@Vetoed
public final class StringUtils {
    private StringUtils() {
        throw new InitializationException("Not allowed to initialize");
    }

    public static String decapitalize(String name) {
        if (name.length() == 1) {
            return name.toLowerCase();
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static String capitalize(String name) {
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String lowercaseFirst(String name) {
        if (name.length() > 1 && Character.isLowerCase(name.charAt(1))) {
            return StringUtils.decapitalize(name);
        }
        for (int i = 1; i < name.length(); ++i) {
            if (!Character.isLowerCase(name.charAt(i))) continue;
            return name.substring(0, i - 1).toLowerCase() + name.substring(i - 1, name.length());
        }
        return name.toLowerCase();
    }

    public static String[] extractParameters(String uri) {
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder param = new StringBuilder();
        int brackets = 0;
        for (int i = 0; i < uri.length(); ++i) {
            char character = uri.charAt(i);
            if (character == '{') {
                if (++brackets == 1) {
                    continue;
                }
            } else if (character == '}' && --brackets == 0) {
                params.add(param.toString());
                param = new StringBuilder();
            }
            if (brackets <= 0) continue;
            param.append(character);
        }
        return params.toArray(new String[params.size()]);
    }
}

