/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.test;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.core.AbstractResult;
import br.com.caelum.vraptor.proxy.JavassistProxifier;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.serialization.NoRootSerialization;
import br.com.caelum.vraptor.serialization.Serializer;
import br.com.caelum.vraptor.serialization.SerializerBuilder;
import br.com.caelum.vraptor.view.EmptyResult;
import br.com.caelum.vraptor.view.ResultException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class MockResult
extends AbstractResult {
    private final Map<String, Object> values = new HashMap<String, Object>();
    protected Class<?> typeToUse;
    protected final Proxifier proxifier;

    public MockResult(Proxifier proxifier) {
        this.proxifier = proxifier;
    }

    public MockResult() {
        this(new JavassistProxifier());
    }

    @Override
    public Result include(String key, Object value) {
        this.values.put(key, value);
        return this;
    }

    @Override
    public Result on(Class<? extends Exception> exception) {
        return this;
    }

    @Override
    public <T extends View> T use(Class<T> view) {
        this.typeToUse = view;
        if (view.equals(EmptyResult.class)) {
            return null;
        }
        return (T)((View)this.proxifier.proxify(view, this.returnOnFinalMethods(view)));
    }

    protected <T> MethodInvocation<T> returnOnFinalMethods(final Class<T> view) {
        return new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                Class<?> type = method.getReturnType();
                if (type == Void.TYPE) {
                    return null;
                }
                if (view.isAssignableFrom(type)) {
                    return proxy;
                }
                if (args.length > 0 && args[0] instanceof Class) {
                    return MockResult.this.proxifier.proxify((Class)args[0], MockResult.this.returnOnFirstInvocation());
                }
                if (Serializer.class.isAssignableFrom(type) || SerializerBuilder.class.isAssignableFrom(type) || NoRootSerialization.class.isAssignableFrom(type)) {
                    return MockResult.this.proxifier.proxify(type, MockResult.this.returnOnFinalMethods(type));
                }
                throw new ResultException("It's not possible to create a mocked version of " + method + ". Please inform this corner case to VRaptor developers");
            }
        };
    }

    private <T> MethodInvocation<T> returnOnFirstInvocation() {
        return new MethodInvocation<T>(){

            @Override
            public Object intercept(Object proxy, Method method, Object[] args, SuperMethod superMethod) {
                return null;
            }
        };
    }

    @Override
    public boolean used() {
        return this.typeToUse != null;
    }

    public <T> T included(String key) {
        return (T)this.values.get(key);
    }

    @Override
    public Map<String, Object> included() {
        return this.values;
    }

    @Override
    public Result include(Object value) {
        return this.include(value.getClass().getSimpleName(), value);
    }
}

