/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.test;

import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.core.DefaultReflectionProvider;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.environment.Environment;
import br.com.caelum.vraptor.environment.NullEnvironment;
import br.com.caelum.vraptor.http.FormatResolver;
import br.com.caelum.vraptor.interceptor.DefaultTypeNameExtractor;
import br.com.caelum.vraptor.proxy.JavassistProxifier;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.serialization.DefaultRepresentationResult;
import br.com.caelum.vraptor.serialization.JSONSerialization;
import br.com.caelum.vraptor.serialization.RepresentationResult;
import br.com.caelum.vraptor.serialization.Serialization;
import br.com.caelum.vraptor.serialization.Serializee;
import br.com.caelum.vraptor.serialization.XMLSerialization;
import br.com.caelum.vraptor.serialization.gson.GsonBuilderWrapper;
import br.com.caelum.vraptor.serialization.gson.GsonJSONSerialization;
import br.com.caelum.vraptor.serialization.gson.GsonSerializerBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilder;
import br.com.caelum.vraptor.serialization.xstream.XStreamBuilderImpl;
import br.com.caelum.vraptor.serialization.xstream.XStreamXMLSerialization;
import br.com.caelum.vraptor.util.test.MockHttpServletResponse;
import br.com.caelum.vraptor.util.test.MockInstanceImpl;
import br.com.caelum.vraptor.util.test.MockResult;
import br.com.caelum.vraptor.view.EmptyResult;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class MockSerializationResult
extends MockResult {
    private Serialization serialization;
    private MockHttpServletResponse response;
    private DefaultTypeNameExtractor extractor;
    private XStreamBuilder xstreambuilder;
    private GsonSerializerBuilder gsonBuilder;
    private Environment environment;
    private ReflectionProvider reflectionProvider;

    public MockSerializationResult(Proxifier proxifier, XStreamBuilder xstreambuilder, GsonSerializerBuilder gsonBuilder, ReflectionProvider reflectionProvider) {
        this(proxifier, xstreambuilder, gsonBuilder, new NullEnvironment(), reflectionProvider);
    }

    public MockSerializationResult(Proxifier proxifier, XStreamBuilder xstreambuilder, GsonSerializerBuilder gsonBuilder, Environment environment, ReflectionProvider reflectionProvider) {
        super(proxifier);
        this.environment = environment;
        this.reflectionProvider = reflectionProvider;
        this.response = new MockHttpServletResponse();
        this.extractor = new DefaultTypeNameExtractor();
        this.xstreambuilder = xstreambuilder;
        this.gsonBuilder = gsonBuilder;
    }

    public MockSerializationResult() {
        this(new JavassistProxifier(), XStreamBuilderImpl.cleanInstance(new Converter[0]), new GsonBuilderWrapper(new MockInstanceImpl(new ArrayList()), new MockInstanceImpl(new ArrayList()), new Serializee(new DefaultReflectionProvider()), new DefaultReflectionProvider()), new DefaultReflectionProvider());
    }

    @Override
    public <T extends View> T use(Class<T> view) {
        this.typeToUse = view;
        if (view.equals(EmptyResult.class)) {
            return null;
        }
        return this.instanceView(view);
    }

    private <T extends View> T instanceView(Class<T> view) {
        if (view.isAssignableFrom(JSONSerialization.class)) {
            this.serialization = new GsonJSONSerialization(this.response, this.extractor, this.gsonBuilder, this.environment, this.reflectionProvider);
            return (T)((View)view.cast(this.serialization));
        }
        if (view.isAssignableFrom(XMLSerialization.class)) {
            this.serialization = new XStreamXMLSerialization(this.response, this.xstreambuilder, this.environment);
            return (T)((View)view.cast(this.serialization));
        }
        if (view.isAssignableFrom(RepresentationResult.class)) {
            this.serialization = new XStreamXMLSerialization(this.response, this.xstreambuilder, this.environment);
            return (T)((View)view.cast(new DefaultRepresentationResult(new FormatResolver(){

                @Override
                public String getAcceptFormat() {
                    return "xml";
                }
            }, this, new MockInstanceImpl<Serialization>(this.serialization))));
        }
        return (T)((View)this.proxifier.proxify(view, this.returnOnFinalMethods(view)));
    }

    public String serializedResult() throws Exception {
        if ("application/xml".equals(this.response.getContentType())) {
            return this.response.getContentAsString();
        }
        if ("application/json".equals(this.response.getContentType())) {
            return this.response.getContentAsString();
        }
        return null;
    }
}

