/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.util.test;

import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.util.test.MockResult;
import br.com.caelum.vraptor.validator.AbstractValidator;
import br.com.caelum.vraptor.validator.I18nMessage;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.SimpleMessage;
import br.com.caelum.vraptor.validator.ValidationException;
import br.com.caelum.vraptor.validator.Validator;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.inject.Vetoed;
import javax.validation.ConstraintViolation;

@Vetoed
public class MockValidator
extends AbstractValidator {
    private List<Message> errors = new ArrayList<Message>();

    @Override
    public Validator check(boolean condition, Message message) {
        return this.ensure(condition, message);
    }

    @Override
    public Validator addIf(boolean expression, Message message) {
        if (expression) {
            this.add(message);
        }
        return this;
    }

    @Override
    public Validator ensure(boolean expression, Message message) {
        return this.addIf(!expression, message);
    }

    @Override
    public Validator validate(Object object, Class<?> ... groups) {
        return this;
    }

    @Override
    public Validator validate(String alias, Object object, Class<?> ... groups) {
        return this;
    }

    @Override
    public <T> Validator addAll(String alias, Set<ConstraintViolation<T>> errors) {
        for (ConstraintViolation<T> v : errors) {
            String category = v.getPropertyPath().toString();
            if (Strings.isNullOrEmpty((String)alias)) {
                category = alias + "." + category;
            }
            this.add(new SimpleMessage(category, v.getMessage(), new Object[0]));
        }
        return this;
    }

    @Override
    public <T> Validator addAll(Set<ConstraintViolation<T>> errors) {
        return this.addAll(null, errors);
    }

    @Override
    public <T extends View> T onErrorUse(Class<T> view) {
        if (!this.errors.isEmpty()) {
            throw new ValidationException(this.errors);
        }
        return new MockResult().use(view);
    }

    @Override
    public Validator addAll(Collection<? extends Message> messages) {
        for (Message message : messages) {
            this.add(message);
        }
        return this;
    }

    @Override
    public Validator add(Message message) {
        this.errors.add(message);
        return this;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public List<Message> getErrors() {
        return this.errors;
    }

    public boolean containsMessage(String messageKey, Object ... messageParameters) {
        I18nMessage expectedMessage = new I18nMessage("validation", messageKey, messageParameters);
        expectedMessage.setBundle(ResourceBundle.getBundle("messages"));
        for (Message error : this.getErrors()) {
            if (!expectedMessage.getMessage().equals(error.getMessage())) continue;
            return true;
        }
        return false;
    }
}

