/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.View;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.util.test.MockResult;
import br.com.caelum.vraptor.validator.AbstractValidator;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.Messages;
import br.com.caelum.vraptor.validator.Outjector;
import br.com.caelum.vraptor.validator.SimpleMessage;
import br.com.caelum.vraptor.validator.Validator;
import br.com.caelum.vraptor.validator.beanvalidation.BeanValidatorContext;
import br.com.caelum.vraptor.view.ValidationViewsFactory;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DefaultValidator
extends AbstractValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultValidator.class);
    private final Result result;
    private final ValidationViewsFactory viewsFactory;
    private final Outjector outjector;
    private final Proxifier proxifier;
    private final ResourceBundle bundle;
    private final javax.validation.Validator bvalidator;
    private final MessageInterpolator interpolator;
    private final Locale locale;
    private final Messages messages;

    protected DefaultValidator() {
        this(null, null, null, null, null, null, null, null, null);
    }

    @Inject
    public DefaultValidator(Result result, ValidationViewsFactory factory, Outjector outjector, Proxifier proxifier, ResourceBundle bundle, javax.validation.Validator bvalidator, MessageInterpolator interpolator, Locale locale, Messages messages) {
        this.result = result;
        this.viewsFactory = factory;
        this.outjector = outjector;
        this.proxifier = proxifier;
        this.bundle = bundle;
        this.bvalidator = bvalidator;
        this.interpolator = interpolator;
        this.locale = locale;
        this.messages = messages;
    }

    @Override
    public Validator check(boolean condition, Message message) {
        return this.ensure(condition, message);
    }

    @Override
    public Validator ensure(boolean expression, Message message) {
        return this.addIf(!expression, message);
    }

    @Override
    public Validator addIf(boolean expression, Message message) {
        message.setBundle(this.bundle);
        if (expression) {
            this.messages.add(message);
        }
        return this;
    }

    @Override
    public Validator validate(Object object, Class<?> ... groups) {
        return this.validate(null, object, groups);
    }

    @Override
    public Validator validate(String alias, Object object, Class<?> ... groups) {
        if (object != null) {
            this.addAll(alias, this.bvalidator.validate(object, (Class[])groups));
        }
        return this;
    }

    @Override
    public Validator add(Message message) {
        message.setBundle(this.bundle);
        this.messages.add(message);
        return this;
    }

    @Override
    public Validator addAll(Collection<? extends Message> messages) {
        for (Message message : messages) {
            this.add(message);
        }
        return this;
    }

    @Override
    public <T> Validator addAll(Set<ConstraintViolation<T>> errors) {
        return this.addAll(null, errors);
    }

    @Override
    public <T> Validator addAll(String alias, Set<ConstraintViolation<T>> errors) {
        for (ConstraintViolation<T> v : errors) {
            String msg = this.interpolator.interpolate(v.getMessageTemplate(), (MessageInterpolator.Context)new BeanValidatorContext(v), this.locale);
            String category = v.getPropertyPath().toString();
            if (!Strings.isNullOrEmpty((String)alias)) {
                category = alias + "." + category;
            }
            this.add(new SimpleMessage(category, msg, new Object[0]));
            logger.debug("added message {}={} for contraint violation", (Object)category, (Object)msg);
        }
        return this;
    }

    @Override
    public <T extends View> T onErrorUse(Class<T> view) {
        if (!this.hasErrors()) {
            return new MockResult(this.proxifier).use(view);
        }
        this.result.include("errors", this.getErrors());
        this.outjector.outjectRequestMap();
        logger.debug("there are errors on result: {}", this.getErrors());
        return this.viewsFactory.instanceFor(view, this.messages.handleErrors());
    }

    @Override
    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    @Override
    public List<Message> getErrors() {
        return this.messages.getErrors();
    }
}

