/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.validator.Message;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class MessageList
extends ForwardingList<Message>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Message> delegate;
    private Map<String, Collection<Message>> grouped;

    public MessageList(List<Message> delegate) {
        this.delegate = delegate;
    }

    public Map<String, Collection<Message>> getGrouped() {
        if (this.grouped == null) {
            this.grouped = FluentIterable.from(this.delegate).index(this.byCategoryMapping()).asMap();
        }
        return this.grouped;
    }

    public MessageListItem from(String category) {
        ImmutableList messages = FluentIterable.from(this.delegate).filter(this.byCategory(category)).transform(this.toMessageString()).toList();
        return new MessageListItem((List<String>)messages);
    }

    private Predicate<Message> byCategory(final String category) {
        return new Predicate<Message>(){

            public boolean apply(Message input) {
                return input.getCategory().equals(category);
            }
        };
    }

    private Function<Message, String> byCategoryMapping() {
        return new Function<Message, String>(){

            public String apply(Message input) {
                return input.getCategory();
            }
        };
    }

    private Function<Message, String> toMessageString() {
        return new Function<Message, String>(){

            public String apply(Message input) {
                return input.getMessage();
            }
        };
    }

    protected List<Message> delegate() {
        return this.delegate;
    }

    public class MessageListItem
    extends ForwardingList<String> {
        private final List<String> delegate;

        public MessageListItem(List<String> delegate) {
            this.delegate = delegate;
        }

        protected List<String> delegate() {
            return this.delegate;
        }

        public String toString() {
            return this.join(", ");
        }

        public String join(String separator) {
            return Joiner.on((String)separator).join(this.delegate);
        }
    }
}

