/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator;

import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.validator.MessageList;
import br.com.caelum.vraptor.validator.Severity;
import br.com.caelum.vraptor.validator.ValidationFailedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Vetoed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
public class Messages
implements Serializable {
    private static final long serialVersionUID = 728589528391504120L;
    private static final Logger log = LoggerFactory.getLogger(Messages.class);
    private final Map<Severity, List<Message>> messages = new HashMap<Severity, List<Message>>();
    private boolean unhandledErrors;

    public Messages add(Message message) {
        this.get(message.getSeverity()).add(message);
        if (Severity.ERROR.equals((Object)message.getSeverity())) {
            this.unhandledErrors = true;
        }
        return this;
    }

    private List<Message> get(Severity severity) {
        if (!this.messages.containsKey((Object)severity)) {
            this.messages.put(severity, (List<Message>)((Object)this.createMessageList()));
        }
        return this.messages.get((Object)severity);
    }

    public List<Message> getErrors() {
        return this.get(Severity.ERROR);
    }

    public List<Message> getInfo() {
        return this.get(Severity.INFO);
    }

    public List<Message> getWarnings() {
        return this.get(Severity.WARN);
    }

    public List<Message> getSuccess() {
        return this.get(Severity.SUCCESS);
    }

    public List<Message> getAll() {
        MessageList allMessages = this.createMessageList();
        allMessages.addAll(this.get(Severity.ERROR));
        allMessages.addAll(this.get(Severity.WARN));
        allMessages.addAll(this.get(Severity.INFO));
        allMessages.addAll(this.get(Severity.SUCCESS));
        return new MessageList((List<Message>)((Object)allMessages));
    }

    private MessageList createMessageList() {
        return new MessageList(new ArrayList<Message>());
    }

    public List<Message> handleErrors() {
        this.unhandledErrors = false;
        return this.getErrors();
    }

    public boolean hasUnhandledErrors() {
        return this.unhandledErrors;
    }

    public void assertAbsenceOfErrors() {
        if (this.hasUnhandledErrors()) {
            log.debug("Some validation errors occured: {}", this.getErrors());
            throw new ValidationFailedException("There are validation errors and you forgot to specify where to go. Please add in your method something like:\nvalidator.onErrorUse(page()).of(AnyController.class).anyMethod();\nor any view that you like.\nIf you didn't add any validation error, it is possible that a conversion error had happened.");
        }
    }
}

