/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.validator.beanvalidation;

import br.com.caelum.vraptor.controller.ControllerInstance;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.events.MethodReady;
import br.com.caelum.vraptor.http.ValuedParameter;
import br.com.caelum.vraptor.validator.SimpleMessage;
import br.com.caelum.vraptor.validator.Validator;
import br.com.caelum.vraptor.validator.beanvalidation.BeanValidatorContext;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Path;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.MethodDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MethodValidator {
    private static final Logger logger = LoggerFactory.getLogger(MethodValidator.class);
    private final Instance<Locale> locale;
    private final MessageInterpolator interpolator;
    private final javax.validation.Validator bvalidator;

    protected MethodValidator() {
        this(null, null, null);
    }

    @Inject
    public MethodValidator(Instance<Locale> locale, MessageInterpolator interpolator, javax.validation.Validator bvalidator) {
        this.locale = locale;
        this.interpolator = interpolator;
        this.bvalidator = bvalidator;
    }

    private boolean hasConstraints(ControllerMethod controllerMethod) {
        Method method = controllerMethod.getMethod();
        if (method.getParameterTypes().length == 0) {
            logger.debug("method {} has no parameters, skipping", (Object)controllerMethod);
            return false;
        }
        BeanDescriptor bean = this.bvalidator.getConstraintsForClass(controllerMethod.getController().getType());
        if (bean == null) {
            return false;
        }
        MethodDescriptor descriptor = bean.getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes());
        return descriptor != null && descriptor.hasConstrainedParameters();
    }

    public void validate(@Observes MethodReady event, ControllerInstance controllerInstance, MethodInfo methodInfo, Validator validator) {
        ControllerMethod method = event.getControllerMethod();
        if (this.hasConstraints(method)) {
            Set violations = this.bvalidator.forExecutables().validateParameters(controllerInstance.getController(), method.getMethod(), methodInfo.getParametersValues(), new Class[0]);
            logger.debug("there are {} constraint violations at method {}.", (Object)violations.size(), (Object)method);
            for (ConstraintViolation v : violations) {
                String category = this.extractCategory(methodInfo.getValuedParameters(), (ConstraintViolation<Object>)v);
                String msg = this.extractInternacionalizedMessage((ConstraintViolation<Object>)v);
                validator.add(new SimpleMessage(category, msg, new Object[0]));
                logger.debug("added message {}={} for contraint violation", (Object)category, (Object)msg);
            }
        }
    }

    protected String extractCategory(ValuedParameter[] params, ConstraintViolation<Object> violation) {
        Iterator path = violation.getPropertyPath().iterator();
        Path.Node method = (Path.Node)path.next();
        logger.debug("Constraint violation on method {}: {}", (Object)method, violation);
        StringBuilder cat = new StringBuilder();
        cat.append(params[((Path.ParameterNode)((Path.Node)path.next()).as(Path.ParameterNode.class)).getParameterIndex()].getName());
        while (path.hasNext()) {
            cat.append(".").append(path.next());
        }
        return cat.toString();
    }

    protected String extractInternacionalizedMessage(ConstraintViolation<Object> v) {
        return this.interpolator.interpolate(v.getMessageTemplate(), (MessageInterpolator.Context)new BeanValidatorContext(v), (Locale)this.locale.get());
    }
}

