/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.cache.CacheStore;
import br.com.caelum.vraptor.cache.LRU;
import br.com.caelum.vraptor.view.AcceptHeaderToFormat;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.FluentIterable;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class DefaultAcceptHeaderToFormat
implements AcceptHeaderToFormat {
    private final CacheStore<String, String> acceptToFormatCache;
    private static final String DEFAULT_FORMAT = "html";
    private static final double DEFAULT_QUALIFIER_VALUE = 0.01;
    protected final Map<String, String> mimeToFormat;

    protected DefaultAcceptHeaderToFormat() {
        this(null);
    }

    @Inject
    public DefaultAcceptHeaderToFormat(@LRU CacheStore<String, String> acceptToFormatCache) {
        this.acceptToFormatCache = acceptToFormatCache;
        this.mimeToFormat = new ConcurrentHashMap<String, String>();
        this.mimeToFormat.put("text/html", DEFAULT_FORMAT);
        this.mimeToFormat.put("application/json", "json");
        this.mimeToFormat.put("application/xml", "xml");
        this.mimeToFormat.put("text/xml", "xml");
        this.mimeToFormat.put("xml", "xml");
    }

    @Override
    public String getFormat(final String acceptHeader) {
        if (acceptHeader == null || acceptHeader.trim().equals("")) {
            return DEFAULT_FORMAT;
        }
        if (acceptHeader.contains(DEFAULT_FORMAT)) {
            return DEFAULT_FORMAT;
        }
        return this.acceptToFormatCache.fetch(acceptHeader, new Supplier<String>(){

            public String get() {
                return DefaultAcceptHeaderToFormat.this.chooseMimeType(acceptHeader);
            }
        });
    }

    private String chooseMimeType(String acceptHeader) {
        String[] mimeTypes;
        for (String mimeType : mimeTypes = this.getOrderedMimeTypes(acceptHeader)) {
            if (!this.mimeToFormat.containsKey(mimeType)) continue;
            return this.mimeToFormat.get(mimeType);
        }
        return mimeTypes[0];
    }

    String[] getOrderedMimeTypes(String acceptHeader) {
        String[] types = acceptHeader.split(",");
        if (types.length == 0) {
            return new String[]{types[0].split(";")[0]};
        }
        TreeSet<MimeType> mimes = new TreeSet<MimeType>();
        for (String string : types) {
            mimes.add(this.convertToMimeType(string));
        }
        return (String[])FluentIterable.from(mimes).transform(this.mimeType()).toArray(String.class);
    }

    private Function<MimeType, String> mimeType() {
        return new Function<MimeType, String>(){

            public String apply(MimeType mime) {
                return mime.getType().trim();
            }
        };
    }

    private MimeType convertToMimeType(String string) {
        if (string.contains("*/*")) {
            return new MimeType("text/html", 0.01);
        }
        if (string.contains(";")) {
            String type = string.substring(0, string.indexOf(59));
            return new MimeType(type, DefaultAcceptHeaderToFormat.extractQualifier(string));
        }
        return new MimeType(string, 1.0);
    }

    private static double extractQualifier(String string) {
        double qualifier = 0.01;
        if (string.contains("q=")) {
            Matcher matcher = Pattern.compile("\\s*q=(.+)\\s*").matcher(string);
            matcher.find();
            String value = matcher.group(1);
            qualifier = Double.parseDouble(value);
        }
        return qualifier;
    }

    private static class MimeType
    implements Comparable<MimeType> {
        private final String type;
        private final double qualifier;

        public MimeType(String type, double qualifier) {
            this.type = type;
            this.qualifier = qualifier;
        }

        @Override
        public int compareTo(MimeType mime) {
            return Double.compare(mime.qualifier, this.qualifier);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MimeType other = (MimeType)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.qualifier, other.qualifier);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.qualifier);
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

