/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.controller.DefaultControllerMethod;
import br.com.caelum.vraptor.core.MethodInfo;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.MutableResponse;
import br.com.caelum.vraptor.interceptor.ApplicationLogicException;
import br.com.caelum.vraptor.proxy.CDIProxies;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.ProxyInvocationException;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.view.PageResult;
import br.com.caelum.vraptor.view.PathResolver;
import br.com.caelum.vraptor.view.ResultException;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class DefaultPageResult
implements PageResult {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPageResult.class);
    private final MutableRequest request;
    private final MutableResponse response;
    private final PathResolver resolver;
    private final Proxifier proxifier;
    private final MethodInfo methodInfo;

    protected DefaultPageResult() {
        this(null, null, null, null, null);
    }

    @Inject
    public DefaultPageResult(MutableRequest req, MutableResponse res, MethodInfo methodInfo, PathResolver resolver, Proxifier proxifier) {
        this.request = CDIProxies.unproxifyIfPossible(req);
        this.response = CDIProxies.unproxifyIfPossible(res);
        this.methodInfo = methodInfo;
        this.proxifier = proxifier;
        this.resolver = resolver;
    }

    @Override
    public void defaultView() {
        String to = this.resolver.pathFor(this.methodInfo.getControllerMethod());
        logger.debug("forwarding to {}", (Object)to);
        try {
            this.request.getRequestDispatcher(to).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new ApplicationLogicException(to + " raised an exception", e);
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void include() {
        try {
            String to = this.resolver.pathFor(this.methodInfo.getControllerMethod());
            logger.debug("including {}", (Object)to);
            this.request.getRequestDispatcher(to).include((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (ServletException e) {
            throw new ResultException(e);
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void redirectTo(String url) {
        logger.debug("redirection to {}", (Object)url);
        try {
            if (url.startsWith("/")) {
                this.response.sendRedirect(this.request.getContextPath() + url);
            } else {
                this.response.sendRedirect(url);
            }
        }
        catch (IOException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public void forwardTo(String url) {
        logger.debug("forwarding to {}", (Object)url);
        try {
            this.request.getRequestDispatcher(url).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (IOException | ServletException e) {
            throw new ResultException(e);
        }
    }

    @Override
    public <T> T of(final Class<T> controllerType) {
        return this.proxifier.proxify(controllerType, new MethodInvocation<T>(){

            @Override
            public Object intercept(T proxy, Method method, Object[] args, SuperMethod superMethod) {
                try {
                    DefaultPageResult.this.request.getRequestDispatcher(DefaultPageResult.this.resolver.pathFor(DefaultControllerMethod.instanceFor(controllerType, method))).forward((ServletRequest)DefaultPageResult.this.request, (ServletResponse)DefaultPageResult.this.response);
                    return null;
                }
                catch (Exception e) {
                    throw new ProxyInvocationException(e);
                }
            }
        });
    }
}

