/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.Result;
import br.com.caelum.vraptor.controller.ControllerMethod;
import br.com.caelum.vraptor.controller.HttpMethod;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.http.MutableRequest;
import br.com.caelum.vraptor.http.ParametersProvider;
import br.com.caelum.vraptor.http.route.ControllerNotFoundException;
import br.com.caelum.vraptor.http.route.MethodNotAllowedException;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.validator.Message;
import br.com.caelum.vraptor.view.RefererResult;
import br.com.caelum.vraptor.view.Results;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DefaultRefererResult
implements RefererResult {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRefererResult.class);
    private final MutableRequest request;
    private final Result result;
    private final Router router;
    private final ParametersProvider provider;
    private ReflectionProvider reflectionProvider;

    protected DefaultRefererResult() {
        this(null, null, null, null, null);
    }

    @Inject
    public DefaultRefererResult(Result result, MutableRequest request, Router router, ParametersProvider provider, ReflectionProvider reflectionProvider) {
        this.result = result;
        this.request = request;
        this.router = router;
        this.provider = provider;
        this.reflectionProvider = reflectionProvider;
    }

    @Override
    public void forward() throws IllegalStateException {
        String referer = this.getReferer();
        try {
            ControllerMethod method = this.router.parse(referer, HttpMethod.GET, this.request);
            this.executeMethod(method, this.result.use(Results.logic()).forwardTo(method.getController().getType()));
        }
        catch (ControllerNotFoundException | MethodNotAllowedException e) {
            logger.warn("Could not find or doesn't allowed to get controller method", (Throwable)e);
            this.result.use(Results.page()).forwardTo(referer);
        }
    }

    private void executeMethod(ControllerMethod method, Object instance) {
        Object[] args = this.provider.getParametersFor(method, new ArrayList<Message>());
        this.reflectionProvider.invoke(instance, method.getMethod(), args);
    }

    @Override
    public void redirect() throws IllegalStateException {
        String referer = this.getReferer();
        try {
            ControllerMethod method = this.router.parse(referer, HttpMethod.GET, this.request);
            this.executeMethod(method, this.result.use(Results.logic()).redirectTo(method.getController().getType()));
        }
        catch (ControllerNotFoundException | MethodNotAllowedException e) {
            logger.warn("Could not find or doesn't allowed to get controller method", (Throwable)e);
            this.result.use(Results.page()).redirectTo(referer);
        }
    }

    protected String getReferer() {
        String referer = this.request.getHeader("Referer");
        Preconditions.checkState((referer != null ? 1 : 0) != 0, (Object)"The Referer header was not specified");
        String refererPath = null;
        try {
            refererPath = new URL(referer).getPath();
        }
        catch (MalformedURLException e) {
            refererPath = referer;
        }
        String ctxPath = this.request.getContextPath();
        return refererPath.startsWith(ctxPath + "/") || refererPath.equals(ctxPath) ? refererPath.substring(ctxPath.length()) : refererPath;
    }
}

