/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.controller.BeanClass;
import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.http.route.Router;
import br.com.caelum.vraptor.proxy.MethodInvocation;
import br.com.caelum.vraptor.proxy.Proxifier;
import br.com.caelum.vraptor.proxy.ProxyCreationException;
import br.com.caelum.vraptor.proxy.SuperMethod;
import br.com.caelum.vraptor.util.StringUtils;
import br.com.caelum.vraptor.view.Linker;
import com.google.common.collect.ForwardingMap;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="linkTo")
@ApplicationScoped
public class LinkToHandler
extends ForwardingMap<Class<?>, Object> {
    private static final Logger logger = LoggerFactory.getLogger(LinkToHandler.class);
    private final ServletContext context;
    private final Router router;
    private final Proxifier proxifier;
    private final ReflectionProvider reflectionProvider;
    private final ConcurrentMap<Class<?>, Class<?>> interfaces = new ConcurrentHashMap();
    private final Lock lock = new ReentrantLock();

    protected LinkToHandler() {
        this(null, null, null, null);
    }

    @Inject
    public LinkToHandler(ServletContext context, Router router, Proxifier proxifier, ReflectionProvider reflectionProvider) {
        this.context = context;
        this.router = router;
        this.proxifier = proxifier;
        this.reflectionProvider = reflectionProvider;
    }

    @PostConstruct
    public void start() {
        logger.info("Registering linkTo component");
    }

    protected Map<Class<?>, Object> delegate() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        logger.debug("getting key {}", key);
        BeanClass beanClass = (BeanClass)key;
        final Class<?> controller = beanClass.getType();
        Class<?> linkToInterface = (Class<?>)this.interfaces.get(controller);
        if (linkToInterface == null) {
            logger.debug("interface not found, creating one {}", controller);
            this.lock.lock();
            try {
                linkToInterface = (Class)this.interfaces.get(controller);
                if (linkToInterface == null) {
                    String path = this.context.getContextPath().replace('/', '$');
                    String interfaceName = controller.getName() + "$linkTo" + path;
                    linkToInterface = this.createLinkToInterface(controller, interfaceName);
                    this.interfaces.put(controller, linkToInterface);
                    logger.debug("created interface {} to {}", (Object)interfaceName, controller);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.proxifier.proxify(linkToInterface, new MethodInvocation<Object>(){

            @Override
            public Object intercept(Object proxy, Method method, Object[] args, SuperMethod superMethod) {
                String methodName = StringUtils.decapitalize(method.getName().replaceFirst("^get", ""));
                List<Object> params = args.length == 0 ? Collections.emptyList() : Arrays.asList(args);
                return LinkToHandler.this.linker(controller, methodName, params).getLink();
            }
        });
    }

    protected Linker linker(Class<?> controller, String methodName, List<Object> params) {
        return new Linker(this.context, this.router, controller, methodName, params, this.reflectionProvider);
    }

    private Class<?> createLinkToInterface(Class<?> controller, String interfaceName) {
        try {
            return Class.forName(interfaceName);
        }
        catch (ClassNotFoundException e1) {
            logger.debug("Could not find class, but will keep looking", (Throwable)e1);
            HashSet<CtMethod> used = new HashSet<CtMethod>();
            ClassPool pool = ClassPool.getDefault();
            CtClass inter = pool.makeInterface(interfaceName);
            try {
                CtClass returnType = pool.get(String.class.getName());
                CtClass objectType = pool.get(Object.class.getName());
                for (Method m : this.getMethods(controller)) {
                    String name = m.getName();
                    CtClass[] params = this.createParameters(objectType, m.getParameterTypes().length);
                    CtClass[] empty = new CtClass[]{};
                    for (int length = params.length; length >= 0; --length) {
                        CtMethod method = CtNewMethod.abstractMethod((CtClass)returnType, (String)m.getName(), (CtClass[])Arrays.copyOf(params, length), (CtClass[])empty, (CtClass)inter);
                        if (!used.add(method)) continue;
                        inter.addMethod(method);
                        logger.debug("added method {} to interface {}", (Object)method.getName(), controller);
                    }
                    CtMethod getter = CtNewMethod.abstractMethod((CtClass)returnType, (String)String.format("get%s", StringUtils.capitalize(name)), (CtClass[])empty, (CtClass[])empty, (CtClass)inter);
                    if (!used.add(getter)) continue;
                    inter.addMethod(getter);
                    logger.debug("added getter {} to interface {}", (Object)getter.getName(), controller);
                }
                return inter.toClass();
            }
            catch (CannotCompileException | NotFoundException e) {
                throw new ProxyCreationException(e);
            }
        }
    }

    private CtClass[] createParameters(CtClass objectType, int num) {
        Object[] params = new CtClass[num];
        Arrays.fill(params, objectType);
        return params;
    }

    private List<Method> getMethods(Class<?> controller) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : this.reflectionProvider.getMethodsFor(controller)) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            methods.add(method);
        }
        Collections.sort(methods, new SortByArgumentsLengthDesc());
        return methods;
    }

    @PreDestroy
    public void removeGeneratedClasses() {
        ClassPool pool = ClassPool.getDefault();
        for (Class clazz : this.interfaces.values()) {
            CtClass ctClass = pool.getOrNull(clazz.getName());
            if (ctClass == null) continue;
            ctClass.detach();
            logger.debug("class {} is detached", (Object)clazz.getName());
        }
    }

    private static final class SortByArgumentsLengthDesc
    implements Comparator<Method>,
    Serializable {
        public static final long serialVersionUID = 1L;

        private SortByArgumentsLengthDesc() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            return Integer.compare(o2.getParameterTypes().length, o1.getParameterTypes().length);
        }
    }
}

