/*
 * Decompiled with CFR 0.152.
 */
package br.com.caelum.vraptor.view;

import br.com.caelum.vraptor.core.ReflectionProvider;
import br.com.caelum.vraptor.http.route.Router;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Vetoed;
import javax.servlet.ServletContext;

@Vetoed
public class Linker {
    private final Router router;
    private final ServletContext context;
    private final List<Object> args;
    private final String methodName;
    private final Class<?> controller;
    private final ReflectionProvider reflectionProvider;

    public Linker(ServletContext context, Router router, Class<?> controller, String methodName, List<Object> args, ReflectionProvider reflectionProvider) {
        this.router = router;
        this.context = context;
        this.controller = controller;
        this.methodName = methodName;
        this.args = args;
        this.reflectionProvider = reflectionProvider;
    }

    protected String getLink() {
        Method method = this.getMethod();
        return this.getPrefix() + this.router.urlFor(this.controller, method, this.getArgs(method));
    }

    protected String getPrefix() {
        return this.context.getContextPath();
    }

    protected Method getMethod() {
        Method method = null;
        if (this.countMethodsWithSameName() > 1) {
            method = this.reflectionProvider.getMethod(this.controller, this.methodName, this.getClasses(this.args));
            if (method == null && this.args.isEmpty()) {
                throw new IllegalArgumentException("Ambiguous method '" + this.methodName + "' on " + this.controller + ". Try to add some parameters to resolve ambiguity, or use different method names.");
            }
        } else {
            method = this.findMethodWithName(this.controller, this.methodName);
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("There are no methods on %s named '%s' that receives args of types %s", this.controller, this.methodName, Arrays.toString(this.getClasses(this.args))));
        }
        return method;
    }

    protected Object[] getArgs(Method method) {
        int methodArity = method.getParameterTypes().length;
        if (this.args.size() == methodArity) {
            return this.args.toArray();
        }
        if (this.args.size() > methodArity) {
            throw new IllegalArgumentException(String.format("linkTo param args must have the same or lower length as method param args. linkTo args: %d | method args: %d", this.args.size(), methodArity));
        }
        Object[] noMissingParamsArgs = new Object[methodArity];
        System.arraycopy(this.args.toArray(), 0, noMissingParamsArgs, 0, this.args.size());
        return noMissingParamsArgs;
    }

    protected Method findMethodWithName(Class<?> type, String name) {
        for (Method method : type.getDeclaredMethods()) {
            if (method.isBridge() || !method.getName().equals(name)) continue;
            return method;
        }
        if (type.getSuperclass().equals(Object.class)) {
            return null;
        }
        return this.findMethodWithName(type.getSuperclass(), name);
    }

    protected int countMethodsWithSameName() {
        int amount = 0;
        for (Method method : this.controller.getDeclaredMethods()) {
            if (method.isBridge() || !method.getName().equals(this.methodName)) continue;
            ++amount;
        }
        return amount;
    }

    protected Class<?>[] getClasses(List<Object> params) {
        Class[] classes = new Class[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            classes[i] = params.get(i).getClass();
        }
        return classes;
    }
}

