/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.EntityManagerConfig;
import br.gov.frameworkdemoiselle.internal.producer.Persistences;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@ApplicationScoped
public class EntityManagerFactoryProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ENTITY_MANAGER_RESOURCE = "META-INF/persistence.xml";
    @Inject
    protected Logger logger;
    @Inject
    @Name(value="demoiselle-jpa-bundle")
    protected ResourceBundle bundle;
    @Inject
    private Persistences persistenceUnitReader;
    private final Map<ClassLoader, Map<String, EntityManagerFactory>> factoryCache = Collections.synchronizedMap(new HashMap());

    @Default
    @Produces
    protected EntityManagerFactory createDefault(EntityManagerConfig config) {
        String persistenceUnit = this.persistenceUnitReader.getFromProperties(config);
        if (persistenceUnit == null) {
            persistenceUnit = this.persistenceUnitReader.getFromXML();
        }
        return this.create(persistenceUnit);
    }

    @Name(value="")
    @Produces
    protected EntityManagerFactory createNamed(InjectionPoint ip) {
        String persistenceUnit = ((Name)ip.getAnnotated().getAnnotation(Name.class)).value();
        return this.create(persistenceUnit);
    }

    public EntityManagerFactory create(String persistenceUnit) {
        EntityManagerFactory factory;
        ClassLoader c = Thread.currentThread().getContextClassLoader();
        if (this.factoryCache.containsKey(c)) {
            Map<String, EntityManagerFactory> localCache = this.factoryCache.get(c);
            if (localCache.containsKey(persistenceUnit)) {
                factory = localCache.get(persistenceUnit);
            } else {
                factory = Persistence.createEntityManagerFactory((String)persistenceUnit);
                localCache.put(persistenceUnit, factory);
            }
        } else {
            HashMap<String, EntityManagerFactory> localCache = new HashMap<String, EntityManagerFactory>();
            factory = Persistence.createEntityManagerFactory((String)persistenceUnit);
            localCache.put(persistenceUnit, factory);
            this.factoryCache.put(c, localCache);
        }
        return factory;
    }

    private String[] loadPersistenceUnitFromClassloader(ClassLoader classLoader) {
        try {
            ArrayList<String> persistenceUnits = new ArrayList<String>();
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(classLoader.getResourceAsStream(ENTITY_MANAGER_RESOURCE));
            NodeList nodes = document.getElementsByTagName("persistence-unit");
            String persistenceUnit = "";
            for (int index = 0; index < nodes.getLength(); ++index) {
                Node node = nodes.item(index);
                persistenceUnit = ((Element)node).getAttribute("name");
                if ("".equals(persistenceUnit)) {
                    throw new DemoiselleException(this.bundle.getString("can-not-get-persistence-unit-from-persistence"));
                }
                persistenceUnits.add(persistenceUnit);
            }
            return persistenceUnits.toArray(new String[0]);
        }
        catch (Exception cause) {
            String message = this.bundle.getString("can-not-get-persistence-unit-from-persistence");
            this.logger.error(message, (Throwable)cause);
            throw new DemoiselleException(message, (Throwable)cause);
        }
    }

    @PostConstruct
    public void loadPersistenceUnits() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (String persistenceUnit : this.loadPersistenceUnitFromClassloader(contextClassLoader)) {
            try {
                this.create(persistenceUnit);
            }
            catch (Exception cause) {
                throw new DemoiselleException((Throwable)cause);
            }
            this.logger.debug(this.bundle.getString("persistence-unit-name-found", new Object[]{persistenceUnit}));
        }
    }

    @PreDestroy
    public void close() {
        for (Map<String, EntityManagerFactory> factories : this.factoryCache.values()) {
            for (EntityManagerFactory factory : factories.values()) {
                factory.close();
            }
        }
        this.factoryCache.clear();
    }

    public Map<String, EntityManagerFactory> getCache() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map<String, EntityManagerFactory> result = this.factoryCache.get(classLoader);
        if (result == null || result.isEmpty()) {
            this.logger.debug(this.bundle.getString("entity-manager-factory-not-found-in-cache"));
            for (String persistenceUnit : this.loadPersistenceUnitFromClassloader(classLoader)) {
                this.create(persistenceUnit);
                result = this.factoryCache.get(classLoader);
            }
        }
        return result;
    }
}

