/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.EntityManagerConfig;
import br.gov.frameworkdemoiselle.internal.producer.ApplicationEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.ConversationEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.DependentEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.Persistences;
import br.gov.frameworkdemoiselle.internal.producer.RequestEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.SessionEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.ViewEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.proxy.EntityManagerProxy;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManager;

@ApplicationScoped
public class EntityManagerProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Instance<EntityManagerStore> storeInstance;
    @Inject
    private EntityManagerConfig configuration;
    @Inject
    private Persistences persistenceUnitReader;

    @Default
    @Produces
    protected EntityManager createDefault(EntityManagerConfig config) {
        String persistenceUnit = this.persistenceUnitReader.getFromProperties(config);
        if (persistenceUnit == null) {
            persistenceUnit = this.persistenceUnitReader.getFromXML();
        }
        return new EntityManagerProxy(persistenceUnit);
    }

    @Name(value="")
    @Produces
    protected EntityManager createNamed(InjectionPoint ip) {
        String persistenceUnit = ((Name)ip.getAnnotated().getAnnotation(Name.class)).value();
        return new EntityManagerProxy(persistenceUnit);
    }

    public EntityManager getEntityManager(String persistenceUnit) {
        return this.getStore().getEntityManager(persistenceUnit);
    }

    public Map<String, EntityManager> getCache() {
        return this.getStore().getCache();
    }

    private EntityManagerStore getStore() {
        switch (this.configuration.getEntityManagerScope()) {
            case REQUEST: {
                return (EntityManagerStore)this.storeInstance.select(RequestEntityManagerStore.class, new Annotation[0]).get();
            }
            case APPLICATION: {
                return (EntityManagerStore)this.storeInstance.select(ApplicationEntityManagerStore.class, new Annotation[0]).get();
            }
            case CONVERSATION: {
                return (EntityManagerStore)this.storeInstance.select(ConversationEntityManagerStore.class, new Annotation[0]).get();
            }
            case NOSCOPE: {
                return (EntityManagerStore)this.storeInstance.select(DependentEntityManagerStore.class, new Annotation[0]).get();
            }
            case SESSION: {
                return (EntityManagerStore)this.storeInstance.select(SessionEntityManagerStore.class, new Annotation[0]).get();
            }
            case VIEW: {
                return (EntityManagerStore)this.storeInstance.select(ViewEntityManagerStore.class, new Annotation[0]).get();
            }
        }
        return (EntityManagerStore)this.storeInstance.select(RequestEntityManagerStore.class, new Annotation[0]).get();
    }
}

