/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.EntityManagerConfig;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerFactoryProducer;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;

@Singleton
public class Persistences {
    @Inject
    protected Logger logger;
    @Inject
    @Name(value="demoiselle-jpa-bundle")
    protected ResourceBundle bundle;
    @Inject
    private EntityManagerFactoryProducer factory;

    protected String getFromProperties(EntityManagerConfig config) {
        String persistenceUnit = config.getDefaultPersistenceUnitName();
        if (persistenceUnit != null) {
            this.logger.debug(this.bundle.getString("getting-persistence-unit-from-properties", new Object[]{"demoiselle"}));
        }
        return persistenceUnit;
    }

    protected String getFromXML() {
        Set<String> persistenceUnits = this.factory.getCache().keySet();
        if (persistenceUnits.size() > 1) {
            throw new DemoiselleException(this.bundle.getString("more-than-one-persistence-unit-defined", new Object[]{Name.class.getSimpleName()}));
        }
        return persistenceUnits.iterator().next();
    }
}

