/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.protovalidate.internal.constraints.ConstraintCache;
import build.buf.protovalidate.internal.constraints.DescriptorMappings;
import build.buf.protovalidate.internal.evaluator.AnyEvaluator;
import build.buf.protovalidate.internal.evaluator.ConstraintResolver;
import build.buf.protovalidate.internal.evaluator.EnumEvaluator;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.FieldEvaluator;
import build.buf.protovalidate.internal.evaluator.ListEvaluator;
import build.buf.protovalidate.internal.evaluator.MapEvaluator;
import build.buf.protovalidate.internal.evaluator.MessageEvaluator;
import build.buf.protovalidate.internal.evaluator.OneofEvaluator;
import build.buf.protovalidate.internal.evaluator.UnknownDescriptorEvaluator;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.protovalidate.internal.expression.AstExpression;
import build.buf.protovalidate.internal.expression.CelPrograms;
import build.buf.protovalidate.internal.expression.CompiledProgram;
import build.buf.protovalidate.internal.expression.Expression;
import build.buf.validate.Constraint;
import build.buf.validate.FieldConstraints;
import build.buf.validate.Ignore;
import build.buf.validate.MessageConstraints;
import build.buf.validate.OneofConstraints;
import build.buf.validate.ValidateProto;
import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.checker.Decls;

public class EvaluatorBuilder {
    private static final ExtensionRegistry EXTENSION_REGISTRY = ExtensionRegistry.newInstance();
    private volatile ImmutableMap<Descriptors.Descriptor, Evaluator> evaluatorCache = ImmutableMap.of();
    private final Env env;
    private final boolean disableLazy;
    private final ConstraintCache constraints;

    public EvaluatorBuilder(Env env, boolean disableLazy) {
        this.env = env;
        this.disableLazy = disableLazy;
        this.constraints = new ConstraintCache(env);
    }

    public Evaluator load(Descriptors.Descriptor desc) throws CompilationException {
        Evaluator evaluator = (Evaluator)this.evaluatorCache.get((Object)desc);
        if (evaluator == null && this.disableLazy) {
            return new UnknownDescriptorEvaluator(desc);
        }
        return this.build(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Evaluator build(Descriptors.Descriptor desc) throws CompilationException {
        Evaluator eval = (Evaluator)this.evaluatorCache.get((Object)desc);
        if (eval != null) {
            return eval;
        }
        EvaluatorBuilder evaluatorBuilder = this;
        synchronized (evaluatorBuilder) {
            eval = (Evaluator)this.evaluatorCache.get((Object)desc);
            if (eval != null) {
                return eval;
            }
            ImmutableMap<Descriptors.Descriptor, Evaluator> updatedCache = new DescriptorCacheBuilder(this.env, this.constraints, this.evaluatorCache).build(desc);
            this.evaluatorCache = updatedCache;
            eval = (Evaluator)updatedCache.get((Object)desc);
            if (eval == null) {
                throw new IllegalStateException("updated cache missing evaluator for descriptor - should not happen");
            }
        }
        return eval;
    }

    static {
        EXTENSION_REGISTRY.add(ValidateProto.message);
        EXTENSION_REGISTRY.add(ValidateProto.field);
        EXTENSION_REGISTRY.add(ValidateProto.oneof);
    }

    private static class DescriptorCacheBuilder {
        private final ConstraintResolver resolver = new ConstraintResolver();
        private final Env env;
        private final ConstraintCache constraintCache;
        private final HashMap<Descriptors.Descriptor, Evaluator> cache;

        private DescriptorCacheBuilder(Env env, ConstraintCache constraintCache, ImmutableMap<Descriptors.Descriptor, Evaluator> previousCache) {
            this.env = Objects.requireNonNull(env, "env");
            this.constraintCache = Objects.requireNonNull(constraintCache, "constraintCache");
            this.cache = new HashMap<Descriptors.Descriptor, Evaluator>((Map<Descriptors.Descriptor, Evaluator>)previousCache);
        }

        public ImmutableMap<Descriptors.Descriptor, Evaluator> build(Descriptors.Descriptor descriptor) throws CompilationException {
            this.createMessageEvaluator(descriptor);
            return ImmutableMap.copyOf(this.cache);
        }

        private Evaluator createMessageEvaluator(Descriptors.Descriptor desc) throws CompilationException {
            Evaluator eval = this.cache.get(desc);
            if (eval != null) {
                return eval;
            }
            MessageEvaluator msgEval = new MessageEvaluator();
            this.cache.put(desc, msgEval);
            this.buildMessage(desc, msgEval);
            return msgEval;
        }

        private void buildMessage(Descriptors.Descriptor desc, MessageEvaluator msgEval) throws CompilationException {
            try {
                DynamicMessage defaultInstance = ((DynamicMessage.Builder)DynamicMessage.newBuilder((Descriptors.Descriptor)desc).mergeFrom(new byte[0], (ExtensionRegistryLite)EXTENSION_REGISTRY)).buildPartial();
                Descriptors.Descriptor descriptor = defaultInstance.getDescriptorForType();
                MessageConstraints msgConstraints = this.resolver.resolveMessageConstraints(descriptor, EXTENSION_REGISTRY);
                if (msgConstraints.getDisabled()) {
                    return;
                }
                this.processMessageExpressions(descriptor, msgConstraints, msgEval, defaultInstance);
                this.processOneofConstraints(descriptor, msgEval);
                this.processFields(descriptor, msgEval);
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompilationException("failed to parse proto definition: " + desc.getFullName(), e);
            }
        }

        private void processMessageExpressions(Descriptors.Descriptor desc, MessageConstraints msgConstraints, MessageEvaluator msgEval, DynamicMessage message) throws CompilationException {
            List<Constraint> celList = msgConstraints.getCelList();
            if (celList.isEmpty()) {
                return;
            }
            Env finalEnv = this.env.extend(new EnvOption[]{EnvOption.types((Object[])new Object[]{message}), EnvOption.declarations((Decl[])new Decl[]{Decls.newVar((String)"this", (Type)Decls.newObjectType((String)desc.getFullName()))})});
            List<CompiledProgram> compiledPrograms = DescriptorCacheBuilder.compileConstraints(celList, finalEnv);
            if (compiledPrograms.isEmpty()) {
                throw new CompilationException("compile returned null");
            }
            msgEval.append(new CelPrograms(compiledPrograms));
        }

        private void processOneofConstraints(Descriptors.Descriptor desc, MessageEvaluator msgEval) throws InvalidProtocolBufferException, CompilationException {
            List oneofs = desc.getOneofs();
            for (Descriptors.OneofDescriptor oneofDesc : oneofs) {
                OneofConstraints oneofConstraints = this.resolver.resolveOneofConstraints(oneofDesc, EXTENSION_REGISTRY);
                OneofEvaluator oneofEvaluatorEval = new OneofEvaluator(oneofDesc, oneofConstraints.getRequired());
                msgEval.append(oneofEvaluatorEval);
            }
        }

        private void processFields(Descriptors.Descriptor desc, MessageEvaluator msgEval) throws CompilationException, InvalidProtocolBufferException {
            List fields = desc.getFields();
            for (Descriptors.FieldDescriptor fieldDescriptor : fields) {
                Descriptors.FieldDescriptor descriptor = desc.findFieldByName(fieldDescriptor.getName());
                FieldConstraints fieldConstraints = this.resolver.resolveFieldConstraints(descriptor, EXTENSION_REGISTRY);
                FieldEvaluator fldEval = this.buildField(descriptor, fieldConstraints);
                msgEval.append(fldEval);
            }
        }

        private FieldEvaluator buildField(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints) throws CompilationException {
            ValueEvaluator valueEvaluatorEval = new ValueEvaluator();
            boolean ignoreDefault = fieldDescriptor.hasPresence() && DescriptorCacheBuilder.shouldIgnoreDefault(fieldConstraints);
            Object zero = null;
            if (ignoreDefault) {
                zero = this.zeroValue(fieldDescriptor, false);
            }
            FieldEvaluator fieldEvaluator = new FieldEvaluator(valueEvaluatorEval, fieldDescriptor, fieldConstraints.getRequired(), fieldDescriptor.hasPresence() || DescriptorCacheBuilder.shouldIgnoreEmpty(fieldConstraints), fieldDescriptor.hasPresence() && DescriptorCacheBuilder.shouldIgnoreDefault(fieldConstraints), zero);
            this.buildValue(fieldDescriptor, fieldConstraints, false, fieldEvaluator.valueEvaluator);
            return fieldEvaluator;
        }

        private boolean shouldSkip(FieldConstraints constraints) {
            return constraints.getSkipped() || constraints.getIgnore() == Ignore.IGNORE_ALWAYS;
        }

        private static boolean shouldIgnoreEmpty(FieldConstraints constraints) {
            return constraints.getIgnoreEmpty() || constraints.getIgnore() == Ignore.IGNORE_IF_UNPOPULATED || constraints.getIgnore() == Ignore.IGNORE_IF_DEFAULT_VALUE;
        }

        private static boolean shouldIgnoreDefault(FieldConstraints constraints) {
            return constraints.getIgnore() == Ignore.IGNORE_IF_DEFAULT_VALUE;
        }

        private void buildValue(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems, ValueEvaluator valueEvaluator) throws CompilationException {
            this.processIgnoreEmpty(fieldDescriptor, fieldConstraints, forItems, valueEvaluator);
            this.processFieldExpressions(fieldDescriptor, fieldConstraints, valueEvaluator);
            this.processEmbeddedMessage(fieldDescriptor, fieldConstraints, forItems, valueEvaluator);
            this.processWrapperConstraints(fieldDescriptor, fieldConstraints, forItems, valueEvaluator);
            this.processStandardConstraints(fieldDescriptor, fieldConstraints, forItems, valueEvaluator);
            this.processAnyConstraints(fieldDescriptor, fieldConstraints, forItems, valueEvaluator);
            this.processEnumConstraints(fieldDescriptor, fieldConstraints, valueEvaluator);
            this.processMapConstraints(fieldDescriptor, fieldConstraints, valueEvaluator);
            this.processRepeatedConstraints(fieldDescriptor, fieldConstraints, forItems, valueEvaluator);
        }

        private void processIgnoreEmpty(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (forItems && DescriptorCacheBuilder.shouldIgnoreEmpty(fieldConstraints)) {
                valueEvaluatorEval.setIgnoreEmpty(this.zeroValue(fieldDescriptor, true));
            }
        }

        private Object zeroValue(Descriptors.FieldDescriptor fieldDescriptor, boolean forItems) throws CompilationException {
            Object zero;
            if (forItems && fieldDescriptor.isRepeated()) {
                switch (fieldDescriptor.getType().getJavaType()) {
                    case INT: {
                        zero = 0;
                        break;
                    }
                    case LONG: {
                        zero = 0L;
                        break;
                    }
                    case FLOAT: {
                        zero = Float.valueOf(0.0f);
                        break;
                    }
                    case DOUBLE: {
                        zero = 0.0;
                        break;
                    }
                    case BOOLEAN: {
                        zero = false;
                        break;
                    }
                    case STRING: {
                        zero = "";
                        break;
                    }
                    case BYTE_STRING: {
                        zero = ByteString.EMPTY;
                        break;
                    }
                    case ENUM: {
                        zero = fieldDescriptor.getEnumType().getValues().get(0);
                        break;
                    }
                    case MESSAGE: {
                        zero = this.createMessageForType(fieldDescriptor.getMessageType());
                        break;
                    }
                    default: {
                        zero = fieldDescriptor.getDefaultValue();
                        break;
                    }
                }
            } else {
                zero = fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && !fieldDescriptor.isRepeated() ? this.createMessageForType(fieldDescriptor.getMessageType()) : fieldDescriptor.getDefaultValue();
            }
            return zero;
        }

        private Message createMessageForType(Descriptors.Descriptor messageType) throws CompilationException {
            try {
                return DynamicMessage.parseFrom((Descriptors.Descriptor)messageType, (byte[])new byte[0], (ExtensionRegistry)EXTENSION_REGISTRY);
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompilationException("field descriptor type is invalid " + e.getMessage(), e);
            }
        }

        private void processFieldExpressions(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            List<EnvOption> opts;
            List<Constraint> constraintsCelList = fieldConstraints.getCelList();
            if (constraintsCelList.isEmpty()) {
                return;
            }
            if (fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                try {
                    DynamicMessage defaultInstance = DynamicMessage.parseFrom((Descriptors.Descriptor)fieldDescriptor.getMessageType(), (byte[])new byte[0], (ExtensionRegistry)EXTENSION_REGISTRY);
                    opts = Arrays.asList(EnvOption.types((Object[])new Object[]{defaultInstance}), EnvOption.declarations((Decl[])new Decl[]{Decls.newVar((String)"this", (Type)Decls.newObjectType((String)fieldDescriptor.getMessageType().getFullName()))}));
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CompilationException("field descriptor type is invalid " + e.getMessage(), e);
                }
            } else {
                opts = Collections.singletonList(EnvOption.declarations((Decl[])new Decl[]{Decls.newVar((String)"this", (Type)DescriptorMappings.protoKindToCELType(fieldDescriptor.getType()))}));
            }
            Env finalEnv = this.env.extend(opts.toArray(new EnvOption[0]));
            List<CompiledProgram> compiledPrograms = DescriptorCacheBuilder.compileConstraints(constraintsCelList, finalEnv);
            if (!compiledPrograms.isEmpty()) {
                valueEvaluatorEval.append(new CelPrograms(compiledPrograms));
            }
        }

        private void processEmbeddedMessage(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || this.shouldSkip(fieldConstraints) || fieldDescriptor.isMapField() || fieldDescriptor.isRepeated() && !forItems) {
                return;
            }
            Evaluator embedEval = this.createMessageEvaluator(fieldDescriptor.getMessageType());
            valueEvaluatorEval.append(embedEval);
        }

        private void processWrapperConstraints(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || this.shouldSkip(fieldConstraints) || fieldDescriptor.isMapField() || fieldDescriptor.isRepeated() && !forItems) {
                return;
            }
            Descriptors.FieldDescriptor expectedWrapperDescriptor = DescriptorMappings.expectedWrapperConstraints(fieldDescriptor.getMessageType().getFullName());
            if (expectedWrapperDescriptor == null || !fieldConstraints.hasField(expectedWrapperDescriptor)) {
                return;
            }
            ValueEvaluator unwrapped = new ValueEvaluator();
            this.buildValue(fieldDescriptor.getMessageType().findFieldByName("value"), fieldConstraints, true, unwrapped);
            valueEvaluatorEval.append(unwrapped);
        }

        private void processStandardConstraints(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            List<CompiledProgram> compile = this.constraintCache.compile(fieldDescriptor, fieldConstraints, forItems);
            if (compile.isEmpty()) {
                return;
            }
            valueEvaluatorEval.append(new CelPrograms(compile));
        }

        private void processAnyConstraints(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems, ValueEvaluator valueEvaluatorEval) {
            if (fieldDescriptor.isRepeated() && !forItems || fieldDescriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE || !fieldDescriptor.getMessageType().getFullName().equals("google.protobuf.Any")) {
                return;
            }
            Descriptors.FieldDescriptor typeURLDesc = fieldDescriptor.getMessageType().findFieldByName("type_url");
            AnyEvaluator anyEvaluatorEval = new AnyEvaluator(typeURLDesc, (List<String>)fieldConstraints.getAny().getInList(), (List<String>)fieldConstraints.getAny().getNotInList());
            valueEvaluatorEval.append(anyEvaluatorEval);
        }

        private void processEnumConstraints(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, ValueEvaluator valueEvaluatorEval) {
            if (fieldDescriptor.getJavaType() != Descriptors.FieldDescriptor.JavaType.ENUM) {
                return;
            }
            if (fieldConstraints.getEnum().getDefinedOnly()) {
                Descriptors.EnumDescriptor enumDescriptor = fieldDescriptor.getEnumType();
                valueEvaluatorEval.append(new EnumEvaluator(enumDescriptor.getValues()));
            }
        }

        private void processMapConstraints(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (!fieldDescriptor.isMapField()) {
                return;
            }
            MapEvaluator mapEval = new MapEvaluator(fieldConstraints, fieldDescriptor);
            this.buildValue(fieldDescriptor.getMessageType().findFieldByNumber(1), fieldConstraints.getMap().getKeys(), true, mapEval.getKeyEvaluator());
            this.buildValue(fieldDescriptor.getMessageType().findFieldByNumber(2), fieldConstraints.getMap().getValues(), true, mapEval.getValueEvaluator());
            valueEvaluatorEval.append(mapEval);
        }

        private void processRepeatedConstraints(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems, ValueEvaluator valueEvaluatorEval) throws CompilationException {
            if (fieldDescriptor.isMapField() || !fieldDescriptor.isRepeated() || forItems) {
                return;
            }
            ListEvaluator listEval = new ListEvaluator();
            this.buildValue(fieldDescriptor, fieldConstraints.getRepeated().getItems(), true, listEval.itemConstraints);
            valueEvaluatorEval.append(listEval);
        }

        private static List<CompiledProgram> compileConstraints(List<Constraint> constraints, Env env) throws CompilationException {
            List<Expression> expressions = Expression.fromConstraints(constraints);
            ArrayList<CompiledProgram> compiledPrograms = new ArrayList<CompiledProgram>();
            for (Expression expression : expressions) {
                AstExpression astExpression = AstExpression.newAstExpression(env, expression);
                compiledPrograms.add(new CompiledProgram(env.program(astExpression.ast, new ProgramOption[0]), astExpression.source));
            }
            return compiledPrograms;
        }
    }
}

