/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.validate.Violation;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;

public class OneofEvaluator
implements Evaluator {
    private final Descriptors.OneofDescriptor descriptor;
    private final boolean required;

    public OneofEvaluator(Descriptors.OneofDescriptor descriptor, boolean required) {
        this.descriptor = descriptor;
        this.required = required;
    }

    @Override
    public boolean tautology() {
        return !this.required;
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        Message message = val.messageValue();
        if (message == null) {
            return ValidationResult.EMPTY;
        }
        if (this.required && message.getOneofFieldDescriptor(this.descriptor) == null) {
            return new ValidationResult(Collections.singletonList(Violation.newBuilder().setFieldPath(this.descriptor.getName()).setConstraintId("required").setMessage("exactly one field is required in oneof").build()));
        }
        return ValidationResult.EMPTY;
    }
}

