/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Address;
import org.hl7.fhir.dstu3.model.AllergyIntolerance;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Appointment;
import org.hl7.fhir.dstu3.model.AppointmentResponse;
import org.hl7.fhir.dstu3.model.AuditEvent;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Binary;
import org.hl7.fhir.dstu3.model.BodySite;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.dstu3.model.CareTeam;
import org.hl7.fhir.dstu3.model.ClinicalImpression;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Communication;
import org.hl7.fhir.dstu3.model.CompartmentDefinition;
import org.hl7.fhir.dstu3.model.Composition;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Consent;
import org.hl7.fhir.dstu3.model.ContactPoint;
import org.hl7.fhir.dstu3.model.Contributor;
import org.hl7.fhir.dstu3.model.Count;
import org.hl7.fhir.dstu3.model.DataElement;
import org.hl7.fhir.dstu3.model.DataRequirement;
import org.hl7.fhir.dstu3.model.DetectedIssue;
import org.hl7.fhir.dstu3.model.DeviceUseStatement;
import org.hl7.fhir.dstu3.model.DiagnosticReport;
import org.hl7.fhir.dstu3.model.DocumentManifest;
import org.hl7.fhir.dstu3.model.DocumentReference;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Dosage;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.Endpoint;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.ExpansionProfile;
import org.hl7.fhir.dstu3.model.FamilyMemberHistory;
import org.hl7.fhir.dstu3.model.Flag;
import org.hl7.fhir.dstu3.model.Goal;
import org.hl7.fhir.dstu3.model.GraphDefinition;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.HumanName;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Immunization;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.Library;
import org.hl7.fhir.dstu3.model.Linkage;
import org.hl7.fhir.dstu3.model.ListResource;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.dstu3.model.MedicationAdministration;
import org.hl7.fhir.dstu3.model.MedicationDispense;
import org.hl7.fhir.dstu3.model.MedicationRequest;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.dstu3.model.MessageDefinition;
import org.hl7.fhir.dstu3.model.MessageHeader;
import org.hl7.fhir.dstu3.model.Money;
import org.hl7.fhir.dstu3.model.NamingSystem;
import org.hl7.fhir.dstu3.model.Narrative;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.OperationDefinition;
import org.hl7.fhir.dstu3.model.OperationOutcome;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.ParameterDefinition;
import org.hl7.fhir.dstu3.model.Parameters;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.PaymentNotice;
import org.hl7.fhir.dstu3.model.Person;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PractitionerRole;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.QuestionnaireResponse;
import org.hl7.fhir.dstu3.model.Range;
import org.hl7.fhir.dstu3.model.Ratio;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedArtifact;
import org.hl7.fhir.dstu3.model.RiskAssessment;
import org.hl7.fhir.dstu3.model.Schedule;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.Sequence;
import org.hl7.fhir.dstu3.model.Signature;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.Slot;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.StructureMap;
import org.hl7.fhir.dstu3.model.Subscription;
import org.hl7.fhir.dstu3.model.Substance;
import org.hl7.fhir.dstu3.model.SupplyDelivery;
import org.hl7.fhir.dstu3.model.TestReport;
import org.hl7.fhir.dstu3.model.TestScript;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.TriggerDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.UuidType;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.ClinicalImpression;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.CompartmentDefinition;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.DeviceUseStatement;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Flag;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.GraphDefinition;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Linkage;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationAdministration;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MessageDefinition;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.MolecularSequence;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PaymentNotice;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SupplyDelivery;
import org.hl7.fhir.r4.model.TerminologyCapabilities;
import org.hl7.fhir.r4.model.TestReport;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_30_40 {
    private static List<String> CANONICAL_URLS = new ArrayList<String>();

    private static void copyElement(org.hl7.fhir.dstu3.model.Element src, Element tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (org.hl7.fhir.dstu3.model.Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_30_40.convertExtension(e));
        }
    }

    private static void copyElement(Element src, org.hl7.fhir.dstu3.model.Element tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        for (Extension e : src.getExtension()) {
            tgt.addExtension(VersionConvertor_30_40.convertExtension(e));
        }
    }

    private static void copyBackboneElement(BackboneElement src, org.hl7.fhir.r4.model.BackboneElement tgt) throws FHIRException {
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(e));
        }
    }

    private static void copyBackboneElement(org.hl7.fhir.r4.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(e));
        }
    }

    public static Base64BinaryType convertBase64Binary(org.hl7.fhir.dstu3.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = new Base64BinaryType((byte[])src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.Base64BinaryType tgt = new org.hl7.fhir.dstu3.model.Base64BinaryType((byte[])src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.r4.model.BooleanType tgt = new org.hl7.fhir.r4.model.BooleanType((Boolean)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static BooleanType convertBoolean(org.hl7.fhir.r4.model.BooleanType src) throws FHIRException {
        BooleanType tgt = new BooleanType((Boolean)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.r4.model.CodeType tgt = new org.hl7.fhir.r4.model.CodeType((String)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static CodeType convertCode(org.hl7.fhir.r4.model.CodeType src) throws FHIRException {
        CodeType tgt = new CodeType((String)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static DateType convertDate(org.hl7.fhir.dstu3.model.DateType src) throws FHIRException {
        DateType tgt = new DateType(src.getValueAsString());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static DateTimeType convertDateToDateTime(org.hl7.fhir.dstu3.model.DateType src) throws FHIRException {
        DateTimeType tgt = new DateTimeType(src.getValueAsString());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateType convertDateTimeToDate(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateType tgt = new org.hl7.fhir.dstu3.model.DateType(src.getValueAsString());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateType tgt = new org.hl7.fhir.dstu3.model.DateType(src.getValueAsString());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static DateTimeType convertDateTime(org.hl7.fhir.dstu3.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = new DateTimeType(src.getValueAsString());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DateTimeType tgt = new org.hl7.fhir.dstu3.model.DateTimeType(src.getValueAsString());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static DecimalType convertDecimal(org.hl7.fhir.dstu3.model.DecimalType src) throws FHIRException {
        DecimalType tgt = new DecimalType((BigDecimal)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.DecimalType tgt = new org.hl7.fhir.dstu3.model.DecimalType((BigDecimal)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static IdType convertId(org.hl7.fhir.dstu3.model.IdType src) throws FHIRException {
        IdType tgt = new IdType(src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.IdType tgt = new org.hl7.fhir.dstu3.model.IdType(src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static InstantType convertInstant(org.hl7.fhir.dstu3.model.InstantType src) throws FHIRException {
        InstantType tgt = new InstantType(src.getValueAsString());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.InstantType tgt = new org.hl7.fhir.dstu3.model.InstantType(src.getValueAsString());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static IntegerType convertInteger(org.hl7.fhir.dstu3.model.IntegerType src) throws FHIRException {
        IntegerType tgt = new IntegerType(((Integer)src.getValue()).intValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.IntegerType tgt = new org.hl7.fhir.dstu3.model.IntegerType(((Integer)src.getValue()).intValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.r4.model.MarkdownType tgt = new org.hl7.fhir.r4.model.MarkdownType((String)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static MarkdownType convertMarkdown(org.hl7.fhir.r4.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = new MarkdownType((String)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.r4.model.OidType tgt = new org.hl7.fhir.r4.model.OidType((String)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static OidType convertOid(org.hl7.fhir.r4.model.OidType src) throws FHIRException {
        OidType tgt = new OidType((String)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static PositiveIntType convertPositiveInt(org.hl7.fhir.dstu3.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = new PositiveIntType(((Integer)src.getValue()).intValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.PositiveIntType tgt = new org.hl7.fhir.dstu3.model.PositiveIntType(((Integer)src.getValue()).intValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.r4.model.StringType tgt = new org.hl7.fhir.r4.model.StringType((String)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static StringType convertString(org.hl7.fhir.r4.model.StringType src) throws FHIRException {
        StringType tgt = new StringType((String)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.r4.model.TimeType tgt = new org.hl7.fhir.r4.model.TimeType((String)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static TimeType convertTime(org.hl7.fhir.r4.model.TimeType src) throws FHIRException {
        TimeType tgt = new TimeType((String)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static UnsignedIntType convertUnsignedInt(org.hl7.fhir.dstu3.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = new UnsignedIntType(((Integer)src.getValue()).intValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.UnsignedIntType tgt = new org.hl7.fhir.dstu3.model.UnsignedIntType(((Integer)src.getValue()).intValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static UriType convertUri(org.hl7.fhir.dstu3.model.UriType src) throws FHIRException {
        UriType tgt = new UriType((String)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static UrlType convertUriToUrl(org.hl7.fhir.dstu3.model.UriType src) throws FHIRException {
        UrlType tgt = new UrlType((String)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.dstu3.model.UriType tgt = new org.hl7.fhir.dstu3.model.UriType((String)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.r4.model.UuidType tgt = new org.hl7.fhir.r4.model.UuidType((String)src.getValue());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        return tgt;
    }

    public static UuidType convertUuid(org.hl7.fhir.r4.model.UuidType src) throws FHIRException {
        UuidType tgt = new UuidType((String)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        return tgt;
    }

    public static Extension convertExtension(org.hl7.fhir.dstu3.model.Extension src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Extension tgt = new Extension();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof Reference) {
                tgt.setValue((org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertReferenceToCanonical((Reference)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Extension tgt = new org.hl7.fhir.dstu3.model.Extension();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof CanonicalType) {
                tgt.setValue((Type)VersionConvertor_30_40.convertCanonicalToReference((CanonicalType)src.getValue()));
            } else {
                tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public static Narrative convertNarrative(org.hl7.fhir.dstu3.model.Narrative src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Narrative tgt = new Narrative();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertNarrativeStatus(src.getStatus()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(src.getDiv());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Narrative tgt = new org.hl7.fhir.dstu3.model.Narrative();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertNarrativeStatus(src.getStatus()));
        }
        if (src.hasDiv()) {
            tgt.setDiv(src.getDiv());
        }
        return tgt;
    }

    private static Narrative.NarrativeStatus convertNarrativeStatus(Narrative.NarrativeStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GENERATED: {
                return Narrative.NarrativeStatus.GENERATED;
            }
            case EXTENSIONS: {
                return Narrative.NarrativeStatus.EXTENSIONS;
            }
            case ADDITIONAL: {
                return Narrative.NarrativeStatus.ADDITIONAL;
            }
            case EMPTY: {
                return Narrative.NarrativeStatus.EMPTY;
            }
        }
        return Narrative.NarrativeStatus.NULL;
    }

    private static Narrative.NarrativeStatus convertNarrativeStatus(Narrative.NarrativeStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GENERATED: {
                return Narrative.NarrativeStatus.GENERATED;
            }
            case EXTENSIONS: {
                return Narrative.NarrativeStatus.EXTENSIONS;
            }
            case ADDITIONAL: {
                return Narrative.NarrativeStatus.ADDITIONAL;
            }
            case EMPTY: {
                return Narrative.NarrativeStatus.EMPTY;
            }
        }
        return Narrative.NarrativeStatus.NULL;
    }

    public static Age convertAge(org.hl7.fhir.dstu3.model.Age src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Age tgt = new Age();
        VersionConvertor_30_40.copyQuantity((org.hl7.fhir.dstu3.model.Quantity)src, (Quantity)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Age convertAge(Age src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Age tgt = new org.hl7.fhir.dstu3.model.Age();
        VersionConvertor_30_40.copyQuantity((Quantity)src, (org.hl7.fhir.dstu3.model.Quantity)tgt);
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Annotation tgt = new org.hl7.fhir.r4.model.Annotation();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTime(src.getTime());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static Annotation convertAnnotation(org.hl7.fhir.r4.model.Annotation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Annotation tgt = new Annotation();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertType(src.getAuthor()));
        }
        if (src.hasTime()) {
            tgt.setTime(src.getTime());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static Attachment convertAttachment(org.hl7.fhir.dstu3.model.Attachment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Attachment tgt = new Attachment();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasContentType()) {
            tgt.setContentType(src.getContentType());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasData()) {
            tgt.setData(src.getData());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSize(src.getSize());
        }
        if (src.hasHash()) {
            tgt.setHash(src.getHash());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasCreation()) {
            tgt.setCreation(src.getCreation());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Attachment tgt = new org.hl7.fhir.dstu3.model.Attachment();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasContentType()) {
            tgt.setContentType(src.getContentType());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasData()) {
            tgt.setData(src.getData());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasSize()) {
            tgt.setSize(src.getSize());
        }
        if (src.hasHash()) {
            tgt.setHash(src.getHash());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasCreation()) {
            tgt.setCreation(src.getCreation());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept tgt = new org.hl7.fhir.r4.model.CodeableConcept();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static CodeableConcept convertCodeableConcept(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.Coding t : src.getCoding()) {
            tgt.addCoding(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Coding tgt = new org.hl7.fhir.r4.model.Coding();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelected(src.getUserSelected());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Coding convertCoding(CodeType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Coding tgt = new org.hl7.fhir.r4.model.Coding();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        tgt.setCode((String)src.getValue());
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CodeableConcept convertCodingToCodeableConcept(Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept tgt = new org.hl7.fhir.r4.model.CodeableConcept();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSystem()) {
            tgt.getCodingFirstRep().setSystem(src.getSystem());
        }
        if (src.hasVersion()) {
            tgt.getCodingFirstRep().setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.getCodingFirstRep().setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.getCodingFirstRep().setDisplay(src.getDisplay());
        }
        if (src.hasUserSelected()) {
            tgt.getCodingFirstRep().setUserSelected(src.getUserSelected());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Coding convertCoding(CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Coding tgt = new org.hl7.fhir.r4.model.Coding();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCoding()) {
            if (src.getCodingFirstRep().hasSystem()) {
                tgt.setSystem(src.getCodingFirstRep().getSystem());
            }
            if (src.getCodingFirstRep().hasVersion()) {
                tgt.setVersion(src.getCodingFirstRep().getVersion());
            }
            if (src.getCodingFirstRep().hasCode()) {
                tgt.setCode(src.getCodingFirstRep().getCode());
            }
            if (src.getCodingFirstRep().hasDisplay()) {
                tgt.setDisplay(src.getCodingFirstRep().getDisplay());
            }
            if (src.getCodingFirstRep().hasUserSelected()) {
                tgt.setUserSelected(src.getCodingFirstRep().getUserSelected());
            }
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCoding()) {
            if (src.getCodingFirstRep().hasSystem()) {
                tgt.setSystem(src.getCodingFirstRep().getSystem());
            }
            if (src.getCodingFirstRep().hasVersion()) {
                tgt.setVersion(src.getCodingFirstRep().getVersion());
            }
            if (src.getCodingFirstRep().hasCode()) {
                tgt.setCode(src.getCodingFirstRep().getCode());
            }
            if (src.getCodingFirstRep().hasDisplay()) {
                tgt.setDisplay(src.getCodingFirstRep().getDisplay());
            }
            if (src.getCodingFirstRep().hasUserSelected()) {
                tgt.setUserSelected(src.getCodingFirstRep().getUserSelected());
            }
        }
        return tgt;
    }

    public static Coding convertCoding(org.hl7.fhir.r4.model.Coding src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Coding tgt = new Coding();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasUserSelected()) {
            tgt.setUserSelected(src.getUserSelected());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Count convertCount(Count src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Count tgt = new org.hl7.fhir.r4.model.Count();
        VersionConvertor_30_40.copyQuantity((org.hl7.fhir.dstu3.model.Quantity)src, (Quantity)tgt);
        return tgt;
    }

    public static Count convertCount(org.hl7.fhir.r4.model.Count src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Count tgt = new Count();
        VersionConvertor_30_40.copyQuantity((Quantity)src, (org.hl7.fhir.dstu3.model.Quantity)tgt);
        return tgt;
    }

    public static Distance convertDistance(org.hl7.fhir.dstu3.model.Distance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Distance tgt = new Distance();
        VersionConvertor_30_40.copyQuantity((org.hl7.fhir.dstu3.model.Quantity)src, (Quantity)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Distance tgt = new org.hl7.fhir.dstu3.model.Distance();
        VersionConvertor_30_40.copyQuantity((Quantity)src, (org.hl7.fhir.dstu3.model.Quantity)tgt);
        return tgt;
    }

    public static Duration convertDuration(org.hl7.fhir.dstu3.model.Duration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Duration tgt = new Duration();
        VersionConvertor_30_40.copyQuantity((org.hl7.fhir.dstu3.model.Quantity)src, (Quantity)tgt);
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Duration tgt = new org.hl7.fhir.dstu3.model.Duration();
        VersionConvertor_30_40.copyQuantity((Quantity)src, (org.hl7.fhir.dstu3.model.Quantity)tgt);
        return tgt;
    }

    public static Identifier convertIdentifier(org.hl7.fhir.dstu3.model.Identifier src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Identifier tgt = new Identifier();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertIdentifierUse(src.getUse()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_30_40.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Identifier tgt = new org.hl7.fhir.dstu3.model.Identifier();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertIdentifierUse(src.getUse()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(VersionConvertor_30_40.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    private static Identifier.IdentifierUse convertIdentifierUse(Identifier.IdentifierUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return Identifier.IdentifierUse.USUAL;
            }
            case OFFICIAL: {
                return Identifier.IdentifierUse.OFFICIAL;
            }
            case TEMP: {
                return Identifier.IdentifierUse.TEMP;
            }
            case SECONDARY: {
                return Identifier.IdentifierUse.SECONDARY;
            }
        }
        return Identifier.IdentifierUse.NULL;
    }

    private static Identifier.IdentifierUse convertIdentifierUse(Identifier.IdentifierUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return Identifier.IdentifierUse.USUAL;
            }
            case OFFICIAL: {
                return Identifier.IdentifierUse.OFFICIAL;
            }
            case TEMP: {
                return Identifier.IdentifierUse.TEMP;
            }
            case SECONDARY: {
                return Identifier.IdentifierUse.SECONDARY;
            }
        }
        return Identifier.IdentifierUse.NULL;
    }

    public static org.hl7.fhir.r4.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Money tgt = new org.hl7.fhir.r4.model.Money();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasCode()) {
            tgt.setCurrency(src.getCode());
        }
        return tgt;
    }

    public static Money convertMoney(org.hl7.fhir.r4.model.Money src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Money tgt = new Money();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasCurrency()) {
            tgt.setCode(src.getCurrency());
        }
        return tgt;
    }

    public static Period convertPeriod(org.hl7.fhir.dstu3.model.Period src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Period tgt = new Period();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Period tgt = new org.hl7.fhir.dstu3.model.Period();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        return tgt;
    }

    public static void copyQuantity(org.hl7.fhir.dstu3.model.Quantity src, Quantity tgt) throws FHIRException {
        if (src == null || tgt == null) {
            return;
        }
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparator(VersionConvertor_30_40.convertQuantityComparator(src.getComparator()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
    }

    public static void copyQuantity(Quantity src, org.hl7.fhir.dstu3.model.Quantity tgt) throws FHIRException {
        if (src == null || tgt == null) {
            return;
        }
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparator(VersionConvertor_30_40.convertQuantityComparator(src.getComparator()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
    }

    public static Quantity convertQuantity(org.hl7.fhir.dstu3.model.Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Quantity tgt = new Quantity();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparator(VersionConvertor_30_40.convertQuantityComparator(src.getComparator()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Quantity tgt = new org.hl7.fhir.dstu3.model.Quantity();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparator(VersionConvertor_30_40.convertQuantityComparator(src.getComparator()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    private static Quantity.QuantityComparator convertQuantityComparator(Quantity.QuantityComparator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LESS_THAN: {
                return Quantity.QuantityComparator.LESS_THAN;
            }
            case LESS_OR_EQUAL: {
                return Quantity.QuantityComparator.LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Quantity.QuantityComparator.GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Quantity.QuantityComparator.GREATER_THAN;
            }
        }
        return Quantity.QuantityComparator.NULL;
    }

    private static Quantity.QuantityComparator convertQuantityComparator(Quantity.QuantityComparator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LESS_THAN: {
                return Quantity.QuantityComparator.LESS_THAN;
            }
            case LESS_OR_EQUAL: {
                return Quantity.QuantityComparator.LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Quantity.QuantityComparator.GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Quantity.QuantityComparator.GREATER_THAN;
            }
        }
        return Quantity.QuantityComparator.NULL;
    }

    public static org.hl7.fhir.r4.model.Range convertRange(Range src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Range tgt = new org.hl7.fhir.r4.model.Range();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_40.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static Range convertRange(org.hl7.fhir.r4.model.Range src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Range tgt = new Range();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_40.convertSimpleQuantity(src.getHigh()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Ratio tgt = new org.hl7.fhir.r4.model.Ratio();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_30_40.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_30_40.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static Ratio convertRatio(org.hl7.fhir.r4.model.Ratio src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Ratio tgt = new Ratio();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasNumerator()) {
            tgt.setNumerator(VersionConvertor_30_40.convertQuantity(src.getNumerator()));
        }
        if (src.hasDenominator()) {
            tgt.setDenominator(VersionConvertor_30_40.convertQuantity(src.getDenominator()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Reference tgt = new org.hl7.fhir.r4.model.Reference();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        return tgt;
    }

    public static Reference convertReference(org.hl7.fhir.r4.model.Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Reference tgt = new Reference();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        return tgt;
    }

    public static SampledData convertSampledData(org.hl7.fhir.dstu3.model.SampledData src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SampledData tgt = new SampledData();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_40.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(src.getPeriod());
        }
        if (src.hasFactor()) {
            tgt.setFactor(src.getFactor());
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimit(src.getLowerLimit());
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimit(src.getUpperLimit());
        }
        if (src.hasDimensions()) {
            tgt.setDimensions(src.getDimensions());
        }
        if (src.hasData()) {
            tgt.setData(src.getData());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.SampledData tgt = new org.hl7.fhir.dstu3.model.SampledData();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_40.convertSimpleQuantity(src.getOrigin()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(src.getPeriod());
        }
        if (src.hasFactor()) {
            tgt.setFactor(src.getFactor());
        }
        if (src.hasLowerLimit()) {
            tgt.setLowerLimit(src.getLowerLimit());
        }
        if (src.hasUpperLimit()) {
            tgt.setUpperLimit(src.getUpperLimit());
        }
        if (src.hasDimensions()) {
            tgt.setDimensions(src.getDimensions());
        }
        if (src.hasData()) {
            tgt.setData(src.getData());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Signature tgt = new org.hl7.fhir.r4.model.Signature();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasWhen()) {
            tgt.setWhen(src.getWhen());
        }
        if (src.hasWho()) {
            if (src.hasWhoUriType()) {
                tgt.setWho(new org.hl7.fhir.r4.model.Reference((String)src.getWhoUriType().getValue()));
            } else {
                tgt.setWho(VersionConvertor_30_40.convertReference(src.getWhoReference()));
            }
        }
        if (src.hasOnBehalfOf()) {
            if (src.hasOnBehalfOfUriType()) {
                tgt.setOnBehalfOf(new org.hl7.fhir.r4.model.Reference(src.getOnBehalfOfUriType().primitiveValue()));
            } else {
                tgt.setOnBehalfOf(VersionConvertor_30_40.convertReference(src.getOnBehalfOfReference()));
            }
        }
        if (src.hasContentType()) {
            tgt.setSigFormat(src.getContentType());
        }
        if (src.hasBlob()) {
            tgt.setData(src.getBlob());
        }
        return tgt;
    }

    public static Signature convertSignature(org.hl7.fhir.r4.model.Signature src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Signature tgt = new Signature();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasWhen()) {
            tgt.setWhen(src.getWhen());
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getOnBehalfOf()));
        }
        if (src.hasSigFormat()) {
            tgt.setContentType(src.getSigFormat());
        }
        if (src.hasData()) {
            tgt.setBlob(src.getData());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Address tgt = new org.hl7.fhir.r4.model.Address();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertAddressUse(src.getUse()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertAddressType(src.getType()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCity(src.getCity());
        }
        if (src.hasDistrict()) {
            tgt.setDistrict(src.getDistrict());
        }
        if (src.hasState()) {
            tgt.setState(src.getState());
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCode(src.getPostalCode());
        }
        if (src.hasCountry()) {
            tgt.setCountry(src.getCountry());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Address convertAddress(org.hl7.fhir.r4.model.Address src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Address tgt = new Address();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertAddressUse(src.getUse()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertAddressType(src.getType()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        if (src.hasCity()) {
            tgt.setCity(src.getCity());
        }
        if (src.hasDistrict()) {
            tgt.setDistrict(src.getDistrict());
        }
        if (src.hasState()) {
            tgt.setState(src.getState());
        }
        if (src.hasPostalCode()) {
            tgt.setPostalCode(src.getPostalCode());
        }
        if (src.hasCountry()) {
            tgt.setCountry(src.getCountry());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    private static Address.AddressUse convertAddressUse(Address.AddressUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return Address.AddressUse.HOME;
            }
            case WORK: {
                return Address.AddressUse.WORK;
            }
            case TEMP: {
                return Address.AddressUse.TEMP;
            }
            case OLD: {
                return Address.AddressUse.OLD;
            }
        }
        return Address.AddressUse.NULL;
    }

    private static Address.AddressUse convertAddressUse(Address.AddressUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return Address.AddressUse.HOME;
            }
            case WORK: {
                return Address.AddressUse.WORK;
            }
            case TEMP: {
                return Address.AddressUse.TEMP;
            }
            case OLD: {
                return Address.AddressUse.OLD;
            }
        }
        return Address.AddressUse.NULL;
    }

    private static Address.AddressType convertAddressType(Address.AddressType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case POSTAL: {
                return Address.AddressType.POSTAL;
            }
            case PHYSICAL: {
                return Address.AddressType.PHYSICAL;
            }
            case BOTH: {
                return Address.AddressType.BOTH;
            }
        }
        return Address.AddressType.NULL;
    }

    private static Address.AddressType convertAddressType(Address.AddressType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case POSTAL: {
                return Address.AddressType.POSTAL;
            }
            case PHYSICAL: {
                return Address.AddressType.PHYSICAL;
            }
            case BOTH: {
                return Address.AddressType.BOTH;
            }
        }
        return Address.AddressType.NULL;
    }

    public static ContactDetail convertContactDetail(org.hl7.fhir.dstu3.model.ContactDetail src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ContactDetail convertContactDetail(ContactDetail src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ContactDetail tgt = new org.hl7.fhir.dstu3.model.ContactDetail();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactPoint convertContactPoint(org.hl7.fhir.dstu3.model.ContactPoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(VersionConvertor_30_40.convertContactPointSystem(src.getSystem()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertContactPointUse(src.getUse()));
        }
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ContactPoint tgt = new org.hl7.fhir.dstu3.model.ContactPoint();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(VersionConvertor_30_40.convertContactPointSystem(src.getSystem()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertContactPointUse(src.getUse()));
        }
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    private static ContactPoint.ContactPointSystem convertContactPointSystem(ContactPoint.ContactPointSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PHONE: {
                return ContactPoint.ContactPointSystem.PHONE;
            }
            case FAX: {
                return ContactPoint.ContactPointSystem.FAX;
            }
            case EMAIL: {
                return ContactPoint.ContactPointSystem.EMAIL;
            }
            case PAGER: {
                return ContactPoint.ContactPointSystem.PAGER;
            }
            case URL: {
                return ContactPoint.ContactPointSystem.URL;
            }
            case SMS: {
                return ContactPoint.ContactPointSystem.SMS;
            }
            case OTHER: {
                return ContactPoint.ContactPointSystem.OTHER;
            }
        }
        return ContactPoint.ContactPointSystem.NULL;
    }

    private static ContactPoint.ContactPointSystem convertContactPointSystem(ContactPoint.ContactPointSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PHONE: {
                return ContactPoint.ContactPointSystem.PHONE;
            }
            case FAX: {
                return ContactPoint.ContactPointSystem.FAX;
            }
            case EMAIL: {
                return ContactPoint.ContactPointSystem.EMAIL;
            }
            case PAGER: {
                return ContactPoint.ContactPointSystem.PAGER;
            }
            case URL: {
                return ContactPoint.ContactPointSystem.URL;
            }
            case SMS: {
                return ContactPoint.ContactPointSystem.SMS;
            }
            case OTHER: {
                return ContactPoint.ContactPointSystem.OTHER;
            }
        }
        return ContactPoint.ContactPointSystem.NULL;
    }

    private static ContactPoint.ContactPointUse convertContactPointUse(ContactPoint.ContactPointUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return ContactPoint.ContactPointUse.HOME;
            }
            case WORK: {
                return ContactPoint.ContactPointUse.WORK;
            }
            case TEMP: {
                return ContactPoint.ContactPointUse.TEMP;
            }
            case OLD: {
                return ContactPoint.ContactPointUse.OLD;
            }
            case MOBILE: {
                return ContactPoint.ContactPointUse.MOBILE;
            }
        }
        return ContactPoint.ContactPointUse.NULL;
    }

    private static ContactPoint.ContactPointUse convertContactPointUse(ContactPoint.ContactPointUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return ContactPoint.ContactPointUse.HOME;
            }
            case WORK: {
                return ContactPoint.ContactPointUse.WORK;
            }
            case TEMP: {
                return ContactPoint.ContactPointUse.TEMP;
            }
            case OLD: {
                return ContactPoint.ContactPointUse.OLD;
            }
            case MOBILE: {
                return ContactPoint.ContactPointUse.MOBILE;
            }
        }
        return ContactPoint.ContactPointUse.NULL;
    }

    public static org.hl7.fhir.r4.model.Contributor convertContributor(Contributor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Contributor tgt = new org.hl7.fhir.r4.model.Contributor();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertContributorType(src.getType()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        return tgt;
    }

    public static Contributor convertContributor(org.hl7.fhir.r4.model.Contributor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Contributor tgt = new Contributor();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertContributorType(src.getType()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        return tgt;
    }

    private static Contributor.ContributorType convertContributorType(Contributor.ContributorType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case AUTHOR: {
                return Contributor.ContributorType.AUTHOR;
            }
            case EDITOR: {
                return Contributor.ContributorType.EDITOR;
            }
            case REVIEWER: {
                return Contributor.ContributorType.REVIEWER;
            }
            case ENDORSER: {
                return Contributor.ContributorType.ENDORSER;
            }
        }
        return Contributor.ContributorType.NULL;
    }

    private static Contributor.ContributorType convertContributorType(Contributor.ContributorType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case AUTHOR: {
                return Contributor.ContributorType.AUTHOR;
            }
            case EDITOR: {
                return Contributor.ContributorType.EDITOR;
            }
            case REVIEWER: {
                return Contributor.ContributorType.REVIEWER;
            }
            case ENDORSER: {
                return Contributor.ContributorType.ENDORSER;
            }
        }
        return Contributor.ContributorType.NULL;
    }

    public static org.hl7.fhir.r4.model.Dosage convertDosage(Dosage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Dosage tgt = new org.hl7.fhir.r4.model.Dosage();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSequence()) {
            tgt.setSequence(src.getSequence());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (CodeableConcept t : src.getAdditionalInstruction()) {
            tgt.addAdditionalInstruction(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstruction(src.getPatientInstruction());
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_30_40.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose() || src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasDose()) {
                dr.setDose(VersionConvertor_30_40.convertType(src.getDose()));
            }
            if (src.hasRate()) {
                dr.setRate(VersionConvertor_30_40.convertType(src.getRate()));
            }
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_30_40.convertRatio(src.getMaxDosePerPeriod()));
        }
        if (src.hasMaxDosePerAdministration()) {
            tgt.setMaxDosePerAdministration(VersionConvertor_30_40.convertSimpleQuantity(src.getMaxDosePerAdministration()));
        }
        if (src.hasMaxDosePerLifetime()) {
            tgt.setMaxDosePerLifetime(VersionConvertor_30_40.convertSimpleQuantity(src.getMaxDosePerLifetime()));
        }
        return tgt;
    }

    public static Dosage convertDosage(org.hl7.fhir.r4.model.Dosage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Dosage tgt = new Dosage();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasSequence()) {
            tgt.setSequence(src.getSequence());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getAdditionalInstruction()) {
            tgt.addAdditionalInstruction(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPatientInstruction()) {
            tgt.setPatientInstruction(src.getPatientInstruction());
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertTiming(src.getTiming()));
        }
        if (src.hasAsNeeded()) {
            tgt.setAsNeeded(VersionConvertor_30_40.convertType(src.getAsNeeded()));
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDoseAndRate() && ((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).hasDose()) {
            tgt.setDose(VersionConvertor_30_40.convertType(((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).getDose()));
        }
        if (src.hasMaxDosePerPeriod()) {
            tgt.setMaxDosePerPeriod(VersionConvertor_30_40.convertRatio(src.getMaxDosePerPeriod()));
        }
        if (src.hasMaxDosePerAdministration()) {
            tgt.setMaxDosePerAdministration(VersionConvertor_30_40.convertSimpleQuantity(src.getMaxDosePerAdministration()));
        }
        if (src.hasMaxDosePerLifetime()) {
            tgt.setMaxDosePerLifetime(VersionConvertor_30_40.convertSimpleQuantity(src.getMaxDosePerLifetime()));
        }
        if (src.hasDoseAndRate() && ((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).hasRate()) {
            tgt.setRate(VersionConvertor_30_40.convertType(((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).getRate()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ElementDefinition tgt = new org.hl7.fhir.r4.model.ElementDefinition();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getRepresentation()) {
            tgt.addRepresentation(VersionConvertor_30_40.convertPropertyRepresentation((ElementDefinition.PropertyRepresentation)t.getValue()));
        }
        if (src.hasSliceName()) {
            tgt.setSliceName(src.getSliceName());
        }
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding((Coding)t));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_30_40.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShort(src.getShort());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_40.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReference(src.getContentReference());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getType()) {
            VersionConvertor_30_40.convertTypeRefComponent((ElementDefinition.TypeRefComponent)t, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_40.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissing(src.getMeaningWhenMissing());
        }
        if (src.hasOrderMeaning()) {
            tgt.setOrderMeaning(src.getOrderMeaning());
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_30_40.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_30_40.convertType(src.getPattern()));
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getExample()) {
            tgt.addExample(VersionConvertor_30_40.convertElementDefinitionExampleComponent((ElementDefinition.ElementDefinitionExampleComponent)t));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_30_40.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_30_40.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getCondition()) {
            tgt.addCondition(t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_30_40.convertElementDefinitionConstraintComponent((ElementDefinition.ElementDefinitionConstraintComponent)t));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupport(src.getMustSupport());
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifier(src.getIsModifier());
        }
        if (tgt.getIsModifier()) {
            String reason = ToolingExtensions.readStringExtension((org.hl7.fhir.dstu3.model.Element)src, (String)"http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason");
            if (Utilities.noString((String)reason)) {
                reason = "No Modifier Reason provideed in previous versions of FHIR";
            }
            tgt.setIsModifierReason(reason);
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummary(src.getIsSummary());
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_30_40.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_40.convertElementDefinitionMappingComponent((ElementDefinition.ElementDefinitionMappingComponent)t));
        }
        return tgt;
    }

    public static ElementDefinition convertElementDefinition(org.hl7.fhir.r4.model.ElementDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        for (Enumeration t : src.getRepresentation()) {
            tgt.addRepresentation(VersionConvertor_30_40.convertPropertyRepresentation((ElementDefinition.PropertyRepresentation)t.getValue()));
        }
        if (src.hasSliceName()) {
            tgt.setSliceName(src.getSliceName());
        }
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        for (Enumeration t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(VersionConvertor_30_40.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        if (src.hasShort()) {
            tgt.setShort(src.getShort());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        for (Enumeration t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_40.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setContentReference(src.getContentReference());
        }
        for (Enumeration t : src.getType()) {
            VersionConvertor_30_40.convertTypeRefComponent((ElementDefinition.TypeRefComponent)t, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_40.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissing(src.getMeaningWhenMissing());
        }
        if (src.hasOrderMeaning()) {
            tgt.setOrderMeaning(src.getOrderMeaning());
        }
        if (src.hasFixed()) {
            tgt.setFixed(VersionConvertor_30_40.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(VersionConvertor_30_40.convertType(src.getPattern()));
        }
        for (Enumeration t : src.getExample()) {
            tgt.addExample(VersionConvertor_30_40.convertElementDefinitionExampleComponent((ElementDefinition.ElementDefinitionExampleComponent)t));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(VersionConvertor_30_40.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(VersionConvertor_30_40.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        for (Enumeration t : src.getCondition()) {
            tgt.addCondition(t.getValue());
        }
        for (Enumeration t : src.getConstraint()) {
            tgt.addConstraint(VersionConvertor_30_40.convertElementDefinitionConstraintComponent((ElementDefinition.ElementDefinitionConstraintComponent)t));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupport(src.getMustSupport());
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifier(src.getIsModifier());
        }
        if (src.hasIsModifierReason() && !"No Modifier Reason provideed in previous versions of FHIR".equals(src.getIsModifierReason())) {
            ToolingExtensions.setStringExtension((org.hl7.fhir.dstu3.model.Element)tgt, (String)"http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason", (String)src.getIsModifierReason());
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummary(src.getIsSummary());
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_30_40.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (Enumeration t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_40.convertElementDefinitionMappingComponent((ElementDefinition.ElementDefinitionMappingComponent)t));
        }
        return tgt;
    }

    private static ElementDefinition.PropertyRepresentation convertPropertyRepresentation(ElementDefinition.PropertyRepresentation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XMLATTR: {
                return ElementDefinition.PropertyRepresentation.XMLATTR;
            }
            case XMLTEXT: {
                return ElementDefinition.PropertyRepresentation.XMLTEXT;
            }
            case TYPEATTR: {
                return ElementDefinition.PropertyRepresentation.TYPEATTR;
            }
            case CDATEXT: {
                return ElementDefinition.PropertyRepresentation.CDATEXT;
            }
            case XHTML: {
                return ElementDefinition.PropertyRepresentation.XHTML;
            }
        }
        return ElementDefinition.PropertyRepresentation.NULL;
    }

    private static ElementDefinition.PropertyRepresentation convertPropertyRepresentation(ElementDefinition.PropertyRepresentation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XMLATTR: {
                return ElementDefinition.PropertyRepresentation.XMLATTR;
            }
            case XMLTEXT: {
                return ElementDefinition.PropertyRepresentation.XMLTEXT;
            }
            case TYPEATTR: {
                return ElementDefinition.PropertyRepresentation.TYPEATTR;
            }
            case CDATEXT: {
                return ElementDefinition.PropertyRepresentation.CDATEXT;
            }
            case XHTML: {
                return ElementDefinition.PropertyRepresentation.XHTML;
            }
        }
        return ElementDefinition.PropertyRepresentation.NULL;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(VersionConvertor_30_40.convertElementDefinitionSlicingDiscriminatorComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasOrdered()) {
            tgt.setOrdered(src.getOrdered());
        }
        if (src.hasRules()) {
            tgt.setRules(VersionConvertor_30_40.convertSlicingRules(src.getRules()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(VersionConvertor_30_40.convertElementDefinitionSlicingDiscriminatorComponent(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasOrdered()) {
            tgt.setOrdered(src.getOrdered());
        }
        if (src.hasRules()) {
            tgt.setRules(VersionConvertor_30_40.convertSlicingRules(src.getRules()));
        }
        return tgt;
    }

    private static ElementDefinition.SlicingRules convertSlicingRules(ElementDefinition.SlicingRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLOSED: {
                return ElementDefinition.SlicingRules.CLOSED;
            }
            case OPEN: {
                return ElementDefinition.SlicingRules.OPEN;
            }
            case OPENATEND: {
                return ElementDefinition.SlicingRules.OPENATEND;
            }
        }
        return ElementDefinition.SlicingRules.NULL;
    }

    private static ElementDefinition.SlicingRules convertSlicingRules(ElementDefinition.SlicingRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLOSED: {
                return ElementDefinition.SlicingRules.CLOSED;
            }
            case OPEN: {
                return ElementDefinition.SlicingRules.OPEN;
            }
            case OPENATEND: {
                return ElementDefinition.SlicingRules.OPENATEND;
            }
        }
        return ElementDefinition.SlicingRules.NULL;
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent convertElementDefinitionSlicingDiscriminatorComponent(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent tgt = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertDiscriminatorType(src.getType()));
        }
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent convertElementDefinitionSlicingDiscriminatorComponent(ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent tgt = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertDiscriminatorType(src.getType()));
        }
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        return tgt;
    }

    private static ElementDefinition.DiscriminatorType convertDiscriminatorType(ElementDefinition.DiscriminatorType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case VALUE: {
                return ElementDefinition.DiscriminatorType.VALUE;
            }
            case EXISTS: {
                return ElementDefinition.DiscriminatorType.EXISTS;
            }
            case PATTERN: {
                return ElementDefinition.DiscriminatorType.PATTERN;
            }
            case TYPE: {
                return ElementDefinition.DiscriminatorType.TYPE;
            }
            case PROFILE: {
                return ElementDefinition.DiscriminatorType.PROFILE;
            }
        }
        return ElementDefinition.DiscriminatorType.NULL;
    }

    private static ElementDefinition.DiscriminatorType convertDiscriminatorType(ElementDefinition.DiscriminatorType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case VALUE: {
                return ElementDefinition.DiscriminatorType.VALUE;
            }
            case EXISTS: {
                return ElementDefinition.DiscriminatorType.EXISTS;
            }
            case PATTERN: {
                return ElementDefinition.DiscriminatorType.PATTERN;
            }
            case TYPE: {
                return ElementDefinition.DiscriminatorType.TYPE;
            }
            case PROFILE: {
                return ElementDefinition.DiscriminatorType.PROFILE;
            }
        }
        return ElementDefinition.DiscriminatorType.NULL;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        return tgt;
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = null;
        for (ElementDefinition.TypeRefComponent t : list) {
            if (!t.getCode().equals(src.getCode())) continue;
            tgt = t;
        }
        if (tgt == null) {
            tgt = new ElementDefinition.TypeRefComponent();
            list.add(tgt);
            VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
            tgt.setCodeElement(VersionConvertor_30_40.convertUri(src.getCodeElement()));
        }
        if (src.hasProfile()) {
            tgt.addProfile(src.getProfile());
        }
        if (src.hasTargetProfile()) {
            tgt.addTargetProfile(src.getTargetProfile());
        }
        for (ElementDefinition.TypeRefComponent t : src.getAggregation()) {
            ElementDefinition.AggregationMode a = VersionConvertor_30_40.convertAggregationMode((ElementDefinition.AggregationMode)t.getValue());
            if (tgt.hasAggregation(a)) continue;
            tgt.addAggregation(a);
        }
        if (src.hasVersioning()) {
            tgt.setVersioning(VersionConvertor_30_40.convertReferenceVersionRules(src.getVersioning()));
        }
    }

    public static void convertTypeRefComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        tgt.setCodeElement(VersionConvertor_30_40.convertUri(src.getCodeElement()));
        list.add(tgt);
        if (src.hasTarget()) {
            if (src.hasProfile()) {
                tgt.setProfile((String)((CanonicalType)src.getProfile().get(0)).getValue());
            }
            for (UriType u : src.getTargetProfile()) {
                if (tgt.hasTargetProfile()) {
                    tgt = new ElementDefinition.TypeRefComponent();
                    list.add(tgt);
                    VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
                    tgt.setCode(src.getCode());
                    if (src.hasProfile()) {
                        tgt.setProfile((String)((CanonicalType)src.getProfile().get(0)).getValue());
                    }
                }
                tgt.setTargetProfile((String)u.getValue());
            }
        } else {
            for (UriType u : src.getProfile()) {
                if (tgt.hasProfile()) {
                    tgt = new ElementDefinition.TypeRefComponent();
                    list.add(tgt);
                    VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
                    tgt.setCode(src.getCode());
                }
                tgt.setProfile((String)u.getValue());
            }
        }
    }

    private static ElementDefinition.AggregationMode convertAggregationMode(ElementDefinition.AggregationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CONTAINED: {
                return ElementDefinition.AggregationMode.CONTAINED;
            }
            case REFERENCED: {
                return ElementDefinition.AggregationMode.REFERENCED;
            }
            case BUNDLED: {
                return ElementDefinition.AggregationMode.BUNDLED;
            }
        }
        return ElementDefinition.AggregationMode.NULL;
    }

    private static ElementDefinition.AggregationMode convertAggregationMode(ElementDefinition.AggregationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CONTAINED: {
                return ElementDefinition.AggregationMode.CONTAINED;
            }
            case REFERENCED: {
                return ElementDefinition.AggregationMode.REFERENCED;
            }
            case BUNDLED: {
                return ElementDefinition.AggregationMode.BUNDLED;
            }
        }
        return ElementDefinition.AggregationMode.NULL;
    }

    private static ElementDefinition.ReferenceVersionRules convertReferenceVersionRules(ElementDefinition.ReferenceVersionRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EITHER: {
                return ElementDefinition.ReferenceVersionRules.EITHER;
            }
            case INDEPENDENT: {
                return ElementDefinition.ReferenceVersionRules.INDEPENDENT;
            }
            case SPECIFIC: {
                return ElementDefinition.ReferenceVersionRules.SPECIFIC;
            }
        }
        return ElementDefinition.ReferenceVersionRules.NULL;
    }

    private static ElementDefinition.ReferenceVersionRules convertReferenceVersionRules(ElementDefinition.ReferenceVersionRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EITHER: {
                return ElementDefinition.ReferenceVersionRules.EITHER;
            }
            case INDEPENDENT: {
                return ElementDefinition.ReferenceVersionRules.INDEPENDENT;
            }
            case SPECIFIC: {
                return ElementDefinition.ReferenceVersionRules.SPECIFIC;
            }
        }
        return ElementDefinition.ReferenceVersionRules.NULL;
    }

    public static ElementDefinition.ElementDefinitionExampleComponent convertElementDefinitionExampleComponent(ElementDefinition.ElementDefinitionExampleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionExampleComponent tgt = new ElementDefinition.ElementDefinitionExampleComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionExampleComponent convertElementDefinitionExampleComponent(ElementDefinition.ElementDefinitionExampleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionExampleComponent tgt = new ElementDefinition.ElementDefinitionExampleComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasKey()) {
            tgt.setKey(src.getKey());
        }
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertConstraintSeverity(src.getSeverity()));
        }
        if (src.hasHuman()) {
            tgt.setHuman(src.getHuman());
        }
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        if (src.hasXpath()) {
            tgt.setXpath(src.getXpath());
        }
        if (src.hasSource()) {
            tgt.setSource(src.getSource());
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasKey()) {
            tgt.setKey(src.getKey());
        }
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertConstraintSeverity(src.getSeverity()));
        }
        if (src.hasHuman()) {
            tgt.setHuman(src.getHuman());
        }
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        if (src.hasXpath()) {
            tgt.setXpath(src.getXpath());
        }
        if (src.hasSource()) {
            tgt.setSource(src.getSource());
        }
        return tgt;
    }

    private static ElementDefinition.ConstraintSeverity convertConstraintSeverity(ElementDefinition.ConstraintSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ERROR: {
                return ElementDefinition.ConstraintSeverity.ERROR;
            }
            case WARNING: {
                return ElementDefinition.ConstraintSeverity.WARNING;
            }
        }
        return ElementDefinition.ConstraintSeverity.NULL;
    }

    private static ElementDefinition.ConstraintSeverity convertConstraintSeverity(ElementDefinition.ConstraintSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ERROR: {
                return ElementDefinition.ConstraintSeverity.ERROR;
            }
            case WARNING: {
                return ElementDefinition.ConstraintSeverity.WARNING;
            }
        }
        return ElementDefinition.ConstraintSeverity.NULL;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasStrength()) {
            tgt.setStrength(VersionConvertor_30_40.convertBindingStrength(src.getStrength()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasValueSet()) {
            org.hl7.fhir.r4.model.Type t = VersionConvertor_30_40.convertType(src.getValueSet());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setValueSet(((org.hl7.fhir.r4.model.Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasStrength()) {
            tgt.setStrength(VersionConvertor_30_40.convertBindingStrength(src.getStrength()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet((Type)new org.hl7.fhir.dstu3.model.UriType(vsr));
            } else {
                tgt.setValueSet((Type)new Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    private static Enumerations.BindingStrength convertBindingStrength(Enumerations.BindingStrength src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Enumerations.BindingStrength.REQUIRED;
            }
            case EXTENSIBLE: {
                return Enumerations.BindingStrength.EXTENSIBLE;
            }
            case PREFERRED: {
                return Enumerations.BindingStrength.PREFERRED;
            }
            case EXAMPLE: {
                return Enumerations.BindingStrength.EXAMPLE;
            }
        }
        return Enumerations.BindingStrength.NULL;
    }

    private static Enumerations.BindingStrength convertBindingStrength(Enumerations.BindingStrength src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Enumerations.BindingStrength.REQUIRED;
            }
            case EXTENSIBLE: {
                return Enumerations.BindingStrength.EXTENSIBLE;
            }
            case PREFERRED: {
                return Enumerations.BindingStrength.PREFERRED;
            }
            case EXAMPLE: {
                return Enumerations.BindingStrength.EXAMPLE;
            }
        }
        return Enumerations.BindingStrength.NULL;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasIdentity()) {
            tgt.setIdentity(src.getIdentity());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasMap()) {
            tgt.setMap(src.getMap());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasIdentity()) {
            tgt.setIdentity(src.getIdentity());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasMap()) {
            tgt.setMap(src.getMap());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.HumanName tgt = new org.hl7.fhir.r4.model.HumanName();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertNameUse(src.getUse()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        if (src.hasFamily()) {
            tgt.setFamily(src.getFamily());
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static HumanName convertHumanName(org.hl7.fhir.r4.model.HumanName src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HumanName tgt = new HumanName();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertNameUse(src.getUse()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        if (src.hasFamily()) {
            tgt.setFamily(src.getFamily());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    private static HumanName.NameUse convertNameUse(HumanName.NameUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return HumanName.NameUse.USUAL;
            }
            case OFFICIAL: {
                return HumanName.NameUse.OFFICIAL;
            }
            case TEMP: {
                return HumanName.NameUse.TEMP;
            }
            case NICKNAME: {
                return HumanName.NameUse.NICKNAME;
            }
            case ANONYMOUS: {
                return HumanName.NameUse.ANONYMOUS;
            }
            case OLD: {
                return HumanName.NameUse.OLD;
            }
            case MAIDEN: {
                return HumanName.NameUse.MAIDEN;
            }
        }
        return HumanName.NameUse.NULL;
    }

    private static HumanName.NameUse convertNameUse(HumanName.NameUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return HumanName.NameUse.USUAL;
            }
            case OFFICIAL: {
                return HumanName.NameUse.OFFICIAL;
            }
            case TEMP: {
                return HumanName.NameUse.TEMP;
            }
            case NICKNAME: {
                return HumanName.NameUse.NICKNAME;
            }
            case ANONYMOUS: {
                return HumanName.NameUse.ANONYMOUS;
            }
            case OLD: {
                return HumanName.NameUse.OLD;
            }
            case MAIDEN: {
                return HumanName.NameUse.MAIDEN;
            }
        }
        return HumanName.NameUse.NULL;
    }

    public static Meta convertMeta(org.hl7.fhir.dstu3.model.Meta src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Meta tgt = new Meta();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasVersionId()) {
            tgt.setVersionId(src.getVersionId());
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdated(src.getLastUpdated());
        }
        for (org.hl7.fhir.dstu3.model.UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.UriType t : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_30_40.convertCoding((Coding)t));
        }
        for (org.hl7.fhir.dstu3.model.UriType t : src.getTag()) {
            tgt.addTag(VersionConvertor_30_40.convertCoding((Coding)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Meta tgt = new org.hl7.fhir.dstu3.model.Meta();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasVersionId()) {
            tgt.setVersionId(src.getVersionId());
        }
        if (src.hasLastUpdated()) {
            tgt.setLastUpdated(src.getLastUpdated());
        }
        for (UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (UriType t : src.getSecurity()) {
            tgt.addSecurity(VersionConvertor_30_40.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        for (UriType t : src.getTag()) {
            tgt.addTag(VersionConvertor_30_40.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ParameterDefinition convertParameterDefinition(ParameterDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ParameterDefinition tgt = new org.hl7.fhir.r4.model.ParameterDefinition();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertParameterUse(src.getUse()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertReference(src.getProfile()).getReference());
        }
        return tgt;
    }

    public static ParameterDefinition convertParameterDefinition(org.hl7.fhir.r4.model.ParameterDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ParameterDefinition tgt = new ParameterDefinition();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertParameterUse(src.getUse()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasProfile()) {
            tgt.setProfile(new Reference(src.getProfile()));
        }
        return tgt;
    }

    private static ParameterDefinition.ParameterUse convertParameterUse(ParameterDefinition.ParameterUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IN: {
                return ParameterDefinition.ParameterUse.IN;
            }
            case OUT: {
                return ParameterDefinition.ParameterUse.OUT;
            }
        }
        return ParameterDefinition.ParameterUse.NULL;
    }

    private static ParameterDefinition.ParameterUse convertParameterUse(ParameterDefinition.ParameterUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IN: {
                return ParameterDefinition.ParameterUse.IN;
            }
            case OUT: {
                return ParameterDefinition.ParameterUse.OUT;
            }
        }
        return ParameterDefinition.ParameterUse.NULL;
    }

    public static org.hl7.fhir.r4.model.RelatedArtifact convertRelatedArtifact(RelatedArtifact src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.RelatedArtifact tgt = new org.hl7.fhir.r4.model.RelatedArtifact();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertRelatedArtifactType(src.getType()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasCitation()) {
            tgt.setCitation(src.getCitation());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasDocument()) {
            tgt.setDocument(VersionConvertor_30_40.convertAttachment(src.getDocument()));
        }
        if (src.hasResource()) {
            tgt.setResourceElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getResource()));
        }
        return tgt;
    }

    public static RelatedArtifact convertRelatedArtifact(org.hl7.fhir.r4.model.RelatedArtifact src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RelatedArtifact tgt = new RelatedArtifact();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertRelatedArtifactType(src.getType()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasCitation()) {
            tgt.setCitation(src.getCitation());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasDocument()) {
            tgt.setDocument(VersionConvertor_30_40.convertAttachment(src.getDocument()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertCanonicalToReference(src.getResourceElement()));
        }
        return tgt;
    }

    private static RelatedArtifact.RelatedArtifactType convertRelatedArtifactType(RelatedArtifact.RelatedArtifactType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DOCUMENTATION: {
                return RelatedArtifact.RelatedArtifactType.DOCUMENTATION;
            }
            case JUSTIFICATION: {
                return RelatedArtifact.RelatedArtifactType.JUSTIFICATION;
            }
            case CITATION: {
                return RelatedArtifact.RelatedArtifactType.CITATION;
            }
            case PREDECESSOR: {
                return RelatedArtifact.RelatedArtifactType.PREDECESSOR;
            }
            case SUCCESSOR: {
                return RelatedArtifact.RelatedArtifactType.SUCCESSOR;
            }
            case DERIVEDFROM: {
                return RelatedArtifact.RelatedArtifactType.DERIVEDFROM;
            }
            case DEPENDSON: {
                return RelatedArtifact.RelatedArtifactType.DEPENDSON;
            }
            case COMPOSEDOF: {
                return RelatedArtifact.RelatedArtifactType.COMPOSEDOF;
            }
        }
        return RelatedArtifact.RelatedArtifactType.NULL;
    }

    private static RelatedArtifact.RelatedArtifactType convertRelatedArtifactType(RelatedArtifact.RelatedArtifactType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DOCUMENTATION: {
                return RelatedArtifact.RelatedArtifactType.DOCUMENTATION;
            }
            case JUSTIFICATION: {
                return RelatedArtifact.RelatedArtifactType.JUSTIFICATION;
            }
            case CITATION: {
                return RelatedArtifact.RelatedArtifactType.CITATION;
            }
            case PREDECESSOR: {
                return RelatedArtifact.RelatedArtifactType.PREDECESSOR;
            }
            case SUCCESSOR: {
                return RelatedArtifact.RelatedArtifactType.SUCCESSOR;
            }
            case DERIVEDFROM: {
                return RelatedArtifact.RelatedArtifactType.DERIVEDFROM;
            }
            case DEPENDSON: {
                return RelatedArtifact.RelatedArtifactType.DEPENDSON;
            }
            case COMPOSEDOF: {
                return RelatedArtifact.RelatedArtifactType.COMPOSEDOF;
            }
        }
        return RelatedArtifact.RelatedArtifactType.NULL;
    }

    public static Timing convertTiming(org.hl7.fhir.dstu3.model.Timing src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing tgt = new Timing();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_30_40.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Timing tgt = new org.hl7.fhir.dstu3.model.Timing();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        if (src.hasRepeat()) {
            tgt.setRepeat(VersionConvertor_30_40.convertTimingRepeatComponent(src.getRepeat()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_30_40.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDuration(src.getDuration());
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMax(src.getDurationMax());
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnit(VersionConvertor_30_40.convertUnitsOfTime(src.getDurationUnit()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(src.getPeriod());
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMax(src.getPeriodMax());
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnit(VersionConvertor_30_40.convertUnitsOfTime(src.getPeriodUnit()));
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getDayOfWeek()) {
            tgt.addDayOfWeek(VersionConvertor_30_40.convertDayOfWeek((Timing.DayOfWeek)t.getValue()));
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getTimeOfDay()) {
            tgt.addTimeOfDay((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getWhen()) {
            tgt.addWhen(VersionConvertor_30_40.convertEventTiming((Timing.EventTiming)t.getValue()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(src.getOffset());
        }
        return tgt;
    }

    public static Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasBounds()) {
            tgt.setBounds(VersionConvertor_30_40.convertType(src.getBounds()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        if (src.hasCountMax()) {
            tgt.setCountMax(src.getCountMax());
        }
        if (src.hasDuration()) {
            tgt.setDuration(src.getDuration());
        }
        if (src.hasDurationMax()) {
            tgt.setDurationMax(src.getDurationMax());
        }
        if (src.hasDurationUnit()) {
            tgt.setDurationUnit(VersionConvertor_30_40.convertUnitsOfTime(src.getDurationUnit()));
        }
        if (src.hasFrequency()) {
            tgt.setFrequency(src.getFrequency());
        }
        if (src.hasFrequencyMax()) {
            tgt.setFrequencyMax(src.getFrequencyMax());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(src.getPeriod());
        }
        if (src.hasPeriodMax()) {
            tgt.setPeriodMax(src.getPeriodMax());
        }
        if (src.hasPeriodUnit()) {
            tgt.setPeriodUnit(VersionConvertor_30_40.convertUnitsOfTime(src.getPeriodUnit()));
        }
        for (Enumeration t : src.getDayOfWeek()) {
            tgt.addDayOfWeek(VersionConvertor_30_40.convertDayOfWeek((Timing.DayOfWeek)t.getValue()));
        }
        for (Enumeration t : src.getTimeOfDay()) {
            tgt.addTimeOfDay((String)t.getValue());
        }
        for (Enumeration t : src.getWhen()) {
            tgt.addWhen(VersionConvertor_30_40.convertEventTiming((Timing.EventTiming)t.getValue()));
        }
        if (src.hasOffset()) {
            tgt.setOffset(src.getOffset());
        }
        return tgt;
    }

    private static Timing.UnitsOfTime convertUnitsOfTime(Timing.UnitsOfTime src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case S: {
                return Timing.UnitsOfTime.S;
            }
            case MIN: {
                return Timing.UnitsOfTime.MIN;
            }
            case H: {
                return Timing.UnitsOfTime.H;
            }
            case D: {
                return Timing.UnitsOfTime.D;
            }
            case WK: {
                return Timing.UnitsOfTime.WK;
            }
            case MO: {
                return Timing.UnitsOfTime.MO;
            }
            case A: {
                return Timing.UnitsOfTime.A;
            }
        }
        return Timing.UnitsOfTime.NULL;
    }

    private static Timing.UnitsOfTime convertUnitsOfTime(Timing.UnitsOfTime src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case S: {
                return Timing.UnitsOfTime.S;
            }
            case MIN: {
                return Timing.UnitsOfTime.MIN;
            }
            case H: {
                return Timing.UnitsOfTime.H;
            }
            case D: {
                return Timing.UnitsOfTime.D;
            }
            case WK: {
                return Timing.UnitsOfTime.WK;
            }
            case MO: {
                return Timing.UnitsOfTime.MO;
            }
            case A: {
                return Timing.UnitsOfTime.A;
            }
        }
        return Timing.UnitsOfTime.NULL;
    }

    private static Timing.DayOfWeek convertDayOfWeek(Timing.DayOfWeek src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MON: {
                return Timing.DayOfWeek.MON;
            }
            case TUE: {
                return Timing.DayOfWeek.TUE;
            }
            case WED: {
                return Timing.DayOfWeek.WED;
            }
            case THU: {
                return Timing.DayOfWeek.THU;
            }
            case FRI: {
                return Timing.DayOfWeek.FRI;
            }
            case SAT: {
                return Timing.DayOfWeek.SAT;
            }
            case SUN: {
                return Timing.DayOfWeek.SUN;
            }
        }
        return Timing.DayOfWeek.NULL;
    }

    private static Timing.DayOfWeek convertDayOfWeek(Timing.DayOfWeek src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MON: {
                return Timing.DayOfWeek.MON;
            }
            case TUE: {
                return Timing.DayOfWeek.TUE;
            }
            case WED: {
                return Timing.DayOfWeek.WED;
            }
            case THU: {
                return Timing.DayOfWeek.THU;
            }
            case FRI: {
                return Timing.DayOfWeek.FRI;
            }
            case SAT: {
                return Timing.DayOfWeek.SAT;
            }
            case SUN: {
                return Timing.DayOfWeek.SUN;
            }
        }
        return Timing.DayOfWeek.NULL;
    }

    private static Timing.EventTiming convertEventTiming(Timing.EventTiming src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MORN: {
                return Timing.EventTiming.MORN;
            }
            case AFT: {
                return Timing.EventTiming.AFT;
            }
            case EVE: {
                return Timing.EventTiming.EVE;
            }
            case NIGHT: {
                return Timing.EventTiming.NIGHT;
            }
            case PHS: {
                return Timing.EventTiming.PHS;
            }
            case HS: {
                return Timing.EventTiming.HS;
            }
            case WAKE: {
                return Timing.EventTiming.WAKE;
            }
            case C: {
                return Timing.EventTiming.C;
            }
            case CM: {
                return Timing.EventTiming.CM;
            }
            case CD: {
                return Timing.EventTiming.CD;
            }
            case CV: {
                return Timing.EventTiming.CV;
            }
            case AC: {
                return Timing.EventTiming.AC;
            }
            case ACM: {
                return Timing.EventTiming.ACM;
            }
            case ACD: {
                return Timing.EventTiming.ACD;
            }
            case ACV: {
                return Timing.EventTiming.ACV;
            }
            case PC: {
                return Timing.EventTiming.PC;
            }
            case PCM: {
                return Timing.EventTiming.PCM;
            }
            case PCD: {
                return Timing.EventTiming.PCD;
            }
            case PCV: {
                return Timing.EventTiming.PCV;
            }
        }
        return Timing.EventTiming.NULL;
    }

    private static Timing.EventTiming convertEventTiming(Timing.EventTiming src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MORN: {
                return Timing.EventTiming.MORN;
            }
            case AFT: {
                return Timing.EventTiming.AFT;
            }
            case EVE: {
                return Timing.EventTiming.EVE;
            }
            case NIGHT: {
                return Timing.EventTiming.NIGHT;
            }
            case PHS: {
                return Timing.EventTiming.PHS;
            }
            case HS: {
                return Timing.EventTiming.HS;
            }
            case WAKE: {
                return Timing.EventTiming.WAKE;
            }
            case C: {
                return Timing.EventTiming.C;
            }
            case CM: {
                return Timing.EventTiming.CM;
            }
            case CD: {
                return Timing.EventTiming.CD;
            }
            case CV: {
                return Timing.EventTiming.CV;
            }
            case AC: {
                return Timing.EventTiming.AC;
            }
            case ACM: {
                return Timing.EventTiming.ACM;
            }
            case ACD: {
                return Timing.EventTiming.ACD;
            }
            case ACV: {
                return Timing.EventTiming.ACV;
            }
            case PC: {
                return Timing.EventTiming.PC;
            }
            case PCM: {
                return Timing.EventTiming.PCM;
            }
            case PCD: {
                return Timing.EventTiming.PCD;
            }
            case PCV: {
                return Timing.EventTiming.PCV;
            }
        }
        return Timing.EventTiming.NULL;
    }

    public static org.hl7.fhir.r4.model.UsageContext convertUsageContext(UsageContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.UsageContext tgt = new org.hl7.fhir.r4.model.UsageContext();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCoding(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static UsageContext convertUsageContext(org.hl7.fhir.r4.model.UsageContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        UsageContext tgt = new UsageContext();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCoding(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Quantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.SimpleQuantity tgt = new org.hl7.fhir.r4.model.SimpleQuantity();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparator(VersionConvertor_30_40.convertQuantityComparator(src.getComparator()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static SimpleQuantity convertSimpleQuantity(Quantity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasComparator()) {
            tgt.setComparator(VersionConvertor_30_40.convertQuantityComparator(src.getComparator()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(src.getUnit());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        return tgt;
    }

    public static TriggerDefinition convertTriggerDefinition(org.hl7.fhir.dstu3.model.TriggerDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TriggerDefinition tgt = new TriggerDefinition();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertTriggerType(src.getType()));
        }
        if (src.hasEventName()) {
            tgt.setName(src.getEventName());
        }
        if (src.hasEventTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertType(src.getEventTiming()));
        }
        if (src.hasEventData()) {
            tgt.addData(VersionConvertor_30_40.convertDataRequirement(src.getEventData()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.TriggerDefinition convertTriggerDefinition(TriggerDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.TriggerDefinition tgt = new org.hl7.fhir.dstu3.model.TriggerDefinition();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertTriggerType(src.getType()));
        }
        if (src.hasName()) {
            tgt.setEventName(src.getName());
        }
        if (src.hasTiming()) {
            tgt.setEventTiming(VersionConvertor_30_40.convertType(src.getTiming()));
        }
        if (src.hasData()) {
            tgt.setEventData(VersionConvertor_30_40.convertDataRequirement(src.getDataFirstRep()));
        }
        return tgt;
    }

    public static DataRequirement convertDataRequirement(org.hl7.fhir.dstu3.model.DataRequirement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement tgt = new DataRequirement();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        for (org.hl7.fhir.dstu3.model.UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.UriType t : src.getMustSupport()) {
            tgt.addMustSupport((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.UriType t : src.getCodeFilter()) {
            tgt.addCodeFilter(VersionConvertor_30_40.convertDataRequirementCodeFilterComponent((DataRequirement.DataRequirementCodeFilterComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.UriType t : src.getDateFilter()) {
            tgt.addDateFilter(VersionConvertor_30_40.convertDataRequirementDateFilterComponent((DataRequirement.DataRequirementDateFilterComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DataRequirement convertDataRequirement(DataRequirement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.DataRequirement tgt = new org.hl7.fhir.dstu3.model.DataRequirement();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        for (UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (UriType t : src.getMustSupport()) {
            tgt.addMustSupport((String)t.getValue());
        }
        for (UriType t : src.getCodeFilter()) {
            tgt.addCodeFilter(VersionConvertor_30_40.convertDataRequirementCodeFilterComponent((DataRequirement.DataRequirementCodeFilterComponent)t));
        }
        for (UriType t : src.getDateFilter()) {
            tgt.addDateFilter(VersionConvertor_30_40.convertDataRequirementDateFilterComponent((DataRequirement.DataRequirementDateFilterComponent)t));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementCodeFilterComponent convertDataRequirementCodeFilterComponent(DataRequirement.DataRequirementCodeFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementCodeFilterComponent tgt = new DataRequirement.DataRequirementCodeFilterComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasValueSet()) {
            org.hl7.fhir.r4.model.Type t = VersionConvertor_30_40.convertType(src.getValueSet());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setValueSet(((org.hl7.fhir.r4.model.Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        for (CodeType t : src.getValueCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(t));
        }
        for (CodeType t : src.getValueCoding()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding((Coding)t));
        }
        for (CodeType t : src.getValueCodeableConcept()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding((CodeableConcept)t));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementCodeFilterComponent convertDataRequirementCodeFilterComponent(DataRequirement.DataRequirementCodeFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementCodeFilterComponent tgt = new DataRequirement.DataRequirementCodeFilterComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet((Type)new org.hl7.fhir.dstu3.model.UriType(vsr));
            } else {
                tgt.setValueSet((Type)new Reference(src.getValueSet()));
            }
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getCode()) {
            tgt.addValueCoding(VersionConvertor_30_40.convertCoding(t));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementDateFilterComponent convertDataRequirementDateFilterComponent(DataRequirement.DataRequirementDateFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementDateFilterComponent tgt = new DataRequirement.DataRequirementDateFilterComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static DataRequirement.DataRequirementDateFilterComponent convertDataRequirementDateFilterComponent(DataRequirement.DataRequirementDateFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DataRequirement.DataRequirementDateFilterComponent tgt = new DataRequirement.DataRequirementDateFilterComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    private static TriggerDefinition.TriggerType convertTriggerType(TriggerDefinition.TriggerType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NAMEDEVENT: {
                return TriggerDefinition.TriggerType.NAMEDEVENT;
            }
            case PERIODIC: {
                return TriggerDefinition.TriggerType.PERIODIC;
            }
            case DATAADDED: {
                return TriggerDefinition.TriggerType.DATAADDED;
            }
            case DATAMODIFIED: {
                return TriggerDefinition.TriggerType.DATAMODIFIED;
            }
            case DATAREMOVED: {
                return TriggerDefinition.TriggerType.DATAREMOVED;
            }
            case DATAACCESSED: {
                return TriggerDefinition.TriggerType.DATAACCESSED;
            }
            case DATAACCESSENDED: {
                return TriggerDefinition.TriggerType.DATAACCESSENDED;
            }
        }
        return TriggerDefinition.TriggerType.NULL;
    }

    private static TriggerDefinition.TriggerType convertTriggerType(TriggerDefinition.TriggerType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NAMEDEVENT: {
                return TriggerDefinition.TriggerType.NAMEDEVENT;
            }
            case PERIODIC: {
                return TriggerDefinition.TriggerType.PERIODIC;
            }
            case DATAADDED: {
                return TriggerDefinition.TriggerType.DATAADDED;
            }
            case DATAMODIFIED: {
                return TriggerDefinition.TriggerType.DATAMODIFIED;
            }
            case DATAREMOVED: {
                return TriggerDefinition.TriggerType.DATAREMOVED;
            }
            case DATAACCESSED: {
                return TriggerDefinition.TriggerType.DATAACCESSED;
            }
            case DATAACCESSENDED: {
                return TriggerDefinition.TriggerType.DATAACCESSENDED;
            }
        }
        return TriggerDefinition.TriggerType.NULL;
    }

    public static org.hl7.fhir.r4.model.Type convertType(Type src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Base64BinaryType) {
            return VersionConvertor_30_40.convertBase64Binary((org.hl7.fhir.dstu3.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return VersionConvertor_30_40.convertBoolean((BooleanType)src);
        }
        if (src instanceof CodeType) {
            return VersionConvertor_30_40.convertCode((CodeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateType) {
            return VersionConvertor_30_40.convertDate((org.hl7.fhir.dstu3.model.DateType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DateTimeType) {
            return VersionConvertor_30_40.convertDateTime((org.hl7.fhir.dstu3.model.DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DecimalType) {
            return VersionConvertor_30_40.convertDecimal((org.hl7.fhir.dstu3.model.DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.IdType) {
            return VersionConvertor_30_40.convertId((org.hl7.fhir.dstu3.model.IdType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.InstantType) {
            return VersionConvertor_30_40.convertInstant((org.hl7.fhir.dstu3.model.InstantType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.IntegerType) {
            return VersionConvertor_30_40.convertInteger((org.hl7.fhir.dstu3.model.IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return VersionConvertor_30_40.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof OidType) {
            return VersionConvertor_30_40.convertOid((OidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.PositiveIntType) {
            return VersionConvertor_30_40.convertPositiveInt((org.hl7.fhir.dstu3.model.PositiveIntType)src);
        }
        if (src instanceof StringType) {
            return VersionConvertor_30_40.convertString((StringType)src);
        }
        if (src instanceof TimeType) {
            return VersionConvertor_30_40.convertTime((TimeType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.UnsignedIntType) {
            return VersionConvertor_30_40.convertUnsignedInt((org.hl7.fhir.dstu3.model.UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.UriType) {
            return VersionConvertor_30_40.convertUri((org.hl7.fhir.dstu3.model.UriType)src);
        }
        if (src instanceof UuidType) {
            return VersionConvertor_30_40.convertUuid((UuidType)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Extension) {
            return VersionConvertor_30_40.convertExtension((org.hl7.fhir.dstu3.model.Extension)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Narrative) {
            return VersionConvertor_30_40.convertNarrative((org.hl7.fhir.dstu3.model.Narrative)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Age) {
            return VersionConvertor_30_40.convertAge((org.hl7.fhir.dstu3.model.Age)src);
        }
        if (src instanceof Annotation) {
            return VersionConvertor_30_40.convertAnnotation((Annotation)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Attachment) {
            return VersionConvertor_30_40.convertAttachment((org.hl7.fhir.dstu3.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return VersionConvertor_30_40.convertCoding((Coding)src);
        }
        if (src instanceof Count) {
            return VersionConvertor_30_40.convertCount((Count)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Distance) {
            return VersionConvertor_30_40.convertDistance((org.hl7.fhir.dstu3.model.Distance)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Duration) {
            return VersionConvertor_30_40.convertDuration((org.hl7.fhir.dstu3.model.Duration)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Identifier) {
            return VersionConvertor_30_40.convertIdentifier((org.hl7.fhir.dstu3.model.Identifier)src);
        }
        if (src instanceof Money) {
            return VersionConvertor_30_40.convertMoney((Money)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Period) {
            return VersionConvertor_30_40.convertPeriod((org.hl7.fhir.dstu3.model.Period)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Quantity) {
            return VersionConvertor_30_40.convertQuantity((org.hl7.fhir.dstu3.model.Quantity)src);
        }
        if (src instanceof Range) {
            return VersionConvertor_30_40.convertRange((Range)src);
        }
        if (src instanceof Ratio) {
            return VersionConvertor_30_40.convertRatio((Ratio)src);
        }
        if (src instanceof Reference) {
            return VersionConvertor_30_40.convertReference((Reference)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.SampledData) {
            return VersionConvertor_30_40.convertSampledData((org.hl7.fhir.dstu3.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return VersionConvertor_30_40.convertSignature((Signature)src);
        }
        if (src instanceof Address) {
            return VersionConvertor_30_40.convertAddress((Address)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ContactDetail) {
            return VersionConvertor_30_40.convertContactDetail((org.hl7.fhir.dstu3.model.ContactDetail)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.ContactPoint) {
            return VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)src);
        }
        if (src instanceof Contributor) {
            return VersionConvertor_30_40.convertContributor((Contributor)src);
        }
        if (src instanceof Dosage) {
            return VersionConvertor_30_40.convertDosage((Dosage)src);
        }
        if (src instanceof HumanName) {
            return VersionConvertor_30_40.convertHumanName((HumanName)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Meta) {
            return VersionConvertor_30_40.convertMeta((org.hl7.fhir.dstu3.model.Meta)src);
        }
        if (src instanceof ParameterDefinition) {
            return VersionConvertor_30_40.convertParameterDefinition((ParameterDefinition)src);
        }
        if (src instanceof RelatedArtifact) {
            return VersionConvertor_30_40.convertRelatedArtifact((RelatedArtifact)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.Timing) {
            return VersionConvertor_30_40.convertTiming((org.hl7.fhir.dstu3.model.Timing)src);
        }
        if (src instanceof UsageContext) {
            return VersionConvertor_30_40.convertUsageContext((UsageContext)src);
        }
        if (src instanceof ElementDefinition) {
            return VersionConvertor_30_40.convertElementDefinition((ElementDefinition)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.DataRequirement) {
            return VersionConvertor_30_40.convertDataRequirement((org.hl7.fhir.dstu3.model.DataRequirement)src);
        }
        if (src instanceof org.hl7.fhir.dstu3.model.TriggerDefinition) {
            return VersionConvertor_30_40.convertTriggerDefinition((org.hl7.fhir.dstu3.model.TriggerDefinition)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public static Type convertType(org.hl7.fhir.r4.model.Type src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return VersionConvertor_30_40.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.BooleanType) {
            return VersionConvertor_30_40.convertBoolean((org.hl7.fhir.r4.model.BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeType) {
            return VersionConvertor_30_40.convertCode((org.hl7.fhir.r4.model.CodeType)src);
        }
        if (src instanceof DateType) {
            return VersionConvertor_30_40.convertDate((DateType)src);
        }
        if (src instanceof DateTimeType) {
            return VersionConvertor_30_40.convertDateTime((DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return VersionConvertor_30_40.convertDecimal((DecimalType)src);
        }
        if (src instanceof IdType) {
            return VersionConvertor_30_40.convertId((IdType)src);
        }
        if (src instanceof InstantType) {
            return VersionConvertor_30_40.convertInstant((InstantType)src);
        }
        if (src instanceof IntegerType) {
            return VersionConvertor_30_40.convertInteger((IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MarkdownType) {
            return VersionConvertor_30_40.convertMarkdown((org.hl7.fhir.r4.model.MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OidType) {
            return VersionConvertor_30_40.convertOid((org.hl7.fhir.r4.model.OidType)src);
        }
        if (src instanceof PositiveIntType) {
            return VersionConvertor_30_40.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.StringType) {
            return VersionConvertor_30_40.convertString((org.hl7.fhir.r4.model.StringType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TimeType) {
            return VersionConvertor_30_40.convertTime((org.hl7.fhir.r4.model.TimeType)src);
        }
        if (src instanceof UnsignedIntType) {
            return VersionConvertor_30_40.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof UriType) {
            return VersionConvertor_30_40.convertUri((UriType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UuidType) {
            return VersionConvertor_30_40.convertUuid((org.hl7.fhir.r4.model.UuidType)src);
        }
        if (src instanceof Extension) {
            return VersionConvertor_30_40.convertExtension((Extension)src);
        }
        if (src instanceof Narrative) {
            return VersionConvertor_30_40.convertNarrative((Narrative)src);
        }
        if (src instanceof Age) {
            return VersionConvertor_30_40.convertAge((Age)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Annotation) {
            return VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)src);
        }
        if (src instanceof Attachment) {
            return VersionConvertor_30_40.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            return VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Coding) {
            return VersionConvertor_30_40.convertCoding((org.hl7.fhir.r4.model.Coding)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Count) {
            return VersionConvertor_30_40.convertCount((org.hl7.fhir.r4.model.Count)src);
        }
        if (src instanceof Distance) {
            return VersionConvertor_30_40.convertDistance((Distance)src);
        }
        if (src instanceof Duration) {
            return VersionConvertor_30_40.convertDuration((Duration)src);
        }
        if (src instanceof Identifier) {
            return VersionConvertor_30_40.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Money) {
            return VersionConvertor_30_40.convertMoney((org.hl7.fhir.r4.model.Money)src);
        }
        if (src instanceof Period) {
            return VersionConvertor_30_40.convertPeriod((Period)src);
        }
        if (src instanceof Quantity) {
            return VersionConvertor_30_40.convertQuantity((Quantity)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Range) {
            return VersionConvertor_30_40.convertRange((org.hl7.fhir.r4.model.Range)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Ratio) {
            return VersionConvertor_30_40.convertRatio((org.hl7.fhir.r4.model.Ratio)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Reference) {
            return VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)src);
        }
        if (src instanceof SampledData) {
            return VersionConvertor_30_40.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Signature) {
            return VersionConvertor_30_40.convertSignature((org.hl7.fhir.r4.model.Signature)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Address) {
            return VersionConvertor_30_40.convertAddress((org.hl7.fhir.r4.model.Address)src);
        }
        if (src instanceof ContactDetail) {
            return VersionConvertor_30_40.convertContactDetail((ContactDetail)src);
        }
        if (src instanceof ContactPoint) {
            return VersionConvertor_30_40.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Contributor) {
            return VersionConvertor_30_40.convertContributor((org.hl7.fhir.r4.model.Contributor)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Dosage) {
            return VersionConvertor_30_40.convertDosage((org.hl7.fhir.r4.model.Dosage)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.HumanName) {
            return VersionConvertor_30_40.convertHumanName((org.hl7.fhir.r4.model.HumanName)src);
        }
        if (src instanceof Meta) {
            return VersionConvertor_30_40.convertMeta((Meta)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ParameterDefinition) {
            return VersionConvertor_30_40.convertParameterDefinition((org.hl7.fhir.r4.model.ParameterDefinition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.RelatedArtifact) {
            return VersionConvertor_30_40.convertRelatedArtifact((org.hl7.fhir.r4.model.RelatedArtifact)src);
        }
        if (src instanceof Timing) {
            return VersionConvertor_30_40.convertTiming((Timing)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UsageContext) {
            return VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ElementDefinition) {
            return VersionConvertor_30_40.convertElementDefinition((org.hl7.fhir.r4.model.ElementDefinition)src);
        }
        if (src instanceof DataRequirement) {
            return VersionConvertor_30_40.convertDataRequirement((DataRequirement)src);
        }
        if (src instanceof TriggerDefinition) {
            return VersionConvertor_30_40.convertTriggerDefinition((TriggerDefinition)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    private static void copyDomainResource(DomainResource src, org.hl7.fhir.r4.model.DomainResource tgt) throws FHIRException {
        VersionConvertor_30_40.copyResource((org.hl7.fhir.dstu3.model.Resource)src, (Resource)tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_40.convertNarrative(src.getText()));
        }
        for (org.hl7.fhir.dstu3.model.Resource t1 : src.getContained()) {
            tgt.addContained(VersionConvertor_30_40.convertResource(t1, false));
        }
        for (org.hl7.fhir.dstu3.model.Extension t2 : src.getExtension()) {
            tgt.addExtension(VersionConvertor_30_40.convertExtension(t2));
        }
        for (org.hl7.fhir.dstu3.model.Extension t3 : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(t3));
        }
    }

    private static void copyDomainResource(org.hl7.fhir.r4.model.DomainResource src, DomainResource tgt) throws FHIRException {
        VersionConvertor_30_40.copyResource((Resource)src, (org.hl7.fhir.dstu3.model.Resource)tgt);
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_40.convertNarrative(src.getText()));
        }
        for (Resource t1 : src.getContained()) {
            tgt.addContained(VersionConvertor_30_40.convertResource(t1, false));
        }
        for (Extension t2 : src.getExtension()) {
            tgt.addExtension(VersionConvertor_30_40.convertExtension(t2));
        }
        for (Extension t3 : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension(t3));
        }
    }

    public static org.hl7.fhir.r4.model.Parameters convertParameters(Parameters src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Parameters tgt = new org.hl7.fhir.r4.model.Parameters();
        VersionConvertor_30_40.copyResource((org.hl7.fhir.dstu3.model.Resource)src, (Resource)tgt);
        for (Parameters.ParametersParameterComponent t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_30_40.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public static Parameters convertParameters(org.hl7.fhir.r4.model.Parameters src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Parameters tgt = new Parameters();
        VersionConvertor_30_40.copyResource((Resource)src, (org.hl7.fhir.dstu3.model.Resource)tgt);
        for (Parameters.ParametersParameterComponent t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_30_40.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public static Parameters.ParametersParameterComponent convertParametersParameterComponent(Parameters.ParametersParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Parameters.ParametersParameterComponent tgt = new Parameters.ParametersParameterComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertResource(src.getResource(), false));
        }
        for (Parameters.ParametersParameterComponent t : src.getPart()) {
            tgt.addPart(VersionConvertor_30_40.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public static Parameters.ParametersParameterComponent convertParametersParameterComponent(Parameters.ParametersParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Parameters.ParametersParameterComponent tgt = new Parameters.ParametersParameterComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertResource(src.getResource(), false));
        }
        for (Parameters.ParametersParameterComponent t : src.getPart()) {
            tgt.addPart(VersionConvertor_30_40.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    private static void copyResource(org.hl7.fhir.dstu3.model.Resource src, Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_30_40.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    private static void copyResource(Resource src, org.hl7.fhir.dstu3.model.Resource tgt) throws FHIRException {
        if (src.hasId()) {
            tgt.setId(src.getId());
        }
        if (src.hasMeta()) {
            tgt.setMeta(VersionConvertor_30_40.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public static ActivityDefinition convertActivityDefinition(org.hl7.fhir.dstu3.model.ActivityDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition tgt = new ActivityDefinition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasUsage()) {
            tgt.setUsage(src.getUsage());
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDate(src.getApprovalDate());
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDate(src.getLastReviewDate());
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_40.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTopic()) {
            tgt.addTopic(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContributor()) {
            if (t.getType() == Contributor.ContributorType.AUTHOR) {
                for (org.hl7.fhir.dstu3.model.ContactDetail c : t.getContact()) {
                    tgt.addAuthor(VersionConvertor_30_40.convertContactDetail(c));
                }
            }
            if (t.getType() == Contributor.ContributorType.EDITOR) {
                for (org.hl7.fhir.dstu3.model.ContactDetail c : t.getContact()) {
                    tgt.addEditor(VersionConvertor_30_40.convertContactDetail(c));
                }
            }
            if (t.getType() == Contributor.ContributorType.REVIEWER) {
                for (org.hl7.fhir.dstu3.model.ContactDetail c : t.getContact()) {
                    tgt.addReviewer(VersionConvertor_30_40.convertContactDetail(c));
                }
            }
            if (t.getType() != Contributor.ContributorType.ENDORSER) continue;
            for (org.hl7.fhir.dstu3.model.ContactDetail c : t.getContact()) {
                tgt.addEndorser(VersionConvertor_30_40.convertContactDetail(c));
            }
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((org.hl7.fhir.dstu3.model.ContactDetail)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(VersionConvertor_30_40.convertRelatedArtifact((RelatedArtifact)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getLibrary()) {
            tgt.getLibrary().add(VersionConvertor_30_40.convertReferenceToCanonical((Reference)t));
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertActivityDefinitionKind(src.getKind()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertType(src.getTiming()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertActivityDefinitionParticipantComponent((ActivityDefinition.ActivityDefinitionParticipantComponent)t));
        }
        if (src.hasProduct()) {
            tgt.setProduct(VersionConvertor_30_40.convertType(src.getProduct()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_40.convertDosage((Dosage)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasTransform()) {
            tgt.setTransformElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getTransform()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDynamicValue()) {
            tgt.addDynamicValue(VersionConvertor_30_40.convertActivityDefinitionDynamicValueComponent((ActivityDefinition.ActivityDefinitionDynamicValueComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ActivityDefinition convertActivityDefinition(ActivityDefinition src) throws FHIRException {
        Contributor c;
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ActivityDefinition tgt = new org.hl7.fhir.dstu3.model.ActivityDefinition();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasUsage()) {
            tgt.setUsage(src.getUsage());
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDate(src.getApprovalDate());
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDate(src.getLastReviewDate());
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_40.convertPeriod(src.getEffectivePeriod()));
        }
        for (Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getTopic()) {
            tgt.addTopic(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getAuthor()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.AUTHOR);
            c.addContact(VersionConvertor_30_40.convertContactDetail((ContactDetail)t));
            tgt.addContributor(c);
        }
        for (Identifier t : src.getEditor()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.EDITOR);
            c.addContact(VersionConvertor_30_40.convertContactDetail((ContactDetail)t));
            tgt.addContributor(c);
        }
        for (Identifier t : src.getReviewer()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.REVIEWER);
            c.addContact(VersionConvertor_30_40.convertContactDetail((ContactDetail)t));
            tgt.addContributor(c);
        }
        for (Identifier t : src.getEndorser()) {
            c = new Contributor();
            c.setType(Contributor.ContributorType.ENDORSER);
            c.addContact(VersionConvertor_30_40.convertContactDetail((ContactDetail)t));
            tgt.addContributor(c);
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((ContactDetail)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Identifier t : src.getRelatedArtifact()) {
            tgt.addRelatedArtifact(VersionConvertor_30_40.convertRelatedArtifact((org.hl7.fhir.r4.model.RelatedArtifact)t));
        }
        for (Identifier t : src.getLibrary()) {
            tgt.addLibrary(VersionConvertor_30_40.convertCanonicalToReference((CanonicalType)t));
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertActivityDefinitionKind(src.getKind()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertType(src.getTiming()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (Identifier t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertActivityDefinitionParticipantComponent((ActivityDefinition.ActivityDefinitionParticipantComponent)t));
        }
        if (src.hasProduct()) {
            tgt.setProduct(VersionConvertor_30_40.convertType(src.getProduct()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        for (Identifier t : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_40.convertDosage((org.hl7.fhir.r4.model.Dosage)t));
        }
        for (Identifier t : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasTransform()) {
            tgt.setTransform(VersionConvertor_30_40.convertCanonicalToReference(src.getTransformElement()));
        }
        for (Identifier t : src.getDynamicValue()) {
            tgt.addDynamicValue(VersionConvertor_30_40.convertActivityDefinitionDynamicValueComponent((ActivityDefinition.ActivityDefinitionDynamicValueComponent)t));
        }
        return tgt;
    }

    private static Enumerations.PublicationStatus convertPublicationStatus(Enumerations.PublicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Enumerations.PublicationStatus.DRAFT;
            }
            case ACTIVE: {
                return Enumerations.PublicationStatus.ACTIVE;
            }
            case RETIRED: {
                return Enumerations.PublicationStatus.RETIRED;
            }
            case UNKNOWN: {
                return Enumerations.PublicationStatus.UNKNOWN;
            }
        }
        return Enumerations.PublicationStatus.NULL;
    }

    private static Enumerations.PublicationStatus convertPublicationStatus(Enumerations.PublicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Enumerations.PublicationStatus.DRAFT;
            }
            case ACTIVE: {
                return Enumerations.PublicationStatus.ACTIVE;
            }
            case RETIRED: {
                return Enumerations.PublicationStatus.RETIRED;
            }
            case UNKNOWN: {
                return Enumerations.PublicationStatus.UNKNOWN;
            }
        }
        return Enumerations.PublicationStatus.NULL;
    }

    private static ActivityDefinition.ActivityDefinitionKind convertActivityDefinitionKind(ActivityDefinition.ActivityDefinitionKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case APPOINTMENT: {
                return ActivityDefinition.ActivityDefinitionKind.APPOINTMENT;
            }
            case APPOINTMENTRESPONSE: {
                return ActivityDefinition.ActivityDefinitionKind.APPOINTMENTRESPONSE;
            }
            case CAREPLAN: {
                return ActivityDefinition.ActivityDefinitionKind.CAREPLAN;
            }
            case CLAIM: {
                return ActivityDefinition.ActivityDefinitionKind.CLAIM;
            }
            case COMMUNICATIONREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.COMMUNICATIONREQUEST;
            }
            case CONTRACT: {
                return ActivityDefinition.ActivityDefinitionKind.CONTRACT;
            }
            case DEVICEREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.DEVICEREQUEST;
            }
            case ENROLLMENTREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.ENROLLMENTREQUEST;
            }
            case IMMUNIZATIONRECOMMENDATION: {
                return ActivityDefinition.ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION;
            }
            case MEDICATIONREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.MEDICATIONREQUEST;
            }
            case NUTRITIONORDER: {
                return ActivityDefinition.ActivityDefinitionKind.NUTRITIONORDER;
            }
            case PROCEDUREREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.SERVICEREQUEST;
            }
            case REFERRALREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.SERVICEREQUEST;
            }
            case SUPPLYREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.SUPPLYREQUEST;
            }
            case TASK: {
                return ActivityDefinition.ActivityDefinitionKind.TASK;
            }
            case VISIONPRESCRIPTION: {
                return ActivityDefinition.ActivityDefinitionKind.VISIONPRESCRIPTION;
            }
        }
        return ActivityDefinition.ActivityDefinitionKind.NULL;
    }

    private static ActivityDefinition.ActivityDefinitionKind convertActivityDefinitionKind(ActivityDefinition.ActivityDefinitionKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case APPOINTMENT: {
                return ActivityDefinition.ActivityDefinitionKind.APPOINTMENT;
            }
            case APPOINTMENTRESPONSE: {
                return ActivityDefinition.ActivityDefinitionKind.APPOINTMENTRESPONSE;
            }
            case CAREPLAN: {
                return ActivityDefinition.ActivityDefinitionKind.CAREPLAN;
            }
            case CLAIM: {
                return ActivityDefinition.ActivityDefinitionKind.CLAIM;
            }
            case COMMUNICATIONREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.COMMUNICATIONREQUEST;
            }
            case CONTRACT: {
                return ActivityDefinition.ActivityDefinitionKind.CONTRACT;
            }
            case DEVICEREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.DEVICEREQUEST;
            }
            case ENROLLMENTREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.ENROLLMENTREQUEST;
            }
            case IMMUNIZATIONRECOMMENDATION: {
                return ActivityDefinition.ActivityDefinitionKind.IMMUNIZATIONRECOMMENDATION;
            }
            case MEDICATIONREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.MEDICATIONREQUEST;
            }
            case NUTRITIONORDER: {
                return ActivityDefinition.ActivityDefinitionKind.NUTRITIONORDER;
            }
            case SERVICEREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.PROCEDUREREQUEST;
            }
            case SUPPLYREQUEST: {
                return ActivityDefinition.ActivityDefinitionKind.SUPPLYREQUEST;
            }
            case TASK: {
                return ActivityDefinition.ActivityDefinitionKind.TASK;
            }
            case VISIONPRESCRIPTION: {
                return ActivityDefinition.ActivityDefinitionKind.VISIONPRESCRIPTION;
            }
        }
        return ActivityDefinition.ActivityDefinitionKind.NULL;
    }

    public static ActivityDefinition.ActivityDefinitionParticipantComponent convertActivityDefinitionParticipantComponent(ActivityDefinition.ActivityDefinitionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionParticipantComponent tgt = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertActivityParticipantType(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionParticipantComponent convertActivityDefinitionParticipantComponent(ActivityDefinition.ActivityDefinitionParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionParticipantComponent tgt = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertActivityParticipantType(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        return tgt;
    }

    private static ActivityDefinition.ActivityParticipantType convertActivityParticipantType(ActivityDefinition.ActivityParticipantType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PATIENT: {
                return ActivityDefinition.ActivityParticipantType.PATIENT;
            }
            case PRACTITIONER: {
                return ActivityDefinition.ActivityParticipantType.PRACTITIONER;
            }
            case RELATEDPERSON: {
                return ActivityDefinition.ActivityParticipantType.RELATEDPERSON;
            }
        }
        return ActivityDefinition.ActivityParticipantType.NULL;
    }

    private static ActivityDefinition.ActivityParticipantType convertActivityParticipantType(ActivityDefinition.ActivityParticipantType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PATIENT: {
                return ActivityDefinition.ActivityParticipantType.PATIENT;
            }
            case PRACTITIONER: {
                return ActivityDefinition.ActivityParticipantType.PRACTITIONER;
            }
            case RELATEDPERSON: {
                return ActivityDefinition.ActivityParticipantType.RELATEDPERSON;
            }
        }
        return ActivityDefinition.ActivityParticipantType.NULL;
    }

    public static ActivityDefinition.ActivityDefinitionDynamicValueComponent convertActivityDefinitionDynamicValueComponent(ActivityDefinition.ActivityDefinitionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionDynamicValueComponent tgt = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasDescription()) {
            tgt.getExpression().setDescription(src.getDescription());
        }
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasLanguage()) {
            tgt.getExpression().setLanguage(Expression.ExpressionLanguage.fromCode((String)src.getLanguage()));
        }
        if (src.hasExpression()) {
            tgt.getExpression().setExpression(src.getExpression());
        }
        return tgt;
    }

    public static ActivityDefinition.ActivityDefinitionDynamicValueComponent convertActivityDefinitionDynamicValueComponent(ActivityDefinition.ActivityDefinitionDynamicValueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ActivityDefinition.ActivityDefinitionDynamicValueComponent tgt = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.getExpression().hasDescription()) {
            tgt.setDescription(src.getExpression().getDescription());
        }
        if (src.getExpression().hasLanguage()) {
            tgt.setLanguage(src.getExpression().getLanguage().toCode());
        }
        if (src.getExpression().hasExpression()) {
            tgt.setExpression(src.getExpression().getExpression());
        }
        return tgt;
    }

    public static AllergyIntolerance convertAllergyIntolerance(org.hl7.fhir.dstu3.model.AllergyIntolerance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance tgt = new AllergyIntolerance();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(VersionConvertor_30_40.convertAllergyIntoleranceClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(VersionConvertor_30_40.convertAllergyIntoleranceVerificationStatus(src.getVerificationStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertAllergyIntoleranceType(src.getType()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertAllergyIntoleranceCategory((AllergyIntolerance.AllergyIntoleranceCategory)t.getValue()));
        }
        if (src.hasCriticality()) {
            tgt.setCriticality(VersionConvertor_30_40.convertAllergyIntoleranceCriticality(src.getCriticality()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        if (src.hasAssertedDate()) {
            tgt.setRecordedDate(src.getAssertedDate());
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_40.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_30_40.convertReference(src.getAsserter()));
        }
        if (src.hasLastOccurrence()) {
            tgt.setLastOccurrence(src.getLastOccurrence());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReaction()) {
            tgt.addReaction(VersionConvertor_30_40.convertAllergyIntoleranceReactionComponent((AllergyIntolerance.AllergyIntoleranceReactionComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.AllergyIntolerance convertAllergyIntolerance(AllergyIntolerance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.AllergyIntolerance tgt = new org.hl7.fhir.dstu3.model.AllergyIntolerance();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(VersionConvertor_30_40.convertAllergyIntoleranceClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(VersionConvertor_30_40.convertAllergyIntoleranceVerificationStatus(src.getVerificationStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertAllergyIntoleranceType(src.getType()));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertAllergyIntoleranceCategory((AllergyIntolerance.AllergyIntoleranceCategory)t.getValue()));
        }
        if (src.hasCriticality()) {
            tgt.setCriticality(VersionConvertor_30_40.convertAllergyIntoleranceCriticality(src.getCriticality()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        if (src.hasRecordedDate()) {
            tgt.setAssertedDate(src.getRecordedDate());
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_40.convertReference(src.getRecorder()));
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_30_40.convertReference(src.getAsserter()));
        }
        if (src.hasLastOccurrence()) {
            tgt.setLastOccurrence(src.getLastOccurrence());
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        for (Identifier t : src.getReaction()) {
            tgt.addReaction(VersionConvertor_30_40.convertAllergyIntoleranceReactionComponent((AllergyIntolerance.AllergyIntoleranceReactionComponent)t));
        }
        return tgt;
    }

    private static org.hl7.fhir.r4.model.CodeableConcept convertAllergyIntoleranceClinicalStatus(AllergyIntolerance.AllergyIntoleranceClinicalStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return new org.hl7.fhir.r4.model.CodeableConcept(new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical").setCode("active"));
            }
            case INACTIVE: {
                return new org.hl7.fhir.r4.model.CodeableConcept(new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical").setCode("inactive"));
            }
            case RESOLVED: {
                new org.hl7.fhir.r4.model.CodeableConcept(new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical").setCode("resolved"));
            }
        }
        return null;
    }

    private static AllergyIntolerance.AllergyIntoleranceClinicalStatus convertAllergyIntoleranceClinicalStatus(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "active")) {
            return AllergyIntolerance.AllergyIntoleranceClinicalStatus.ACTIVE;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "inactive")) {
            return AllergyIntolerance.AllergyIntoleranceClinicalStatus.INACTIVE;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical", "resolved")) {
            return AllergyIntolerance.AllergyIntoleranceClinicalStatus.RESOLVED;
        }
        return AllergyIntolerance.AllergyIntoleranceClinicalStatus.NULL;
    }

    private static org.hl7.fhir.r4.model.CodeableConcept convertAllergyIntoleranceVerificationStatus(AllergyIntolerance.AllergyIntoleranceVerificationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case UNCONFIRMED: {
                return new org.hl7.fhir.r4.model.CodeableConcept(new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification").setCode("unconfirmed"));
            }
            case CONFIRMED: {
                return new org.hl7.fhir.r4.model.CodeableConcept(new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification").setCode("confirmed"));
            }
            case REFUTED: {
                return new org.hl7.fhir.r4.model.CodeableConcept(new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification").setCode("refuted"));
            }
            case ENTEREDINERROR: {
                return new org.hl7.fhir.r4.model.CodeableConcept(new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification").setCode("entered-in-error"));
            }
        }
        return null;
    }

    private static AllergyIntolerance.AllergyIntoleranceVerificationStatus convertAllergyIntoleranceVerificationStatus(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "unconfirmed")) {
            return AllergyIntolerance.AllergyIntoleranceVerificationStatus.UNCONFIRMED;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "confirmed")) {
            return AllergyIntolerance.AllergyIntoleranceVerificationStatus.CONFIRMED;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "refuted")) {
            return AllergyIntolerance.AllergyIntoleranceVerificationStatus.REFUTED;
        }
        if (src.hasCoding("http://terminology.hl7.org/CodeSystem/allergyintolerance-verification", "entered-in-error")) {
            return AllergyIntolerance.AllergyIntoleranceVerificationStatus.ENTEREDINERROR;
        }
        return AllergyIntolerance.AllergyIntoleranceVerificationStatus.NULL;
    }

    private static AllergyIntolerance.AllergyIntoleranceType convertAllergyIntoleranceType(AllergyIntolerance.AllergyIntoleranceType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ALLERGY: {
                return AllergyIntolerance.AllergyIntoleranceType.ALLERGY;
            }
            case INTOLERANCE: {
                return AllergyIntolerance.AllergyIntoleranceType.INTOLERANCE;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceType.NULL;
    }

    private static AllergyIntolerance.AllergyIntoleranceType convertAllergyIntoleranceType(AllergyIntolerance.AllergyIntoleranceType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ALLERGY: {
                return AllergyIntolerance.AllergyIntoleranceType.ALLERGY;
            }
            case INTOLERANCE: {
                return AllergyIntolerance.AllergyIntoleranceType.INTOLERANCE;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceType.NULL;
    }

    private static AllergyIntolerance.AllergyIntoleranceCategory convertAllergyIntoleranceCategory(AllergyIntolerance.AllergyIntoleranceCategory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FOOD: {
                return AllergyIntolerance.AllergyIntoleranceCategory.FOOD;
            }
            case MEDICATION: {
                return AllergyIntolerance.AllergyIntoleranceCategory.MEDICATION;
            }
            case ENVIRONMENT: {
                return AllergyIntolerance.AllergyIntoleranceCategory.ENVIRONMENT;
            }
            case BIOLOGIC: {
                return AllergyIntolerance.AllergyIntoleranceCategory.BIOLOGIC;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceCategory.NULL;
    }

    private static AllergyIntolerance.AllergyIntoleranceCategory convertAllergyIntoleranceCategory(AllergyIntolerance.AllergyIntoleranceCategory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FOOD: {
                return AllergyIntolerance.AllergyIntoleranceCategory.FOOD;
            }
            case MEDICATION: {
                return AllergyIntolerance.AllergyIntoleranceCategory.MEDICATION;
            }
            case ENVIRONMENT: {
                return AllergyIntolerance.AllergyIntoleranceCategory.ENVIRONMENT;
            }
            case BIOLOGIC: {
                return AllergyIntolerance.AllergyIntoleranceCategory.BIOLOGIC;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceCategory.NULL;
    }

    private static AllergyIntolerance.AllergyIntoleranceCriticality convertAllergyIntoleranceCriticality(AllergyIntolerance.AllergyIntoleranceCriticality src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LOW: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.LOW;
            }
            case HIGH: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.HIGH;
            }
            case UNABLETOASSESS: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.UNABLETOASSESS;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceCriticality.NULL;
    }

    private static AllergyIntolerance.AllergyIntoleranceCriticality convertAllergyIntoleranceCriticality(AllergyIntolerance.AllergyIntoleranceCriticality src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LOW: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.LOW;
            }
            case HIGH: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.HIGH;
            }
            case UNABLETOASSESS: {
                return AllergyIntolerance.AllergyIntoleranceCriticality.UNABLETOASSESS;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceCriticality.NULL;
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent convertAllergyIntoleranceReactionComponent(AllergyIntolerance.AllergyIntoleranceReactionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance.AllergyIntoleranceReactionComponent tgt = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_30_40.convertCodeableConcept(src.getSubstance()));
        }
        for (CodeableConcept t : src.getManifestation()) {
            tgt.addManifestation(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasOnset()) {
            tgt.setOnset(src.getOnset());
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertAllergyIntoleranceSeverity(src.getSeverity()));
        }
        if (src.hasExposureRoute()) {
            tgt.setExposureRoute(VersionConvertor_30_40.convertCodeableConcept(src.getExposureRoute()));
        }
        for (CodeableConcept t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        return tgt;
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent convertAllergyIntoleranceReactionComponent(AllergyIntolerance.AllergyIntoleranceReactionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AllergyIntolerance.AllergyIntoleranceReactionComponent tgt = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_30_40.convertCodeableConcept(src.getSubstance()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getManifestation()) {
            tgt.addManifestation(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasOnset()) {
            tgt.setOnset(src.getOnset());
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertAllergyIntoleranceSeverity(src.getSeverity()));
        }
        if (src.hasExposureRoute()) {
            tgt.setExposureRoute(VersionConvertor_30_40.convertCodeableConcept(src.getExposureRoute()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        return tgt;
    }

    private static AllergyIntolerance.AllergyIntoleranceSeverity convertAllergyIntoleranceSeverity(AllergyIntolerance.AllergyIntoleranceSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MILD: {
                return AllergyIntolerance.AllergyIntoleranceSeverity.MILD;
            }
            case MODERATE: {
                return AllergyIntolerance.AllergyIntoleranceSeverity.MODERATE;
            }
            case SEVERE: {
                return AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceSeverity.NULL;
    }

    private static AllergyIntolerance.AllergyIntoleranceSeverity convertAllergyIntoleranceSeverity(AllergyIntolerance.AllergyIntoleranceSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MILD: {
                return AllergyIntolerance.AllergyIntoleranceSeverity.MILD;
            }
            case MODERATE: {
                return AllergyIntolerance.AllergyIntoleranceSeverity.MODERATE;
            }
            case SEVERE: {
                return AllergyIntolerance.AllergyIntoleranceSeverity.SEVERE;
            }
        }
        return AllergyIntolerance.AllergyIntoleranceSeverity.NULL;
    }

    public static org.hl7.fhir.r4.model.Appointment convertAppointment(Appointment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Appointment tgt = new org.hl7.fhir.r4.model.Appointment();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertAppointmentStatus(src.getStatus()));
        }
        if (src.hasServiceCategory()) {
            tgt.addServiceCategory(VersionConvertor_30_40.convertCodeableConcept(src.getServiceCategory()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(VersionConvertor_30_40.convertCodeableConcept(src.getAppointmentType()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReason()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIndication()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasPriority()) {
            tgt.setPriority(src.getPriority());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasMinutesDuration()) {
            tgt.setMinutesDuration(src.getMinutesDuration());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSlot()) {
            tgt.addSlot(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasCreated()) {
            tgt.setCreated(src.getCreated());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIncomingReferral()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertAppointmentParticipantComponent((Appointment.AppointmentParticipantComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getRequestedPeriod()) {
            tgt.addRequestedPeriod(VersionConvertor_30_40.convertPeriod((org.hl7.fhir.dstu3.model.Period)t));
        }
        return tgt;
    }

    public static Appointment convertAppointment(org.hl7.fhir.r4.model.Appointment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment tgt = new Appointment();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertAppointmentStatus(src.getStatus()));
        }
        if (src.hasServiceCategory()) {
            tgt.setServiceCategory(VersionConvertor_30_40.convertCodeableConcept(src.getServiceCategoryFirstRep()));
        }
        for (Identifier t : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(VersionConvertor_30_40.convertCodeableConcept(src.getAppointmentType()));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReasonReference()) {
            tgt.addIndication(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasPriority()) {
            tgt.setPriority(src.getPriority());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasMinutesDuration()) {
            tgt.setMinutesDuration(src.getMinutesDuration());
        }
        for (Identifier t : src.getSlot()) {
            tgt.addSlot(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasCreated()) {
            tgt.setCreated(src.getCreated());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        for (Identifier t : src.getBasedOn()) {
            tgt.addIncomingReferral(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertAppointmentParticipantComponent((Appointment.AppointmentParticipantComponent)t));
        }
        for (Identifier t : src.getRequestedPeriod()) {
            tgt.addRequestedPeriod(VersionConvertor_30_40.convertPeriod((Period)t));
        }
        return tgt;
    }

    private static Appointment.AppointmentStatus convertAppointmentStatus(Appointment.AppointmentStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return Appointment.AppointmentStatus.PROPOSED;
            }
            case PENDING: {
                return Appointment.AppointmentStatus.PENDING;
            }
            case BOOKED: {
                return Appointment.AppointmentStatus.BOOKED;
            }
            case ARRIVED: {
                return Appointment.AppointmentStatus.ARRIVED;
            }
            case FULFILLED: {
                return Appointment.AppointmentStatus.FULFILLED;
            }
            case CANCELLED: {
                return Appointment.AppointmentStatus.CANCELLED;
            }
            case NOSHOW: {
                return Appointment.AppointmentStatus.NOSHOW;
            }
            case ENTEREDINERROR: {
                return Appointment.AppointmentStatus.ENTEREDINERROR;
            }
        }
        return Appointment.AppointmentStatus.NULL;
    }

    private static Appointment.AppointmentStatus convertAppointmentStatus(Appointment.AppointmentStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return Appointment.AppointmentStatus.PROPOSED;
            }
            case PENDING: {
                return Appointment.AppointmentStatus.PENDING;
            }
            case BOOKED: {
                return Appointment.AppointmentStatus.BOOKED;
            }
            case ARRIVED: {
                return Appointment.AppointmentStatus.ARRIVED;
            }
            case FULFILLED: {
                return Appointment.AppointmentStatus.FULFILLED;
            }
            case CANCELLED: {
                return Appointment.AppointmentStatus.CANCELLED;
            }
            case NOSHOW: {
                return Appointment.AppointmentStatus.NOSHOW;
            }
            case ENTEREDINERROR: {
                return Appointment.AppointmentStatus.ENTEREDINERROR;
            }
        }
        return Appointment.AppointmentStatus.NULL;
    }

    public static Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        if (src.hasRequired()) {
            tgt.setRequired(VersionConvertor_30_40.convertParticipantRequired(src.getRequired()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertParticipationStatus(src.getStatus()));
        }
        return tgt;
    }

    public static Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        if (src.hasRequired()) {
            tgt.setRequired(VersionConvertor_30_40.convertParticipantRequired(src.getRequired()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertParticipationStatus(src.getStatus()));
        }
        return tgt;
    }

    private static Appointment.ParticipantRequired convertParticipantRequired(Appointment.ParticipantRequired src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Appointment.ParticipantRequired.REQUIRED;
            }
            case OPTIONAL: {
                return Appointment.ParticipantRequired.OPTIONAL;
            }
            case INFORMATIONONLY: {
                return Appointment.ParticipantRequired.INFORMATIONONLY;
            }
        }
        return Appointment.ParticipantRequired.NULL;
    }

    private static Appointment.ParticipantRequired convertParticipantRequired(Appointment.ParticipantRequired src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Appointment.ParticipantRequired.REQUIRED;
            }
            case OPTIONAL: {
                return Appointment.ParticipantRequired.OPTIONAL;
            }
            case INFORMATIONONLY: {
                return Appointment.ParticipantRequired.INFORMATIONONLY;
            }
        }
        return Appointment.ParticipantRequired.NULL;
    }

    private static Appointment.ParticipationStatus convertParticipationStatus(Appointment.ParticipationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACCEPTED: {
                return Appointment.ParticipationStatus.ACCEPTED;
            }
            case DECLINED: {
                return Appointment.ParticipationStatus.DECLINED;
            }
            case TENTATIVE: {
                return Appointment.ParticipationStatus.TENTATIVE;
            }
            case NEEDSACTION: {
                return Appointment.ParticipationStatus.NEEDSACTION;
            }
        }
        return Appointment.ParticipationStatus.NULL;
    }

    private static Appointment.ParticipationStatus convertParticipationStatus(Appointment.ParticipationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACCEPTED: {
                return Appointment.ParticipationStatus.ACCEPTED;
            }
            case DECLINED: {
                return Appointment.ParticipationStatus.DECLINED;
            }
            case TENTATIVE: {
                return Appointment.ParticipationStatus.TENTATIVE;
            }
            case NEEDSACTION: {
                return Appointment.ParticipationStatus.NEEDSACTION;
            }
        }
        return Appointment.ParticipationStatus.NULL;
    }

    public static org.hl7.fhir.r4.model.AppointmentResponse convertAppointmentResponse(AppointmentResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.AppointmentResponse tgt = new org.hl7.fhir.r4.model.AppointmentResponse();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_30_40.convertReference(src.getAppointment()));
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getParticipantType()) {
            tgt.addParticipantType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatus(VersionConvertor_30_40.convertParticipantStatus(src.getParticipantStatus()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static AppointmentResponse convertAppointmentResponse(org.hl7.fhir.r4.model.AppointmentResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AppointmentResponse tgt = new AppointmentResponse();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_30_40.convertReference(src.getAppointment()));
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        for (Identifier t : src.getParticipantType()) {
            tgt.addParticipantType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        if (src.hasParticipantStatus()) {
            tgt.setParticipantStatus(VersionConvertor_30_40.convertParticipantStatus(src.getParticipantStatus()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    private static AppointmentResponse.ParticipantStatus convertParticipantStatus(AppointmentResponse.ParticipantStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACCEPTED: {
                return AppointmentResponse.ParticipantStatus.ACCEPTED;
            }
            case DECLINED: {
                return AppointmentResponse.ParticipantStatus.DECLINED;
            }
            case TENTATIVE: {
                return AppointmentResponse.ParticipantStatus.TENTATIVE;
            }
            case NEEDSACTION: {
                return AppointmentResponse.ParticipantStatus.NEEDSACTION;
            }
        }
        return AppointmentResponse.ParticipantStatus.NULL;
    }

    private static AppointmentResponse.ParticipantStatus convertParticipantStatus(AppointmentResponse.ParticipantStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACCEPTED: {
                return AppointmentResponse.ParticipantStatus.ACCEPTED;
            }
            case DECLINED: {
                return AppointmentResponse.ParticipantStatus.DECLINED;
            }
            case TENTATIVE: {
                return AppointmentResponse.ParticipantStatus.TENTATIVE;
            }
            case NEEDSACTION: {
                return AppointmentResponse.ParticipantStatus.NEEDSACTION;
            }
        }
        return AppointmentResponse.ParticipantStatus.NULL;
    }

    public static AuditEvent convertAuditEvent(org.hl7.fhir.dstu3.model.AuditEvent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent tgt = new AuditEvent();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCoding(src.getType()));
        }
        for (Coding t : src.getSubtype()) {
            tgt.addSubtype(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_30_40.convertAuditEventAction(src.getAction()));
        }
        if (src.hasRecorded()) {
            tgt.setRecorded(src.getRecorded());
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertAuditEventOutcome(src.getOutcome()));
        }
        if (src.hasOutcomeDesc()) {
            tgt.setOutcomeDesc(src.getOutcomeDesc());
        }
        for (Coding t : src.getPurposeOfEvent()) {
            tgt.addPurposeOfEvent(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (Coding t : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_40.convertAuditEventAgentComponent((AuditEvent.AuditEventAgentComponent)t));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertAuditEventSourceComponent(src.getSource()));
        }
        for (Coding t : src.getEntity()) {
            tgt.addEntity(VersionConvertor_30_40.convertAuditEventEntityComponent((AuditEvent.AuditEventEntityComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.AuditEvent convertAuditEvent(AuditEvent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.AuditEvent tgt = new org.hl7.fhir.dstu3.model.AuditEvent();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCoding(src.getType()));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getSubtype()) {
            tgt.addSubtype(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_30_40.convertAuditEventAction(src.getAction()));
        }
        if (src.hasRecorded()) {
            tgt.setRecorded(src.getRecorded());
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertAuditEventOutcome(src.getOutcome()));
        }
        if (src.hasOutcomeDesc()) {
            tgt.setOutcomeDesc(src.getOutcomeDesc());
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getPurposeOfEvent()) {
            tgt.addPurposeOfEvent(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_40.convertAuditEventAgentComponent((AuditEvent.AuditEventAgentComponent)t));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertAuditEventSourceComponent(src.getSource()));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getEntity()) {
            tgt.addEntity(VersionConvertor_30_40.convertAuditEventEntityComponent((AuditEvent.AuditEventEntityComponent)t));
        }
        return tgt;
    }

    private static AuditEvent.AuditEventAction convertAuditEventAction(AuditEvent.AuditEventAction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case C: {
                return AuditEvent.AuditEventAction.C;
            }
            case R: {
                return AuditEvent.AuditEventAction.R;
            }
            case U: {
                return AuditEvent.AuditEventAction.U;
            }
            case D: {
                return AuditEvent.AuditEventAction.D;
            }
            case E: {
                return AuditEvent.AuditEventAction.E;
            }
        }
        return AuditEvent.AuditEventAction.NULL;
    }

    private static AuditEvent.AuditEventAction convertAuditEventAction(AuditEvent.AuditEventAction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case C: {
                return AuditEvent.AuditEventAction.C;
            }
            case R: {
                return AuditEvent.AuditEventAction.R;
            }
            case U: {
                return AuditEvent.AuditEventAction.U;
            }
            case D: {
                return AuditEvent.AuditEventAction.D;
            }
            case E: {
                return AuditEvent.AuditEventAction.E;
            }
        }
        return AuditEvent.AuditEventAction.NULL;
    }

    private static AuditEvent.AuditEventOutcome convertAuditEventOutcome(AuditEvent.AuditEventOutcome src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case _0: {
                return AuditEvent.AuditEventOutcome._0;
            }
            case _4: {
                return AuditEvent.AuditEventOutcome._4;
            }
            case _8: {
                return AuditEvent.AuditEventOutcome._8;
            }
            case _12: {
                return AuditEvent.AuditEventOutcome._12;
            }
        }
        return AuditEvent.AuditEventOutcome.NULL;
    }

    private static AuditEvent.AuditEventOutcome convertAuditEventOutcome(AuditEvent.AuditEventOutcome src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case _0: {
                return AuditEvent.AuditEventOutcome._0;
            }
            case _4: {
                return AuditEvent.AuditEventOutcome._4;
            }
            case _8: {
                return AuditEvent.AuditEventOutcome._8;
            }
            case _12: {
                return AuditEvent.AuditEventOutcome._12;
            }
        }
        return AuditEvent.AuditEventOutcome.NULL;
    }

    public static AuditEvent.AuditEventAgentComponent convertAuditEventAgentComponent(AuditEvent.AuditEventAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventAgentComponent tgt = new AuditEvent.AuditEventAgentComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasReference()) {
            tgt.setWho(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        if (src.hasUserId()) {
            tgt.getWho().setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getUserId()));
        }
        if (src.hasAltId()) {
            tgt.setAltId(src.getAltId());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasRequestor()) {
            tgt.setRequestor(src.getRequestor());
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (CodeableConcept t : src.getPolicy()) {
            tgt.addPolicy((String)t.getValue());
        }
        if (src.hasMedia()) {
            tgt.setMedia(VersionConvertor_30_40.convertCoding(src.getMedia()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(VersionConvertor_30_40.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        }
        for (CodeableConcept t : src.getPurposeOfUse()) {
            tgt.addPurposeOfUse(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentComponent convertAuditEventAgentComponent(AuditEvent.AuditEventAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventAgentComponent tgt = new AuditEvent.AuditEventAgentComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasWho()) {
            if (src.getWho().hasIdentifier()) {
                tgt.setUserId(VersionConvertor_30_40.convertIdentifier(src.getWho().getIdentifier()));
            }
            if (src.getWho().hasReference() || src.getWho().hasDisplay() || src.getWho().hasExtension() || src.getWho().hasId()) {
                tgt.setReference(VersionConvertor_30_40.convertReference(src.getWho()));
            }
        }
        if (src.hasAltId()) {
            tgt.setAltId(src.getAltId());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasRequestor()) {
            tgt.setRequestor(src.getRequestor());
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getPolicy()) {
            tgt.addPolicy((String)t.getValue());
        }
        if (src.hasMedia()) {
            tgt.setMedia(VersionConvertor_30_40.convertCoding(src.getMedia()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(VersionConvertor_30_40.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getPurposeOfUse()) {
            tgt.addPurposeOfUse(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventAgentNetworkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventAgentNetworkComponent tgt = new AuditEvent.AuditEventAgentNetworkComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertAuditEventAgentNetworkType(src.getType()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventAgentNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventAgentNetworkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventAgentNetworkComponent tgt = new AuditEvent.AuditEventAgentNetworkComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertAuditEventAgentNetworkType(src.getType()));
        }
        return tgt;
    }

    private static AuditEvent.AuditEventAgentNetworkType convertAuditEventAgentNetworkType(AuditEvent.AuditEventAgentNetworkType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case _1: {
                return AuditEvent.AuditEventAgentNetworkType._1;
            }
            case _2: {
                return AuditEvent.AuditEventAgentNetworkType._2;
            }
            case _3: {
                return AuditEvent.AuditEventAgentNetworkType._3;
            }
            case _4: {
                return AuditEvent.AuditEventAgentNetworkType._4;
            }
            case _5: {
                return AuditEvent.AuditEventAgentNetworkType._5;
            }
        }
        return AuditEvent.AuditEventAgentNetworkType.NULL;
    }

    private static AuditEvent.AuditEventAgentNetworkType convertAuditEventAgentNetworkType(AuditEvent.AuditEventAgentNetworkType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case _1: {
                return AuditEvent.AuditEventAgentNetworkType._1;
            }
            case _2: {
                return AuditEvent.AuditEventAgentNetworkType._2;
            }
            case _3: {
                return AuditEvent.AuditEventAgentNetworkType._3;
            }
            case _4: {
                return AuditEvent.AuditEventAgentNetworkType._4;
            }
            case _5: {
                return AuditEvent.AuditEventAgentNetworkType._5;
            }
        }
        return AuditEvent.AuditEventAgentNetworkType.NULL;
    }

    public static AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSite()) {
            tgt.setSite(src.getSite());
        }
        if (src.hasIdentifier()) {
            tgt.getObserver().setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        for (Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCoding(t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasSite()) {
            tgt.setSite(src.getSite());
        }
        if (src.hasObserver()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getObserver().getIdentifier()));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCoding(t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityComponent convertAuditEventEntityComponent(AuditEvent.AuditEventEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventEntityComponent tgt = new AuditEvent.AuditEventEntityComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.getWhat().setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasReference()) {
            tgt.setWhat(VersionConvertor_30_40.convertReference(src.getReference()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCoding(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCoding(src.getRole()));
        }
        if (src.hasLifecycle()) {
            tgt.setLifecycle(VersionConvertor_30_40.convertCoding(src.getLifecycle()));
        }
        for (Coding t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasQuery()) {
            tgt.setQuery(src.getQuery());
        }
        for (Coding t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_40.convertAuditEventEntityDetailComponent((AuditEvent.AuditEventEntityDetailComponent)t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityComponent convertAuditEventEntityComponent(AuditEvent.AuditEventEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventEntityComponent tgt = new AuditEvent.AuditEventEntityComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasWhat()) {
            if (src.getWhat().hasIdentifier()) {
                tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getWhat().getIdentifier()));
            }
            if (src.getWhat().hasReference() || src.getWhat().hasDisplay() || src.getWhat().hasExtension() || src.getWhat().hasId()) {
                tgt.setReference(VersionConvertor_30_40.convertReference(src.getWhat()));
            }
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCoding(src.getType()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCoding(src.getRole()));
        }
        if (src.hasLifecycle()) {
            tgt.setLifecycle(VersionConvertor_30_40.convertCoding(src.getLifecycle()));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasQuery()) {
            tgt.setQuery(src.getQuery());
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_40.convertAuditEventEntityDetailComponent((AuditEvent.AuditEventEntityDetailComponent)t));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventEntityDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventEntityDetailComponent tgt = new AuditEvent.AuditEventEntityDetailComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasValue()) {
            tgt.setValue((org.hl7.fhir.r4.model.Type)new Base64BinaryType(src.getValue()));
        }
        return tgt;
    }

    public static AuditEvent.AuditEventEntityDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventEntityDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        AuditEvent.AuditEventEntityDetailComponent tgt = new AuditEvent.AuditEventEntityDetailComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasValueStringType()) {
            tgt.setValue(((String)src.getValueStringType().getValue()).getBytes());
        } else if (src.hasValueBase64BinaryType()) {
            tgt.setValue((byte[])src.getValueBase64BinaryType().getValue());
        }
        return tgt;
    }

    public static Basic convertBasic(org.hl7.fhir.dstu3.model.Basic src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Basic tgt = new Basic();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasCreated()) {
            tgt.setCreated(src.getCreated());
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Basic convertBasic(Basic src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Basic tgt = new org.hl7.fhir.dstu3.model.Basic();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasCreated()) {
            tgt.setCreated(src.getCreated());
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Binary convertBinary(Binary src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Binary tgt = new org.hl7.fhir.r4.model.Binary();
        VersionConvertor_30_40.copyResource((org.hl7.fhir.dstu3.model.Resource)src, (Resource)tgt);
        if (src.hasContentType()) {
            tgt.setContentType(src.getContentType());
        }
        if (src.hasSecurityContext()) {
            tgt.setSecurityContext(VersionConvertor_30_40.convertReference(src.getSecurityContext()));
        }
        if (src.hasContent()) {
            tgt.setData(src.getContent());
        }
        return tgt;
    }

    public static Binary convertBinary(org.hl7.fhir.r4.model.Binary src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Binary tgt = new Binary();
        VersionConvertor_30_40.copyResource((Resource)src, (org.hl7.fhir.dstu3.model.Resource)tgt);
        if (src.hasContentType()) {
            tgt.setContentType(src.getContentType());
        }
        if (src.hasSecurityContext()) {
            tgt.setSecurityContext(VersionConvertor_30_40.convertReference(src.getSecurityContext()));
        }
        if (src.hasData()) {
            tgt.setContent(src.getData());
        }
        return tgt;
    }

    public static BodyStructure convertBodySite(BodySite src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BodyStructure tgt = new BodyStructure();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getImage()) {
            tgt.addImage(VersionConvertor_30_40.convertAttachment((org.hl7.fhir.dstu3.model.Attachment)t));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        return tgt;
    }

    public static BodySite convertBodySite(BodyStructure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BodySite tgt = new BodySite();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getImage()) {
            tgt.addImage(VersionConvertor_30_40.convertAttachment((Attachment)t));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        return tgt;
    }

    public static Bundle convertBundle(org.hl7.fhir.dstu3.model.Bundle src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle tgt = new Bundle();
        VersionConvertor_30_40.copyResource((org.hl7.fhir.dstu3.model.Resource)src, (Resource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertBundleType(src.getType()));
        }
        if (src.hasTotal()) {
            tgt.setTotal(src.getTotal());
        }
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertBundleLinkComponent(t));
        }
        for (Bundle.BundleLinkComponent t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_30_40.convertBundleEntryComponent((Bundle.BundleEntryComponent)t));
        }
        if (src.hasSignature()) {
            tgt.setSignature(VersionConvertor_30_40.convertSignature(src.getSignature()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Bundle convertBundle(Bundle src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Bundle tgt = new org.hl7.fhir.dstu3.model.Bundle();
        VersionConvertor_30_40.copyResource((Resource)src, (org.hl7.fhir.dstu3.model.Resource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertBundleType(src.getType()));
        }
        if (src.hasTotal()) {
            tgt.setTotal(src.getTotal());
        }
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertBundleLinkComponent(t));
        }
        for (Bundle.BundleLinkComponent t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_30_40.convertBundleEntryComponent((Bundle.BundleEntryComponent)t));
        }
        if (src.hasSignature()) {
            tgt.setSignature(VersionConvertor_30_40.convertSignature(src.getSignature()));
        }
        return tgt;
    }

    private static Bundle.BundleType convertBundleType(Bundle.BundleType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DOCUMENT: {
                return Bundle.BundleType.DOCUMENT;
            }
            case MESSAGE: {
                return Bundle.BundleType.MESSAGE;
            }
            case TRANSACTION: {
                return Bundle.BundleType.TRANSACTION;
            }
            case TRANSACTIONRESPONSE: {
                return Bundle.BundleType.TRANSACTIONRESPONSE;
            }
            case BATCH: {
                return Bundle.BundleType.BATCH;
            }
            case BATCHRESPONSE: {
                return Bundle.BundleType.BATCHRESPONSE;
            }
            case HISTORY: {
                return Bundle.BundleType.HISTORY;
            }
            case SEARCHSET: {
                return Bundle.BundleType.SEARCHSET;
            }
            case COLLECTION: {
                return Bundle.BundleType.COLLECTION;
            }
        }
        return Bundle.BundleType.NULL;
    }

    private static Bundle.BundleType convertBundleType(Bundle.BundleType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DOCUMENT: {
                return Bundle.BundleType.DOCUMENT;
            }
            case MESSAGE: {
                return Bundle.BundleType.MESSAGE;
            }
            case TRANSACTION: {
                return Bundle.BundleType.TRANSACTION;
            }
            case TRANSACTIONRESPONSE: {
                return Bundle.BundleType.TRANSACTIONRESPONSE;
            }
            case BATCH: {
                return Bundle.BundleType.BATCH;
            }
            case BATCHRESPONSE: {
                return Bundle.BundleType.BATCHRESPONSE;
            }
            case HISTORY: {
                return Bundle.BundleType.HISTORY;
            }
            case SEARCHSET: {
                return Bundle.BundleType.SEARCHSET;
            }
            case COLLECTION: {
                return Bundle.BundleType.COLLECTION;
            }
        }
        return Bundle.BundleType.NULL;
    }

    public static Bundle.BundleLinkComponent convertBundleLinkComponent(Bundle.BundleLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleLinkComponent tgt = new Bundle.BundleLinkComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasRelation()) {
            tgt.setRelation(src.getRelation());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static Bundle.BundleLinkComponent convertBundleLinkComponent(Bundle.BundleLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleLinkComponent tgt = new Bundle.BundleLinkComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasRelation()) {
            tgt.setRelation(src.getRelation());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static Bundle.BundleEntryComponent convertBundleEntryComponent(Bundle.BundleEntryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleEntryComponent tgt = new Bundle.BundleEntryComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertBundleLinkComponent(t));
        }
        if (src.hasFullUrl()) {
            tgt.setFullUrl(src.getFullUrl());
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertResource(src.getResource(), false));
        }
        if (src.hasSearch()) {
            tgt.setSearch(VersionConvertor_30_40.convertBundleEntrySearchComponent(src.getSearch()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(VersionConvertor_30_40.convertBundleEntryRequestComponent(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_30_40.convertBundleEntryResponseComponent(src.getResponse()));
        }
        return tgt;
    }

    public static Bundle.BundleEntryComponent convertBundleEntryComponent(Bundle.BundleEntryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleEntryComponent tgt = new Bundle.BundleEntryComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertBundleLinkComponent(t));
        }
        if (src.hasFullUrl()) {
            tgt.setFullUrl(src.getFullUrl());
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertResource(src.getResource(), false));
        }
        if (src.hasSearch()) {
            tgt.setSearch(VersionConvertor_30_40.convertBundleEntrySearchComponent(src.getSearch()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(VersionConvertor_30_40.convertBundleEntryRequestComponent(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_30_40.convertBundleEntryResponseComponent(src.getResponse()));
        }
        return tgt;
    }

    public static Bundle.BundleEntrySearchComponent convertBundleEntrySearchComponent(Bundle.BundleEntrySearchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleEntrySearchComponent tgt = new Bundle.BundleEntrySearchComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertSearchEntryMode(src.getMode()));
        }
        if (src.hasScore()) {
            tgt.setScore(src.getScore());
        }
        return tgt;
    }

    public static Bundle.BundleEntrySearchComponent convertBundleEntrySearchComponent(Bundle.BundleEntrySearchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleEntrySearchComponent tgt = new Bundle.BundleEntrySearchComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertSearchEntryMode(src.getMode()));
        }
        if (src.hasScore()) {
            tgt.setScore(src.getScore());
        }
        return tgt;
    }

    private static Bundle.SearchEntryMode convertSearchEntryMode(Bundle.SearchEntryMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MATCH: {
                return Bundle.SearchEntryMode.MATCH;
            }
            case INCLUDE: {
                return Bundle.SearchEntryMode.INCLUDE;
            }
            case OUTCOME: {
                return Bundle.SearchEntryMode.OUTCOME;
            }
        }
        return Bundle.SearchEntryMode.NULL;
    }

    private static Bundle.SearchEntryMode convertSearchEntryMode(Bundle.SearchEntryMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MATCH: {
                return Bundle.SearchEntryMode.MATCH;
            }
            case INCLUDE: {
                return Bundle.SearchEntryMode.INCLUDE;
            }
            case OUTCOME: {
                return Bundle.SearchEntryMode.OUTCOME;
            }
        }
        return Bundle.SearchEntryMode.NULL;
    }

    public static Bundle.BundleEntryRequestComponent convertBundleEntryRequestComponent(Bundle.BundleEntryRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleEntryRequestComponent tgt = new Bundle.BundleEntryRequestComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertHTTPVerb(src.getMethod()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIfNoneMatch()) {
            tgt.setIfNoneMatch(src.getIfNoneMatch());
        }
        if (src.hasIfModifiedSince()) {
            tgt.setIfModifiedSince(src.getIfModifiedSince());
        }
        if (src.hasIfMatch()) {
            tgt.setIfMatch(src.getIfMatch());
        }
        if (src.hasIfNoneExist()) {
            tgt.setIfNoneExist(src.getIfNoneExist());
        }
        return tgt;
    }

    public static Bundle.BundleEntryRequestComponent convertBundleEntryRequestComponent(Bundle.BundleEntryRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleEntryRequestComponent tgt = new Bundle.BundleEntryRequestComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertHTTPVerb(src.getMethod()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIfNoneMatch()) {
            tgt.setIfNoneMatch(src.getIfNoneMatch());
        }
        if (src.hasIfModifiedSince()) {
            tgt.setIfModifiedSince(src.getIfModifiedSince());
        }
        if (src.hasIfMatch()) {
            tgt.setIfMatch(src.getIfMatch());
        }
        if (src.hasIfNoneExist()) {
            tgt.setIfNoneExist(src.getIfNoneExist());
        }
        return tgt;
    }

    private static Bundle.HTTPVerb convertHTTPVerb(Bundle.HTTPVerb src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GET: {
                return Bundle.HTTPVerb.GET;
            }
            case POST: {
                return Bundle.HTTPVerb.POST;
            }
            case PUT: {
                return Bundle.HTTPVerb.PUT;
            }
            case DELETE: {
                return Bundle.HTTPVerb.DELETE;
            }
        }
        return Bundle.HTTPVerb.NULL;
    }

    private static Bundle.HTTPVerb convertHTTPVerb(Bundle.HTTPVerb src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GET: {
                return Bundle.HTTPVerb.GET;
            }
            case POST: {
                return Bundle.HTTPVerb.POST;
            }
            case PUT: {
                return Bundle.HTTPVerb.PUT;
            }
            case DELETE: {
                return Bundle.HTTPVerb.DELETE;
            }
        }
        return Bundle.HTTPVerb.NULL;
    }

    public static Bundle.BundleEntryResponseComponent convertBundleEntryResponseComponent(Bundle.BundleEntryResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleEntryResponseComponent tgt = new Bundle.BundleEntryResponseComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(src.getStatus());
        }
        if (src.hasLocation()) {
            tgt.setLocation(src.getLocation());
        }
        if (src.hasEtag()) {
            tgt.setEtag(src.getEtag());
        }
        if (src.hasLastModified()) {
            tgt.setLastModified(src.getLastModified());
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertResource(src.getOutcome(), false));
        }
        return tgt;
    }

    public static Bundle.BundleEntryResponseComponent convertBundleEntryResponseComponent(Bundle.BundleEntryResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Bundle.BundleEntryResponseComponent tgt = new Bundle.BundleEntryResponseComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(src.getStatus());
        }
        if (src.hasLocation()) {
            tgt.setLocation(src.getLocation());
        }
        if (src.hasEtag()) {
            tgt.setEtag(src.getEtag());
        }
        if (src.hasLastModified()) {
            tgt.setLastModified(src.getLastModified());
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertResource(src.getOutcome(), false));
        }
        return tgt;
    }

    public static CapabilityStatement convertCapabilityStatement(org.hl7.fhir.dstu3.model.CapabilityStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement tgt = new CapabilityStatement();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertCapabilityStatementKind(src.getKind()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getInstantiates()) {
            tgt.addInstantiates((String)t.getValue());
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(VersionConvertor_30_40.convertCapabilityStatementSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(VersionConvertor_30_40.convertCapabilityStatementImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode((String)src.getFhirVersion()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getFormat()) {
            tgt.addFormat((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getPatchFormat()) {
            tgt.addPatchFormat((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getImplementationGuide()) {
            tgt.addImplementationGuide((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getRest()) {
            tgt.addRest(VersionConvertor_30_40.convertCapabilityStatementRestComponent((CapabilityStatement.CapabilityStatementRestComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getMessaging()) {
            tgt.addMessaging(VersionConvertor_30_40.convertCapabilityStatementMessagingComponent((CapabilityStatement.CapabilityStatementMessagingComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getDocument()) {
            tgt.addDocument(VersionConvertor_30_40.convertCapabilityStatementDocumentComponent((CapabilityStatement.CapabilityStatementDocumentComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.CapabilityStatement convertCapabilityStatement(CapabilityStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CapabilityStatement tgt = new org.hl7.fhir.dstu3.model.CapabilityStatement();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertCapabilityStatementKind(src.getKind()));
        }
        for (ContactDetail t : src.getInstantiates()) {
            tgt.addInstantiates((String)t.getValue());
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(VersionConvertor_30_40.convertCapabilityStatementSoftwareComponent(src.getSoftware()));
        }
        if (src.hasImplementation()) {
            tgt.setImplementation(VersionConvertor_30_40.convertCapabilityStatementImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion().toCode());
        }
        for (ContactDetail t : src.getFormat()) {
            tgt.addFormat((String)t.getValue());
        }
        for (ContactDetail t : src.getPatchFormat()) {
            tgt.addPatchFormat((String)t.getValue());
        }
        for (ContactDetail t : src.getImplementationGuide()) {
            tgt.addImplementationGuide((String)t.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestComponent r : src.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent rr : r.getResource()) {
                for (CanonicalType t : rr.getSupportedProfile()) {
                    tgt.addProfile(VersionConvertor_30_40.convertCanonicalToReference(t));
                }
            }
        }
        for (ContactDetail t : src.getRest()) {
            tgt.addRest(VersionConvertor_30_40.convertCapabilityStatementRestComponent((CapabilityStatement.CapabilityStatementRestComponent)t));
        }
        for (ContactDetail t : src.getMessaging()) {
            tgt.addMessaging(VersionConvertor_30_40.convertCapabilityStatementMessagingComponent((CapabilityStatement.CapabilityStatementMessagingComponent)t));
        }
        for (ContactDetail t : src.getDocument()) {
            tgt.addDocument(VersionConvertor_30_40.convertCapabilityStatementDocumentComponent((CapabilityStatement.CapabilityStatementDocumentComponent)t));
        }
        return tgt;
    }

    private static CapabilityStatement.CapabilityStatementKind convertCapabilityStatementKind(CapabilityStatement.CapabilityStatementKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return CapabilityStatement.CapabilityStatementKind.INSTANCE;
            }
            case CAPABILITY: {
                return CapabilityStatement.CapabilityStatementKind.CAPABILITY;
            }
            case REQUIREMENTS: {
                return CapabilityStatement.CapabilityStatementKind.REQUIREMENTS;
            }
        }
        return CapabilityStatement.CapabilityStatementKind.NULL;
    }

    private static CapabilityStatement.CapabilityStatementKind convertCapabilityStatementKind(CapabilityStatement.CapabilityStatementKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return CapabilityStatement.CapabilityStatementKind.INSTANCE;
            }
            case CAPABILITY: {
                return CapabilityStatement.CapabilityStatementKind.CAPABILITY;
            }
            case REQUIREMENTS: {
                return CapabilityStatement.CapabilityStatementKind.REQUIREMENTS;
            }
        }
        return CapabilityStatement.CapabilityStatementKind.NULL;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertCapabilityStatementSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDate(src.getReleaseDate());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementSoftwareComponent convertCapabilityStatementSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasReleaseDate()) {
            tgt.setReleaseDate(src.getReleaseDate());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertCapabilityStatementImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementImplementationComponent convertCapabilityStatementImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertCapabilityStatementRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertRestfulCapabilityMode(src.getMode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(VersionConvertor_30_40.convertCapabilityStatementRestSecurityComponent(src.getSecurity()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getResource()) {
            tgt.addResource(VersionConvertor_30_40.convertCapabilityStatementRestResourceComponent(t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getInteraction()) {
            tgt.addInteraction(VersionConvertor_30_40.convertSystemInteractionComponent((CapabilityStatement.SystemInteractionComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getSearchParam()) {
            tgt.addSearchParam(VersionConvertor_30_40.convertCapabilityStatementRestResourceSearchParamComponent((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getOperation()) {
            tgt.addOperation(VersionConvertor_30_40.convertCapabilityStatementRestOperationComponent((CapabilityStatement.CapabilityStatementRestOperationComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getCompartment()) {
            tgt.addCompartment((String)t.getValue());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestComponent convertCapabilityStatementRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertRestfulCapabilityMode(src.getMode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasSecurity()) {
            tgt.setSecurity(VersionConvertor_30_40.convertCapabilityStatementRestSecurityComponent(src.getSecurity()));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getResource()) {
            tgt.addResource(VersionConvertor_30_40.convertCapabilityStatementRestResourceComponent(t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getInteraction()) {
            tgt.addInteraction(VersionConvertor_30_40.convertSystemInteractionComponent((CapabilityStatement.SystemInteractionComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getSearchParam()) {
            tgt.addSearchParam(VersionConvertor_30_40.convertCapabilityStatementRestResourceSearchParamComponent((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getOperation()) {
            tgt.addOperation(VersionConvertor_30_40.convertCapabilityStatementRestOperationComponent((CapabilityStatement.CapabilityStatementRestResourceOperationComponent)t));
        }
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getCompartment()) {
            tgt.addCompartment((String)t.getValue());
        }
        return tgt;
    }

    private static CapabilityStatement.RestfulCapabilityMode convertRestfulCapabilityMode(CapabilityStatement.RestfulCapabilityMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLIENT: {
                return CapabilityStatement.RestfulCapabilityMode.CLIENT;
            }
            case SERVER: {
                return CapabilityStatement.RestfulCapabilityMode.SERVER;
            }
        }
        return CapabilityStatement.RestfulCapabilityMode.NULL;
    }

    private static CapabilityStatement.RestfulCapabilityMode convertRestfulCapabilityMode(CapabilityStatement.RestfulCapabilityMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLIENT: {
                return CapabilityStatement.RestfulCapabilityMode.CLIENT;
            }
            case SERVER: {
                return CapabilityStatement.RestfulCapabilityMode.SERVER;
            }
        }
        return CapabilityStatement.RestfulCapabilityMode.NULL;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertCapabilityStatementRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCors()) {
            tgt.setCors(src.getCors());
        }
        for (CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestSecurityComponent convertCapabilityStatementRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCors()) {
            tgt.setCors(src.getCors());
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getService()) {
            tgt.addService(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertCapabilityStatementRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getProfile()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getInteraction()) {
            tgt.addInteraction(VersionConvertor_30_40.convertResourceInteractionComponent(t));
        }
        if (src.hasVersioning()) {
            tgt.setVersioning(VersionConvertor_30_40.convertResourceVersionPolicy(src.getVersioning()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistory(src.getReadHistory());
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreate(src.getUpdateCreate());
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreate(src.getConditionalCreate());
        }
        if (src.hasConditionalRead()) {
            tgt.setConditionalRead(VersionConvertor_30_40.convertConditionalReadStatus(src.getConditionalRead()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdate(src.getConditionalUpdate());
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDelete(VersionConvertor_30_40.convertConditionalDeleteStatus(src.getConditionalDelete()));
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getReferencePolicy()) {
            tgt.addReferencePolicy(VersionConvertor_30_40.convertReferenceHandlingPolicy((CapabilityStatement.ReferenceHandlingPolicy)t.getValue()));
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchInclude()) {
            tgt.addSearchInclude((String)t.getValue());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)t.getValue());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(VersionConvertor_30_40.convertCapabilityStatementRestResourceSearchParamComponent((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t));
        }
        return tgt;
    }

    private static CanonicalType convertReferenceToCanonical(Reference src) throws FHIRException {
        CanonicalType dst = new CanonicalType(src.getReference());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)dst);
        return dst;
    }

    private static Reference convertCanonicalToReference(CanonicalType src) throws FHIRException {
        Reference dst = new Reference((String)src.getValue());
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)dst);
        return dst;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceComponent convertCapabilityStatementRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCanonicalToReference(src.getProfileElement()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getInteraction()) {
            tgt.addInteraction(VersionConvertor_30_40.convertResourceInteractionComponent(t));
        }
        if (src.hasVersioning()) {
            tgt.setVersioning(VersionConvertor_30_40.convertResourceVersionPolicy(src.getVersioning()));
        }
        if (src.hasReadHistory()) {
            tgt.setReadHistory(src.getReadHistory());
        }
        if (src.hasUpdateCreate()) {
            tgt.setUpdateCreate(src.getUpdateCreate());
        }
        if (src.hasConditionalCreate()) {
            tgt.setConditionalCreate(src.getConditionalCreate());
        }
        if (src.hasConditionalRead()) {
            tgt.setConditionalRead(VersionConvertor_30_40.convertConditionalReadStatus(src.getConditionalRead()));
        }
        if (src.hasConditionalUpdate()) {
            tgt.setConditionalUpdate(src.getConditionalUpdate());
        }
        if (src.hasConditionalDelete()) {
            tgt.setConditionalDelete(VersionConvertor_30_40.convertConditionalDeleteStatus(src.getConditionalDelete()));
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getReferencePolicy()) {
            tgt.addReferencePolicy(VersionConvertor_30_40.convertReferenceHandlingPolicy((CapabilityStatement.ReferenceHandlingPolicy)t.getValue()));
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchInclude()) {
            tgt.addSearchInclude((String)t.getValue());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)t.getValue());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(VersionConvertor_30_40.convertCapabilityStatementRestResourceSearchParamComponent((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t));
        }
        return tgt;
    }

    private static CapabilityStatement.ResourceVersionPolicy convertResourceVersionPolicy(CapabilityStatement.ResourceVersionPolicy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOVERSION: {
                return CapabilityStatement.ResourceVersionPolicy.NOVERSION;
            }
            case VERSIONED: {
                return CapabilityStatement.ResourceVersionPolicy.VERSIONED;
            }
            case VERSIONEDUPDATE: {
                return CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE;
            }
        }
        return CapabilityStatement.ResourceVersionPolicy.NULL;
    }

    private static CapabilityStatement.ResourceVersionPolicy convertResourceVersionPolicy(CapabilityStatement.ResourceVersionPolicy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOVERSION: {
                return CapabilityStatement.ResourceVersionPolicy.NOVERSION;
            }
            case VERSIONED: {
                return CapabilityStatement.ResourceVersionPolicy.VERSIONED;
            }
            case VERSIONEDUPDATE: {
                return CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE;
            }
        }
        return CapabilityStatement.ResourceVersionPolicy.NULL;
    }

    private static CapabilityStatement.ConditionalReadStatus convertConditionalReadStatus(CapabilityStatement.ConditionalReadStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSUPPORTED: {
                return CapabilityStatement.ConditionalReadStatus.NOTSUPPORTED;
            }
            case MODIFIEDSINCE: {
                return CapabilityStatement.ConditionalReadStatus.MODIFIEDSINCE;
            }
            case NOTMATCH: {
                return CapabilityStatement.ConditionalReadStatus.NOTMATCH;
            }
            case FULLSUPPORT: {
                return CapabilityStatement.ConditionalReadStatus.FULLSUPPORT;
            }
        }
        return CapabilityStatement.ConditionalReadStatus.NULL;
    }

    private static CapabilityStatement.ConditionalReadStatus convertConditionalReadStatus(CapabilityStatement.ConditionalReadStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSUPPORTED: {
                return CapabilityStatement.ConditionalReadStatus.NOTSUPPORTED;
            }
            case MODIFIEDSINCE: {
                return CapabilityStatement.ConditionalReadStatus.MODIFIEDSINCE;
            }
            case NOTMATCH: {
                return CapabilityStatement.ConditionalReadStatus.NOTMATCH;
            }
            case FULLSUPPORT: {
                return CapabilityStatement.ConditionalReadStatus.FULLSUPPORT;
            }
        }
        return CapabilityStatement.ConditionalReadStatus.NULL;
    }

    private static CapabilityStatement.ConditionalDeleteStatus convertConditionalDeleteStatus(CapabilityStatement.ConditionalDeleteStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSUPPORTED: {
                return CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED;
            }
            case SINGLE: {
                return CapabilityStatement.ConditionalDeleteStatus.SINGLE;
            }
            case MULTIPLE: {
                return CapabilityStatement.ConditionalDeleteStatus.MULTIPLE;
            }
        }
        return CapabilityStatement.ConditionalDeleteStatus.NULL;
    }

    private static CapabilityStatement.ConditionalDeleteStatus convertConditionalDeleteStatus(CapabilityStatement.ConditionalDeleteStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSUPPORTED: {
                return CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED;
            }
            case SINGLE: {
                return CapabilityStatement.ConditionalDeleteStatus.SINGLE;
            }
            case MULTIPLE: {
                return CapabilityStatement.ConditionalDeleteStatus.MULTIPLE;
            }
        }
        return CapabilityStatement.ConditionalDeleteStatus.NULL;
    }

    private static CapabilityStatement.ReferenceHandlingPolicy convertReferenceHandlingPolicy(CapabilityStatement.ReferenceHandlingPolicy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LITERAL: {
                return CapabilityStatement.ReferenceHandlingPolicy.LITERAL;
            }
            case LOGICAL: {
                return CapabilityStatement.ReferenceHandlingPolicy.LOGICAL;
            }
            case RESOLVES: {
                return CapabilityStatement.ReferenceHandlingPolicy.RESOLVES;
            }
            case ENFORCED: {
                return CapabilityStatement.ReferenceHandlingPolicy.ENFORCED;
            }
            case LOCAL: {
                return CapabilityStatement.ReferenceHandlingPolicy.LOCAL;
            }
        }
        return CapabilityStatement.ReferenceHandlingPolicy.NULL;
    }

    private static CapabilityStatement.ReferenceHandlingPolicy convertReferenceHandlingPolicy(CapabilityStatement.ReferenceHandlingPolicy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LITERAL: {
                return CapabilityStatement.ReferenceHandlingPolicy.LITERAL;
            }
            case LOGICAL: {
                return CapabilityStatement.ReferenceHandlingPolicy.LOGICAL;
            }
            case RESOLVES: {
                return CapabilityStatement.ReferenceHandlingPolicy.RESOLVES;
            }
            case ENFORCED: {
                return CapabilityStatement.ReferenceHandlingPolicy.ENFORCED;
            }
            case LOCAL: {
                return CapabilityStatement.ReferenceHandlingPolicy.LOCAL;
            }
        }
        return CapabilityStatement.ReferenceHandlingPolicy.NULL;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertTypeRestfulInteraction(src.getCode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertTypeRestfulInteraction(src.getCode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    private static CapabilityStatement.TypeRestfulInteraction convertTypeRestfulInteraction(CapabilityStatement.TypeRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case READ: {
                return CapabilityStatement.TypeRestfulInteraction.READ;
            }
            case VREAD: {
                return CapabilityStatement.TypeRestfulInteraction.VREAD;
            }
            case UPDATE: {
                return CapabilityStatement.TypeRestfulInteraction.UPDATE;
            }
            case PATCH: {
                return CapabilityStatement.TypeRestfulInteraction.PATCH;
            }
            case DELETE: {
                return CapabilityStatement.TypeRestfulInteraction.DELETE;
            }
            case HISTORYINSTANCE: {
                return CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE;
            }
            case HISTORYTYPE: {
                return CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE;
            }
            case CREATE: {
                return CapabilityStatement.TypeRestfulInteraction.CREATE;
            }
            case SEARCHTYPE: {
                return CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE;
            }
        }
        return CapabilityStatement.TypeRestfulInteraction.NULL;
    }

    private static CapabilityStatement.TypeRestfulInteraction convertTypeRestfulInteraction(CapabilityStatement.TypeRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case READ: {
                return CapabilityStatement.TypeRestfulInteraction.READ;
            }
            case VREAD: {
                return CapabilityStatement.TypeRestfulInteraction.VREAD;
            }
            case UPDATE: {
                return CapabilityStatement.TypeRestfulInteraction.UPDATE;
            }
            case PATCH: {
                return CapabilityStatement.TypeRestfulInteraction.PATCH;
            }
            case DELETE: {
                return CapabilityStatement.TypeRestfulInteraction.DELETE;
            }
            case HISTORYINSTANCE: {
                return CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE;
            }
            case HISTORYTYPE: {
                return CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE;
            }
            case CREATE: {
                return CapabilityStatement.TypeRestfulInteraction.CREATE;
            }
            case SEARCHTYPE: {
                return CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE;
            }
        }
        return CapabilityStatement.TypeRestfulInteraction.NULL;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertCapabilityStatementRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertSearchParamType(src.getType()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertCapabilityStatementRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertSearchParamType(src.getType()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    private static Enumerations.SearchParamType convertSearchParamType(Enumerations.SearchParamType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NUMBER: {
                return Enumerations.SearchParamType.NUMBER;
            }
            case DATE: {
                return Enumerations.SearchParamType.DATE;
            }
            case STRING: {
                return Enumerations.SearchParamType.STRING;
            }
            case TOKEN: {
                return Enumerations.SearchParamType.TOKEN;
            }
            case REFERENCE: {
                return Enumerations.SearchParamType.REFERENCE;
            }
            case COMPOSITE: {
                return Enumerations.SearchParamType.COMPOSITE;
            }
            case QUANTITY: {
                return Enumerations.SearchParamType.QUANTITY;
            }
            case URI: {
                return Enumerations.SearchParamType.URI;
            }
        }
        return Enumerations.SearchParamType.NULL;
    }

    private static Enumerations.SearchParamType convertSearchParamType(Enumerations.SearchParamType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NUMBER: {
                return Enumerations.SearchParamType.NUMBER;
            }
            case DATE: {
                return Enumerations.SearchParamType.DATE;
            }
            case STRING: {
                return Enumerations.SearchParamType.STRING;
            }
            case TOKEN: {
                return Enumerations.SearchParamType.TOKEN;
            }
            case REFERENCE: {
                return Enumerations.SearchParamType.REFERENCE;
            }
            case COMPOSITE: {
                return Enumerations.SearchParamType.COMPOSITE;
            }
            case QUANTITY: {
                return Enumerations.SearchParamType.QUANTITY;
            }
            case URI: {
                return Enumerations.SearchParamType.URI;
            }
        }
        return Enumerations.SearchParamType.NULL;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertSystemRestfulInteraction(src.getCode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertSystemRestfulInteraction(src.getCode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    private static CapabilityStatement.SystemRestfulInteraction convertSystemRestfulInteraction(CapabilityStatement.SystemRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case TRANSACTION: {
                return CapabilityStatement.SystemRestfulInteraction.TRANSACTION;
            }
            case BATCH: {
                return CapabilityStatement.SystemRestfulInteraction.BATCH;
            }
            case SEARCHSYSTEM: {
                return CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM;
            }
            case HISTORYSYSTEM: {
                return CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM;
            }
        }
        return CapabilityStatement.SystemRestfulInteraction.NULL;
    }

    private static CapabilityStatement.SystemRestfulInteraction convertSystemRestfulInteraction(CapabilityStatement.SystemRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case TRANSACTION: {
                return CapabilityStatement.SystemRestfulInteraction.TRANSACTION;
            }
            case BATCH: {
                return CapabilityStatement.SystemRestfulInteraction.BATCH;
            }
            case SEARCHSYSTEM: {
                return CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM;
            }
            case HISTORYSYSTEM: {
                return CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM;
            }
        }
        return CapabilityStatement.SystemRestfulInteraction.NULL;
    }

    public static CapabilityStatement.CapabilityStatementRestResourceOperationComponent convertCapabilityStatementRestOperationComponent(CapabilityStatement.CapabilityStatementRestOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getDefinition()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementRestOperationComponent convertCapabilityStatementRestOperationComponent(CapabilityStatement.CapabilityStatementRestResourceOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestOperationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_30_40.convertCanonicalToReference(src.getDefinitionElement()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertCapabilityStatementMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertCapabilityStatementMessagingEndpointComponent(t));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCache(src.getReliableCache());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent t : src.getSupportedMessage()) {
            tgt.addSupportedMessage(VersionConvertor_30_40.convertCapabilityStatementMessagingSupportedMessageComponent((CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent)t));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingComponent convertCapabilityStatementMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertCapabilityStatementMessagingEndpointComponent(t));
        }
        if (src.hasReliableCache()) {
            tgt.setReliableCache(src.getReliableCache());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent t : src.getSupportedMessage()) {
            tgt.addSupportedMessage(VersionConvertor_30_40.convertCapabilityStatementMessagingSupportedMessageComponent((CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent)t));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertCapabilityStatementMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasProtocol()) {
            tgt.setProtocol(VersionConvertor_30_40.convertCoding(src.getProtocol()));
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertCapabilityStatementMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasProtocol()) {
            tgt.setProtocol(VersionConvertor_30_40.convertCoding(src.getProtocol()));
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent convertCapabilityStatementMessagingSupportedMessageComponent(CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent tgt = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertEventCapabilityMode(src.getMode()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getDefinition()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent convertCapabilityStatementMessagingSupportedMessageComponent(CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent tgt = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertEventCapabilityMode(src.getMode()));
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_30_40.convertCanonicalToReference(src.getDefinitionElement()));
        }
        return tgt;
    }

    private static CapabilityStatement.EventCapabilityMode convertEventCapabilityMode(CapabilityStatement.EventCapabilityMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SENDER: {
                return CapabilityStatement.EventCapabilityMode.SENDER;
            }
            case RECEIVER: {
                return CapabilityStatement.EventCapabilityMode.RECEIVER;
            }
        }
        return CapabilityStatement.EventCapabilityMode.NULL;
    }

    private static CapabilityStatement.EventCapabilityMode convertEventCapabilityMode(CapabilityStatement.EventCapabilityMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SENDER: {
                return CapabilityStatement.EventCapabilityMode.SENDER;
            }
            case RECEIVER: {
                return CapabilityStatement.EventCapabilityMode.RECEIVER;
            }
        }
        return CapabilityStatement.EventCapabilityMode.NULL;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertCapabilityStatementDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertDocumentMode(src.getMode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getProfile()));
        }
        return tgt;
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent convertCapabilityStatementDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertDocumentMode(src.getMode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCanonicalToReference(src.getProfileElement()));
        }
        return tgt;
    }

    private static CapabilityStatement.DocumentMode convertDocumentMode(CapabilityStatement.DocumentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRODUCER: {
                return CapabilityStatement.DocumentMode.PRODUCER;
            }
            case CONSUMER: {
                return CapabilityStatement.DocumentMode.CONSUMER;
            }
        }
        return CapabilityStatement.DocumentMode.NULL;
    }

    private static CapabilityStatement.DocumentMode convertDocumentMode(CapabilityStatement.DocumentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRODUCER: {
                return CapabilityStatement.DocumentMode.PRODUCER;
            }
            case CONSUMER: {
                return CapabilityStatement.DocumentMode.CONSUMER;
            }
        }
        return CapabilityStatement.DocumentMode.NULL;
    }

    public static CareTeam convertCareTeam(org.hl7.fhir.dstu3.model.CareTeam src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam tgt = new CareTeam();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertCareTeamStatus(src.getStatus()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertCareTeamParticipantComponent((CareTeam.CareTeamParticipantComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getManagingOrganization()) {
            tgt.addManagingOrganization(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.CareTeam convertCareTeam(CareTeam src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CareTeam tgt = new org.hl7.fhir.dstu3.model.CareTeam();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertCareTeamStatus(src.getStatus()));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (Identifier t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertCareTeamParticipantComponent((CareTeam.CareTeamParticipantComponent)t));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getManagingOrganization()) {
            tgt.addManagingOrganization(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        return tgt;
    }

    private static CareTeam.CareTeamStatus convertCareTeamStatus(CareTeam.CareTeamStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return CareTeam.CareTeamStatus.PROPOSED;
            }
            case ACTIVE: {
                return CareTeam.CareTeamStatus.ACTIVE;
            }
            case SUSPENDED: {
                return CareTeam.CareTeamStatus.SUSPENDED;
            }
            case INACTIVE: {
                return CareTeam.CareTeamStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return CareTeam.CareTeamStatus.ENTEREDINERROR;
            }
        }
        return CareTeam.CareTeamStatus.NULL;
    }

    private static CareTeam.CareTeamStatus convertCareTeamStatus(CareTeam.CareTeamStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return CareTeam.CareTeamStatus.PROPOSED;
            }
            case ACTIVE: {
                return CareTeam.CareTeamStatus.ACTIVE;
            }
            case SUSPENDED: {
                return CareTeam.CareTeamStatus.SUSPENDED;
            }
            case INACTIVE: {
                return CareTeam.CareTeamStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return CareTeam.CareTeamStatus.ENTEREDINERROR;
            }
        }
        return CareTeam.CareTeamStatus.NULL;
    }

    public static CareTeam.CareTeamParticipantComponent convertCareTeamParticipantComponent(CareTeam.CareTeamParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam.CareTeamParticipantComponent tgt = new CareTeam.CareTeamParticipantComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasRole()) {
            tgt.addRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasMember()) {
            tgt.setMember(VersionConvertor_30_40.convertReference(src.getMember()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_40.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static CareTeam.CareTeamParticipantComponent convertCareTeamParticipantComponent(CareTeam.CareTeamParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam.CareTeamParticipantComponent tgt = new CareTeam.CareTeamParticipantComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRoleFirstRep()));
        }
        if (src.hasMember()) {
            tgt.setMember(VersionConvertor_30_40.convertReference(src.getMember()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_40.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static ClinicalImpression convertClinicalImpression(org.hl7.fhir.dstu3.model.ClinicalImpression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression tgt = new ClinicalImpression();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertClinicalImpressionStatus(src.getStatus()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasAssessor()) {
            tgt.setAssessor(VersionConvertor_30_40.convertReference(src.getAssessor()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(VersionConvertor_30_40.convertReference(src.getPrevious()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getProblem()) {
            tgt.addProblem(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getInvestigation()) {
            tgt.addInvestigation(VersionConvertor_30_40.convertClinicalImpressionInvestigationComponent((ClinicalImpression.ClinicalImpressionInvestigationComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getProtocol()) {
            tgt.addProtocol((String)t.getValue());
        }
        if (src.hasSummary()) {
            tgt.setSummary(src.getSummary());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getFinding()) {
            tgt.addFinding(VersionConvertor_30_40.convertClinicalImpressionFindingComponent((ClinicalImpression.ClinicalImpressionFindingComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPrognosisCodeableConcept()) {
            tgt.addPrognosisCodeableConcept(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPrognosisReference()) {
            tgt.addPrognosisReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ClinicalImpression convertClinicalImpression(ClinicalImpression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ClinicalImpression tgt = new org.hl7.fhir.dstu3.model.ClinicalImpression();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertClinicalImpressionStatus(src.getStatus()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasAssessor()) {
            tgt.setAssessor(VersionConvertor_30_40.convertReference(src.getAssessor()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(VersionConvertor_30_40.convertReference(src.getPrevious()));
        }
        for (Identifier t : src.getProblem()) {
            tgt.addProblem(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getInvestigation()) {
            tgt.addInvestigation(VersionConvertor_30_40.convertClinicalImpressionInvestigationComponent((ClinicalImpression.ClinicalImpressionInvestigationComponent)t));
        }
        for (Identifier t : src.getProtocol()) {
            tgt.addProtocol((String)t.getValue());
        }
        if (src.hasSummary()) {
            tgt.setSummary(src.getSummary());
        }
        for (Identifier t : src.getFinding()) {
            tgt.addFinding(VersionConvertor_30_40.convertClinicalImpressionFindingComponent((ClinicalImpression.ClinicalImpressionFindingComponent)t));
        }
        for (Identifier t : src.getPrognosisCodeableConcept()) {
            tgt.addPrognosisCodeableConcept(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getPrognosisReference()) {
            tgt.addPrognosisReference(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        return tgt;
    }

    private static ClinicalImpression.ClinicalImpressionStatus convertClinicalImpressionStatus(ClinicalImpression.ClinicalImpressionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return ClinicalImpression.ClinicalImpressionStatus.INPROGRESS;
            }
            case COMPLETED: {
                return ClinicalImpression.ClinicalImpressionStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return ClinicalImpression.ClinicalImpressionStatus.ENTEREDINERROR;
            }
        }
        return ClinicalImpression.ClinicalImpressionStatus.NULL;
    }

    private static ClinicalImpression.ClinicalImpressionStatus convertClinicalImpressionStatus(ClinicalImpression.ClinicalImpressionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return ClinicalImpression.ClinicalImpressionStatus.DRAFT;
            }
            case COMPLETED: {
                return ClinicalImpression.ClinicalImpressionStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return ClinicalImpression.ClinicalImpressionStatus.ENTEREDINERROR;
            }
        }
        return ClinicalImpression.ClinicalImpressionStatus.NULL;
    }

    public static ClinicalImpression.ClinicalImpressionInvestigationComponent convertClinicalImpressionInvestigationComponent(ClinicalImpression.ClinicalImpressionInvestigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionInvestigationComponent tgt = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (Reference t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionInvestigationComponent convertClinicalImpressionInvestigationComponent(ClinicalImpression.ClinicalImpressionInvestigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionInvestigationComponent tgt = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasItemCodeableConcept()) {
            tgt.setItemCodeableConcept(VersionConvertor_30_40.convertCodeableConcept(src.getItemCodeableConcept()));
        }
        if (src.hasItemReference()) {
            tgt.setItemReference(VersionConvertor_30_40.convertReference(src.getItemReference()));
        }
        if (src.hasBasis()) {
            tgt.setBasis(src.getBasis());
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasItemCodeableConcept()) {
            tgt.setItem(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getItemCodeableConcept()));
        } else if (src.hasItemReference()) {
            tgt.setItem(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getItemReference()));
        }
        if (src.hasBasis()) {
            tgt.setBasis(src.getBasis());
        }
        return tgt;
    }

    public static CodeSystem convertCodeSystem(org.hl7.fhir.dstu3.model.CodeSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem tgt = new CodeSystem();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitive(src.getCaseSensitive());
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(src.getValueSet());
        }
        if (src.hasHierarchyMeaning()) {
            tgt.setHierarchyMeaning(VersionConvertor_30_40.convertCodeSystemHierarchyMeaning(src.getHierarchyMeaning()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositional(src.getCompositional());
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeeded(src.getVersionNeeded());
        }
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_30_40.convertCodeSystemContentMode(src.getContent()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getFilter()) {
            tgt.addFilter(VersionConvertor_30_40.convertCodeSystemFilterComponent((CodeSystem.CodeSystemFilterComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getProperty()) {
            tgt.addProperty(VersionConvertor_30_40.convertPropertyComponent((CodeSystem.PropertyComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_30_40.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.CodeSystem convertCodeSystem(CodeSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CodeSystem tgt = new org.hl7.fhir.dstu3.model.CodeSystem();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasCaseSensitive()) {
            tgt.setCaseSensitive(src.getCaseSensitive());
        }
        if (src.hasValueSet()) {
            tgt.setValueSet(src.getValueSet());
        }
        if (src.hasHierarchyMeaning()) {
            tgt.setHierarchyMeaning(VersionConvertor_30_40.convertCodeSystemHierarchyMeaning(src.getHierarchyMeaning()));
        }
        if (src.hasCompositional()) {
            tgt.setCompositional(src.getCompositional());
        }
        if (src.hasVersionNeeded()) {
            tgt.setVersionNeeded(src.getVersionNeeded());
        }
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_30_40.convertCodeSystemContentMode(src.getContent()));
        }
        if (src.hasCount()) {
            tgt.setCount(src.getCount());
        }
        for (ContactDetail t : src.getFilter()) {
            tgt.addFilter(VersionConvertor_30_40.convertCodeSystemFilterComponent((CodeSystem.CodeSystemFilterComponent)t));
        }
        for (ContactDetail t : src.getProperty()) {
            tgt.addProperty(VersionConvertor_30_40.convertPropertyComponent((CodeSystem.PropertyComponent)t));
        }
        for (ContactDetail t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_30_40.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)t));
        }
        return tgt;
    }

    private static CodeSystem.CodeSystemHierarchyMeaning convertCodeSystemHierarchyMeaning(CodeSystem.CodeSystemHierarchyMeaning src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GROUPEDBY: {
                return CodeSystem.CodeSystemHierarchyMeaning.GROUPEDBY;
            }
            case ISA: {
                return CodeSystem.CodeSystemHierarchyMeaning.ISA;
            }
            case PARTOF: {
                return CodeSystem.CodeSystemHierarchyMeaning.PARTOF;
            }
            case CLASSIFIEDWITH: {
                return CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH;
            }
        }
        return CodeSystem.CodeSystemHierarchyMeaning.NULL;
    }

    private static CodeSystem.CodeSystemHierarchyMeaning convertCodeSystemHierarchyMeaning(CodeSystem.CodeSystemHierarchyMeaning src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GROUPEDBY: {
                return CodeSystem.CodeSystemHierarchyMeaning.GROUPEDBY;
            }
            case ISA: {
                return CodeSystem.CodeSystemHierarchyMeaning.ISA;
            }
            case PARTOF: {
                return CodeSystem.CodeSystemHierarchyMeaning.PARTOF;
            }
            case CLASSIFIEDWITH: {
                return CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH;
            }
        }
        return CodeSystem.CodeSystemHierarchyMeaning.NULL;
    }

    private static CodeSystem.CodeSystemContentMode convertCodeSystemContentMode(CodeSystem.CodeSystemContentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTPRESENT: {
                return CodeSystem.CodeSystemContentMode.NOTPRESENT;
            }
            case EXAMPLE: {
                return CodeSystem.CodeSystemContentMode.EXAMPLE;
            }
            case FRAGMENT: {
                return CodeSystem.CodeSystemContentMode.FRAGMENT;
            }
            case COMPLETE: {
                return CodeSystem.CodeSystemContentMode.COMPLETE;
            }
        }
        return CodeSystem.CodeSystemContentMode.NULL;
    }

    private static CodeSystem.CodeSystemContentMode convertCodeSystemContentMode(CodeSystem.CodeSystemContentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTPRESENT: {
                return CodeSystem.CodeSystemContentMode.NOTPRESENT;
            }
            case EXAMPLE: {
                return CodeSystem.CodeSystemContentMode.EXAMPLE;
            }
            case FRAGMENT: {
                return CodeSystem.CodeSystemContentMode.FRAGMENT;
            }
            case COMPLETE: {
                return CodeSystem.CodeSystemContentMode.COMPLETE;
            }
        }
        return CodeSystem.CodeSystemContentMode.NULL;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getOperator()) {
            tgt.addOperator(VersionConvertor_30_40.convertFilterOperator((CodeSystem.FilterOperator)t.getValue()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static CodeSystem.CodeSystemFilterComponent convertCodeSystemFilterComponent(CodeSystem.CodeSystemFilterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.CodeSystemFilterComponent tgt = new CodeSystem.CodeSystemFilterComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Enumeration t : src.getOperator()) {
            tgt.addOperator(VersionConvertor_30_40.convertFilterOperator((CodeSystem.FilterOperator)t.getValue()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    private static CodeSystem.FilterOperator convertFilterOperator(CodeSystem.FilterOperator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUAL: {
                return CodeSystem.FilterOperator.EQUAL;
            }
            case ISA: {
                return CodeSystem.FilterOperator.ISA;
            }
            case DESCENDENTOF: {
                return CodeSystem.FilterOperator.DESCENDENTOF;
            }
            case ISNOTA: {
                return CodeSystem.FilterOperator.ISNOTA;
            }
            case REGEX: {
                return CodeSystem.FilterOperator.REGEX;
            }
            case IN: {
                return CodeSystem.FilterOperator.IN;
            }
            case NOTIN: {
                return CodeSystem.FilterOperator.NOTIN;
            }
            case GENERALIZES: {
                return CodeSystem.FilterOperator.GENERALIZES;
            }
            case EXISTS: {
                return CodeSystem.FilterOperator.EXISTS;
            }
        }
        return CodeSystem.FilterOperator.NULL;
    }

    private static CodeSystem.FilterOperator convertFilterOperator(CodeSystem.FilterOperator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUAL: {
                return CodeSystem.FilterOperator.EQUAL;
            }
            case ISA: {
                return CodeSystem.FilterOperator.ISA;
            }
            case DESCENDENTOF: {
                return CodeSystem.FilterOperator.DESCENDENTOF;
            }
            case ISNOTA: {
                return CodeSystem.FilterOperator.ISNOTA;
            }
            case REGEX: {
                return CodeSystem.FilterOperator.REGEX;
            }
            case IN: {
                return CodeSystem.FilterOperator.IN;
            }
            case NOTIN: {
                return CodeSystem.FilterOperator.NOTIN;
            }
            case GENERALIZES: {
                return CodeSystem.FilterOperator.GENERALIZES;
            }
            case EXISTS: {
                return CodeSystem.FilterOperator.EXISTS;
            }
        }
        return CodeSystem.FilterOperator.NULL;
    }

    public static CodeSystem.PropertyComponent convertPropertyComponent(CodeSystem.PropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.PropertyComponent tgt = new CodeSystem.PropertyComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertPropertyType(src.getType()));
        }
        return tgt;
    }

    public static CodeSystem.PropertyComponent convertPropertyComponent(CodeSystem.PropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.PropertyComponent tgt = new CodeSystem.PropertyComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertPropertyType(src.getType()));
        }
        return tgt;
    }

    private static CodeSystem.PropertyType convertPropertyType(CodeSystem.PropertyType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODE: {
                return CodeSystem.PropertyType.CODE;
            }
            case CODING: {
                return CodeSystem.PropertyType.CODING;
            }
            case STRING: {
                return CodeSystem.PropertyType.STRING;
            }
            case INTEGER: {
                return CodeSystem.PropertyType.INTEGER;
            }
            case BOOLEAN: {
                return CodeSystem.PropertyType.BOOLEAN;
            }
            case DATETIME: {
                return CodeSystem.PropertyType.DATETIME;
            }
        }
        return CodeSystem.PropertyType.NULL;
    }

    private static CodeSystem.PropertyType convertPropertyType(CodeSystem.PropertyType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODE: {
                return CodeSystem.PropertyType.CODE;
            }
            case CODING: {
                return CodeSystem.PropertyType.CODING;
            }
            case STRING: {
                return CodeSystem.PropertyType.STRING;
            }
            case INTEGER: {
                return CodeSystem.PropertyType.INTEGER;
            }
            case BOOLEAN: {
                return CodeSystem.PropertyType.BOOLEAN;
            }
            case DATETIME: {
                return CodeSystem.PropertyType.DATETIME;
            }
        }
        return CodeSystem.PropertyType.NULL;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(VersionConvertor_30_40.convertConceptDefinitionDesignationComponent(t));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getProperty()) {
            tgt.addProperty(VersionConvertor_30_40.convertConceptPropertyComponent((CodeSystem.ConceptPropertyComponent)t));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_30_40.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)t));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionComponent convertConceptDefinitionComponent(CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionComponent tgt = new CodeSystem.ConceptDefinitionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(VersionConvertor_30_40.convertConceptDefinitionDesignationComponent(t));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getProperty()) {
            tgt.addProperty(VersionConvertor_30_40.convertConceptPropertyComponent((CodeSystem.ConceptPropertyComponent)t));
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent t : src.getConcept()) {
            tgt.addConcept(VersionConvertor_30_40.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)t));
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static CodeSystem.ConceptDefinitionDesignationComponent convertConceptDefinitionDesignationComponent(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptDefinitionDesignationComponent tgt = new CodeSystem.ConceptDefinitionDesignationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertCoding(src.getUse()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        return tgt;
    }

    public static CodeSystem.ConceptPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptPropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptPropertyComponent tgt = new CodeSystem.ConceptPropertyComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static CodeSystem.ConceptPropertyComponent convertConceptPropertyComponent(CodeSystem.ConceptPropertyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeSystem.ConceptPropertyComponent tgt = new CodeSystem.ConceptPropertyComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Communication convertCommunication(org.hl7.fhir.dstu3.model.Communication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication tgt = new Communication();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDefinition()) {
            tgt.addInstantiatesCanonical(t.getReference());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasNotDone()) {
            tgt.setStatus(Communication.CommunicationStatus.NOTDONE);
        } else if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertCommunicationStatus(src.getStatus()));
        }
        if (src.hasNotDoneReason()) {
            tgt.setStatusReason(VersionConvertor_30_40.convertCodeableConcept(src.getNotDoneReason()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getMedium()) {
            tgt.addMedium(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasSent()) {
            tgt.setSent(src.getSent());
        }
        if (src.hasReceived()) {
            tgt.setReceived(src.getReceived());
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_30_40.convertReference(src.getSender()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPayload()) {
            tgt.addPayload(VersionConvertor_30_40.convertCommunicationPayloadComponent((Communication.CommunicationPayloadComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Communication convertCommunication(Communication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Communication tgt = new org.hl7.fhir.dstu3.model.Communication();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getInstantiatesCanonical()) {
            tgt.addDefinition(new Reference((String)t.getValue()));
        }
        for (Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasStatus()) {
            if (src.getStatus() == Communication.CommunicationStatus.NOTDONE) {
                tgt.setNotDone(true);
            } else {
                tgt.setStatus(VersionConvertor_30_40.convertCommunicationStatus(src.getStatus()));
            }
        }
        if (src.hasStatusReason()) {
            tgt.setNotDoneReason(VersionConvertor_30_40.convertCodeableConcept(src.getStatusReason()));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getMedium()) {
            tgt.addMedium(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (Identifier t : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasSent()) {
            tgt.setSent(src.getSent());
        }
        if (src.hasReceived()) {
            tgt.setReceived(src.getReceived());
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_30_40.convertReference(src.getSender()));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getPayload()) {
            tgt.addPayload(VersionConvertor_30_40.convertCommunicationPayloadComponent((Communication.CommunicationPayloadComponent)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        return tgt;
    }

    private static Communication.CommunicationStatus convertCommunicationStatus(Communication.CommunicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PREPARATION: {
                return Communication.CommunicationStatus.PREPARATION;
            }
            case INPROGRESS: {
                return Communication.CommunicationStatus.INPROGRESS;
            }
            case SUSPENDED: {
                return Communication.CommunicationStatus.ONHOLD;
            }
            case ABORTED: {
                return Communication.CommunicationStatus.STOPPED;
            }
            case COMPLETED: {
                return Communication.CommunicationStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return Communication.CommunicationStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return Communication.CommunicationStatus.UNKNOWN;
            }
        }
        return Communication.CommunicationStatus.NULL;
    }

    private static Communication.CommunicationStatus convertCommunicationStatus(Communication.CommunicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PREPARATION: {
                return Communication.CommunicationStatus.PREPARATION;
            }
            case INPROGRESS: {
                return Communication.CommunicationStatus.INPROGRESS;
            }
            case ONHOLD: {
                return Communication.CommunicationStatus.SUSPENDED;
            }
            case STOPPED: {
                return Communication.CommunicationStatus.ABORTED;
            }
            case COMPLETED: {
                return Communication.CommunicationStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return Communication.CommunicationStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return Communication.CommunicationStatus.UNKNOWN;
            }
        }
        return Communication.CommunicationStatus.NULL;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_30_40.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_30_40.convertType(src.getContent()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.CompartmentDefinition convertCompartmentDefinition(CompartmentDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CompartmentDefinition tgt = new org.hl7.fhir.r4.model.CompartmentDefinition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCompartmentType(src.getCode()));
        }
        if (src.hasSearch()) {
            tgt.setSearch(src.getSearch());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getResource()) {
            tgt.addResource(VersionConvertor_30_40.convertCompartmentDefinitionResourceComponent((CompartmentDefinition.CompartmentDefinitionResourceComponent)t));
        }
        return tgt;
    }

    public static CompartmentDefinition convertCompartmentDefinition(org.hl7.fhir.r4.model.CompartmentDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition tgt = new CompartmentDefinition();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCompartmentType(src.getCode()));
        }
        if (src.hasSearch()) {
            tgt.setSearch(src.getSearch());
        }
        for (ContactDetail t : src.getResource()) {
            tgt.addResource(VersionConvertor_30_40.convertCompartmentDefinitionResourceComponent((CompartmentDefinition.CompartmentDefinitionResourceComponent)t));
        }
        return tgt;
    }

    private static CompartmentDefinition.CompartmentType convertCompartmentType(CompartmentDefinition.CompartmentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PATIENT: {
                return CompartmentDefinition.CompartmentType.PATIENT;
            }
            case ENCOUNTER: {
                return CompartmentDefinition.CompartmentType.ENCOUNTER;
            }
            case RELATEDPERSON: {
                return CompartmentDefinition.CompartmentType.RELATEDPERSON;
            }
            case PRACTITIONER: {
                return CompartmentDefinition.CompartmentType.PRACTITIONER;
            }
            case DEVICE: {
                return CompartmentDefinition.CompartmentType.DEVICE;
            }
        }
        return CompartmentDefinition.CompartmentType.NULL;
    }

    private static CompartmentDefinition.CompartmentType convertCompartmentType(CompartmentDefinition.CompartmentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PATIENT: {
                return CompartmentDefinition.CompartmentType.PATIENT;
            }
            case ENCOUNTER: {
                return CompartmentDefinition.CompartmentType.ENCOUNTER;
            }
            case RELATEDPERSON: {
                return CompartmentDefinition.CompartmentType.RELATEDPERSON;
            }
            case PRACTITIONER: {
                return CompartmentDefinition.CompartmentType.PRACTITIONER;
            }
            case DEVICE: {
                return CompartmentDefinition.CompartmentType.DEVICE;
            }
        }
        return CompartmentDefinition.CompartmentType.NULL;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        for (StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static CompartmentDefinition.CompartmentDefinitionResourceComponent convertCompartmentDefinitionResourceComponent(CompartmentDefinition.CompartmentDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CompartmentDefinition.CompartmentDefinitionResourceComponent tgt = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getParam()) {
            tgt.addParam((String)t.getValue());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Composition convertComposition(Composition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Composition tgt = new org.hl7.fhir.r4.model.Composition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertCompositionStatus(src.getStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        for (Reference t : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasConfidentiality()) {
            tgt.setConfidentiality(VersionConvertor_30_40.convertDocumentConfidentiality(src.getConfidentiality()));
        }
        for (Reference t : src.getAttester()) {
            tgt.addAttester(VersionConvertor_30_40.convertCompositionAttesterComponent((Composition.CompositionAttesterComponent)t));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_30_40.convertReference(src.getCustodian()));
        }
        for (Reference t : src.getRelatesTo()) {
            tgt.addRelatesTo(VersionConvertor_30_40.convertCompositionRelatesToComponent((Composition.CompositionRelatesToComponent)t));
        }
        for (Reference t : src.getEvent()) {
            tgt.addEvent(VersionConvertor_30_40.convertCompositionEventComponent((Composition.CompositionEventComponent)t));
        }
        for (Reference t : src.getSection()) {
            tgt.addSection(VersionConvertor_30_40.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public static Composition convertComposition(org.hl7.fhir.r4.model.Composition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition tgt = new Composition();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertCompositionStatus(src.getStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasCategory()) {
            tgt.setClass_(VersionConvertor_30_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getAuthor()) {
            tgt.addAuthor(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasConfidentiality()) {
            tgt.setConfidentiality(VersionConvertor_30_40.convertDocumentConfidentiality(src.getConfidentiality()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getAttester()) {
            tgt.addAttester(VersionConvertor_30_40.convertCompositionAttesterComponent((Composition.CompositionAttesterComponent)t));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_30_40.convertReference(src.getCustodian()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getRelatesTo()) {
            tgt.addRelatesTo(VersionConvertor_30_40.convertCompositionRelatesToComponent((Composition.CompositionRelatesToComponent)t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getEvent()) {
            tgt.addEvent(VersionConvertor_30_40.convertCompositionEventComponent((Composition.CompositionEventComponent)t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getSection()) {
            tgt.addSection(VersionConvertor_30_40.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    private static Composition.CompositionStatus convertCompositionStatus(Composition.CompositionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRELIMINARY: {
                return Composition.CompositionStatus.PRELIMINARY;
            }
            case FINAL: {
                return Composition.CompositionStatus.FINAL;
            }
            case AMENDED: {
                return Composition.CompositionStatus.AMENDED;
            }
            case ENTEREDINERROR: {
                return Composition.CompositionStatus.ENTEREDINERROR;
            }
        }
        return Composition.CompositionStatus.NULL;
    }

    private static Composition.CompositionStatus convertCompositionStatus(Composition.CompositionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRELIMINARY: {
                return Composition.CompositionStatus.PRELIMINARY;
            }
            case FINAL: {
                return Composition.CompositionStatus.FINAL;
            }
            case AMENDED: {
                return Composition.CompositionStatus.AMENDED;
            }
            case ENTEREDINERROR: {
                return Composition.CompositionStatus.ENTEREDINERROR;
            }
        }
        return Composition.CompositionStatus.NULL;
    }

    private static Composition.DocumentConfidentiality convertDocumentConfidentiality(Composition.DocumentConfidentiality src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case U: {
                return Composition.DocumentConfidentiality.U;
            }
            case L: {
                return Composition.DocumentConfidentiality.L;
            }
            case M: {
                return Composition.DocumentConfidentiality.M;
            }
            case N: {
                return Composition.DocumentConfidentiality.N;
            }
            case R: {
                return Composition.DocumentConfidentiality.R;
            }
            case V: {
                return Composition.DocumentConfidentiality.V;
            }
        }
        return Composition.DocumentConfidentiality.NULL;
    }

    private static Composition.DocumentConfidentiality convertDocumentConfidentiality(Composition.DocumentConfidentiality src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case U: {
                return Composition.DocumentConfidentiality.U;
            }
            case L: {
                return Composition.DocumentConfidentiality.L;
            }
            case M: {
                return Composition.DocumentConfidentiality.M;
            }
            case N: {
                return Composition.DocumentConfidentiality.N;
            }
            case R: {
                return Composition.DocumentConfidentiality.R;
            }
            case V: {
                return Composition.DocumentConfidentiality.V;
            }
        }
        return Composition.DocumentConfidentiality.NULL;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertCompositionAttestationMode((Composition.CompositionAttestationMode)((org.hl7.fhir.dstu3.model.Enumeration)src.getMode().get(0)).getValue()));
        }
        if (src.hasTime()) {
            tgt.setTime(src.getTime());
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_30_40.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMode()) {
            tgt.addMode(VersionConvertor_30_40.convertCompositionAttestationMode(src.getMode()));
        }
        if (src.hasTime()) {
            tgt.setTime(src.getTime());
        }
        if (src.hasParty()) {
            tgt.setParty(VersionConvertor_30_40.convertReference(src.getParty()));
        }
        return tgt;
    }

    private static Composition.CompositionAttestationMode convertCompositionAttestationMode(Composition.CompositionAttestationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PERSONAL: {
                return Composition.CompositionAttestationMode.PERSONAL;
            }
            case PROFESSIONAL: {
                return Composition.CompositionAttestationMode.PROFESSIONAL;
            }
            case LEGAL: {
                return Composition.CompositionAttestationMode.LEGAL;
            }
            case OFFICIAL: {
                return Composition.CompositionAttestationMode.OFFICIAL;
            }
        }
        return Composition.CompositionAttestationMode.NULL;
    }

    private static Composition.CompositionAttestationMode convertCompositionAttestationMode(Composition.CompositionAttestationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PERSONAL: {
                return Composition.CompositionAttestationMode.PERSONAL;
            }
            case PROFESSIONAL: {
                return Composition.CompositionAttestationMode.PROFESSIONAL;
            }
            case LEGAL: {
                return Composition.CompositionAttestationMode.LEGAL;
            }
            case OFFICIAL: {
                return Composition.CompositionAttestationMode.OFFICIAL;
            }
        }
        return Composition.CompositionAttestationMode.NULL;
    }

    public static Composition.CompositionRelatesToComponent convertCompositionRelatesToComponent(Composition.CompositionRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionRelatesToComponent tgt = new Composition.CompositionRelatesToComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertDocumentRelationshipType(src.getCode()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertType(src.getTarget()));
        }
        return tgt;
    }

    public static Composition.CompositionRelatesToComponent convertCompositionRelatesToComponent(Composition.CompositionRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionRelatesToComponent tgt = new Composition.CompositionRelatesToComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertDocumentRelationshipType(src.getCode()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertType(src.getTarget()));
        }
        return tgt;
    }

    private static Composition.DocumentRelationshipType convertDocumentRelationshipType(Composition.DocumentRelationshipType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACES: {
                return Composition.DocumentRelationshipType.REPLACES;
            }
            case TRANSFORMS: {
                return Composition.DocumentRelationshipType.TRANSFORMS;
            }
            case SIGNS: {
                return Composition.DocumentRelationshipType.SIGNS;
            }
            case APPENDS: {
                return Composition.DocumentRelationshipType.APPENDS;
            }
        }
        return Composition.DocumentRelationshipType.NULL;
    }

    private static Composition.DocumentRelationshipType convertDocumentRelationshipType(Composition.DocumentRelationshipType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACES: {
                return Composition.DocumentRelationshipType.REPLACES;
            }
            case TRANSFORMS: {
                return Composition.DocumentRelationshipType.TRANSFORMS;
            }
            case SIGNS: {
                return Composition.DocumentRelationshipType.SIGNS;
            }
            case APPENDS: {
                return Composition.DocumentRelationshipType.APPENDS;
            }
        }
        return Composition.DocumentRelationshipType.NULL;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (CodeableConcept t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_40.convertNarrative(src.getText()));
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertSectionMode(src.getMode()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_30_40.convertCodeableConcept(src.getOrderedBy()));
        }
        for (Reference t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_30_40.convertCodeableConcept(src.getEmptyReason()));
        }
        for (Reference t : src.getSection()) {
            tgt.addSection(VersionConvertor_30_40.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public static Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasText()) {
            tgt.setText(VersionConvertor_30_40.convertNarrative(src.getText()));
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertSectionMode(src.getMode()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_30_40.convertCodeableConcept(src.getOrderedBy()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_30_40.convertCodeableConcept(src.getEmptyReason()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getSection()) {
            tgt.addSection(VersionConvertor_30_40.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    private static Composition.SectionMode convertSectionMode(Composition.SectionMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case WORKING: {
                return Composition.SectionMode.WORKING;
            }
            case SNAPSHOT: {
                return Composition.SectionMode.SNAPSHOT;
            }
            case CHANGES: {
                return Composition.SectionMode.CHANGES;
            }
        }
        return Composition.SectionMode.NULL;
    }

    private static Composition.SectionMode convertSectionMode(Composition.SectionMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case WORKING: {
                return Composition.SectionMode.WORKING;
            }
            case SNAPSHOT: {
                return Composition.SectionMode.SNAPSHOT;
            }
            case CHANGES: {
                return Composition.SectionMode.CHANGES;
            }
        }
        return Composition.SectionMode.NULL;
    }

    public static org.hl7.fhir.r4.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        org.hl7.fhir.r4.model.Type t;
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ConceptMap tgt = new org.hl7.fhir.r4.model.ConceptMap();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t2 : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t2));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t2 : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t2));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t2 : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t2));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasSource()) {
            t = VersionConvertor_30_40.convertType(src.getSource());
            tgt.setSource((org.hl7.fhir.r4.model.Type)(t instanceof org.hl7.fhir.r4.model.Reference ? new CanonicalType(((org.hl7.fhir.r4.model.Reference)t).getReference()) : t));
        }
        if (src.hasTarget()) {
            t = VersionConvertor_30_40.convertType(src.getTarget());
            tgt.setTarget((org.hl7.fhir.r4.model.Type)(t instanceof org.hl7.fhir.r4.model.Reference ? new CanonicalType(((org.hl7.fhir.r4.model.Reference)t).getReference()) : t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t2 : src.getGroup()) {
            tgt.addGroup(VersionConvertor_30_40.convertConceptMapGroupComponent((ConceptMap.ConceptMapGroupComponent)t2));
        }
        return tgt;
    }

    public static ConceptMap convertConceptMap(org.hl7.fhir.r4.model.ConceptMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertType(src.getTarget()));
        }
        for (ContactDetail t : src.getGroup()) {
            tgt.addGroup(VersionConvertor_30_40.convertConceptMapGroupComponent((ConceptMap.ConceptMapGroupComponent)t));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent convertConceptMapGroupComponent(ConceptMap.ConceptMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupComponent tgt = new ConceptMap.ConceptMapGroupComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSource()) {
            tgt.setSource(src.getSource());
        }
        if (src.hasSourceVersion()) {
            tgt.setSourceVersion(src.getSourceVersion());
        }
        if (src.hasTarget()) {
            tgt.setTarget(src.getTarget());
        }
        if (src.hasTargetVersion()) {
            tgt.setTargetVersion(src.getTargetVersion());
        }
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_40.convertSourceElementComponent(t));
        }
        if (src.hasUnmapped()) {
            tgt.setUnmapped(VersionConvertor_30_40.convertConceptMapGroupUnmappedComponent(src.getUnmapped()));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent convertConceptMapGroupComponent(ConceptMap.ConceptMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupComponent tgt = new ConceptMap.ConceptMapGroupComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasSource()) {
            tgt.setSource(src.getSource());
        }
        if (src.hasSourceVersion()) {
            tgt.setSourceVersion(src.getSourceVersion());
        }
        if (src.hasTarget()) {
            tgt.setTarget(src.getTarget());
        }
        if (src.hasTargetVersion()) {
            tgt.setTargetVersion(src.getTargetVersion());
        }
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_40.convertSourceElementComponent(t));
        }
        if (src.hasUnmapped()) {
            tgt.setUnmapped(VersionConvertor_30_40.convertConceptMapGroupUnmappedComponent(src.getUnmapped()));
        }
        return tgt;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertTargetElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertTargetElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasEquivalence()) {
            tgt.setEquivalence(VersionConvertor_30_40.convertConceptMapEquivalence(src.getEquivalence()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(VersionConvertor_30_40.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(VersionConvertor_30_40.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasEquivalence()) {
            tgt.setEquivalence(VersionConvertor_30_40.convertConceptMapEquivalence(src.getEquivalence()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(VersionConvertor_30_40.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(VersionConvertor_30_40.convertOtherElementComponent(t));
        }
        return tgt;
    }

    private static Enumerations.ConceptMapEquivalence convertConceptMapEquivalence(Enumerations.ConceptMapEquivalence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RELATEDTO: {
                return Enumerations.ConceptMapEquivalence.RELATEDTO;
            }
            case EQUIVALENT: {
                return Enumerations.ConceptMapEquivalence.EQUIVALENT;
            }
            case EQUAL: {
                return Enumerations.ConceptMapEquivalence.EQUAL;
            }
            case WIDER: {
                return Enumerations.ConceptMapEquivalence.WIDER;
            }
            case SUBSUMES: {
                return Enumerations.ConceptMapEquivalence.SUBSUMES;
            }
            case NARROWER: {
                return Enumerations.ConceptMapEquivalence.NARROWER;
            }
            case SPECIALIZES: {
                return Enumerations.ConceptMapEquivalence.SPECIALIZES;
            }
            case INEXACT: {
                return Enumerations.ConceptMapEquivalence.INEXACT;
            }
            case UNMATCHED: {
                return Enumerations.ConceptMapEquivalence.UNMATCHED;
            }
            case DISJOINT: {
                return Enumerations.ConceptMapEquivalence.DISJOINT;
            }
        }
        return Enumerations.ConceptMapEquivalence.NULL;
    }

    private static Enumerations.ConceptMapEquivalence convertConceptMapEquivalence(Enumerations.ConceptMapEquivalence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RELATEDTO: {
                return Enumerations.ConceptMapEquivalence.RELATEDTO;
            }
            case EQUIVALENT: {
                return Enumerations.ConceptMapEquivalence.EQUIVALENT;
            }
            case EQUAL: {
                return Enumerations.ConceptMapEquivalence.EQUAL;
            }
            case WIDER: {
                return Enumerations.ConceptMapEquivalence.WIDER;
            }
            case SUBSUMES: {
                return Enumerations.ConceptMapEquivalence.SUBSUMES;
            }
            case NARROWER: {
                return Enumerations.ConceptMapEquivalence.NARROWER;
            }
            case SPECIALIZES: {
                return Enumerations.ConceptMapEquivalence.SPECIALIZES;
            }
            case INEXACT: {
                return Enumerations.ConceptMapEquivalence.INEXACT;
            }
            case UNMATCHED: {
                return Enumerations.ConceptMapEquivalence.UNMATCHED;
            }
            case DISJOINT: {
                return Enumerations.ConceptMapEquivalence.DISJOINT;
            }
        }
        return Enumerations.ConceptMapEquivalence.NULL;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasProperty()) {
            tgt.setProperty(src.getProperty());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setValue(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasProperty()) {
            tgt.setProperty(src.getProperty());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasValue()) {
            tgt.setCode(src.getValue());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupUnmappedComponent convertConceptMapGroupUnmappedComponent(ConceptMap.ConceptMapGroupUnmappedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupUnmappedComponent tgt = new ConceptMap.ConceptMapGroupUnmappedComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertConceptMapGroupUnmappedMode(src.getMode()));
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupUnmappedComponent convertConceptMapGroupUnmappedComponent(ConceptMap.ConceptMapGroupUnmappedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupUnmappedComponent tgt = new ConceptMap.ConceptMapGroupUnmappedComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertConceptMapGroupUnmappedMode(src.getMode()));
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    private static ConceptMap.ConceptMapGroupUnmappedMode convertConceptMapGroupUnmappedMode(ConceptMap.ConceptMapGroupUnmappedMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROVIDED: {
                return ConceptMap.ConceptMapGroupUnmappedMode.PROVIDED;
            }
            case FIXED: {
                return ConceptMap.ConceptMapGroupUnmappedMode.FIXED;
            }
            case OTHERMAP: {
                return ConceptMap.ConceptMapGroupUnmappedMode.OTHERMAP;
            }
        }
        return ConceptMap.ConceptMapGroupUnmappedMode.NULL;
    }

    private static ConceptMap.ConceptMapGroupUnmappedMode convertConceptMapGroupUnmappedMode(ConceptMap.ConceptMapGroupUnmappedMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROVIDED: {
                return ConceptMap.ConceptMapGroupUnmappedMode.PROVIDED;
            }
            case FIXED: {
                return ConceptMap.ConceptMapGroupUnmappedMode.FIXED;
            }
            case OTHERMAP: {
                return ConceptMap.ConceptMapGroupUnmappedMode.OTHERMAP;
            }
        }
        return ConceptMap.ConceptMapGroupUnmappedMode.NULL;
    }

    public static Condition convertCondition(org.hl7.fhir.dstu3.model.Condition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition tgt = new Condition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(VersionConvertor_30_40.convertConditionClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(VersionConvertor_30_40.convertConditionVerificationStatus(src.getVerificationStatus()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(VersionConvertor_30_40.convertType(src.getAbatement()));
        }
        if (src.hasAssertedDate()) {
            tgt.setRecordedDate(src.getAssertedDate());
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_30_40.convertReference(src.getAsserter()));
        }
        if (src.hasStage()) {
            tgt.addStage(VersionConvertor_30_40.convertConditionStageComponent(src.getStage()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEvidence()) {
            tgt.addEvidence(VersionConvertor_30_40.convertConditionEvidenceComponent((Condition.ConditionEvidenceComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Condition convertCondition(Condition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Condition tgt = new org.hl7.fhir.dstu3.model.Condition();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(VersionConvertor_30_40.convertConditionClinicalStatus(src.getClinicalStatus()));
        }
        if (src.hasVerificationStatus()) {
            tgt.setVerificationStatus(VersionConvertor_30_40.convertConditionVerificationStatus(src.getVerificationStatus()));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertCodeableConcept(src.getSeverity()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        for (Identifier t : src.getBodySite()) {
            tgt.addBodySite(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        if (src.hasAbatement()) {
            tgt.setAbatement(VersionConvertor_30_40.convertType(src.getAbatement()));
        }
        if (src.hasRecordedDate()) {
            tgt.setAssertedDate(src.getRecordedDate());
        }
        if (src.hasAsserter()) {
            tgt.setAsserter(VersionConvertor_30_40.convertReference(src.getAsserter()));
        }
        if (src.hasStage()) {
            tgt.setStage(VersionConvertor_30_40.convertConditionStageComponent(src.getStageFirstRep()));
        }
        for (Identifier t : src.getEvidence()) {
            tgt.addEvidence(VersionConvertor_30_40.convertConditionEvidenceComponent((Condition.ConditionEvidenceComponent)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        return tgt;
    }

    private static org.hl7.fhir.r4.model.CodeableConcept convertConditionClinicalStatus(Condition.ConditionClinicalStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept cc = new org.hl7.fhir.r4.model.CodeableConcept();
        switch (src) {
            case ACTIVE: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-clinical").setCode("active");
                return cc;
            }
            case RECURRENCE: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-clinical").setCode("recurrence");
                return cc;
            }
            case INACTIVE: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-clinical").setCode("inactive");
                return cc;
            }
            case REMISSION: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-clinical").setCode("remission");
                return cc;
            }
            case RESOLVED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-clinical").setCode("resolved");
                return cc;
            }
        }
        return null;
    }

    private static Condition.ConditionClinicalStatus convertConditionClinicalStatus(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "active")) {
            return Condition.ConditionClinicalStatus.ACTIVE;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "recurrence")) {
            return Condition.ConditionClinicalStatus.RECURRENCE;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "inactive")) {
            return Condition.ConditionClinicalStatus.INACTIVE;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "remission")) {
            return Condition.ConditionClinicalStatus.REMISSION;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "resolved")) {
            return Condition.ConditionClinicalStatus.RESOLVED;
        }
        return Condition.ConditionClinicalStatus.NULL;
    }

    private static org.hl7.fhir.r4.model.CodeableConcept convertConditionVerificationStatus(Condition.ConditionVerificationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept cc = new org.hl7.fhir.r4.model.CodeableConcept();
        switch (src) {
            case PROVISIONAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("provisional");
                return cc;
            }
            case DIFFERENTIAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("differential");
                return cc;
            }
            case CONFIRMED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("confirmed");
                return cc;
            }
            case REFUTED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("refuted");
                return cc;
            }
            case ENTEREDINERROR: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("entered-in-error");
                return cc;
            }
        }
        return null;
    }

    private static Condition.ConditionVerificationStatus convertConditionVerificationStatus(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "provisional")) {
            return Condition.ConditionVerificationStatus.PROVISIONAL;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "differential")) {
            return Condition.ConditionVerificationStatus.DIFFERENTIAL;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "confirmed")) {
            return Condition.ConditionVerificationStatus.CONFIRMED;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "refuted")) {
            return Condition.ConditionVerificationStatus.REFUTED;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "entered-in-error")) {
            return Condition.ConditionVerificationStatus.ENTEREDINERROR;
        }
        return Condition.ConditionVerificationStatus.NULL;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSummary()) {
            tgt.setSummary(VersionConvertor_30_40.convertCodeableConcept(src.getSummary()));
        }
        for (Reference t : src.getAssessment()) {
            tgt.addAssessment(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasSummary()) {
            tgt.setSummary(VersionConvertor_30_40.convertCodeableConcept(src.getSummary()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getAssessment()) {
            tgt.addAssessment(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getDetail()) {
            tgt.addDetail(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Consent convertConsent(Consent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Consent tgt = new org.hl7.fhir.r4.model.Consent();
        return tgt;
    }

    public static Consent convertConsent(org.hl7.fhir.r4.model.Consent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent tgt = new Consent();
        return tgt;
    }

    public static Consent.ConsentPolicyComponent convertConsentPolicyComponent(Consent.ConsentPolicyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentPolicyComponent tgt = new Consent.ConsentPolicyComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasAuthority()) {
            tgt.setAuthority(src.getAuthority());
        }
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        return tgt;
    }

    public static Consent.ConsentPolicyComponent convertConsentPolicyComponent(Consent.ConsentPolicyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Consent.ConsentPolicyComponent tgt = new Consent.ConsentPolicyComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasAuthority()) {
            tgt.setAuthority(src.getAuthority());
        }
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        return tgt;
    }

    private static Consent.ConsentDataMeaning convertConsentDataMeaning(Consent.ConsentDataMeaning src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return Consent.ConsentDataMeaning.INSTANCE;
            }
            case RELATED: {
                return Consent.ConsentDataMeaning.RELATED;
            }
            case DEPENDENTS: {
                return Consent.ConsentDataMeaning.DEPENDENTS;
            }
            case AUTHOREDBY: {
                return Consent.ConsentDataMeaning.AUTHOREDBY;
            }
        }
        return Consent.ConsentDataMeaning.NULL;
    }

    private static Consent.ConsentDataMeaning convertConsentDataMeaning(Consent.ConsentDataMeaning src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return Consent.ConsentDataMeaning.INSTANCE;
            }
            case RELATED: {
                return Consent.ConsentDataMeaning.RELATED;
            }
            case DEPENDENTS: {
                return Consent.ConsentDataMeaning.DEPENDENTS;
            }
            case AUTHOREDBY: {
                return Consent.ConsentDataMeaning.AUTHOREDBY;
            }
        }
        return Consent.ConsentDataMeaning.NULL;
    }

    public static org.hl7.fhir.r4.model.StructureDefinition convertDataElement(DataElement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.StructureDefinition tgt = new org.hl7.fhir.r4.model.StructureDefinition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl().replace("/DataElement/", "/StructureDefinition/de-"));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((org.hl7.fhir.dstu3.model.ContactDetail)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_40.convertDataElementMappingComponent((DataElement.DataElementMappingComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getElement()) {
            tgt.getSnapshot().addElement(VersionConvertor_30_40.convertElementDefinition((ElementDefinition)t));
        }
        tgt.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        tgt.setAbstract(false);
        tgt.setType(tgt.getName());
        tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Element");
        tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertDataElementMappingComponent(DataElement.DataElementMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasIdentity()) {
            tgt.setIdentity(src.getIdentity());
        }
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static DetectedIssue convertDetectedIssue(org.hl7.fhir.dstu3.model.DetectedIssue src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue tgt = new DetectedIssue();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertDetectedIssueStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertDetectedIssueSeverity(src.getSeverity()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setIdentified((org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        for (Reference t : src.getImplicated()) {
            tgt.addImplicated(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasDetail()) {
            tgt.setDetail(src.getDetail());
        }
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        for (Reference t : src.getMitigation()) {
            tgt.addMitigation(VersionConvertor_30_40.convertDetectedIssueMitigationComponent((DetectedIssue.DetectedIssueMitigationComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DetectedIssue convertDetectedIssue(DetectedIssue src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.DetectedIssue tgt = new org.hl7.fhir.dstu3.model.DetectedIssue();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertDetectedIssueStatus(src.getStatus()));
        }
        if (src.hasCode()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertDetectedIssueSeverity(src.getSeverity()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasIdentifiedDateTimeType()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getIdentifiedDateTimeType()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getImplicated()) {
            tgt.addImplicated(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasDetail()) {
            tgt.setDetail(src.getDetail());
        }
        if (src.hasReference()) {
            tgt.setReference(src.getReference());
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getMitigation()) {
            tgt.addMitigation(VersionConvertor_30_40.convertDetectedIssueMitigationComponent((DetectedIssue.DetectedIssueMitigationComponent)t));
        }
        return tgt;
    }

    private static DetectedIssue.DetectedIssueStatus convertDetectedIssueStatus(DetectedIssue.DetectedIssueStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return DetectedIssue.DetectedIssueStatus.REGISTERED;
            }
            case PRELIMINARY: {
                return DetectedIssue.DetectedIssueStatus.PRELIMINARY;
            }
            case FINAL: {
                return DetectedIssue.DetectedIssueStatus.FINAL;
            }
            case AMENDED: {
                return DetectedIssue.DetectedIssueStatus.AMENDED;
            }
            case CORRECTED: {
                return DetectedIssue.DetectedIssueStatus.CORRECTED;
            }
            case CANCELLED: {
                return DetectedIssue.DetectedIssueStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return DetectedIssue.DetectedIssueStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return DetectedIssue.DetectedIssueStatus.UNKNOWN;
            }
        }
        return DetectedIssue.DetectedIssueStatus.NULL;
    }

    private static DetectedIssue.DetectedIssueStatus convertDetectedIssueStatus(DetectedIssue.DetectedIssueStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return DetectedIssue.DetectedIssueStatus.REGISTERED;
            }
            case PRELIMINARY: {
                return DetectedIssue.DetectedIssueStatus.PRELIMINARY;
            }
            case FINAL: {
                return DetectedIssue.DetectedIssueStatus.FINAL;
            }
            case AMENDED: {
                return DetectedIssue.DetectedIssueStatus.AMENDED;
            }
            case CORRECTED: {
                return DetectedIssue.DetectedIssueStatus.CORRECTED;
            }
            case CANCELLED: {
                return DetectedIssue.DetectedIssueStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return DetectedIssue.DetectedIssueStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return DetectedIssue.DetectedIssueStatus.UNKNOWN;
            }
        }
        return DetectedIssue.DetectedIssueStatus.NULL;
    }

    private static DetectedIssue.DetectedIssueSeverity convertDetectedIssueSeverity(DetectedIssue.DetectedIssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HIGH: {
                return DetectedIssue.DetectedIssueSeverity.HIGH;
            }
            case MODERATE: {
                return DetectedIssue.DetectedIssueSeverity.MODERATE;
            }
            case LOW: {
                return DetectedIssue.DetectedIssueSeverity.LOW;
            }
        }
        return DetectedIssue.DetectedIssueSeverity.NULL;
    }

    private static DetectedIssue.DetectedIssueSeverity convertDetectedIssueSeverity(DetectedIssue.DetectedIssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HIGH: {
                return DetectedIssue.DetectedIssueSeverity.HIGH;
            }
            case MODERATE: {
                return DetectedIssue.DetectedIssueSeverity.MODERATE;
            }
            case LOW: {
                return DetectedIssue.DetectedIssueSeverity.LOW;
            }
        }
        return DetectedIssue.DetectedIssueSeverity.NULL;
    }

    public static DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_30_40.convertCodeableConcept(src.getAction()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasAction()) {
            tgt.setAction(VersionConvertor_30_40.convertCodeableConcept(src.getAction()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static DeviceUseStatement convertDeviceUseStatement(org.hl7.fhir.dstu3.model.DeviceUseStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DeviceUseStatement tgt = new DeviceUseStatement();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertDeviceUseStatementStatus(src.getStatus()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertType(src.getTiming()));
        }
        if (src.hasRecordedOn()) {
            tgt.setRecordedOn(src.getRecordedOn());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertReference(src.getSource()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIndication()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DeviceUseStatement convertDeviceUseStatement(DeviceUseStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.DeviceUseStatement tgt = new org.hl7.fhir.dstu3.model.DeviceUseStatement();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertDeviceUseStatementStatus(src.getStatus()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(VersionConvertor_30_40.convertType(src.getTiming()));
        }
        if (src.hasRecordedOn()) {
            tgt.setRecordedOn(src.getRecordedOn());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertReference(src.getSource()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addIndication(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        return tgt;
    }

    private static DeviceUseStatement.DeviceUseStatementStatus convertDeviceUseStatementStatus(DeviceUseStatement.DeviceUseStatementStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return DeviceUseStatement.DeviceUseStatementStatus.ACTIVE;
            }
            case COMPLETED: {
                return DeviceUseStatement.DeviceUseStatementStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return DeviceUseStatement.DeviceUseStatementStatus.ENTEREDINERROR;
            }
            case INTENDED: {
                return DeviceUseStatement.DeviceUseStatementStatus.INTENDED;
            }
            case STOPPED: {
                return DeviceUseStatement.DeviceUseStatementStatus.STOPPED;
            }
            case ONHOLD: {
                return DeviceUseStatement.DeviceUseStatementStatus.ONHOLD;
            }
        }
        return DeviceUseStatement.DeviceUseStatementStatus.NULL;
    }

    private static DeviceUseStatement.DeviceUseStatementStatus convertDeviceUseStatementStatus(DeviceUseStatement.DeviceUseStatementStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return DeviceUseStatement.DeviceUseStatementStatus.ACTIVE;
            }
            case COMPLETED: {
                return DeviceUseStatement.DeviceUseStatementStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return DeviceUseStatement.DeviceUseStatementStatus.ENTEREDINERROR;
            }
            case INTENDED: {
                return DeviceUseStatement.DeviceUseStatementStatus.INTENDED;
            }
            case STOPPED: {
                return DeviceUseStatement.DeviceUseStatementStatus.STOPPED;
            }
            case ONHOLD: {
                return DeviceUseStatement.DeviceUseStatementStatus.ONHOLD;
            }
        }
        return DeviceUseStatement.DeviceUseStatementStatus.NULL;
    }

    public static org.hl7.fhir.r4.model.DiagnosticReport convertDiagnosticReport(DiagnosticReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.DiagnosticReport tgt = new org.hl7.fhir.r4.model.DiagnosticReport();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertDiagnosticReportStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssued(src.getIssued());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSpecimen()) {
            tgt.addSpecimen(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getResult()) {
            tgt.addResult(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getImagingStudy()) {
            tgt.addImagingStudy(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getImage()) {
            tgt.addMedia(VersionConvertor_30_40.convertDiagnosticReportImageComponent((DiagnosticReport.DiagnosticReportImageComponent)t));
        }
        if (src.hasConclusion()) {
            tgt.setConclusion(src.getConclusion());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCodedDiagnosis()) {
            tgt.addConclusionCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPresentedForm()) {
            tgt.addPresentedForm(VersionConvertor_30_40.convertAttachment((org.hl7.fhir.dstu3.model.Attachment)t));
        }
        return tgt;
    }

    public static DiagnosticReport convertDiagnosticReport(org.hl7.fhir.r4.model.DiagnosticReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport tgt = new DiagnosticReport();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertDiagnosticReportStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssued(src.getIssued());
        }
        for (Identifier t : src.getSpecimen()) {
            tgt.addSpecimen(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getResult()) {
            tgt.addResult(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getImagingStudy()) {
            tgt.addImagingStudy(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getMedia()) {
            tgt.addImage(VersionConvertor_30_40.convertDiagnosticReportImageComponent((DiagnosticReport.DiagnosticReportMediaComponent)t));
        }
        if (src.hasConclusion()) {
            tgt.setConclusion(src.getConclusion());
        }
        for (Identifier t : src.getConclusionCode()) {
            tgt.addCodedDiagnosis(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getPresentedForm()) {
            tgt.addPresentedForm(VersionConvertor_30_40.convertAttachment((Attachment)t));
        }
        return tgt;
    }

    private static DiagnosticReport.DiagnosticReportStatus convertDiagnosticReportStatus(DiagnosticReport.DiagnosticReportStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return DiagnosticReport.DiagnosticReportStatus.REGISTERED;
            }
            case PARTIAL: {
                return DiagnosticReport.DiagnosticReportStatus.PARTIAL;
            }
            case PRELIMINARY: {
                return DiagnosticReport.DiagnosticReportStatus.PRELIMINARY;
            }
            case FINAL: {
                return DiagnosticReport.DiagnosticReportStatus.FINAL;
            }
            case AMENDED: {
                return DiagnosticReport.DiagnosticReportStatus.AMENDED;
            }
            case CORRECTED: {
                return DiagnosticReport.DiagnosticReportStatus.CORRECTED;
            }
            case APPENDED: {
                return DiagnosticReport.DiagnosticReportStatus.APPENDED;
            }
            case CANCELLED: {
                return DiagnosticReport.DiagnosticReportStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return DiagnosticReport.DiagnosticReportStatus.UNKNOWN;
            }
        }
        return DiagnosticReport.DiagnosticReportStatus.NULL;
    }

    private static DiagnosticReport.DiagnosticReportStatus convertDiagnosticReportStatus(DiagnosticReport.DiagnosticReportStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return DiagnosticReport.DiagnosticReportStatus.REGISTERED;
            }
            case PARTIAL: {
                return DiagnosticReport.DiagnosticReportStatus.PARTIAL;
            }
            case PRELIMINARY: {
                return DiagnosticReport.DiagnosticReportStatus.PRELIMINARY;
            }
            case FINAL: {
                return DiagnosticReport.DiagnosticReportStatus.FINAL;
            }
            case AMENDED: {
                return DiagnosticReport.DiagnosticReportStatus.AMENDED;
            }
            case CORRECTED: {
                return DiagnosticReport.DiagnosticReportStatus.CORRECTED;
            }
            case APPENDED: {
                return DiagnosticReport.DiagnosticReportStatus.APPENDED;
            }
            case CANCELLED: {
                return DiagnosticReport.DiagnosticReportStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return DiagnosticReport.DiagnosticReportStatus.UNKNOWN;
            }
        }
        return DiagnosticReport.DiagnosticReportStatus.NULL;
    }

    public static DiagnosticReport.DiagnosticReportMediaComponent convertDiagnosticReportImageComponent(DiagnosticReport.DiagnosticReportImageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport.DiagnosticReportMediaComponent tgt = new DiagnosticReport.DiagnosticReportMediaComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasLink()) {
            tgt.setLink(VersionConvertor_30_40.convertReference(src.getLink()));
        }
        return tgt;
    }

    public static DiagnosticReport.DiagnosticReportImageComponent convertDiagnosticReportImageComponent(DiagnosticReport.DiagnosticReportMediaComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DiagnosticReport.DiagnosticReportImageComponent tgt = new DiagnosticReport.DiagnosticReportImageComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasLink()) {
            tgt.setLink(VersionConvertor_30_40.convertReference(src.getLink()));
        }
        return tgt;
    }

    private static Enumerations.DocumentReferenceStatus convertDocumentReferenceStatus(Enumerations.DocumentReferenceStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CURRENT: {
                return Enumerations.DocumentReferenceStatus.CURRENT;
            }
            case SUPERSEDED: {
                return Enumerations.DocumentReferenceStatus.SUPERSEDED;
            }
            case ENTEREDINERROR: {
                return Enumerations.DocumentReferenceStatus.ENTEREDINERROR;
            }
        }
        return Enumerations.DocumentReferenceStatus.NULL;
    }

    private static Enumerations.DocumentReferenceStatus convertDocumentReferenceStatus(Enumerations.DocumentReferenceStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CURRENT: {
                return Enumerations.DocumentReferenceStatus.CURRENT;
            }
            case SUPERSEDED: {
                return Enumerations.DocumentReferenceStatus.SUPERSEDED;
            }
            case ENTEREDINERROR: {
                return Enumerations.DocumentReferenceStatus.ENTEREDINERROR;
            }
        }
        return Enumerations.DocumentReferenceStatus.NULL;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_30_40.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasRef()) {
            tgt.setRef(VersionConvertor_30_40.convertReference(src.getRef()));
        }
        return tgt;
    }

    public static DocumentReference convertDocumentReference(org.hl7.fhir.dstu3.model.DocumentReference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference tgt = new DocumentReference();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_30_40.convertIdentifier(src.getMasterIdentifier()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertDocumentReferenceStatus(src.getStatus()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatus(VersionConvertor_30_40.convertReferredDocumentStatus(src.getDocStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasClass_()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(src.getClass_()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasCreated()) {
            tgt.setDate(src.getCreated());
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_30_40.convertReference(src.getAuthenticator()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_30_40.convertReference(src.getCustodian()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getRelatesTo()) {
            tgt.addRelatesTo(VersionConvertor_30_40.convertDocumentReferenceRelatesToComponent((DocumentReference.DocumentReferenceRelatesToComponent)t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContent()) {
            tgt.addContent(VersionConvertor_30_40.convertDocumentReferenceContentComponent((DocumentReference.DocumentReferenceContentComponent)t));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.DocumentReference convertDocumentReference(DocumentReference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.DocumentReference tgt = new org.hl7.fhir.dstu3.model.DocumentReference();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasMasterIdentifier()) {
            tgt.setMasterIdentifier(VersionConvertor_30_40.convertIdentifier(src.getMasterIdentifier()));
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertDocumentReferenceStatus(src.getStatus()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatus(VersionConvertor_30_40.convertReferredDocumentStatus(src.getDocStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasCategory()) {
            tgt.setClass_(VersionConvertor_30_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setCreated(src.getDate());
        }
        if (src.hasAuthenticator()) {
            tgt.setAuthenticator(VersionConvertor_30_40.convertReference(src.getAuthenticator()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(VersionConvertor_30_40.convertReference(src.getCustodian()));
        }
        for (Identifier t : src.getRelatesTo()) {
            tgt.addRelatesTo(VersionConvertor_30_40.convertDocumentReferenceRelatesToComponent((DocumentReference.DocumentReferenceRelatesToComponent)t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getContent()) {
            tgt.addContent(VersionConvertor_30_40.convertDocumentReferenceContentComponent((DocumentReference.DocumentReferenceContentComponent)t));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertDocumentReferenceContextComponent(src.getContext()));
        }
        return tgt;
    }

    private static DocumentReference.ReferredDocumentStatus convertReferredDocumentStatus(DocumentReference.ReferredDocumentStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRELIMINARY: {
                return DocumentReference.ReferredDocumentStatus.PRELIMINARY;
            }
            case FINAL: {
                return DocumentReference.ReferredDocumentStatus.FINAL;
            }
            case AMENDED: {
                return DocumentReference.ReferredDocumentStatus.AMENDED;
            }
            case ENTEREDINERROR: {
                return DocumentReference.ReferredDocumentStatus.ENTEREDINERROR;
            }
        }
        return DocumentReference.ReferredDocumentStatus.NULL;
    }

    private static DocumentReference.ReferredDocumentStatus convertReferredDocumentStatus(DocumentReference.ReferredDocumentStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRELIMINARY: {
                return DocumentReference.ReferredDocumentStatus.PRELIMINARY;
            }
            case FINAL: {
                return DocumentReference.ReferredDocumentStatus.FINAL;
            }
            case AMENDED: {
                return DocumentReference.ReferredDocumentStatus.AMENDED;
            }
            case ENTEREDINERROR: {
                return DocumentReference.ReferredDocumentStatus.ENTEREDINERROR;
            }
        }
        return DocumentReference.ReferredDocumentStatus.NULL;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertDocumentRelationshipType(src.getCode()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertDocumentRelationshipType(src.getCode()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        return tgt;
    }

    private static DocumentReference.DocumentRelationshipType convertDocumentRelationshipType(DocumentReference.DocumentRelationshipType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACES: {
                return DocumentReference.DocumentRelationshipType.REPLACES;
            }
            case TRANSFORMS: {
                return DocumentReference.DocumentRelationshipType.TRANSFORMS;
            }
            case SIGNS: {
                return DocumentReference.DocumentRelationshipType.SIGNS;
            }
            case APPENDS: {
                return DocumentReference.DocumentRelationshipType.APPENDS;
            }
        }
        return DocumentReference.DocumentRelationshipType.NULL;
    }

    private static DocumentReference.DocumentRelationshipType convertDocumentRelationshipType(DocumentReference.DocumentRelationshipType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACES: {
                return DocumentReference.DocumentRelationshipType.REPLACES;
            }
            case TRANSFORMS: {
                return DocumentReference.DocumentRelationshipType.TRANSFORMS;
            }
            case SIGNS: {
                return DocumentReference.DocumentRelationshipType.SIGNS;
            }
            case APPENDS: {
                return DocumentReference.DocumentRelationshipType.APPENDS;
            }
        }
        return DocumentReference.DocumentRelationshipType.NULL;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_30_40.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.setFormat(VersionConvertor_30_40.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasAttachment()) {
            tgt.setAttachment(VersionConvertor_30_40.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.setFormat(VersionConvertor_30_40.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasEncounter()) {
            tgt.addEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        for (CodeableConcept t : src.getEvent()) {
            tgt.addEvent(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_30_40.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_30_40.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_30_40.convertReference(src.getSourcePatientInfo()));
        }
        for (CodeableConcept t : src.getRelated()) {
            tgt.addRelated(VersionConvertor_30_40.convertDocumentReferenceContextRelatedComponent((DocumentReference.DocumentReferenceContextRelatedComponent)t));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounterFirstRep()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getEvent()) {
            tgt.addEvent(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(VersionConvertor_30_40.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(VersionConvertor_30_40.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(VersionConvertor_30_40.convertReference(src.getSourcePatientInfo()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getRelated()) {
            tgt.addRelated(VersionConvertor_30_40.convertDocumentReferenceContextRelatedComponent((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Reference convertDocumentReferenceContextRelatedComponent(DocumentReference.DocumentReferenceContextRelatedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Reference tgt = VersionConvertor_30_40.convertReference(src.getRef());
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContextRelatedComponent convertDocumentReferenceContextRelatedComponent(org.hl7.fhir.r4.model.Reference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContextRelatedComponent tgt = new DocumentReference.DocumentReferenceContextRelatedComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        tgt.setRef(VersionConvertor_30_40.convertReference(src));
        return tgt;
    }

    public static Encounter convertEncounter(org.hl7.fhir.dstu3.model.Encounter src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter tgt = new Encounter();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEncounterStatus(src.getStatus()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getStatusHistory()) {
            tgt.addStatusHistory(VersionConvertor_30_40.convertStatusHistoryComponent((Encounter.StatusHistoryComponent)t));
        }
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_30_40.convertCoding(src.getClass_()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getClassHistory()) {
            tgt.addClassHistory(VersionConvertor_30_40.convertClassHistoryComponent((Encounter.ClassHistoryComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEpisodeOfCare()) {
            tgt.addEpisodeOfCare(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIncomingReferral()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertEncounterParticipantComponent((Encounter.EncounterParticipantComponent)t));
        }
        if (src.hasAppointment()) {
            tgt.addAppointment(VersionConvertor_30_40.convertReference(src.getAppointment()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasLength()) {
            tgt.setLength(VersionConvertor_30_40.convertDuration(src.getLength()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReason()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDiagnosis()) {
            tgt.addDiagnosis(VersionConvertor_30_40.convertDiagnosisComponent((Encounter.DiagnosisComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAccount()) {
            tgt.addAccount(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasHospitalization()) {
            tgt.setHospitalization(VersionConvertor_30_40.convertEncounterHospitalizationComponent(src.getHospitalization()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertEncounterLocationComponent((Encounter.EncounterLocationComponent)t));
        }
        if (src.hasServiceProvider()) {
            tgt.setServiceProvider(VersionConvertor_30_40.convertReference(src.getServiceProvider()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_40.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Encounter convertEncounter(Encounter src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Encounter tgt = new org.hl7.fhir.dstu3.model.Encounter();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEncounterStatus(src.getStatus()));
        }
        for (Identifier t : src.getStatusHistory()) {
            tgt.addStatusHistory(VersionConvertor_30_40.convertStatusHistoryComponent((Encounter.StatusHistoryComponent)t));
        }
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_30_40.convertCoding(src.getClass_()));
        }
        for (Identifier t : src.getClassHistory()) {
            tgt.addClassHistory(VersionConvertor_30_40.convertClassHistoryComponent((Encounter.ClassHistoryComponent)t));
        }
        for (Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (Identifier t : src.getEpisodeOfCare()) {
            tgt.addEpisodeOfCare(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getBasedOn()) {
            tgt.addIncomingReferral(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertEncounterParticipantComponent((Encounter.EncounterParticipantComponent)t));
        }
        if (src.hasAppointment()) {
            tgt.setAppointment(VersionConvertor_30_40.convertReference(src.getAppointmentFirstRep()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasLength()) {
            tgt.setLength(VersionConvertor_30_40.convertDuration(src.getLength()));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getDiagnosis()) {
            tgt.addDiagnosis(VersionConvertor_30_40.convertDiagnosisComponent((Encounter.DiagnosisComponent)t));
        }
        for (Identifier t : src.getAccount()) {
            tgt.addAccount(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasHospitalization()) {
            tgt.setHospitalization(VersionConvertor_30_40.convertEncounterHospitalizationComponent(src.getHospitalization()));
        }
        for (Identifier t : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertEncounterLocationComponent((Encounter.EncounterLocationComponent)t));
        }
        if (src.hasServiceProvider()) {
            tgt.setServiceProvider(VersionConvertor_30_40.convertReference(src.getServiceProvider()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_40.convertReference(src.getPartOf()));
        }
        return tgt;
    }

    private static Encounter.EncounterStatus convertEncounterStatus(Encounter.EncounterStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return Encounter.EncounterStatus.PLANNED;
            }
            case ARRIVED: {
                return Encounter.EncounterStatus.ARRIVED;
            }
            case TRIAGED: {
                return Encounter.EncounterStatus.TRIAGED;
            }
            case INPROGRESS: {
                return Encounter.EncounterStatus.INPROGRESS;
            }
            case ONLEAVE: {
                return Encounter.EncounterStatus.ONLEAVE;
            }
            case FINISHED: {
                return Encounter.EncounterStatus.FINISHED;
            }
            case CANCELLED: {
                return Encounter.EncounterStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return Encounter.EncounterStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return Encounter.EncounterStatus.UNKNOWN;
            }
        }
        return Encounter.EncounterStatus.NULL;
    }

    private static Encounter.EncounterStatus convertEncounterStatus(Encounter.EncounterStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return Encounter.EncounterStatus.PLANNED;
            }
            case ARRIVED: {
                return Encounter.EncounterStatus.ARRIVED;
            }
            case TRIAGED: {
                return Encounter.EncounterStatus.TRIAGED;
            }
            case INPROGRESS: {
                return Encounter.EncounterStatus.INPROGRESS;
            }
            case ONLEAVE: {
                return Encounter.EncounterStatus.ONLEAVE;
            }
            case FINISHED: {
                return Encounter.EncounterStatus.FINISHED;
            }
            case CANCELLED: {
                return Encounter.EncounterStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return Encounter.EncounterStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return Encounter.EncounterStatus.UNKNOWN;
            }
        }
        return Encounter.EncounterStatus.NULL;
    }

    public static Encounter.StatusHistoryComponent convertStatusHistoryComponent(Encounter.StatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.StatusHistoryComponent tgt = new Encounter.StatusHistoryComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEncounterStatus(src.getStatus()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.StatusHistoryComponent convertStatusHistoryComponent(Encounter.StatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.StatusHistoryComponent tgt = new Encounter.StatusHistoryComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEncounterStatus(src.getStatus()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.ClassHistoryComponent convertClassHistoryComponent(Encounter.ClassHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.ClassHistoryComponent tgt = new Encounter.ClassHistoryComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_30_40.convertCoding(src.getClass_()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.ClassHistoryComponent convertClassHistoryComponent(Encounter.ClassHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.ClassHistoryComponent tgt = new Encounter.ClassHistoryComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasClass_()) {
            tgt.setClass_(VersionConvertor_30_40.convertCoding(src.getClass_()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.EncounterParticipantComponent convertEncounterParticipantComponent(Encounter.EncounterParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterParticipantComponent tgt = new Encounter.EncounterParticipantComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasIndividual()) {
            tgt.setIndividual(VersionConvertor_30_40.convertReference(src.getIndividual()));
        }
        return tgt;
    }

    public static Encounter.EncounterParticipantComponent convertEncounterParticipantComponent(Encounter.EncounterParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterParticipantComponent tgt = new Encounter.EncounterParticipantComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasIndividual()) {
            tgt.setIndividual(VersionConvertor_30_40.convertReference(src.getIndividual()));
        }
        return tgt;
    }

    public static Encounter.DiagnosisComponent convertDiagnosisComponent(Encounter.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.DiagnosisComponent tgt = new Encounter.DiagnosisComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setUse(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        return tgt;
    }

    public static Encounter.DiagnosisComponent convertDiagnosisComponent(Encounter.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.DiagnosisComponent tgt = new Encounter.DiagnosisComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasUse()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getUse()));
        }
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        return tgt;
    }

    public static Encounter.EncounterHospitalizationComponent convertEncounterHospitalizationComponent(Encounter.EncounterHospitalizationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterHospitalizationComponent tgt = new Encounter.EncounterHospitalizationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasPreAdmissionIdentifier()) {
            tgt.setPreAdmissionIdentifier(VersionConvertor_30_40.convertIdentifier(src.getPreAdmissionIdentifier()));
        }
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_40.convertReference(src.getOrigin()));
        }
        if (src.hasAdmitSource()) {
            tgt.setAdmitSource(VersionConvertor_30_40.convertCodeableConcept(src.getAdmitSource()));
        }
        if (src.hasReAdmission()) {
            tgt.setReAdmission(VersionConvertor_30_40.convertCodeableConcept(src.getReAdmission()));
        }
        for (CodeableConcept t : src.getDietPreference()) {
            tgt.addDietPreference(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getSpecialCourtesy()) {
            tgt.addSpecialCourtesy(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getSpecialArrangement()) {
            tgt.addSpecialArrangement(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_40.convertReference(src.getDestination()));
        }
        if (src.hasDischargeDisposition()) {
            tgt.setDischargeDisposition(VersionConvertor_30_40.convertCodeableConcept(src.getDischargeDisposition()));
        }
        return tgt;
    }

    public static Encounter.EncounterHospitalizationComponent convertEncounterHospitalizationComponent(Encounter.EncounterHospitalizationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterHospitalizationComponent tgt = new Encounter.EncounterHospitalizationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasPreAdmissionIdentifier()) {
            tgt.setPreAdmissionIdentifier(VersionConvertor_30_40.convertIdentifier(src.getPreAdmissionIdentifier()));
        }
        if (src.hasOrigin()) {
            tgt.setOrigin(VersionConvertor_30_40.convertReference(src.getOrigin()));
        }
        if (src.hasAdmitSource()) {
            tgt.setAdmitSource(VersionConvertor_30_40.convertCodeableConcept(src.getAdmitSource()));
        }
        if (src.hasReAdmission()) {
            tgt.setReAdmission(VersionConvertor_30_40.convertCodeableConcept(src.getReAdmission()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getDietPreference()) {
            tgt.addDietPreference(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getSpecialCourtesy()) {
            tgt.addSpecialCourtesy(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getSpecialArrangement()) {
            tgt.addSpecialArrangement(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_40.convertReference(src.getDestination()));
        }
        if (src.hasDischargeDisposition()) {
            tgt.setDischargeDisposition(VersionConvertor_30_40.convertCodeableConcept(src.getDischargeDisposition()));
        }
        return tgt;
    }

    public static Encounter.EncounterLocationComponent convertEncounterLocationComponent(Encounter.EncounterLocationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterLocationComponent tgt = new Encounter.EncounterLocationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEncounterLocationStatus(src.getStatus()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Encounter.EncounterLocationComponent convertEncounterLocationComponent(Encounter.EncounterLocationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Encounter.EncounterLocationComponent tgt = new Encounter.EncounterLocationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEncounterLocationStatus(src.getStatus()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    private static Encounter.EncounterLocationStatus convertEncounterLocationStatus(Encounter.EncounterLocationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return Encounter.EncounterLocationStatus.PLANNED;
            }
            case ACTIVE: {
                return Encounter.EncounterLocationStatus.ACTIVE;
            }
            case RESERVED: {
                return Encounter.EncounterLocationStatus.RESERVED;
            }
            case COMPLETED: {
                return Encounter.EncounterLocationStatus.COMPLETED;
            }
        }
        return Encounter.EncounterLocationStatus.NULL;
    }

    private static Encounter.EncounterLocationStatus convertEncounterLocationStatus(Encounter.EncounterLocationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return Encounter.EncounterLocationStatus.PLANNED;
            }
            case ACTIVE: {
                return Encounter.EncounterLocationStatus.ACTIVE;
            }
            case RESERVED: {
                return Encounter.EncounterLocationStatus.RESERVED;
            }
            case COMPLETED: {
                return Encounter.EncounterLocationStatus.COMPLETED;
            }
        }
        return Encounter.EncounterLocationStatus.NULL;
    }

    public static org.hl7.fhir.r4.model.Endpoint convertEndpoint(Endpoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Endpoint tgt = new org.hl7.fhir.r4.model.Endpoint();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEndpointStatus(src.getStatus()));
        }
        if (src.hasConnectionType()) {
            tgt.setConnectionType(VersionConvertor_30_40.convertCoding(src.getConnectionType()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPayloadType()) {
            tgt.addPayloadType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPayloadMimeType()) {
            tgt.addPayloadMimeType((String)t.getValue());
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getHeader()) {
            tgt.addHeader((String)t.getValue());
        }
        return tgt;
    }

    public static Endpoint convertEndpoint(org.hl7.fhir.r4.model.Endpoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Endpoint tgt = new Endpoint();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEndpointStatus(src.getStatus()));
        }
        if (src.hasConnectionType()) {
            tgt.setConnectionType(VersionConvertor_30_40.convertCoding(src.getConnectionType()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (Identifier t : src.getPayloadType()) {
            tgt.addPayloadType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getPayloadMimeType()) {
            tgt.addPayloadMimeType((String)t.getValue());
        }
        if (src.hasAddress()) {
            tgt.setAddress(src.getAddress());
        }
        for (Identifier t : src.getHeader()) {
            tgt.addHeader((String)t.getValue());
        }
        return tgt;
    }

    private static Endpoint.EndpointStatus convertEndpointStatus(Endpoint.EndpointStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Endpoint.EndpointStatus.ACTIVE;
            }
            case SUSPENDED: {
                return Endpoint.EndpointStatus.SUSPENDED;
            }
            case ERROR: {
                return Endpoint.EndpointStatus.ERROR;
            }
            case OFF: {
                return Endpoint.EndpointStatus.OFF;
            }
            case ENTEREDINERROR: {
                return Endpoint.EndpointStatus.ENTEREDINERROR;
            }
            case TEST: {
                return Endpoint.EndpointStatus.TEST;
            }
        }
        return Endpoint.EndpointStatus.NULL;
    }

    private static Endpoint.EndpointStatus convertEndpointStatus(Endpoint.EndpointStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Endpoint.EndpointStatus.ACTIVE;
            }
            case SUSPENDED: {
                return Endpoint.EndpointStatus.SUSPENDED;
            }
            case ERROR: {
                return Endpoint.EndpointStatus.ERROR;
            }
            case OFF: {
                return Endpoint.EndpointStatus.OFF;
            }
            case ENTEREDINERROR: {
                return Endpoint.EndpointStatus.ENTEREDINERROR;
            }
            case TEST: {
                return Endpoint.EndpointStatus.TEST;
            }
        }
        return Endpoint.EndpointStatus.NULL;
    }

    public static org.hl7.fhir.r4.model.EpisodeOfCare convertEpisodeOfCare(EpisodeOfCare src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.EpisodeOfCare tgt = new org.hl7.fhir.r4.model.EpisodeOfCare();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEpisodeOfCareStatus(src.getStatus()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getStatusHistory()) {
            tgt.addStatusHistory(VersionConvertor_30_40.convertEpisodeOfCareStatusHistoryComponent((EpisodeOfCare.EpisodeOfCareStatusHistoryComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDiagnosis()) {
            tgt.addDiagnosis(VersionConvertor_30_40.convertDiagnosisComponent((EpisodeOfCare.DiagnosisComponent)t));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReferralRequest()) {
            tgt.addReferralRequest(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasCareManager()) {
            tgt.setCareManager(VersionConvertor_30_40.convertReference(src.getCareManager()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTeam()) {
            tgt.addTeam(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAccount()) {
            tgt.addAccount(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static EpisodeOfCare convertEpisodeOfCare(org.hl7.fhir.r4.model.EpisodeOfCare src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare tgt = new EpisodeOfCare();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEpisodeOfCareStatus(src.getStatus()));
        }
        for (Identifier t : src.getStatusHistory()) {
            tgt.addStatusHistory(VersionConvertor_30_40.convertEpisodeOfCareStatusHistoryComponent((EpisodeOfCare.EpisodeOfCareStatusHistoryComponent)t));
        }
        for (Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getDiagnosis()) {
            tgt.addDiagnosis(VersionConvertor_30_40.convertDiagnosisComponent((EpisodeOfCare.DiagnosisComponent)t));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        for (Identifier t : src.getReferralRequest()) {
            tgt.addReferralRequest(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasCareManager()) {
            tgt.setCareManager(VersionConvertor_30_40.convertReference(src.getCareManager()));
        }
        for (Identifier t : src.getTeam()) {
            tgt.addTeam(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getAccount()) {
            tgt.addAccount(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    private static EpisodeOfCare.EpisodeOfCareStatus convertEpisodeOfCareStatus(EpisodeOfCare.EpisodeOfCareStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return EpisodeOfCare.EpisodeOfCareStatus.PLANNED;
            }
            case WAITLIST: {
                return EpisodeOfCare.EpisodeOfCareStatus.WAITLIST;
            }
            case ACTIVE: {
                return EpisodeOfCare.EpisodeOfCareStatus.ACTIVE;
            }
            case ONHOLD: {
                return EpisodeOfCare.EpisodeOfCareStatus.ONHOLD;
            }
            case FINISHED: {
                return EpisodeOfCare.EpisodeOfCareStatus.FINISHED;
            }
            case CANCELLED: {
                return EpisodeOfCare.EpisodeOfCareStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return EpisodeOfCare.EpisodeOfCareStatus.ENTEREDINERROR;
            }
        }
        return EpisodeOfCare.EpisodeOfCareStatus.NULL;
    }

    private static EpisodeOfCare.EpisodeOfCareStatus convertEpisodeOfCareStatus(EpisodeOfCare.EpisodeOfCareStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return EpisodeOfCare.EpisodeOfCareStatus.PLANNED;
            }
            case WAITLIST: {
                return EpisodeOfCare.EpisodeOfCareStatus.WAITLIST;
            }
            case ACTIVE: {
                return EpisodeOfCare.EpisodeOfCareStatus.ACTIVE;
            }
            case ONHOLD: {
                return EpisodeOfCare.EpisodeOfCareStatus.ONHOLD;
            }
            case FINISHED: {
                return EpisodeOfCare.EpisodeOfCareStatus.FINISHED;
            }
            case CANCELLED: {
                return EpisodeOfCare.EpisodeOfCareStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return EpisodeOfCare.EpisodeOfCareStatus.ENTEREDINERROR;
            }
        }
        return EpisodeOfCare.EpisodeOfCareStatus.NULL;
    }

    public static EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEpisodeOfCareStatus(src.getStatus()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertEpisodeOfCareStatus(src.getStatus()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static EpisodeOfCare.DiagnosisComponent convertDiagnosisComponent(EpisodeOfCare.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.DiagnosisComponent tgt = new EpisodeOfCare.DiagnosisComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        return tgt;
    }

    public static EpisodeOfCare.DiagnosisComponent convertDiagnosisComponent(EpisodeOfCare.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        EpisodeOfCare.DiagnosisComponent tgt = new EpisodeOfCare.DiagnosisComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Parameters convertExpansionProfile(ExpansionProfile src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Parameters tgt = new org.hl7.fhir.r4.model.Parameters();
        if (src.hasUrl()) {
            tgt.addParameter("profile-url", src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.addParameter("profile-version", src.getVersion());
        }
        if (src.hasName()) {
            tgt.addParameter("profile-name", src.getName());
        }
        if (src.hasStatus()) {
            tgt.addParameter("profile-status", src.getStatus().toCode());
        }
        for (ExpansionProfile.ExpansionProfileFixedVersionComponent t : src.getFixedVersion()) {
            if (t.getMode() == ExpansionProfile.SystemVersionProcessingMode.DEFAULT) {
                tgt.addParameter("system-version", t.getSystem() + "|" + t.getVersion());
                continue;
            }
            if (t.getMode() == ExpansionProfile.SystemVersionProcessingMode.CHECK) {
                tgt.addParameter("check-system-version", t.getSystem() + "|" + t.getVersion());
                continue;
            }
            if (t.getMode() != ExpansionProfile.SystemVersionProcessingMode.OVERRIDE) continue;
            tgt.addParameter("force-system-version", t.getSystem() + "|" + t.getVersion());
        }
        if (src.hasExcludedSystem()) {
            tgt.addParameter("exclude-system", src.getExcludedSystem().getSystem() + "|" + src.getExcludedSystem().getVersion());
        }
        if (src.hasIncludeDesignations()) {
            tgt.addParameter("includeDesignations", src.getIncludeDesignations());
        }
        for (ExpansionProfile.ExpansionProfileFixedVersionComponent t : src.getDesignation().getInclude().getDesignation()) {
            if (t.hasLanguage()) {
                tgt.addParameter("designation", "urn:ietf:bcp:47|" + t.getLanguage());
            }
            if (!t.hasUse()) continue;
            tgt.addParameter("designation", t.getUse().getSystem() + "|" + t.getUse().getCode());
        }
        if (src.hasIncludeDefinition()) {
            tgt.addParameter("includeDefinition", src.getIncludeDefinition());
        }
        if (src.hasActiveOnly()) {
            tgt.addParameter("activeOnly", src.getActiveOnly());
        }
        if (src.hasExcludeNested()) {
            tgt.addParameter("excludeNested", src.getExcludeNested());
        }
        if (src.hasExcludeNotForUI()) {
            tgt.addParameter("excludeNotForUI", src.getExcludeNotForUI());
        }
        if (src.hasExcludePostCoordinated()) {
            tgt.addParameter("excludePostCoordinated", src.getExcludePostCoordinated());
        }
        if (src.hasDisplayLanguage()) {
            tgt.addParameter("excludePostCoordinated", src.getDisplayLanguage());
        }
        if (src.hasLimitedExpansion()) {
            tgt.addParameter("limitedExpansion", src.getLimitedExpansion());
        }
        return tgt;
    }

    public static ExpansionProfile convertExpansionProfile(org.hl7.fhir.r4.model.Parameters src) throws FHIRException {
        String[] v;
        if (src == null) {
            return null;
        }
        ExpansionProfile tgt = new ExpansionProfile();
        if (src.hasParameter("profile-url")) {
            tgt.setUrl(src.getParameter("profile-url").primitiveValue());
        }
        if (src.hasParameter("profile-version")) {
            tgt.setVersion(src.getParameter("profile-version").primitiveValue());
        }
        if (src.hasParameter("profile-name")) {
            tgt.setName(src.getParameter("profile-name").primitiveValue());
        }
        if (src.hasParameter("profile-status")) {
            tgt.setStatus(Enumerations.PublicationStatus.fromCode((String)src.getParameter("profile-status").primitiveValue()));
        }
        for (org.hl7.fhir.r4.model.Type t : src.getParameters("system-version")) {
            v = t.primitiveValue().split("\\|");
            tgt.addFixedVersion().setSystem(v[0]).setVersion(v[1]).setMode(ExpansionProfile.SystemVersionProcessingMode.DEFAULT);
        }
        for (org.hl7.fhir.r4.model.Type t : src.getParameters("force-system-version")) {
            v = t.primitiveValue().split("\\|");
            tgt.addFixedVersion().setSystem(v[0]).setVersion(v[1]).setMode(ExpansionProfile.SystemVersionProcessingMode.OVERRIDE);
        }
        for (org.hl7.fhir.r4.model.Type t : src.getParameters("check-system-version")) {
            v = t.primitiveValue().split("\\|");
            tgt.addFixedVersion().setSystem(v[0]).setVersion(v[1]).setMode(ExpansionProfile.SystemVersionProcessingMode.CHECK);
        }
        for (org.hl7.fhir.r4.model.Type t : src.getParameters("exclude-system")) {
            v = t.primitiveValue().split("\\|");
            tgt.getExcludedSystem().setSystem(v[0]).setVersion(v[1]);
        }
        if (src.hasParameter("includeDesignations")) {
            tgt.setIncludeDesignations(src.getParameterBool(""));
        }
        for (org.hl7.fhir.r4.model.Type t : src.getParameters("designation")) {
            v = t.primitiveValue().split("\\|");
            if ("urn:ietf:bcp:47".equals(v[0])) {
                tgt.getDesignation().getInclude().addDesignation().setLanguage(v[1]);
                continue;
            }
            tgt.getDesignation().getInclude().addDesignation().getUse().setSystem(v[0]).setCode(v[1]);
        }
        if (src.hasParameter("includeDefinition")) {
            tgt.setIncludeDefinition(src.getParameterBool("includeDefinition"));
        }
        if (src.hasParameter("activeOnly")) {
            tgt.setActiveOnly(src.getParameterBool("activeOnly"));
        }
        if (src.hasParameter("excludeNested")) {
            tgt.setExcludeNested(src.getParameterBool("excludeNested"));
        }
        if (src.hasParameter("excludeNotForUI")) {
            tgt.setExcludeNotForUI(src.getParameterBool("excludeNotForUI"));
        }
        if (src.hasParameter("excludeNotForUI")) {
            tgt.setExcludePostCoordinated(src.getParameterBool("excludeNotForUI"));
        }
        if (src.hasParameter("displayLanguage")) {
            tgt.setDisplayLanguage(src.getParameter("displayLanguage").primitiveValue());
        }
        if (src.hasParameter("limitedExpansion")) {
            tgt.setLimitedExpansion(src.getParameterBool("getParameterBool"));
        }
        return tgt;
    }

    public static FamilyMemberHistory convertFamilyMemberHistory(org.hl7.fhir.dstu3.model.FamilyMemberHistory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory tgt = new FamilyMemberHistory();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDefinition()) {
            tgt.addInstantiatesCanonical(t.getReference());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertFamilyHistoryStatus(src.getStatus()));
        }
        if (src.hasNotDoneReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getNotDoneReason()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(VersionConvertor_30_40.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasBorn()) {
            tgt.setBorn(VersionConvertor_30_40.convertType(src.getBorn()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_30_40.convertType(src.getAge()));
        }
        if (src.hasEstimatedAge()) {
            tgt.setEstimatedAge(src.getEstimatedAge());
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_30_40.convertType(src.getDeceased()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCondition()) {
            tgt.addCondition(VersionConvertor_30_40.convertFamilyMemberHistoryConditionComponent((FamilyMemberHistory.FamilyMemberHistoryConditionComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.FamilyMemberHistory convertFamilyMemberHistory(FamilyMemberHistory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.FamilyMemberHistory tgt = new org.hl7.fhir.dstu3.model.FamilyMemberHistory();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getInstantiatesCanonical()) {
            tgt.addDefinition(new Reference((String)t.getValue()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertFamilyHistoryStatus(src.getStatus()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setNotDoneReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(VersionConvertor_30_40.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasBorn()) {
            tgt.setBorn(VersionConvertor_30_40.convertType(src.getBorn()));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_30_40.convertType(src.getAge()));
        }
        if (src.hasEstimatedAge()) {
            tgt.setEstimatedAge(src.getEstimatedAge());
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_30_40.convertType(src.getDeceased()));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        for (Identifier t : src.getCondition()) {
            tgt.addCondition(VersionConvertor_30_40.convertFamilyMemberHistoryConditionComponent((FamilyMemberHistory.FamilyMemberHistoryConditionComponent)t));
        }
        return tgt;
    }

    private static FamilyMemberHistory.FamilyHistoryStatus convertFamilyHistoryStatus(FamilyMemberHistory.FamilyHistoryStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PARTIAL: {
                return FamilyMemberHistory.FamilyHistoryStatus.PARTIAL;
            }
            case COMPLETED: {
                return FamilyMemberHistory.FamilyHistoryStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR;
            }
            case HEALTHUNKNOWN: {
                return FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN;
            }
        }
        return FamilyMemberHistory.FamilyHistoryStatus.NULL;
    }

    private static FamilyMemberHistory.FamilyHistoryStatus convertFamilyHistoryStatus(FamilyMemberHistory.FamilyHistoryStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PARTIAL: {
                return FamilyMemberHistory.FamilyHistoryStatus.PARTIAL;
            }
            case COMPLETED: {
                return FamilyMemberHistory.FamilyHistoryStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR;
            }
            case HEALTHUNKNOWN: {
                return FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN;
            }
        }
        return FamilyMemberHistory.FamilyHistoryStatus.NULL;
    }

    private static Enumerations.AdministrativeGender convertAdministrativeGender(Enumerations.AdministrativeGender src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MALE: {
                return Enumerations.AdministrativeGender.MALE;
            }
            case FEMALE: {
                return Enumerations.AdministrativeGender.FEMALE;
            }
            case OTHER: {
                return Enumerations.AdministrativeGender.OTHER;
            }
            case UNKNOWN: {
                return Enumerations.AdministrativeGender.UNKNOWN;
            }
        }
        return Enumerations.AdministrativeGender.NULL;
    }

    private static Enumerations.AdministrativeGender convertAdministrativeGender(Enumerations.AdministrativeGender src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MALE: {
                return Enumerations.AdministrativeGender.MALE;
            }
            case FEMALE: {
                return Enumerations.AdministrativeGender.FEMALE;
            }
            case OTHER: {
                return Enumerations.AdministrativeGender.OTHER;
            }
            case UNKNOWN: {
                return Enumerations.AdministrativeGender.UNKNOWN;
            }
        }
        return Enumerations.AdministrativeGender.NULL;
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        for (Annotation t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(t));
        }
        return tgt;
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasOnset()) {
            tgt.setOnset(VersionConvertor_30_40.convertType(src.getOnset()));
        }
        for (org.hl7.fhir.r4.model.Annotation t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Flag convertFlag(Flag src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Flag tgt = new org.hl7.fhir.r4.model.Flag();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertFlagStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    public static Flag convertFlag(org.hl7.fhir.r4.model.Flag src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Flag tgt = new Flag();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertFlagStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        return tgt;
    }

    private static Flag.FlagStatus convertFlagStatus(Flag.FlagStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Flag.FlagStatus.ACTIVE;
            }
            case INACTIVE: {
                return Flag.FlagStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return Flag.FlagStatus.ENTEREDINERROR;
            }
        }
        return Flag.FlagStatus.NULL;
    }

    private static Flag.FlagStatus convertFlagStatus(Flag.FlagStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Flag.FlagStatus.ACTIVE;
            }
            case INACTIVE: {
                return Flag.FlagStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return Flag.FlagStatus.ENTEREDINERROR;
            }
        }
        return Flag.FlagStatus.NULL;
    }

    public static org.hl7.fhir.r4.model.Goal convertGoal(Goal src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Goal tgt = new org.hl7.fhir.r4.model.Goal();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setLifecycleStatus(VersionConvertor_30_40.convertGoalStatus(src.getStatus()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(VersionConvertor_30_40.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasStart()) {
            tgt.setStart(VersionConvertor_30_40.convertType(src.getStart()));
        }
        if (src.hasTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertGoalTargetComponent(src.getTarget()));
        }
        if (src.hasStatusDate()) {
            tgt.setStatusDate(src.getStatusDate());
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(src.getStatusReason());
        }
        if (src.hasExpressedBy()) {
            tgt.setExpressedBy(VersionConvertor_30_40.convertReference(src.getExpressedBy()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getOutcomeCode()) {
            tgt.addOutcomeCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getOutcomeReference()) {
            tgt.addOutcomeReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static Goal convertGoal(org.hl7.fhir.r4.model.Goal src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal tgt = new Goal();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasLifecycleStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertGoalStatus(src.getLifecycleStatus()));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(VersionConvertor_30_40.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasStart()) {
            tgt.setStart(VersionConvertor_30_40.convertType(src.getStart()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertGoalTargetComponent(src.getTargetFirstRep()));
        }
        if (src.hasStatusDate()) {
            tgt.setStatusDate(src.getStatusDate());
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(src.getStatusReason());
        }
        if (src.hasExpressedBy()) {
            tgt.setExpressedBy(VersionConvertor_30_40.convertReference(src.getExpressedBy()));
        }
        for (Identifier t : src.getAddresses()) {
            tgt.addAddresses(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        for (Identifier t : src.getOutcomeCode()) {
            tgt.addOutcomeCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getOutcomeReference()) {
            tgt.addOutcomeReference(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    private static Goal.GoalLifecycleStatus convertGoalStatus(Goal.GoalStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return Goal.GoalLifecycleStatus.PROPOSED;
            }
            case ACCEPTED: {
                return Goal.GoalLifecycleStatus.ACCEPTED;
            }
            case PLANNED: {
                return Goal.GoalLifecycleStatus.PLANNED;
            }
            case INPROGRESS: {
                return Goal.GoalLifecycleStatus.ACTIVE;
            }
            case ONTARGET: {
                return Goal.GoalLifecycleStatus.ACTIVE;
            }
            case AHEADOFTARGET: {
                return Goal.GoalLifecycleStatus.ACTIVE;
            }
            case BEHINDTARGET: {
                return Goal.GoalLifecycleStatus.ACTIVE;
            }
            case SUSTAINING: {
                return Goal.GoalLifecycleStatus.ACTIVE;
            }
            case ACHIEVED: {
                return Goal.GoalLifecycleStatus.COMPLETED;
            }
            case ONHOLD: {
                return Goal.GoalLifecycleStatus.ONHOLD;
            }
            case CANCELLED: {
                return Goal.GoalLifecycleStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return Goal.GoalLifecycleStatus.ENTEREDINERROR;
            }
            case REJECTED: {
                return Goal.GoalLifecycleStatus.REJECTED;
            }
        }
        return Goal.GoalLifecycleStatus.NULL;
    }

    private static Goal.GoalStatus convertGoalStatus(Goal.GoalLifecycleStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return Goal.GoalStatus.PROPOSED;
            }
            case ACCEPTED: {
                return Goal.GoalStatus.ACCEPTED;
            }
            case PLANNED: {
                return Goal.GoalStatus.PLANNED;
            }
            case ACTIVE: {
                return Goal.GoalStatus.INPROGRESS;
            }
            case COMPLETED: {
                return Goal.GoalStatus.ACHIEVED;
            }
            case ONHOLD: {
                return Goal.GoalStatus.ONHOLD;
            }
            case CANCELLED: {
                return Goal.GoalStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return Goal.GoalStatus.ENTEREDINERROR;
            }
            case REJECTED: {
                return Goal.GoalStatus.REJECTED;
            }
        }
        return Goal.GoalStatus.NULL;
    }

    public static Goal.GoalTargetComponent convertGoalTargetComponent(Goal.GoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal.GoalTargetComponent tgt = new Goal.GoalTargetComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMeasure()) {
            tgt.setMeasure(VersionConvertor_30_40.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(VersionConvertor_30_40.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(VersionConvertor_30_40.convertType(src.getDue()));
        }
        return tgt;
    }

    public static Goal.GoalTargetComponent convertGoalTargetComponent(Goal.GoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal.GoalTargetComponent tgt = new Goal.GoalTargetComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMeasure()) {
            tgt.setMeasure(VersionConvertor_30_40.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(VersionConvertor_30_40.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(VersionConvertor_30_40.convertType(src.getDue()));
        }
        return tgt;
    }

    public static GraphDefinition convertGraphDefinition(org.hl7.fhir.dstu3.model.GraphDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition tgt = new GraphDefinition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasProfile()) {
            tgt.setProfile(src.getProfile());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertGraphDefinitionLinkComponent((GraphDefinition.GraphDefinitionLinkComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.GraphDefinition convertGraphDefinition(GraphDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.GraphDefinition tgt = new org.hl7.fhir.dstu3.model.GraphDefinition();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasProfile()) {
            tgt.setProfile(src.getProfile());
        }
        for (ContactDetail t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertGraphDefinitionLinkComponent((GraphDefinition.GraphDefinitionLinkComponent)t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkComponent convertGraphDefinitionLinkComponent(GraphDefinition.GraphDefinitionLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkComponent tgt = new GraphDefinition.GraphDefinitionLinkComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasSliceName()) {
            tgt.setSliceName(src.getSliceName());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (GraphDefinition.GraphDefinitionLinkTargetComponent t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertGraphDefinitionLinkTargetComponent(t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkComponent convertGraphDefinitionLinkComponent(GraphDefinition.GraphDefinitionLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkComponent tgt = new GraphDefinition.GraphDefinitionLinkComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasPath()) {
            tgt.setPath(src.getPath());
        }
        if (src.hasSliceName()) {
            tgt.setSliceName(src.getSliceName());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (GraphDefinition.GraphDefinitionLinkTargetComponent t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertGraphDefinitionLinkTargetComponent(t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetComponent convertGraphDefinitionLinkTargetComponent(GraphDefinition.GraphDefinitionLinkTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasProfile()) {
            tgt.setProfile(src.getProfile());
        }
        for (GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent t : src.getCompartment()) {
            tgt.addCompartment(VersionConvertor_30_40.convertGraphDefinitionLinkTargetCompartmentComponent(t));
        }
        for (GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertGraphDefinitionLinkComponent((GraphDefinition.GraphDefinitionLinkComponent)t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetComponent convertGraphDefinitionLinkTargetComponent(GraphDefinition.GraphDefinitionLinkTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasProfile()) {
            tgt.setProfile(src.getProfile());
        }
        for (GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent t : src.getCompartment()) {
            tgt.addCompartment(VersionConvertor_30_40.convertGraphDefinitionLinkTargetCompartmentComponent(t));
        }
        for (GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertGraphDefinitionLinkComponent((GraphDefinition.GraphDefinitionLinkComponent)t));
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent convertGraphDefinitionLinkTargetCompartmentComponent(GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCompartmentCode(src.getCode()));
        }
        if (src.hasRule()) {
            tgt.setRule(VersionConvertor_30_40.convertGraphCompartmentRule(src.getRule()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent convertGraphDefinitionLinkTargetCompartmentComponent(GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent tgt = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCompartmentCode(src.getCode()));
        }
        if (src.hasRule()) {
            tgt.setRule(VersionConvertor_30_40.convertGraphCompartmentRule(src.getRule()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    private static GraphDefinition.CompartmentCode convertCompartmentCode(GraphDefinition.CompartmentCode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PATIENT: {
                return GraphDefinition.CompartmentCode.PATIENT;
            }
            case ENCOUNTER: {
                return GraphDefinition.CompartmentCode.ENCOUNTER;
            }
            case RELATEDPERSON: {
                return GraphDefinition.CompartmentCode.RELATEDPERSON;
            }
            case PRACTITIONER: {
                return GraphDefinition.CompartmentCode.PRACTITIONER;
            }
            case DEVICE: {
                return GraphDefinition.CompartmentCode.DEVICE;
            }
        }
        return GraphDefinition.CompartmentCode.NULL;
    }

    private static GraphDefinition.CompartmentCode convertCompartmentCode(GraphDefinition.CompartmentCode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PATIENT: {
                return GraphDefinition.CompartmentCode.PATIENT;
            }
            case ENCOUNTER: {
                return GraphDefinition.CompartmentCode.ENCOUNTER;
            }
            case RELATEDPERSON: {
                return GraphDefinition.CompartmentCode.RELATEDPERSON;
            }
            case PRACTITIONER: {
                return GraphDefinition.CompartmentCode.PRACTITIONER;
            }
            case DEVICE: {
                return GraphDefinition.CompartmentCode.DEVICE;
            }
        }
        return GraphDefinition.CompartmentCode.NULL;
    }

    private static GraphDefinition.GraphCompartmentRule convertGraphCompartmentRule(GraphDefinition.GraphCompartmentRule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IDENTICAL: {
                return GraphDefinition.GraphCompartmentRule.IDENTICAL;
            }
            case MATCHING: {
                return GraphDefinition.GraphCompartmentRule.MATCHING;
            }
            case DIFFERENT: {
                return GraphDefinition.GraphCompartmentRule.DIFFERENT;
            }
            case CUSTOM: {
                return GraphDefinition.GraphCompartmentRule.CUSTOM;
            }
        }
        return GraphDefinition.GraphCompartmentRule.NULL;
    }

    private static GraphDefinition.GraphCompartmentRule convertGraphCompartmentRule(GraphDefinition.GraphCompartmentRule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IDENTICAL: {
                return GraphDefinition.GraphCompartmentRule.IDENTICAL;
            }
            case MATCHING: {
                return GraphDefinition.GraphCompartmentRule.MATCHING;
            }
            case DIFFERENT: {
                return GraphDefinition.GraphCompartmentRule.DIFFERENT;
            }
            case CUSTOM: {
                return GraphDefinition.GraphCompartmentRule.CUSTOM;
            }
        }
        return GraphDefinition.GraphCompartmentRule.NULL;
    }

    public static Group convertGroup(org.hl7.fhir.dstu3.model.Group src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group tgt = new Group();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertGroupType(src.getType()));
        }
        if (src.hasActual()) {
            tgt.setActual(src.getActual());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(src.getQuantity());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_30_40.convertGroupCharacteristicComponent((Group.GroupCharacteristicComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getMember()) {
            tgt.addMember(VersionConvertor_30_40.convertGroupMemberComponent((Group.GroupMemberComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Group convertGroup(Group src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Group tgt = new org.hl7.fhir.dstu3.model.Group();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertGroupType(src.getType()));
        }
        if (src.hasActual()) {
            tgt.setActual(src.getActual());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(src.getQuantity());
        }
        for (Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_30_40.convertGroupCharacteristicComponent((Group.GroupCharacteristicComponent)t));
        }
        for (Identifier t : src.getMember()) {
            tgt.addMember(VersionConvertor_30_40.convertGroupMemberComponent((Group.GroupMemberComponent)t));
        }
        return tgt;
    }

    private static Group.GroupType convertGroupType(Group.GroupType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PERSON: {
                return Group.GroupType.PERSON;
            }
            case ANIMAL: {
                return Group.GroupType.ANIMAL;
            }
            case PRACTITIONER: {
                return Group.GroupType.PRACTITIONER;
            }
            case DEVICE: {
                return Group.GroupType.DEVICE;
            }
            case MEDICATION: {
                return Group.GroupType.MEDICATION;
            }
            case SUBSTANCE: {
                return Group.GroupType.SUBSTANCE;
            }
        }
        return Group.GroupType.NULL;
    }

    private static Group.GroupType convertGroupType(Group.GroupType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PERSON: {
                return Group.GroupType.PERSON;
            }
            case ANIMAL: {
                return Group.GroupType.ANIMAL;
            }
            case PRACTITIONER: {
                return Group.GroupType.PRACTITIONER;
            }
            case DEVICE: {
                return Group.GroupType.DEVICE;
            }
            case MEDICATION: {
                return Group.GroupType.MEDICATION;
            }
            case SUBSTANCE: {
                return Group.GroupType.SUBSTANCE;
            }
        }
        return Group.GroupType.NULL;
    }

    public static Group.GroupCharacteristicComponent convertGroupCharacteristicComponent(Group.GroupCharacteristicComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group.GroupCharacteristicComponent tgt = new Group.GroupCharacteristicComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasExclude()) {
            tgt.setExclude(src.getExclude());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Group.GroupCharacteristicComponent convertGroupCharacteristicComponent(Group.GroupCharacteristicComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group.GroupCharacteristicComponent tgt = new Group.GroupCharacteristicComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasExclude()) {
            tgt.setExclude(src.getExclude());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Group.GroupMemberComponent convertGroupMemberComponent(Group.GroupMemberComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group.GroupMemberComponent tgt = new Group.GroupMemberComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_30_40.convertReference(src.getEntity()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasInactive()) {
            tgt.setInactive(src.getInactive());
        }
        return tgt;
    }

    public static Group.GroupMemberComponent convertGroupMemberComponent(Group.GroupMemberComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Group.GroupMemberComponent tgt = new Group.GroupMemberComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasEntity()) {
            tgt.setEntity(VersionConvertor_30_40.convertReference(src.getEntity()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasInactive()) {
            tgt.setInactive(src.getInactive());
        }
        return tgt;
    }

    public static HealthcareService convertHealthcareService(org.hl7.fhir.dstu3.model.HealthcareService src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService tgt = new HealthcareService();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_30_40.convertReference(src.getProvidedBy()));
        }
        if (src.hasCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_40.convertAttachment(src.getPhoto()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasEligibility() || src.hasEligibilityNote()) {
            HealthcareService.HealthcareServiceEligibilityComponent t = tgt.addEligibility();
            t.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getEligibility()));
            if (src.hasEligibilityNote()) {
                t.setComment(src.getEligibilityNote());
            }
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getProgramName()) {
            tgt.addProgram().setText((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasAppointmentRequired()) {
            tgt.setAppointmentRequired(src.getAppointmentRequired());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAvailableTime()) {
            tgt.addAvailableTime(VersionConvertor_30_40.convertHealthcareServiceAvailableTimeComponent((HealthcareService.HealthcareServiceAvailableTimeComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNotAvailable()) {
            tgt.addNotAvailable(VersionConvertor_30_40.convertHealthcareServiceNotAvailableComponent((HealthcareService.HealthcareServiceNotAvailableComponent)t));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptions(src.getAvailabilityExceptions());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.HealthcareService convertHealthcareService(HealthcareService src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.HealthcareService tgt = new org.hl7.fhir.dstu3.model.HealthcareService();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasProvidedBy()) {
            tgt.setProvidedBy(VersionConvertor_30_40.convertReference(src.getProvidedBy()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        for (Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasExtraDetails()) {
            tgt.setExtraDetails(src.getExtraDetails());
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_40.convertAttachment(src.getPhoto()));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        for (Identifier t : src.getCoverageArea()) {
            tgt.addCoverageArea(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasEligibility()) {
            tgt.setEligibility(VersionConvertor_30_40.convertCodeableConcept(src.getEligibilityFirstRep().getCode()));
            if (src.getEligibilityFirstRep().hasComment()) {
                tgt.setEligibilityNote(src.getEligibilityFirstRep().getComment());
            }
        }
        for (Identifier t : src.getProgram()) {
            tgt.addProgramName(t.getText());
        }
        for (Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReferralMethod()) {
            tgt.addReferralMethod(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasAppointmentRequired()) {
            tgt.setAppointmentRequired(src.getAppointmentRequired());
        }
        for (Identifier t : src.getAvailableTime()) {
            tgt.addAvailableTime(VersionConvertor_30_40.convertHealthcareServiceAvailableTimeComponent((HealthcareService.HealthcareServiceAvailableTimeComponent)t));
        }
        for (Identifier t : src.getNotAvailable()) {
            tgt.addNotAvailable(VersionConvertor_30_40.convertHealthcareServiceNotAvailableComponent((HealthcareService.HealthcareServiceNotAvailableComponent)t));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptions(src.getAvailabilityExceptions());
        }
        for (Identifier t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getDaysOfWeek()) {
            tgt.addDaysOfWeek(VersionConvertor_30_40.convertDaysOfWeek((HealthcareService.DaysOfWeek)t.getValue()));
        }
        if (src.hasAllDay()) {
            tgt.setAllDay(src.getAllDay());
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTime(src.getAvailableStartTime());
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTime(src.getAvailableEndTime());
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (Enumeration t : src.getDaysOfWeek()) {
            tgt.addDaysOfWeek(VersionConvertor_30_40.convertDaysOfWeek((HealthcareService.DaysOfWeek)t.getValue()));
        }
        if (src.hasAllDay()) {
            tgt.setAllDay(src.getAllDay());
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTime(src.getAvailableStartTime());
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTime(src.getAvailableEndTime());
        }
        return tgt;
    }

    private static HealthcareService.DaysOfWeek convertDaysOfWeek(HealthcareService.DaysOfWeek src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MON: {
                return HealthcareService.DaysOfWeek.MON;
            }
            case TUE: {
                return HealthcareService.DaysOfWeek.TUE;
            }
            case WED: {
                return HealthcareService.DaysOfWeek.WED;
            }
            case THU: {
                return HealthcareService.DaysOfWeek.THU;
            }
            case FRI: {
                return HealthcareService.DaysOfWeek.FRI;
            }
            case SAT: {
                return HealthcareService.DaysOfWeek.SAT;
            }
            case SUN: {
                return HealthcareService.DaysOfWeek.SUN;
            }
        }
        return HealthcareService.DaysOfWeek.NULL;
    }

    private static HealthcareService.DaysOfWeek convertDaysOfWeek(HealthcareService.DaysOfWeek src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MON: {
                return HealthcareService.DaysOfWeek.MON;
            }
            case TUE: {
                return HealthcareService.DaysOfWeek.TUE;
            }
            case WED: {
                return HealthcareService.DaysOfWeek.WED;
            }
            case THU: {
                return HealthcareService.DaysOfWeek.THU;
            }
            case FRI: {
                return HealthcareService.DaysOfWeek.FRI;
            }
            case SAT: {
                return HealthcareService.DaysOfWeek.SAT;
            }
            case SUN: {
                return HealthcareService.DaysOfWeek.SUN;
            }
        }
        return HealthcareService.DaysOfWeek.NULL;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static Immunization convertImmunization(org.hl7.fhir.dstu3.model.Immunization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization tgt = new Immunization();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertImmunizationStatus(src.getStatus()));
        }
        if (src.hasVaccineCode()) {
            tgt.setVaccineCode(VersionConvertor_30_40.convertCodeableConcept(src.getVaccineCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setOccurrence((org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertDateTime(src.getDateElement()));
        }
        if (src.hasPrimarySource()) {
            tgt.setPrimarySource(src.getPrimarySource());
        }
        if (src.hasReportOrigin()) {
            tgt.setReportOrigin(VersionConvertor_30_40.convertCodeableConcept(src.getReportOrigin()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_30_40.convertReference(src.getManufacturer()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumber(src.getLotNumber());
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDate(src.getExpirationDate());
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasDoseQuantity()) {
            tgt.setDoseQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getDoseQuantity()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPractitioner()) {
            tgt.addPerformer(VersionConvertor_30_40.convertImmunizationPractitionerComponent((Immunization.ImmunizationPractitionerComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getExplanation().getReason()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Immunization convertImmunization(Immunization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Immunization tgt = new org.hl7.fhir.dstu3.model.Immunization();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertImmunizationStatus(src.getStatus()));
        }
        if (src.hasVaccineCode()) {
            tgt.setVaccineCode(VersionConvertor_30_40.convertCodeableConcept(src.getVaccineCode()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrenceDateTimeType()) {
            tgt.setDateElement(VersionConvertor_30_40.convertDateTime(src.getOccurrenceDateTimeType()));
        }
        if (src.hasPrimarySource()) {
            tgt.setPrimarySource(src.getPrimarySource());
        }
        if (src.hasReportOrigin()) {
            tgt.setReportOrigin(VersionConvertor_30_40.convertCodeableConcept(src.getReportOrigin()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_30_40.convertReference(src.getManufacturer()));
        }
        if (src.hasLotNumber()) {
            tgt.setLotNumber(src.getLotNumber());
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDate(src.getExpirationDate());
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasDoseQuantity()) {
            tgt.setDoseQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getDoseQuantity()));
        }
        for (Identifier t : src.getPerformer()) {
            tgt.addPractitioner(VersionConvertor_30_40.convertImmunizationPractitionerComponent((Immunization.ImmunizationPerformerComponent)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.getExplanation().addReason(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        return tgt;
    }

    private static Immunization.ImmunizationStatus convertImmunizationStatus(Immunization.ImmunizationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case COMPLETED: {
                return Immunization.ImmunizationStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return Immunization.ImmunizationStatus.ENTEREDINERROR;
            }
        }
        return Immunization.ImmunizationStatus.NULL;
    }

    private static Immunization.ImmunizationStatus convertImmunizationStatus(Immunization.ImmunizationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case COMPLETED: {
                return Immunization.ImmunizationStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return Immunization.ImmunizationStatus.ENTEREDINERROR;
            }
        }
        return Immunization.ImmunizationStatus.NULL;
    }

    public static Immunization.ImmunizationPerformerComponent convertImmunizationPractitionerComponent(Immunization.ImmunizationPractitionerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationPerformerComponent tgt = new Immunization.ImmunizationPerformerComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasRole()) {
            tgt.setFunction(VersionConvertor_30_40.convertCodeableConcept(src.getRole()));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static Immunization.ImmunizationPractitionerComponent convertImmunizationPractitionerComponent(Immunization.ImmunizationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Immunization.ImmunizationPractitionerComponent tgt = new Immunization.ImmunizationPractitionerComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasFunction()) {
            tgt.setRole(VersionConvertor_30_40.convertCodeableConcept(src.getFunction()));
        }
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static ImplementationGuide convertImplementationGuide(org.hl7.fhir.dstu3.model.ImplementationGuide src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion()) {
            tgt.addFhirVersion(Enumerations.FHIRVersion.fromCode((String)src.getFhirVersion()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getDependency()) {
            tgt.addDependsOn(VersionConvertor_30_40.convertImplementationGuideDependencyComponent((ImplementationGuide.ImplementationGuideDependencyComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getPackage()) {
            tgt.getDefinition().addGrouping(VersionConvertor_30_40.convertImplementationGuidePackageComponent(tgt.getDefinition(), (ImplementationGuide.ImplementationGuidePackageComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getGlobal()) {
            tgt.addGlobal(VersionConvertor_30_40.convertImplementationGuideGlobalComponent((ImplementationGuide.ImplementationGuideGlobalComponent)t));
        }
        if (src.hasPage()) {
            tgt.getDefinition().setPage(VersionConvertor_30_40.convertImplementationGuidePageComponent(src.getPage()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ImplementationGuide tgt = new org.hl7.fhir.dstu3.model.ImplementationGuide();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        Iterator iterator = src.getJurisdiction().iterator();
        while (iterator.hasNext()) {
            ContactDetail t;
            t = (org.hl7.fhir.r4.model.CodeableConcept)iterator.next();
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion() && (iterator = src.getFhirVersion().iterator()).hasNext()) {
            Enumeration v = (Enumeration)iterator.next();
            tgt.setFhirVersion(v.asStringValue());
        }
        for (ContactDetail t : src.getDependsOn()) {
            tgt.addDependency(VersionConvertor_30_40.convertImplementationGuideDependencyComponent((ImplementationGuide.ImplementationGuideDependsOnComponent)t));
        }
        for (ContactDetail t : src.getDefinition().getGrouping()) {
            tgt.addPackage(VersionConvertor_30_40.convertImplementationGuidePackageComponent((ImplementationGuide.ImplementationGuideDefinitionGroupingComponent)t));
        }
        for (ContactDetail t : src.getDefinition().getResource()) {
            VersionConvertor_30_40.findPackage(tgt.getPackage(), t.getGroupingId()).addResource(VersionConvertor_30_40.convertImplementationGuidePackageResourceComponent((ImplementationGuide.ImplementationGuideDefinitionResourceComponent)t));
        }
        for (ContactDetail t : src.getGlobal()) {
            tgt.addGlobal(VersionConvertor_30_40.convertImplementationGuideGlobalComponent((ImplementationGuide.ImplementationGuideGlobalComponent)t));
        }
        if (src.getDefinition().hasPage()) {
            tgt.setPage(VersionConvertor_30_40.convertImplementationGuidePageComponent(src.getDefinition().getPage()));
        }
        return tgt;
    }

    private static ImplementationGuide.ImplementationGuidePackageComponent findPackage(List<ImplementationGuide.ImplementationGuidePackageComponent> definition, String id) {
        for (ImplementationGuide.ImplementationGuidePackageComponent t : definition) {
            if (!t.getId().equals(id)) continue;
            return t;
        }
        ImplementationGuide.ImplementationGuidePackageComponent t1 = new ImplementationGuide.ImplementationGuidePackageComponent();
        t1.setName("Default Package");
        t1.setId(id);
        return t1;
    }

    public static ImplementationGuide.ImplementationGuideDependsOnComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependsOnComponent tgt = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependsOnComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        tgt.setType(ImplementationGuide.GuideDependencyType.REFERENCE);
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionGroupingComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionComponent context, ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        tgt.setId("p" + (context.getGrouping().size() + 1));
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            ImplementationGuide.ImplementationGuideDefinitionResourceComponent tn = VersionConvertor_30_40.convertImplementationGuidePackageResourceComponent(t);
            tn.setGroupingId(tgt.getId());
            context.addResource(tn);
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionGroupingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        tgt.setId(src.getId());
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasExampleFor()) {
            org.hl7.fhir.r4.model.Type t = VersionConvertor_30_40.convertType((Type)src.getExampleFor());
            tgt.setExample((org.hl7.fhir.r4.model.Type)(t instanceof org.hl7.fhir.r4.model.Reference ? new CanonicalType(((org.hl7.fhir.r4.model.Reference)t).getReference()) : t));
        } else if (src.hasExample()) {
            tgt.setExample((org.hl7.fhir.r4.model.Type)new org.hl7.fhir.r4.model.BooleanType(src.getExample()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasSourceReference()) {
            tgt.setReference(VersionConvertor_30_40.convertReference(src.getSourceReference()));
        } else if (src.hasSourceUriType()) {
            tgt.setReference(new org.hl7.fhir.r4.model.Reference((String)src.getSourceUriType().getValue()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuideDefinitionResourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasExampleCanonicalType()) {
            tgt.setExampleFor(VersionConvertor_30_40.convertCanonicalToReference(src.getExampleCanonicalType()));
            tgt.setExample(true);
        } else if (src.hasExampleBooleanType()) {
            tgt.setExample(((Boolean)src.getExampleBooleanType().getValue()).booleanValue());
        } else {
            tgt.setExample(false);
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasReference()) {
            tgt.setSource((Type)VersionConvertor_30_40.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getProfile()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCanonicalToReference(src.getProfileElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionPageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSource()) {
            tgt.setName((org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertUriToUrl(src.getSourceElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasKind()) {
            tgt.setGeneration(VersionConvertor_30_40.convertPageGeneration(src.getKind()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent t : src.getPage()) {
            tgt.addPage(VersionConvertor_30_40.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    private static ImplementationGuide.GuidePageGeneration convertPageGeneration(ImplementationGuide.GuidePageKind kind) {
        switch (kind) {
            case PAGE: {
                return ImplementationGuide.GuidePageGeneration.HTML;
            }
        }
        return ImplementationGuide.GuidePageGeneration.GENERATED;
    }

    private static ImplementationGuide.GuidePageKind convertPageGeneration(ImplementationGuide.GuidePageGeneration generation) {
        switch (generation) {
            case HTML: {
                return ImplementationGuide.GuidePageKind.PAGE;
            }
        }
        return ImplementationGuide.GuidePageKind.RESOURCE;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuideDefinitionPageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasNameUrlType()) {
            tgt.setSource((String)src.getNameUrlType().getValue());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasGeneration()) {
            tgt.setKind(VersionConvertor_30_40.convertPageGeneration(src.getGeneration()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionPageComponent t : src.getPage()) {
            tgt.addPage(VersionConvertor_30_40.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public static Linkage convertLinkage(org.hl7.fhir.dstu3.model.Linkage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Linkage tgt = new Linkage();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        for (Linkage.LinkageItemComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertLinkageItemComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Linkage convertLinkage(Linkage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Linkage tgt = new org.hl7.fhir.dstu3.model.Linkage();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        for (Linkage.LinkageItemComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertLinkageItemComponent(t));
        }
        return tgt;
    }

    public static Linkage.LinkageItemComponent convertLinkageItemComponent(Linkage.LinkageItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Linkage.LinkageItemComponent tgt = new Linkage.LinkageItemComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertLinkageType(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static Linkage.LinkageItemComponent convertLinkageItemComponent(Linkage.LinkageItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Linkage.LinkageItemComponent tgt = new Linkage.LinkageItemComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertLinkageType(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResource(VersionConvertor_30_40.convertReference(src.getResource()));
        }
        return tgt;
    }

    private static Linkage.LinkageType convertLinkageType(Linkage.LinkageType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SOURCE: {
                return Linkage.LinkageType.SOURCE;
            }
            case ALTERNATE: {
                return Linkage.LinkageType.ALTERNATE;
            }
            case HISTORICAL: {
                return Linkage.LinkageType.HISTORICAL;
            }
        }
        return Linkage.LinkageType.NULL;
    }

    private static Linkage.LinkageType convertLinkageType(Linkage.LinkageType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SOURCE: {
                return Linkage.LinkageType.SOURCE;
            }
            case ALTERNATE: {
                return Linkage.LinkageType.ALTERNATE;
            }
            case HISTORICAL: {
                return Linkage.LinkageType.HISTORICAL;
            }
        }
        return Linkage.LinkageType.NULL;
    }

    public static org.hl7.fhir.r4.model.ListResource convertList(ListResource src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ListResource tgt = new org.hl7.fhir.r4.model.ListResource();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertListStatus(src.getStatus()));
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertListMode(src.getMode()));
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertReference(src.getSource()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_30_40.convertCodeableConcept(src.getOrderedBy()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_30_40.convertListEntryComponent((ListResource.ListEntryComponent)t));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_30_40.convertCodeableConcept(src.getEmptyReason()));
        }
        return tgt;
    }

    public static ListResource convertList(org.hl7.fhir.r4.model.ListResource src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource tgt = new ListResource();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertListStatus(src.getStatus()));
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertListMode(src.getMode()));
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertReference(src.getSource()));
        }
        if (src.hasOrderedBy()) {
            tgt.setOrderedBy(VersionConvertor_30_40.convertCodeableConcept(src.getOrderedBy()));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        for (Identifier t : src.getEntry()) {
            tgt.addEntry(VersionConvertor_30_40.convertListEntryComponent((ListResource.ListEntryComponent)t));
        }
        if (src.hasEmptyReason()) {
            tgt.setEmptyReason(VersionConvertor_30_40.convertCodeableConcept(src.getEmptyReason()));
        }
        return tgt;
    }

    private static ListResource.ListStatus convertListStatus(ListResource.ListStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CURRENT: {
                return ListResource.ListStatus.CURRENT;
            }
            case RETIRED: {
                return ListResource.ListStatus.RETIRED;
            }
            case ENTEREDINERROR: {
                return ListResource.ListStatus.ENTEREDINERROR;
            }
        }
        return ListResource.ListStatus.NULL;
    }

    private static ListResource.ListStatus convertListStatus(ListResource.ListStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CURRENT: {
                return ListResource.ListStatus.CURRENT;
            }
            case RETIRED: {
                return ListResource.ListStatus.RETIRED;
            }
            case ENTEREDINERROR: {
                return ListResource.ListStatus.ENTEREDINERROR;
            }
        }
        return ListResource.ListStatus.NULL;
    }

    private static ListResource.ListMode convertListMode(ListResource.ListMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case WORKING: {
                return ListResource.ListMode.WORKING;
            }
            case SNAPSHOT: {
                return ListResource.ListMode.SNAPSHOT;
            }
            case CHANGES: {
                return ListResource.ListMode.CHANGES;
            }
        }
        return ListResource.ListMode.NULL;
    }

    private static ListResource.ListMode convertListMode(ListResource.ListMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case WORKING: {
                return ListResource.ListMode.WORKING;
            }
            case SNAPSHOT: {
                return ListResource.ListMode.SNAPSHOT;
            }
            case CHANGES: {
                return ListResource.ListMode.CHANGES;
            }
        }
        return ListResource.ListMode.NULL;
    }

    public static ListResource.ListEntryComponent convertListEntryComponent(ListResource.ListEntryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource.ListEntryComponent tgt = new ListResource.ListEntryComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasFlag()) {
            tgt.setFlag(VersionConvertor_30_40.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeleted()) {
            tgt.setDeleted(src.getDeleted());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static ListResource.ListEntryComponent convertListEntryComponent(ListResource.ListEntryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ListResource.ListEntryComponent tgt = new ListResource.ListEntryComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasFlag()) {
            tgt.setFlag(VersionConvertor_30_40.convertCodeableConcept(src.getFlag()));
        }
        if (src.hasDeleted()) {
            tgt.setDeleted(src.getDeleted());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertReference(src.getItem()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Location convertLocation(Location src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Location tgt = new org.hl7.fhir.r4.model.Location();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertLocationStatus(src.getStatus()));
        }
        if (src.hasOperationalStatus()) {
            tgt.setOperationalStatus(VersionConvertor_30_40.convertCoding(src.getOperationalStatus()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertLocationMode(src.getMode()));
        }
        if (src.hasType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_40.convertAddress(src.getAddress()));
        }
        if (src.hasPhysicalType()) {
            tgt.setPhysicalType(VersionConvertor_30_40.convertCodeableConcept(src.getPhysicalType()));
        }
        if (src.hasPosition()) {
            tgt.setPosition(VersionConvertor_30_40.convertLocationPositionComponent(src.getPosition()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_40.convertReference(src.getPartOf()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static Location convertLocation(org.hl7.fhir.r4.model.Location src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Location tgt = new Location();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertLocationStatus(src.getStatus()));
        }
        if (src.hasOperationalStatus()) {
            tgt.setOperationalStatus(VersionConvertor_30_40.convertCoding(src.getOperationalStatus()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (Identifier t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertLocationMode(src.getMode()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getTypeFirstRep()));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_40.convertAddress(src.getAddress()));
        }
        if (src.hasPhysicalType()) {
            tgt.setPhysicalType(VersionConvertor_30_40.convertCodeableConcept(src.getPhysicalType()));
        }
        if (src.hasPosition()) {
            tgt.setPosition(VersionConvertor_30_40.convertLocationPositionComponent(src.getPosition()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_40.convertReference(src.getPartOf()));
        }
        for (Identifier t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    private static Location.LocationStatus convertLocationStatus(Location.LocationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Location.LocationStatus.ACTIVE;
            }
            case SUSPENDED: {
                return Location.LocationStatus.SUSPENDED;
            }
            case INACTIVE: {
                return Location.LocationStatus.INACTIVE;
            }
        }
        return Location.LocationStatus.NULL;
    }

    private static Location.LocationStatus convertLocationStatus(Location.LocationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Location.LocationStatus.ACTIVE;
            }
            case SUSPENDED: {
                return Location.LocationStatus.SUSPENDED;
            }
            case INACTIVE: {
                return Location.LocationStatus.INACTIVE;
            }
        }
        return Location.LocationStatus.NULL;
    }

    private static Location.LocationMode convertLocationMode(Location.LocationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return Location.LocationMode.INSTANCE;
            }
            case KIND: {
                return Location.LocationMode.KIND;
            }
        }
        return Location.LocationMode.NULL;
    }

    private static Location.LocationMode convertLocationMode(Location.LocationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return Location.LocationMode.INSTANCE;
            }
            case KIND: {
                return Location.LocationMode.KIND;
            }
        }
        return Location.LocationMode.NULL;
    }

    public static Location.LocationPositionComponent convertLocationPositionComponent(Location.LocationPositionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Location.LocationPositionComponent tgt = new Location.LocationPositionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLongitude()) {
            tgt.setLongitude(src.getLongitude());
        }
        if (src.hasLatitude()) {
            tgt.setLatitude(src.getLatitude());
        }
        if (src.hasAltitude()) {
            tgt.setAltitude(src.getAltitude());
        }
        return tgt;
    }

    public static Location.LocationPositionComponent convertLocationPositionComponent(Location.LocationPositionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Location.LocationPositionComponent tgt = new Location.LocationPositionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLongitude()) {
            tgt.setLongitude(src.getLongitude());
        }
        if (src.hasLatitude()) {
            tgt.setLatitude(src.getLatitude());
        }
        if (src.hasAltitude()) {
            tgt.setAltitude(src.getAltitude());
        }
        return tgt;
    }

    public static Medication convertMedication(org.hl7.fhir.dstu3.model.Medication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication tgt = new Medication();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationStatus(src.getStatus()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_30_40.convertReference(src.getManufacturer()));
        }
        if (src.hasForm()) {
            tgt.setForm(VersionConvertor_30_40.convertCodeableConcept(src.getForm()));
        }
        for (Medication.MedicationIngredientComponent t : src.getIngredient()) {
            tgt.addIngredient(VersionConvertor_30_40.convertMedicationIngredientComponent(t));
        }
        if (src.hasPackage()) {
            tgt.setBatch(VersionConvertor_30_40.convertMedicationPackageBatchComponent(src.getPackage().getBatchFirstRep()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Medication convertMedication(Medication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Medication tgt = new org.hl7.fhir.dstu3.model.Medication();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationStatus(src.getStatus()));
        }
        if (src.hasManufacturer()) {
            tgt.setManufacturer(VersionConvertor_30_40.convertReference(src.getManufacturer()));
        }
        if (src.hasForm()) {
            tgt.setForm(VersionConvertor_30_40.convertCodeableConcept(src.getForm()));
        }
        for (Medication.MedicationIngredientComponent t : src.getIngredient()) {
            tgt.addIngredient(VersionConvertor_30_40.convertMedicationIngredientComponent(t));
        }
        if (src.hasBatch()) {
            tgt.getPackage().addBatch(VersionConvertor_30_40.convertMedicationPackageBatchComponent(src.getBatch()));
        }
        return tgt;
    }

    private static Medication.MedicationStatus convertMedicationStatus(Medication.MedicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Medication.MedicationStatus.ACTIVE;
            }
            case INACTIVE: {
                return Medication.MedicationStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return Medication.MedicationStatus.ENTEREDINERROR;
            }
        }
        return Medication.MedicationStatus.NULL;
    }

    private static Medication.MedicationStatus convertMedicationStatus(Medication.MedicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Medication.MedicationStatus.ACTIVE;
            }
            case INACTIVE: {
                return Medication.MedicationStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return Medication.MedicationStatus.ENTEREDINERROR;
            }
        }
        return Medication.MedicationStatus.NULL;
    }

    public static Medication.MedicationIngredientComponent convertMedicationIngredientComponent(Medication.MedicationIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItem()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActive(src.getIsActive());
        }
        if (src.hasAmount()) {
            tgt.setStrength(VersionConvertor_30_40.convertRatio(src.getAmount()));
        }
        return tgt;
    }

    public static Medication.MedicationIngredientComponent convertMedicationIngredientComponent(Medication.MedicationIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItem()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActive(src.getIsActive());
        }
        if (src.hasStrength()) {
            tgt.setAmount(VersionConvertor_30_40.convertRatio(src.getStrength()));
        }
        return tgt;
    }

    public static Medication.MedicationBatchComponent convertMedicationPackageBatchComponent(Medication.MedicationPackageBatchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationBatchComponent tgt = new Medication.MedicationBatchComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLotNumber()) {
            tgt.setLotNumber(src.getLotNumber());
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDate(src.getExpirationDate());
        }
        return tgt;
    }

    public static Medication.MedicationPackageBatchComponent convertMedicationPackageBatchComponent(Medication.MedicationBatchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationPackageBatchComponent tgt = new Medication.MedicationPackageBatchComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLotNumber()) {
            tgt.setLotNumber(src.getLotNumber());
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDate(src.getExpirationDate());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MedicationAdministration convertMedicationAdministration(MedicationAdministration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationAdministration tgt = new org.hl7.fhir.r4.model.MedicationAdministration();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDefinition()) {
            tgt.addInstantiates(t.getReference());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationAdministrationStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertMedicationAdministrationPerformerComponent((MedicationAdministration.MedicationAdministrationPerformerComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasPrescription()) {
            tgt.setRequest(VersionConvertor_30_40.convertReference(src.getPrescription()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDevice()) {
            tgt.addDevice(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        if (src.hasDosage()) {
            tgt.setDosage(VersionConvertor_30_40.convertMedicationAdministrationDosageComponent(src.getDosage()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static MedicationAdministration convertMedicationAdministration(org.hl7.fhir.r4.model.MedicationAdministration src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration tgt = new MedicationAdministration();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getInstantiates()) {
            tgt.addDefinition().setReference((String)t.getValue());
        }
        for (Identifier t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationAdministrationStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        for (Identifier t : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        for (Identifier t : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertMedicationAdministrationPerformerComponent((MedicationAdministration.MedicationAdministrationPerformerComponent)t));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasRequest()) {
            tgt.setPrescription(VersionConvertor_30_40.convertReference(src.getRequest()));
        }
        for (Identifier t : src.getDevice()) {
            tgt.addDevice(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        if (src.hasDosage()) {
            tgt.setDosage(VersionConvertor_30_40.convertMedicationAdministrationDosageComponent(src.getDosage()));
        }
        for (Identifier t : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    private static String convertMedicationAdministrationStatus(MedicationAdministration.MedicationAdministrationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        return src.toCode();
    }

    private static MedicationAdministration.MedicationAdministrationStatus convertMedicationAdministrationStatus(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        return MedicationAdministration.MedicationAdministrationStatus.fromCode((String)src);
    }

    public static MedicationAdministration.MedicationAdministrationPerformerComponent convertMedicationAdministrationPerformerComponent(MedicationAdministration.MedicationAdministrationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationPerformerComponent tgt = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationPerformerComponent convertMedicationAdministrationPerformerComponent(MedicationAdministration.MedicationAdministrationPerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationPerformerComponent tgt = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationDosageComponent convertMedicationAdministrationDosageComponent(MedicationAdministration.MedicationAdministrationDosageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationDosageComponent tgt = new MedicationAdministration.MedicationAdministrationDosageComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_30_40.convertSimpleQuantity(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_30_40.convertType(src.getRate()));
        }
        return tgt;
    }

    public static MedicationAdministration.MedicationAdministrationDosageComponent convertMedicationAdministrationDosageComponent(MedicationAdministration.MedicationAdministrationDosageComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationAdministration.MedicationAdministrationDosageComponent tgt = new MedicationAdministration.MedicationAdministrationDosageComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        if (src.hasSite()) {
            tgt.setSite(VersionConvertor_30_40.convertCodeableConcept(src.getSite()));
        }
        if (src.hasRoute()) {
            tgt.setRoute(VersionConvertor_30_40.convertCodeableConcept(src.getRoute()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasDose()) {
            tgt.setDose(VersionConvertor_30_40.convertSimpleQuantity(src.getDose()));
        }
        if (src.hasRate()) {
            tgt.setRate(VersionConvertor_30_40.convertType(src.getRate()));
        }
        return tgt;
    }

    public static MedicationDispense convertMedicationDispense(org.hl7.fhir.dstu3.model.MedicationDispense src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense tgt = new MedicationDispense();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationDispenseStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertMedicationDispensePerformerComponent((MedicationDispense.MedicationDispensePerformerComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_30_40.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPrepared()) {
            tgt.setWhenPrepared(src.getWhenPrepared());
        }
        if (src.hasWhenHandedOver()) {
            tgt.setWhenHandedOver(src.getWhenHandedOver());
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_40.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_40.convertDosage((Dosage)t));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(VersionConvertor_30_40.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.MedicationDispense convertMedicationDispense(MedicationDispense src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.MedicationDispense tgt = new org.hl7.fhir.dstu3.model.MedicationDispense();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationDispenseStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        for (Identifier t : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertMedicationDispensePerformerComponent((MedicationDispense.MedicationDispensePerformerComponent)t));
        }
        for (Identifier t : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasDaysSupply()) {
            tgt.setDaysSupply(VersionConvertor_30_40.convertSimpleQuantity(src.getDaysSupply()));
        }
        if (src.hasWhenPrepared()) {
            tgt.setWhenPrepared(src.getWhenPrepared());
        }
        if (src.hasWhenHandedOver()) {
            tgt.setWhenHandedOver(src.getWhenHandedOver());
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_40.convertReference(src.getDestination()));
        }
        for (Identifier t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        for (Identifier t : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_40.convertDosage((org.hl7.fhir.r4.model.Dosage)t));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(VersionConvertor_30_40.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        }
        for (Identifier t : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    private static String convertMedicationDispenseStatus(MedicationDispense.MedicationDispenseStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        return src.toCode();
    }

    private static MedicationDispense.MedicationDispenseStatus convertMedicationDispenseStatus(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        return MedicationDispense.MedicationDispenseStatus.fromCode((String)src);
    }

    public static MedicationDispense.MedicationDispensePerformerComponent convertMedicationDispensePerformerComponent(MedicationDispense.MedicationDispensePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispensePerformerComponent tgt = new MedicationDispense.MedicationDispensePerformerComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispensePerformerComponent convertMedicationDispensePerformerComponent(MedicationDispense.MedicationDispensePerformerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispensePerformerComponent tgt = new MedicationDispense.MedicationDispensePerformerComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasActor()) {
            tgt.setActor(VersionConvertor_30_40.convertReference(src.getActor()));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasWasSubstituted()) {
            tgt.setWasSubstituted(src.getWasSubstituted());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getReason()) {
            tgt.addReason(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getResponsibleParty()) {
            tgt.addResponsibleParty(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasWasSubstituted()) {
            tgt.setWasSubstituted(src.getWasSubstituted());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getReason()) {
            tgt.addReason(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getResponsibleParty()) {
            tgt.addResponsibleParty(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MedicationRequest convertMedicationRequest(MedicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationRequest tgt = new org.hl7.fhir.r4.model.MedicationRequest();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(VersionConvertor_30_40.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationRequestStatus(src.getStatus()));
        }
        if (src.hasIntent()) {
            tgt.setIntent(VersionConvertor_30_40.convertMedicationRequestIntent(src.getIntent()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertMedicationRequestPriority(src.getPriority()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOn(src.getAuthoredOn());
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_40.convertReference(src.getRecorder()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_40.convertDosage((Dosage)t));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(VersionConvertor_30_40.convertMedicationRequestDispenseRequestComponent(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(VersionConvertor_30_40.convertMedicationRequestSubstitutionComponent(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(VersionConvertor_30_40.convertReference(src.getPriorPrescription()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static MedicationRequest convertMedicationRequest(org.hl7.fhir.r4.model.MedicationRequest src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest tgt = new MedicationRequest();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasGroupIdentifier()) {
            tgt.setGroupIdentifier(VersionConvertor_30_40.convertIdentifier(src.getGroupIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationRequestStatus(src.getStatus()));
        }
        if (src.hasIntent()) {
            tgt.setIntent(VersionConvertor_30_40.convertMedicationRequestIntent(src.getIntent()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(VersionConvertor_30_40.convertMedicationRequestPriority(src.getPriority()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        for (Identifier t : src.getSupportingInformation()) {
            tgt.addSupportingInformation(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasAuthoredOn()) {
            tgt.setAuthoredOn(src.getAuthoredOn());
        }
        if (src.hasRecorder()) {
            tgt.setRecorder(VersionConvertor_30_40.convertReference(src.getRecorder()));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        for (Identifier t : src.getDosageInstruction()) {
            tgt.addDosageInstruction(VersionConvertor_30_40.convertDosage((org.hl7.fhir.r4.model.Dosage)t));
        }
        if (src.hasDispenseRequest()) {
            tgt.setDispenseRequest(VersionConvertor_30_40.convertMedicationRequestDispenseRequestComponent(src.getDispenseRequest()));
        }
        if (src.hasSubstitution()) {
            tgt.setSubstitution(VersionConvertor_30_40.convertMedicationRequestSubstitutionComponent(src.getSubstitution()));
        }
        if (src.hasPriorPrescription()) {
            tgt.setPriorPrescription(VersionConvertor_30_40.convertReference(src.getPriorPrescription()));
        }
        for (Identifier t : src.getDetectedIssue()) {
            tgt.addDetectedIssue(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getEventHistory()) {
            tgt.addEventHistory(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    private static MedicationRequest.MedicationRequestStatus convertMedicationRequestStatus(MedicationRequest.MedicationRequestStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return MedicationRequest.MedicationRequestStatus.ACTIVE;
            }
            case ONHOLD: {
                return MedicationRequest.MedicationRequestStatus.ONHOLD;
            }
            case CANCELLED: {
                return MedicationRequest.MedicationRequestStatus.CANCELLED;
            }
            case COMPLETED: {
                return MedicationRequest.MedicationRequestStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return MedicationRequest.MedicationRequestStatus.ENTEREDINERROR;
            }
            case STOPPED: {
                return MedicationRequest.MedicationRequestStatus.STOPPED;
            }
            case DRAFT: {
                return MedicationRequest.MedicationRequestStatus.DRAFT;
            }
            case UNKNOWN: {
                return MedicationRequest.MedicationRequestStatus.UNKNOWN;
            }
        }
        return MedicationRequest.MedicationRequestStatus.NULL;
    }

    private static MedicationRequest.MedicationRequestStatus convertMedicationRequestStatus(MedicationRequest.MedicationRequestStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return MedicationRequest.MedicationRequestStatus.ACTIVE;
            }
            case ONHOLD: {
                return MedicationRequest.MedicationRequestStatus.ONHOLD;
            }
            case CANCELLED: {
                return MedicationRequest.MedicationRequestStatus.CANCELLED;
            }
            case COMPLETED: {
                return MedicationRequest.MedicationRequestStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return MedicationRequest.MedicationRequestStatus.ENTEREDINERROR;
            }
            case STOPPED: {
                return MedicationRequest.MedicationRequestStatus.STOPPED;
            }
            case DRAFT: {
                return MedicationRequest.MedicationRequestStatus.DRAFT;
            }
            case UNKNOWN: {
                return MedicationRequest.MedicationRequestStatus.UNKNOWN;
            }
        }
        return MedicationRequest.MedicationRequestStatus.NULL;
    }

    private static MedicationRequest.MedicationRequestIntent convertMedicationRequestIntent(MedicationRequest.MedicationRequestIntent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSAL: {
                return MedicationRequest.MedicationRequestIntent.PROPOSAL;
            }
            case PLAN: {
                return MedicationRequest.MedicationRequestIntent.PLAN;
            }
            case ORDER: {
                return MedicationRequest.MedicationRequestIntent.ORDER;
            }
            case INSTANCEORDER: {
                return MedicationRequest.MedicationRequestIntent.INSTANCEORDER;
            }
        }
        return MedicationRequest.MedicationRequestIntent.NULL;
    }

    private static MedicationRequest.MedicationRequestIntent convertMedicationRequestIntent(MedicationRequest.MedicationRequestIntent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSAL: {
                return MedicationRequest.MedicationRequestIntent.PROPOSAL;
            }
            case PLAN: {
                return MedicationRequest.MedicationRequestIntent.PLAN;
            }
            case ORDER: {
                return MedicationRequest.MedicationRequestIntent.ORDER;
            }
            case INSTANCEORDER: {
                return MedicationRequest.MedicationRequestIntent.INSTANCEORDER;
            }
        }
        return MedicationRequest.MedicationRequestIntent.NULL;
    }

    private static MedicationRequest.MedicationRequestPriority convertMedicationRequestPriority(MedicationRequest.MedicationRequestPriority src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ROUTINE: {
                return MedicationRequest.MedicationRequestPriority.ROUTINE;
            }
            case URGENT: {
                return MedicationRequest.MedicationRequestPriority.URGENT;
            }
            case STAT: {
                return MedicationRequest.MedicationRequestPriority.STAT;
            }
            case ASAP: {
                return MedicationRequest.MedicationRequestPriority.ASAP;
            }
        }
        return MedicationRequest.MedicationRequestPriority.NULL;
    }

    private static MedicationRequest.MedicationRequestPriority convertMedicationRequestPriority(MedicationRequest.MedicationRequestPriority src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ROUTINE: {
                return MedicationRequest.MedicationRequestPriority.ROUTINE;
            }
            case URGENT: {
                return MedicationRequest.MedicationRequestPriority.URGENT;
            }
            case STAT: {
                return MedicationRequest.MedicationRequestPriority.STAT;
            }
            case ASAP: {
                return MedicationRequest.MedicationRequestPriority.ASAP;
            }
        }
        return MedicationRequest.MedicationRequestPriority.NULL;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestComponent convertMedicationRequestDispenseRequestComponent(MedicationRequest.MedicationRequestDispenseRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(VersionConvertor_30_40.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowed(src.getNumberOfRepeatsAllowed());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(VersionConvertor_30_40.convertDuration(src.getExpectedSupplyDuration()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestDispenseRequestComponent convertMedicationRequestDispenseRequestComponent(MedicationRequest.MedicationRequestDispenseRequestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestDispenseRequestComponent tgt = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasValidityPeriod()) {
            tgt.setValidityPeriod(VersionConvertor_30_40.convertPeriod(src.getValidityPeriod()));
        }
        if (src.hasNumberOfRepeatsAllowed()) {
            tgt.setNumberOfRepeatsAllowed(src.getNumberOfRepeatsAllowed());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasExpectedSupplyDuration()) {
            tgt.setExpectedSupplyDuration(VersionConvertor_30_40.convertDuration(src.getExpectedSupplyDuration()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestSubstitutionComponent convertMedicationRequestSubstitutionComponent(MedicationRequest.MedicationRequestSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasAllowed()) {
            tgt.setAllowed((org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertBoolean(src.getAllowedElement()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_40.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }

    public static MedicationRequest.MedicationRequestSubstitutionComponent convertMedicationRequestSubstitutionComponent(MedicationRequest.MedicationRequestSubstitutionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationRequest.MedicationRequestSubstitutionComponent tgt = new MedicationRequest.MedicationRequestSubstitutionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasAllowedBooleanType()) {
            tgt.setAllowedElement(VersionConvertor_30_40.convertBoolean(src.getAllowedBooleanType()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_40.convertCodeableConcept(src.getReason()));
        }
        return tgt;
    }

    public static MedicationStatement convertMedicationStatement(org.hl7.fhir.dstu3.model.MedicationStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationStatement tgt = new MedicationStatement();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationStatementStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAsserted(src.getDateAsserted());
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_30_40.convertReference(src.getInformationSource()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDerivedFrom()) {
            tgt.addDerivedFrom(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_40.convertDosage((Dosage)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.MedicationStatement convertMedicationStatement(MedicationStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.MedicationStatement tgt = new org.hl7.fhir.dstu3.model.MedicationStatement();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertMedicationStatementStatus(src.getStatus()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAsserted(src.getDateAsserted());
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_30_40.convertReference(src.getInformationSource()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (Identifier t : src.getDerivedFrom()) {
            tgt.addDerivedFrom(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        for (Identifier t : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_40.convertDosage((org.hl7.fhir.r4.model.Dosage)t));
        }
        return tgt;
    }

    private static MedicationStatement.MedicationStatementStatus convertMedicationStatementStatus(MedicationStatement.MedicationStatementStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return MedicationStatement.MedicationStatementStatus.ACTIVE;
            }
            case COMPLETED: {
                return MedicationStatement.MedicationStatementStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return MedicationStatement.MedicationStatementStatus.ENTEREDINERROR;
            }
            case INTENDED: {
                return MedicationStatement.MedicationStatementStatus.INTENDED;
            }
            case STOPPED: {
                return MedicationStatement.MedicationStatementStatus.STOPPED;
            }
            case ONHOLD: {
                return MedicationStatement.MedicationStatementStatus.ONHOLD;
            }
        }
        return MedicationStatement.MedicationStatementStatus.NULL;
    }

    private static MedicationStatement.MedicationStatementStatus convertMedicationStatementStatus(MedicationStatement.MedicationStatementStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return MedicationStatement.MedicationStatementStatus.ACTIVE;
            }
            case COMPLETED: {
                return MedicationStatement.MedicationStatementStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return MedicationStatement.MedicationStatementStatus.ENTEREDINERROR;
            }
            case INTENDED: {
                return MedicationStatement.MedicationStatementStatus.INTENDED;
            }
            case STOPPED: {
                return MedicationStatement.MedicationStatementStatus.STOPPED;
            }
            case ONHOLD: {
                return MedicationStatement.MedicationStatementStatus.ONHOLD;
            }
        }
        return MedicationStatement.MedicationStatementStatus.NULL;
    }

    public static org.hl7.fhir.r4.model.MessageDefinition convertMessageDefinition(MessageDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MessageDefinition tgt = new org.hl7.fhir.r4.model.MessageDefinition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasBase()) {
            tgt.setBaseElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getBase()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getParent()) {
            tgt.getParent().add(VersionConvertor_30_40.convertReferenceToCanonical((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getReplaces()) {
            tgt.getReplaces().add(VersionConvertor_30_40.convertReferenceToCanonical((Reference)t));
        }
        if (src.hasEvent()) {
            tgt.setEvent((org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertCoding(src.getEvent()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertMessageSignificanceCategory(src.getCategory()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getFocus()) {
            tgt.addFocus(VersionConvertor_30_40.convertMessageDefinitionFocusComponent((MessageDefinition.MessageDefinitionFocusComponent)t));
        }
        if (src.hasResponseRequired()) {
            tgt.setResponseRequired(src.getResponseRequired() ? MessageDefinition.MessageheaderResponseRequest.ALWAYS : MessageDefinition.MessageheaderResponseRequest.NEVER);
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getAllowedResponse()) {
            tgt.addAllowedResponse(VersionConvertor_30_40.convertMessageDefinitionAllowedResponseComponent((MessageDefinition.MessageDefinitionAllowedResponseComponent)t));
        }
        return tgt;
    }

    public static String convertCoding2Uri(Coding code) {
        return code.getSystem() + "/" + code.getCode();
    }

    public static MessageDefinition convertMessageDefinition(org.hl7.fhir.r4.model.MessageDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition tgt = new MessageDefinition();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_40.convertCanonicalToReference(src.getBaseElement()));
        }
        for (ContactDetail t : src.getParent()) {
            tgt.addParent(VersionConvertor_30_40.convertCanonicalToReference((CanonicalType)t));
        }
        for (ContactDetail t : src.getReplaces()) {
            tgt.addReplaces(VersionConvertor_30_40.convertCanonicalToReference((CanonicalType)t));
        }
        if (src.hasEventCoding()) {
            tgt.setEvent(VersionConvertor_30_40.convertCoding(src.getEventCoding()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertMessageSignificanceCategory(src.getCategory()));
        }
        for (ContactDetail t : src.getFocus()) {
            tgt.addFocus(VersionConvertor_30_40.convertMessageDefinitionFocusComponent((MessageDefinition.MessageDefinitionFocusComponent)t));
        }
        if (src.hasResponseRequired()) {
            tgt.setResponseRequired(src.getResponseRequired() != MessageDefinition.MessageheaderResponseRequest.NEVER);
        }
        for (ContactDetail t : src.getAllowedResponse()) {
            tgt.addAllowedResponse(VersionConvertor_30_40.convertMessageDefinitionAllowedResponseComponent((MessageDefinition.MessageDefinitionAllowedResponseComponent)t));
        }
        return tgt;
    }

    public static Coding convertUri2Coding(String uri) {
        int i = uri.lastIndexOf("/");
        return new Coding().setSystem(uri.substring(0, i)).setCode(uri.substring(i + 1));
    }

    private static MessageDefinition.MessageSignificanceCategory convertMessageSignificanceCategory(MessageDefinition.MessageSignificanceCategory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CONSEQUENCE: {
                return MessageDefinition.MessageSignificanceCategory.CONSEQUENCE;
            }
            case CURRENCY: {
                return MessageDefinition.MessageSignificanceCategory.CURRENCY;
            }
            case NOTIFICATION: {
                return MessageDefinition.MessageSignificanceCategory.NOTIFICATION;
            }
        }
        return MessageDefinition.MessageSignificanceCategory.NULL;
    }

    private static MessageDefinition.MessageSignificanceCategory convertMessageSignificanceCategory(MessageDefinition.MessageSignificanceCategory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CONSEQUENCE: {
                return MessageDefinition.MessageSignificanceCategory.CONSEQUENCE;
            }
            case CURRENCY: {
                return MessageDefinition.MessageSignificanceCategory.CURRENCY;
            }
            case NOTIFICATION: {
                return MessageDefinition.MessageSignificanceCategory.NOTIFICATION;
            }
        }
        return MessageDefinition.MessageSignificanceCategory.NULL;
    }

    public static MessageDefinition.MessageDefinitionFocusComponent convertMessageDefinitionFocusComponent(MessageDefinition.MessageDefinitionFocusComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionFocusComponent tgt = new MessageDefinition.MessageDefinitionFocusComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getProfile()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionFocusComponent convertMessageDefinitionFocusComponent(MessageDefinition.MessageDefinitionFocusComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionFocusComponent tgt = new MessageDefinition.MessageDefinitionFocusComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasProfile()) {
            tgt.setProfile(VersionConvertor_30_40.convertCanonicalToReference(src.getProfileElement()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionAllowedResponseComponent convertMessageDefinitionAllowedResponseComponent(MessageDefinition.MessageDefinitionAllowedResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionAllowedResponseComponent tgt = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasMessage()) {
            tgt.setMessageElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getMessage()));
        }
        if (src.hasSituation()) {
            tgt.setSituation(src.getSituation());
        }
        return tgt;
    }

    public static MessageDefinition.MessageDefinitionAllowedResponseComponent convertMessageDefinitionAllowedResponseComponent(MessageDefinition.MessageDefinitionAllowedResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageDefinition.MessageDefinitionAllowedResponseComponent tgt = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasMessage()) {
            tgt.setMessage(VersionConvertor_30_40.convertCanonicalToReference(src.getMessageElement()));
        }
        if (src.hasSituation()) {
            tgt.setSituation(src.getSituation());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.MessageHeader convertMessageHeader(MessageHeader src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.MessageHeader tgt = new org.hl7.fhir.r4.model.MessageHeader();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasEvent()) {
            tgt.setEvent((org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertCoding(src.getEvent()));
        }
        for (MessageHeader.MessageDestinationComponent t : src.getDestination()) {
            tgt.addDestination(VersionConvertor_30_40.convertMessageDestinationComponent(t));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_30_40.convertReference(src.getSender()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(VersionConvertor_30_40.convertReference(src.getEnterer()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertMessageSourceComponent(src.getSource()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(VersionConvertor_30_40.convertReference(src.getResponsible()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_40.convertCodeableConcept(src.getReason()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_30_40.convertMessageHeaderResponseComponent(src.getResponse()));
        }
        for (MessageHeader.MessageDestinationComponent t : src.getFocus()) {
            tgt.addFocus(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static MessageHeader convertMessageHeader(org.hl7.fhir.r4.model.MessageHeader src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader tgt = new MessageHeader();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasEventCoding()) {
            tgt.setEvent(VersionConvertor_30_40.convertCoding(src.getEventCoding()));
        }
        for (MessageHeader.MessageDestinationComponent t : src.getDestination()) {
            tgt.addDestination(VersionConvertor_30_40.convertMessageDestinationComponent(t));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_30_40.convertReference(src.getSender()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(VersionConvertor_30_40.convertReference(src.getEnterer()));
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertMessageSourceComponent(src.getSource()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(VersionConvertor_30_40.convertReference(src.getResponsible()));
        }
        if (src.hasReason()) {
            tgt.setReason(VersionConvertor_30_40.convertCodeableConcept(src.getReason()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_30_40.convertMessageHeaderResponseComponent(src.getResponse()));
        }
        for (MessageHeader.MessageDestinationComponent t : src.getFocus()) {
            tgt.addFocus(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public static MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        return tgt;
    }

    public static MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        return tgt;
    }

    public static MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(src.getSoftware());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasContact()) {
            tgt.setContact(VersionConvertor_30_40.convertContactPoint(src.getContact()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        return tgt;
    }

    public static MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasSoftware()) {
            tgt.setSoftware(src.getSoftware());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasContact()) {
            tgt.setContact(VersionConvertor_30_40.convertContactPoint(src.getContact()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        return tgt;
    }

    public static MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(src.getIdentifier());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertResponseType(src.getCode()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_30_40.convertReference(src.getDetails()));
        }
        return tgt;
    }

    public static MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(src.getIdentifier());
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertResponseType(src.getCode()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_30_40.convertReference(src.getDetails()));
        }
        return tgt;
    }

    private static MessageHeader.ResponseType convertResponseType(MessageHeader.ResponseType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OK: {
                return MessageHeader.ResponseType.OK;
            }
            case TRANSIENTERROR: {
                return MessageHeader.ResponseType.TRANSIENTERROR;
            }
            case FATALERROR: {
                return MessageHeader.ResponseType.FATALERROR;
            }
        }
        return MessageHeader.ResponseType.NULL;
    }

    private static MessageHeader.ResponseType convertResponseType(MessageHeader.ResponseType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OK: {
                return MessageHeader.ResponseType.OK;
            }
            case TRANSIENTERROR: {
                return MessageHeader.ResponseType.TRANSIENTERROR;
            }
            case FATALERROR: {
                return MessageHeader.ResponseType.FATALERROR;
            }
        }
        return MessageHeader.ResponseType.NULL;
    }

    public static NamingSystem convertNamingSystem(org.hl7.fhir.dstu3.model.NamingSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem tgt = new NamingSystem();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertNamingSystemType(src.getKind()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(src.getResponsible());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasUsage()) {
            tgt.setUsage(src.getUsage());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUniqueId()) {
            tgt.addUniqueId(VersionConvertor_30_40.convertNamingSystemUniqueIdComponent((NamingSystem.NamingSystemUniqueIdComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.NamingSystem convertNamingSystem(NamingSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.NamingSystem tgt = new org.hl7.fhir.dstu3.model.NamingSystem();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertNamingSystemType(src.getKind()));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasResponsible()) {
            tgt.setResponsible(src.getResponsible());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasUsage()) {
            tgt.setUsage(src.getUsage());
        }
        for (ContactDetail t : src.getUniqueId()) {
            tgt.addUniqueId(VersionConvertor_30_40.convertNamingSystemUniqueIdComponent((NamingSystem.NamingSystemUniqueIdComponent)t));
        }
        return tgt;
    }

    private static NamingSystem.NamingSystemType convertNamingSystemType(NamingSystem.NamingSystemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODESYSTEM: {
                return NamingSystem.NamingSystemType.CODESYSTEM;
            }
            case IDENTIFIER: {
                return NamingSystem.NamingSystemType.IDENTIFIER;
            }
            case ROOT: {
                return NamingSystem.NamingSystemType.ROOT;
            }
        }
        return NamingSystem.NamingSystemType.NULL;
    }

    private static NamingSystem.NamingSystemType convertNamingSystemType(NamingSystem.NamingSystemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODESYSTEM: {
                return NamingSystem.NamingSystemType.CODESYSTEM;
            }
            case IDENTIFIER: {
                return NamingSystem.NamingSystemType.IDENTIFIER;
            }
            case ROOT: {
                return NamingSystem.NamingSystemType.ROOT;
            }
        }
        return NamingSystem.NamingSystemType.NULL;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertNamingSystemIdentifierType(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasPreferred()) {
            tgt.setPreferred(src.getPreferred());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertNamingSystemIdentifierType(src.getType()));
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasPreferred()) {
            tgt.setPreferred(src.getPreferred());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    private static NamingSystem.NamingSystemIdentifierType convertNamingSystemIdentifierType(NamingSystem.NamingSystemIdentifierType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OID: {
                return NamingSystem.NamingSystemIdentifierType.OID;
            }
            case UUID: {
                return NamingSystem.NamingSystemIdentifierType.UUID;
            }
            case URI: {
                return NamingSystem.NamingSystemIdentifierType.URI;
            }
            case OTHER: {
                return NamingSystem.NamingSystemIdentifierType.OTHER;
            }
        }
        return NamingSystem.NamingSystemIdentifierType.NULL;
    }

    private static NamingSystem.NamingSystemIdentifierType convertNamingSystemIdentifierType(NamingSystem.NamingSystemIdentifierType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OID: {
                return NamingSystem.NamingSystemIdentifierType.OID;
            }
            case UUID: {
                return NamingSystem.NamingSystemIdentifierType.UUID;
            }
            case URI: {
                return NamingSystem.NamingSystemIdentifierType.URI;
            }
            case OTHER: {
                return NamingSystem.NamingSystemIdentifierType.OTHER;
            }
        }
        return NamingSystem.NamingSystemIdentifierType.NULL;
    }

    public static org.hl7.fhir.r4.model.Observation convertObservation(Observation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Observation tgt = new org.hl7.fhir.r4.model.Observation();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertObservationStatus(src.getStatus()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssued(src.getIssued());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.addInterpretation(VersionConvertor_30_40.convertCodeableConcept(src.getInterpretation()));
        }
        if (src.hasComment()) {
            tgt.addNote().setText(src.getComment());
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_30_40.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getReferenceRange()) {
            tgt.addReferenceRange(VersionConvertor_30_40.convertObservationReferenceRangeComponent((Observation.ObservationReferenceRangeComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getRelated()) {
            if (t.getType() == Observation.ObservationRelationshipType.HASMEMBER) {
                tgt.addHasMember(VersionConvertor_30_40.convertReference(t.getTarget()));
                continue;
            }
            if (t.getType() != Observation.ObservationRelationshipType.DERIVEDFROM) continue;
            tgt.addDerivedFrom(VersionConvertor_30_40.convertReference(t.getTarget()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getComponent()) {
            tgt.addComponent(VersionConvertor_30_40.convertObservationComponentComponent((Observation.ObservationComponentComponent)t));
        }
        return tgt;
    }

    public static Observation convertObservation(org.hl7.fhir.r4.model.Observation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation tgt = new Observation();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertObservationStatus(src.getStatus()));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasIssued()) {
            tgt.setIssued(src.getIssued());
        }
        for (Identifier t : src.getPerformer()) {
            tgt.addPerformer(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.setInterpretation(VersionConvertor_30_40.convertCodeableConcept(src.getInterpretationFirstRep()));
        }
        if (src.hasNote()) {
            tgt.setComment(src.getNoteFirstRep().getText());
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_30_40.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        for (Identifier t : src.getReferenceRange()) {
            tgt.addReferenceRange(VersionConvertor_30_40.convertObservationReferenceRangeComponent((Observation.ObservationReferenceRangeComponent)t));
        }
        for (Identifier t : src.getHasMember()) {
            tgt.addRelated(VersionConvertor_30_40.convertObservationRelatedComponent((org.hl7.fhir.r4.model.Reference)t, Observation.ObservationRelationshipType.HASMEMBER));
        }
        for (Identifier t : src.getDerivedFrom()) {
            tgt.addRelated(VersionConvertor_30_40.convertObservationRelatedComponent((org.hl7.fhir.r4.model.Reference)t, Observation.ObservationRelationshipType.DERIVEDFROM));
        }
        for (Identifier t : src.getComponent()) {
            tgt.addComponent(VersionConvertor_30_40.convertObservationComponentComponent((Observation.ObservationComponentComponent)t));
        }
        return tgt;
    }

    private static Observation.ObservationStatus convertObservationStatus(Observation.ObservationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return Observation.ObservationStatus.REGISTERED;
            }
            case PRELIMINARY: {
                return Observation.ObservationStatus.PRELIMINARY;
            }
            case FINAL: {
                return Observation.ObservationStatus.FINAL;
            }
            case AMENDED: {
                return Observation.ObservationStatus.AMENDED;
            }
            case CORRECTED: {
                return Observation.ObservationStatus.CORRECTED;
            }
            case CANCELLED: {
                return Observation.ObservationStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return Observation.ObservationStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return Observation.ObservationStatus.UNKNOWN;
            }
        }
        return Observation.ObservationStatus.NULL;
    }

    private static Observation.ObservationStatus convertObservationStatus(Observation.ObservationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return Observation.ObservationStatus.REGISTERED;
            }
            case PRELIMINARY: {
                return Observation.ObservationStatus.PRELIMINARY;
            }
            case FINAL: {
                return Observation.ObservationStatus.FINAL;
            }
            case AMENDED: {
                return Observation.ObservationStatus.AMENDED;
            }
            case CORRECTED: {
                return Observation.ObservationStatus.CORRECTED;
            }
            case CANCELLED: {
                return Observation.ObservationStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return Observation.ObservationStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return Observation.ObservationStatus.UNKNOWN;
            }
        }
        return Observation.ObservationStatus.NULL;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_40.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept t : src.getAppliesTo()) {
            tgt.addAppliesTo(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_30_40.convertRange(src.getAge()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLow()) {
            tgt.setLow(VersionConvertor_30_40.convertSimpleQuantity(src.getLow()));
        }
        if (src.hasHigh()) {
            tgt.setHigh(VersionConvertor_30_40.convertSimpleQuantity(src.getHigh()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getAppliesTo()) {
            tgt.addAppliesTo(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasAge()) {
            tgt.setAge(VersionConvertor_30_40.convertRange(src.getAge()));
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        return tgt;
    }

    public static Observation.ObservationRelatedComponent convertObservationRelatedComponent(org.hl7.fhir.r4.model.Reference src, Observation.ObservationRelationshipType type) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationRelatedComponent tgt = new Observation.ObservationRelatedComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        tgt.setType(type);
        tgt.setTarget(VersionConvertor_30_40.convertReference(src));
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.addInterpretation(VersionConvertor_30_40.convertCodeableConcept(src.getInterpretation()));
        }
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(VersionConvertor_30_40.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public static Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        if (src.hasDataAbsentReason()) {
            tgt.setDataAbsentReason(VersionConvertor_30_40.convertCodeableConcept(src.getDataAbsentReason()));
        }
        if (src.hasInterpretation()) {
            tgt.setInterpretation(VersionConvertor_30_40.convertCodeableConcept(src.getInterpretationFirstRep()));
        }
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(VersionConvertor_30_40.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public static OperationDefinition convertOperationDefinition(org.hl7.fhir.dstu3.model.OperationDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition tgt = new OperationDefinition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertOperationKind(src.getKind()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasIdempotent()) {
            tgt.setAffectsState(!src.getIdempotent());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasBase()) {
            tgt.setBaseElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getBase()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getResource()) {
            tgt.addResource((String)t.getValue());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasInstance()) {
            tgt.setInstance(src.getInstance());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_30_40.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getOverload()) {
            tgt.addOverload(VersionConvertor_30_40.convertOperationDefinitionOverloadComponent((OperationDefinition.OperationDefinitionOverloadComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.OperationDefinition convertOperationDefinition(OperationDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.OperationDefinition tgt = new org.hl7.fhir.dstu3.model.OperationDefinition();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertOperationKind(src.getKind()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasAffectsState()) {
            tgt.setIdempotent(!src.getAffectsState());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        if (src.hasBase()) {
            tgt.setBase(VersionConvertor_30_40.convertCanonicalToReference(src.getBaseElement()));
        }
        for (ContactDetail t : src.getResource()) {
            tgt.addResource((String)t.getValue());
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasInstance()) {
            tgt.setInstance(src.getInstance());
        }
        for (ContactDetail t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_30_40.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        for (ContactDetail t : src.getOverload()) {
            tgt.addOverload(VersionConvertor_30_40.convertOperationDefinitionOverloadComponent((OperationDefinition.OperationDefinitionOverloadComponent)t));
        }
        return tgt;
    }

    private static OperationDefinition.OperationKind convertOperationKind(OperationDefinition.OperationKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OPERATION: {
                return OperationDefinition.OperationKind.OPERATION;
            }
            case QUERY: {
                return OperationDefinition.OperationKind.QUERY;
            }
        }
        return OperationDefinition.OperationKind.NULL;
    }

    private static OperationDefinition.OperationKind convertOperationKind(OperationDefinition.OperationKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OPERATION: {
                return OperationDefinition.OperationKind.OPERATION;
            }
            case QUERY: {
                return OperationDefinition.OperationKind.QUERY;
            }
        }
        return OperationDefinition.OperationKind.NULL;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertOperationParameterUse(src.getUse()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasSearchType()) {
            tgt.setSearchType(VersionConvertor_30_40.convertSearchParamType(src.getSearchType()));
        }
        if (src.hasProfile()) {
            tgt.addTargetProfile(src.getProfile().getReference());
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_30_40.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (OperationDefinition.OperationDefinitionParameterComponent t : src.getPart()) {
            tgt.addPart(VersionConvertor_30_40.convertOperationDefinitionParameterComponent(t));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasUse()) {
            tgt.setUse(VersionConvertor_30_40.convertOperationParameterUse(src.getUse()));
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasSearchType()) {
            tgt.setSearchType(VersionConvertor_30_40.convertSearchParamType(src.getSearchType()));
        }
        for (UriType t : src.getTargetProfile()) {
            tgt.setProfile(new Reference((String)t.getValue()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(VersionConvertor_30_40.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (UriType t : src.getPart()) {
            tgt.addPart(VersionConvertor_30_40.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    private static OperationDefinition.OperationParameterUse convertOperationParameterUse(OperationDefinition.OperationParameterUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IN: {
                return OperationDefinition.OperationParameterUse.IN;
            }
            case OUT: {
                return OperationDefinition.OperationParameterUse.OUT;
            }
        }
        return OperationDefinition.OperationParameterUse.NULL;
    }

    private static OperationDefinition.OperationParameterUse convertOperationParameterUse(OperationDefinition.OperationParameterUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IN: {
                return OperationDefinition.OperationParameterUse.IN;
            }
            case OUT: {
                return OperationDefinition.OperationParameterUse.OUT;
            }
        }
        return OperationDefinition.OperationParameterUse.NULL;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasStrength()) {
            tgt.setStrength(VersionConvertor_30_40.convertBindingStrength(src.getStrength()));
        }
        if (src.hasValueSet()) {
            org.hl7.fhir.r4.model.Type t = VersionConvertor_30_40.convertType(src.getValueSet());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setValueSet(((org.hl7.fhir.r4.model.Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasStrength()) {
            tgt.setStrength(VersionConvertor_30_40.convertBindingStrength(src.getStrength()));
        }
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet((Type)new org.hl7.fhir.dstu3.model.UriType(vsr));
            } else {
                tgt.setValueSet((Type)new Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionOverloadComponent convertOperationDefinitionOverloadComponent(OperationDefinition.OperationDefinitionOverloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionOverloadComponent tgt = new OperationDefinition.OperationDefinitionOverloadComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (StringType t : src.getParameterName()) {
            tgt.addParameterName((String)t.getValue());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static OperationDefinition.OperationDefinitionOverloadComponent convertOperationDefinitionOverloadComponent(OperationDefinition.OperationDefinitionOverloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationDefinition.OperationDefinitionOverloadComponent tgt = new OperationDefinition.OperationDefinitionOverloadComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.StringType t : src.getParameterName()) {
            tgt.addParameterName((String)t.getValue());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.OperationOutcome convertOperationOutcome(OperationOutcome src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.OperationOutcome tgt = new org.hl7.fhir.r4.model.OperationOutcome();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(VersionConvertor_30_40.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public static OperationOutcome convertOperationOutcome(org.hl7.fhir.r4.model.OperationOutcome src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationOutcome tgt = new OperationOutcome();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(VersionConvertor_30_40.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public static OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertIssueSeverity(src.getSeverity()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertIssueType(src.getCode()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_30_40.convertCodeableConcept(src.getDetails()));
        }
        if (src.hasDiagnostics()) {
            tgt.setDiagnostics(src.getDiagnostics());
        }
        for (StringType t : src.getLocation()) {
            tgt.addLocation((String)t.getValue());
        }
        for (StringType t : src.getExpression()) {
            tgt.addExpression((String)t.getValue());
        }
        return tgt;
    }

    public static OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasSeverity()) {
            tgt.setSeverity(VersionConvertor_30_40.convertIssueSeverity(src.getSeverity()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertIssueType(src.getCode()));
        }
        if (src.hasDetails()) {
            tgt.setDetails(VersionConvertor_30_40.convertCodeableConcept(src.getDetails()));
        }
        if (src.hasDiagnostics()) {
            tgt.setDiagnostics(src.getDiagnostics());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getLocation()) {
            tgt.addLocation((String)t.getValue());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getExpression()) {
            tgt.addExpression((String)t.getValue());
        }
        return tgt;
    }

    private static OperationOutcome.IssueSeverity convertIssueSeverity(OperationOutcome.IssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
        }
        return OperationOutcome.IssueSeverity.NULL;
    }

    private static OperationOutcome.IssueSeverity convertIssueSeverity(OperationOutcome.IssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
        }
        return OperationOutcome.IssueSeverity.NULL;
    }

    private static OperationOutcome.IssueType convertIssueType(OperationOutcome.IssueType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INVALID: {
                return OperationOutcome.IssueType.INVALID;
            }
            case STRUCTURE: {
                return OperationOutcome.IssueType.STRUCTURE;
            }
            case REQUIRED: {
                return OperationOutcome.IssueType.REQUIRED;
            }
            case VALUE: {
                return OperationOutcome.IssueType.VALUE;
            }
            case INVARIANT: {
                return OperationOutcome.IssueType.INVARIANT;
            }
            case SECURITY: {
                return OperationOutcome.IssueType.SECURITY;
            }
            case LOGIN: {
                return OperationOutcome.IssueType.LOGIN;
            }
            case UNKNOWN: {
                return OperationOutcome.IssueType.UNKNOWN;
            }
            case EXPIRED: {
                return OperationOutcome.IssueType.EXPIRED;
            }
            case FORBIDDEN: {
                return OperationOutcome.IssueType.FORBIDDEN;
            }
            case SUPPRESSED: {
                return OperationOutcome.IssueType.SUPPRESSED;
            }
            case PROCESSING: {
                return OperationOutcome.IssueType.PROCESSING;
            }
            case NOTSUPPORTED: {
                return OperationOutcome.IssueType.NOTSUPPORTED;
            }
            case DUPLICATE: {
                return OperationOutcome.IssueType.DUPLICATE;
            }
            case NOTFOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case TOOLONG: {
                return OperationOutcome.IssueType.TOOLONG;
            }
            case CODEINVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case EXTENSION: {
                return OperationOutcome.IssueType.EXTENSION;
            }
            case TOOCOSTLY: {
                return OperationOutcome.IssueType.TOOCOSTLY;
            }
            case BUSINESSRULE: {
                return OperationOutcome.IssueType.BUSINESSRULE;
            }
            case CONFLICT: {
                return OperationOutcome.IssueType.CONFLICT;
            }
            case INCOMPLETE: {
                return OperationOutcome.IssueType.INCOMPLETE;
            }
            case TRANSIENT: {
                return OperationOutcome.IssueType.TRANSIENT;
            }
            case LOCKERROR: {
                return OperationOutcome.IssueType.LOCKERROR;
            }
            case NOSTORE: {
                return OperationOutcome.IssueType.NOSTORE;
            }
            case EXCEPTION: {
                return OperationOutcome.IssueType.EXCEPTION;
            }
            case TIMEOUT: {
                return OperationOutcome.IssueType.TIMEOUT;
            }
            case THROTTLED: {
                return OperationOutcome.IssueType.THROTTLED;
            }
            case INFORMATIONAL: {
                return OperationOutcome.IssueType.INFORMATIONAL;
            }
        }
        return OperationOutcome.IssueType.NULL;
    }

    private static OperationOutcome.IssueType convertIssueType(OperationOutcome.IssueType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INVALID: {
                return OperationOutcome.IssueType.INVALID;
            }
            case STRUCTURE: {
                return OperationOutcome.IssueType.STRUCTURE;
            }
            case REQUIRED: {
                return OperationOutcome.IssueType.REQUIRED;
            }
            case VALUE: {
                return OperationOutcome.IssueType.VALUE;
            }
            case INVARIANT: {
                return OperationOutcome.IssueType.INVARIANT;
            }
            case SECURITY: {
                return OperationOutcome.IssueType.SECURITY;
            }
            case LOGIN: {
                return OperationOutcome.IssueType.LOGIN;
            }
            case UNKNOWN: {
                return OperationOutcome.IssueType.UNKNOWN;
            }
            case EXPIRED: {
                return OperationOutcome.IssueType.EXPIRED;
            }
            case FORBIDDEN: {
                return OperationOutcome.IssueType.FORBIDDEN;
            }
            case SUPPRESSED: {
                return OperationOutcome.IssueType.SUPPRESSED;
            }
            case PROCESSING: {
                return OperationOutcome.IssueType.PROCESSING;
            }
            case NOTSUPPORTED: {
                return OperationOutcome.IssueType.NOTSUPPORTED;
            }
            case DUPLICATE: {
                return OperationOutcome.IssueType.DUPLICATE;
            }
            case NOTFOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case TOOLONG: {
                return OperationOutcome.IssueType.TOOLONG;
            }
            case CODEINVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case EXTENSION: {
                return OperationOutcome.IssueType.EXTENSION;
            }
            case TOOCOSTLY: {
                return OperationOutcome.IssueType.TOOCOSTLY;
            }
            case BUSINESSRULE: {
                return OperationOutcome.IssueType.BUSINESSRULE;
            }
            case CONFLICT: {
                return OperationOutcome.IssueType.CONFLICT;
            }
            case INCOMPLETE: {
                return OperationOutcome.IssueType.INCOMPLETE;
            }
            case TRANSIENT: {
                return OperationOutcome.IssueType.TRANSIENT;
            }
            case LOCKERROR: {
                return OperationOutcome.IssueType.LOCKERROR;
            }
            case NOSTORE: {
                return OperationOutcome.IssueType.NOSTORE;
            }
            case EXCEPTION: {
                return OperationOutcome.IssueType.EXCEPTION;
            }
            case TIMEOUT: {
                return OperationOutcome.IssueType.TIMEOUT;
            }
            case THROTTLED: {
                return OperationOutcome.IssueType.THROTTLED;
            }
            case INFORMATIONAL: {
                return OperationOutcome.IssueType.INFORMATIONAL;
            }
        }
        return OperationOutcome.IssueType.NULL;
    }

    public static org.hl7.fhir.r4.model.Organization convertOrganization(Organization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Organization tgt = new org.hl7.fhir.r4.model.Organization();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_40.convertAddress((Address)t));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_40.convertReference(src.getPartOf()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertOrganizationContactComponent((Organization.OrganizationContactComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static Organization convertOrganization(org.hl7.fhir.r4.model.Organization src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization tgt = new Organization();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        for (Identifier t : src.getType()) {
            tgt.addType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (Identifier t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_40.convertAddress((org.hl7.fhir.r4.model.Address)t));
        }
        if (src.hasPartOf()) {
            tgt.setPartOf(VersionConvertor_30_40.convertReference(src.getPartOf()));
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertOrganizationContactComponent((Organization.OrganizationContactComponent)t));
        }
        for (Identifier t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasPurpose()) {
            tgt.setPurpose(VersionConvertor_30_40.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_30_40.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_40.convertAddress(src.getAddress()));
        }
        return tgt;
    }

    public static Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasPurpose()) {
            tgt.setPurpose(VersionConvertor_30_40.convertCodeableConcept(src.getPurpose()));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_30_40.convertHumanName(src.getName()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint(t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_40.convertAddress(src.getAddress()));
        }
        return tgt;
    }

    public static Patient convertPatient(org.hl7.fhir.dstu3.model.Patient src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient tgt = new Patient();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getName()) {
            tgt.addName(VersionConvertor_30_40.convertHumanName((HumanName)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_30_40.convertAdministrativeGender(src.getGender()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDate(src.getBirthDate());
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_30_40.convertType(src.getDeceased()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_40.convertAddress((Address)t));
        }
        if (src.hasMaritalStatus()) {
            tgt.setMaritalStatus(VersionConvertor_30_40.convertCodeableConcept(src.getMaritalStatus()));
        }
        if (src.hasMultipleBirth()) {
            tgt.setMultipleBirth(VersionConvertor_30_40.convertType(src.getMultipleBirth()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_40.convertAttachment((org.hl7.fhir.dstu3.model.Attachment)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactComponent((Patient.ContactComponent)t));
        }
        if (src.hasAnimal()) {
            tgt.addExtension(VersionConvertor_30_40.convertAnimalComponent(src.getAnimal()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_30_40.convertPatientCommunicationComponent((Patient.PatientCommunicationComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getGeneralPractitioner()) {
            tgt.addGeneralPractitioner(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertPatientLinkComponent((Patient.PatientLinkComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Patient convertPatient(Patient src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Patient tgt = new org.hl7.fhir.dstu3.model.Patient();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        for (Identifier t : src.getName()) {
            tgt.addName(VersionConvertor_30_40.convertHumanName((org.hl7.fhir.r4.model.HumanName)t));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_30_40.convertAdministrativeGender(src.getGender()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDate(src.getBirthDate());
        }
        if (src.hasDeceased()) {
            tgt.setDeceased(VersionConvertor_30_40.convertType(src.getDeceased()));
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_40.convertAddress((org.hl7.fhir.r4.model.Address)t));
        }
        if (src.hasMaritalStatus()) {
            tgt.setMaritalStatus(VersionConvertor_30_40.convertCodeableConcept(src.getMaritalStatus()));
        }
        if (src.hasMultipleBirth()) {
            tgt.setMultipleBirth(VersionConvertor_30_40.convertType(src.getMultipleBirth()));
        }
        for (Identifier t : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_40.convertAttachment((Attachment)t));
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactComponent((Patient.ContactComponent)t));
        }
        if (src.hasExtension("http://hl7.org/fhir/StructureDefinition/patient-animal")) {
            tgt.setAnimal(VersionConvertor_30_40.convertAnimalComponent(src.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/patient-animal")));
        }
        for (Identifier t : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_30_40.convertPatientCommunicationComponent((Patient.PatientCommunicationComponent)t));
        }
        for (Identifier t : src.getGeneralPractitioner()) {
            tgt.addGeneralPractitioner(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        for (Identifier t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertPatientLinkComponent((Patient.PatientLinkComponent)t));
        }
        return tgt;
    }

    public static Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getRelationship()) {
            tgt.addRelationship(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_30_40.convertHumanName(src.getName()));
        }
        for (CodeableConcept t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_40.convertAddress(src.getAddress()));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_30_40.convertAdministrativeGender(src.getGender()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_30_40.convertReference(src.getOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getRelationship()) {
            tgt.addRelationship(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasName()) {
            tgt.setName(VersionConvertor_30_40.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        if (src.hasAddress()) {
            tgt.setAddress(VersionConvertor_30_40.convertAddress(src.getAddress()));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_30_40.convertAdministrativeGender(src.getGender()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_30_40.convertReference(src.getOrganization()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static Extension convertAnimalComponent(Patient.AnimalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Extension tgt = new Extension();
        tgt.setUrl("http://hl7.org/fhir/StructureDefinition/patient-animal");
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasSpecies()) {
            tgt.addExtension("species", (org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertCodeableConcept(src.getSpecies()));
        }
        if (src.hasBreed()) {
            tgt.addExtension("breed", (org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertCodeableConcept(src.getBreed()));
        }
        if (src.hasGenderStatus()) {
            tgt.addExtension("genderStatus", (org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertCodeableConcept(src.getGenderStatus()));
        }
        return tgt;
    }

    public static Patient.AnimalComponent convertAnimalComponent(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.AnimalComponent tgt = new Patient.AnimalComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasExtension("species")) {
            tgt.setSpecies(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src.getExtensionByUrl("species").getValue()));
        }
        if (src.hasExtension("breed")) {
            tgt.setBreed(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src.getExtensionByUrl("breed").getValue()));
        }
        if (src.hasExtension("genderStatus")) {
            tgt.setGenderStatus(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src.getExtensionByUrl("genderStatus").getValue()));
        }
        return tgt;
    }

    public static Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(VersionConvertor_30_40.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferred(src.getPreferred());
        }
        return tgt;
    }

    public static Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLanguage()) {
            tgt.setLanguage(VersionConvertor_30_40.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferred(src.getPreferred());
        }
        return tgt;
    }

    public static Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasOther()) {
            tgt.setOther(VersionConvertor_30_40.convertReference(src.getOther()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertLinkType(src.getType()));
        }
        return tgt;
    }

    public static Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasOther()) {
            tgt.setOther(VersionConvertor_30_40.convertReference(src.getOther()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertLinkType(src.getType()));
        }
        return tgt;
    }

    private static Patient.LinkType convertLinkType(Patient.LinkType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACEDBY: {
                return Patient.LinkType.REPLACEDBY;
            }
            case REPLACES: {
                return Patient.LinkType.REPLACES;
            }
            case REFER: {
                return Patient.LinkType.REFER;
            }
            case SEEALSO: {
                return Patient.LinkType.SEEALSO;
            }
        }
        return Patient.LinkType.NULL;
    }

    private static Patient.LinkType convertLinkType(Patient.LinkType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACEDBY: {
                return Patient.LinkType.REPLACEDBY;
            }
            case REPLACES: {
                return Patient.LinkType.REPLACES;
            }
            case REFER: {
                return Patient.LinkType.REFER;
            }
            case SEEALSO: {
                return Patient.LinkType.SEEALSO;
            }
        }
        return Patient.LinkType.NULL;
    }

    public static org.hl7.fhir.r4.model.PaymentNotice convertPaymentNotice(PaymentNotice src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.PaymentNotice tgt = new org.hl7.fhir.r4.model.PaymentNotice();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPaymentNoticeStatus(src.getStatus()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(VersionConvertor_30_40.convertReference(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_30_40.convertReference(src.getResponse()));
        }
        if (src.hasStatusDate()) {
            tgt.setPaymentDate(src.getStatusDate());
        }
        if (src.hasCreated()) {
            tgt.setCreated(src.getCreated());
        }
        if (src.hasTarget()) {
            tgt.setRecipient(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(VersionConvertor_30_40.convertReference(src.getProvider()));
        }
        if (src.hasPaymentStatus()) {
            tgt.setPaymentStatus(VersionConvertor_30_40.convertCodeableConcept(src.getPaymentStatus()));
        }
        return tgt;
    }

    public static PaymentNotice convertPaymentNotice(org.hl7.fhir.r4.model.PaymentNotice src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PaymentNotice tgt = new PaymentNotice();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPaymentNoticeStatus(src.getStatus()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(VersionConvertor_30_40.convertReference(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_30_40.convertReference(src.getResponse()));
        }
        if (src.hasPaymentDate()) {
            tgt.setStatusDate(src.getPaymentDate());
        }
        if (src.hasCreated()) {
            tgt.setCreated(src.getCreated());
        }
        if (src.hasRecipient()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getRecipient()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(VersionConvertor_30_40.convertReference(src.getProvider()));
        }
        if (src.hasPaymentStatus()) {
            tgt.setPaymentStatus(VersionConvertor_30_40.convertCodeableConcept(src.getPaymentStatus()));
        }
        return tgt;
    }

    private static PaymentNotice.PaymentNoticeStatus convertPaymentNoticeStatus(PaymentNotice.PaymentNoticeStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return PaymentNotice.PaymentNoticeStatus.ACTIVE;
            }
            case CANCELLED: {
                return PaymentNotice.PaymentNoticeStatus.CANCELLED;
            }
            case DRAFT: {
                return PaymentNotice.PaymentNoticeStatus.DRAFT;
            }
            case ENTEREDINERROR: {
                return PaymentNotice.PaymentNoticeStatus.ENTEREDINERROR;
            }
        }
        return PaymentNotice.PaymentNoticeStatus.NULL;
    }

    private static PaymentNotice.PaymentNoticeStatus convertPaymentNoticeStatus(PaymentNotice.PaymentNoticeStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return PaymentNotice.PaymentNoticeStatus.ACTIVE;
            }
            case CANCELLED: {
                return PaymentNotice.PaymentNoticeStatus.CANCELLED;
            }
            case DRAFT: {
                return PaymentNotice.PaymentNoticeStatus.DRAFT;
            }
            case ENTEREDINERROR: {
                return PaymentNotice.PaymentNoticeStatus.ENTEREDINERROR;
            }
        }
        return PaymentNotice.PaymentNoticeStatus.NULL;
    }

    public static org.hl7.fhir.r4.model.Person convertPerson(Person src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Person tgt = new org.hl7.fhir.r4.model.Person();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getName()) {
            tgt.addName(VersionConvertor_30_40.convertHumanName((HumanName)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_30_40.convertAdministrativeGender(src.getGender()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDate(src.getBirthDate());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_40.convertAddress((Address)t));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_40.convertAttachment(src.getPhoto()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertPersonLinkComponent((Person.PersonLinkComponent)t));
        }
        return tgt;
    }

    public static Person convertPerson(org.hl7.fhir.r4.model.Person src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Person tgt = new Person();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        for (Identifier t : src.getName()) {
            tgt.addName(VersionConvertor_30_40.convertHumanName((org.hl7.fhir.r4.model.HumanName)t));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_30_40.convertAdministrativeGender(src.getGender()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDate(src.getBirthDate());
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_40.convertAddress((org.hl7.fhir.r4.model.Address)t));
        }
        if (src.hasPhoto()) {
            tgt.setPhoto(VersionConvertor_30_40.convertAttachment(src.getPhoto()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(VersionConvertor_30_40.convertReference(src.getManagingOrganization()));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        for (Identifier t : src.getLink()) {
            tgt.addLink(VersionConvertor_30_40.convertPersonLinkComponent((Person.PersonLinkComponent)t));
        }
        return tgt;
    }

    public static Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        if (src.hasAssurance()) {
            tgt.setAssurance(VersionConvertor_30_40.convertIdentityAssuranceLevel(src.getAssurance()));
        }
        return tgt;
    }

    public static Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        if (src.hasAssurance()) {
            tgt.setAssurance(VersionConvertor_30_40.convertIdentityAssuranceLevel(src.getAssurance()));
        }
        return tgt;
    }

    private static Person.IdentityAssuranceLevel convertIdentityAssuranceLevel(Person.IdentityAssuranceLevel src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LEVEL1: {
                return Person.IdentityAssuranceLevel.LEVEL1;
            }
            case LEVEL2: {
                return Person.IdentityAssuranceLevel.LEVEL2;
            }
            case LEVEL3: {
                return Person.IdentityAssuranceLevel.LEVEL3;
            }
            case LEVEL4: {
                return Person.IdentityAssuranceLevel.LEVEL4;
            }
        }
        return Person.IdentityAssuranceLevel.NULL;
    }

    private static Person.IdentityAssuranceLevel convertIdentityAssuranceLevel(Person.IdentityAssuranceLevel src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LEVEL1: {
                return Person.IdentityAssuranceLevel.LEVEL1;
            }
            case LEVEL2: {
                return Person.IdentityAssuranceLevel.LEVEL2;
            }
            case LEVEL3: {
                return Person.IdentityAssuranceLevel.LEVEL3;
            }
            case LEVEL4: {
                return Person.IdentityAssuranceLevel.LEVEL4;
            }
        }
        return Person.IdentityAssuranceLevel.NULL;
    }

    public static org.hl7.fhir.r4.model.Practitioner convertPractitioner(Practitioner src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Practitioner tgt = new org.hl7.fhir.r4.model.Practitioner();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getName()) {
            tgt.addName(VersionConvertor_30_40.convertHumanName((HumanName)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_40.convertAddress((Address)t));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_30_40.convertAdministrativeGender(src.getGender()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDate(src.getBirthDate());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_40.convertAttachment((org.hl7.fhir.dstu3.model.Attachment)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getQualification()) {
            tgt.addQualification(VersionConvertor_30_40.convertPractitionerQualificationComponent((Practitioner.PractitionerQualificationComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        return tgt;
    }

    public static Practitioner convertPractitioner(org.hl7.fhir.r4.model.Practitioner src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner tgt = new Practitioner();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        for (Identifier t : src.getName()) {
            tgt.addName(VersionConvertor_30_40.convertHumanName((org.hl7.fhir.r4.model.HumanName)t));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(VersionConvertor_30_40.convertAddress((org.hl7.fhir.r4.model.Address)t));
        }
        if (src.hasGender()) {
            tgt.setGender(VersionConvertor_30_40.convertAdministrativeGender(src.getGender()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDate(src.getBirthDate());
        }
        for (Identifier t : src.getPhoto()) {
            tgt.addPhoto(VersionConvertor_30_40.convertAttachment((Attachment)t));
        }
        for (Identifier t : src.getQualification()) {
            tgt.addQualification(VersionConvertor_30_40.convertPractitionerQualificationComponent((Practitioner.PractitionerQualificationComponent)t));
        }
        for (Identifier t : src.getCommunication()) {
            tgt.addCommunication(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(VersionConvertor_30_40.convertReference(src.getIssuer()));
        }
        return tgt;
    }

    public static Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasIssuer()) {
            tgt.setIssuer(VersionConvertor_30_40.convertReference(src.getIssuer()));
        }
        return tgt;
    }

    public static PractitionerRole convertPractitionerRole(org.hl7.fhir.dstu3.model.PractitionerRole src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole tgt = new PractitionerRole();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasPractitioner()) {
            tgt.setPractitioner(VersionConvertor_30_40.convertReference(src.getPractitioner()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_30_40.convertReference(src.getOrganization()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getHealthcareService()) {
            tgt.addHealthcareService(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((org.hl7.fhir.dstu3.model.ContactPoint)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getAvailableTime()) {
            tgt.addAvailableTime(VersionConvertor_30_40.convertPractitionerRoleAvailableTimeComponent((PractitionerRole.PractitionerRoleAvailableTimeComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNotAvailable()) {
            tgt.addNotAvailable(VersionConvertor_30_40.convertPractitionerRoleNotAvailableComponent((PractitionerRole.PractitionerRoleNotAvailableComponent)t));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptions(src.getAvailabilityExceptions());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PractitionerRole convertPractitionerRole(PractitionerRole src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.PractitionerRole tgt = new org.hl7.fhir.dstu3.model.PractitionerRole();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasPractitioner()) {
            tgt.setPractitioner(VersionConvertor_30_40.convertReference(src.getPractitioner()));
        }
        if (src.hasOrganization()) {
            tgt.setOrganization(VersionConvertor_30_40.convertReference(src.getOrganization()));
        }
        for (Identifier t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getLocation()) {
            tgt.addLocation(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getHealthcareService()) {
            tgt.addHealthcareService(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_30_40.convertContactPoint((ContactPoint)t));
        }
        for (Identifier t : src.getAvailableTime()) {
            tgt.addAvailableTime(VersionConvertor_30_40.convertPractitionerRoleAvailableTimeComponent((PractitionerRole.PractitionerRoleAvailableTimeComponent)t));
        }
        for (Identifier t : src.getNotAvailable()) {
            tgt.addNotAvailable(VersionConvertor_30_40.convertPractitionerRoleNotAvailableComponent((PractitionerRole.PractitionerRoleNotAvailableComponent)t));
        }
        if (src.hasAvailabilityExceptions()) {
            tgt.setAvailabilityExceptions(src.getAvailabilityExceptions());
        }
        for (Identifier t : src.getEndpoint()) {
            tgt.addEndpoint(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleAvailableTimeComponent convertPractitionerRoleAvailableTimeComponent(PractitionerRole.PractitionerRoleAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleAvailableTimeComponent tgt = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getDaysOfWeek()) {
            tgt.addDaysOfWeek(VersionConvertor_30_40.convertDaysOfWeek((PractitionerRole.DaysOfWeek)t.getValue()));
        }
        if (src.hasAllDay()) {
            tgt.setAllDay(src.getAllDay());
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTime(src.getAvailableStartTime());
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTime(src.getAvailableEndTime());
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleAvailableTimeComponent convertPractitionerRoleAvailableTimeComponent(PractitionerRole.PractitionerRoleAvailableTimeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleAvailableTimeComponent tgt = new PractitionerRole.PractitionerRoleAvailableTimeComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (Enumeration t : src.getDaysOfWeek()) {
            tgt.addDaysOfWeek(VersionConvertor_30_40.convertDaysOfWeek((PractitionerRole.DaysOfWeek)t.getValue()));
        }
        if (src.hasAllDay()) {
            tgt.setAllDay(src.getAllDay());
        }
        if (src.hasAvailableStartTime()) {
            tgt.setAvailableStartTime(src.getAvailableStartTime());
        }
        if (src.hasAvailableEndTime()) {
            tgt.setAvailableEndTime(src.getAvailableEndTime());
        }
        return tgt;
    }

    private static PractitionerRole.DaysOfWeek convertDaysOfWeek(PractitionerRole.DaysOfWeek src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MON: {
                return PractitionerRole.DaysOfWeek.MON;
            }
            case TUE: {
                return PractitionerRole.DaysOfWeek.TUE;
            }
            case WED: {
                return PractitionerRole.DaysOfWeek.WED;
            }
            case THU: {
                return PractitionerRole.DaysOfWeek.THU;
            }
            case FRI: {
                return PractitionerRole.DaysOfWeek.FRI;
            }
            case SAT: {
                return PractitionerRole.DaysOfWeek.SAT;
            }
            case SUN: {
                return PractitionerRole.DaysOfWeek.SUN;
            }
        }
        return PractitionerRole.DaysOfWeek.NULL;
    }

    private static PractitionerRole.DaysOfWeek convertDaysOfWeek(PractitionerRole.DaysOfWeek src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MON: {
                return PractitionerRole.DaysOfWeek.MON;
            }
            case TUE: {
                return PractitionerRole.DaysOfWeek.TUE;
            }
            case WED: {
                return PractitionerRole.DaysOfWeek.WED;
            }
            case THU: {
                return PractitionerRole.DaysOfWeek.THU;
            }
            case FRI: {
                return PractitionerRole.DaysOfWeek.FRI;
            }
            case SAT: {
                return PractitionerRole.DaysOfWeek.SAT;
            }
            case SUN: {
                return PractitionerRole.DaysOfWeek.SUN;
            }
        }
        return PractitionerRole.DaysOfWeek.NULL;
    }

    public static PractitionerRole.PractitionerRoleNotAvailableComponent convertPractitionerRoleNotAvailableComponent(PractitionerRole.PractitionerRoleNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleNotAvailableComponent tgt = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static PractitionerRole.PractitionerRoleNotAvailableComponent convertPractitionerRoleNotAvailableComponent(PractitionerRole.PractitionerRoleNotAvailableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PractitionerRole.PractitionerRoleNotAvailableComponent tgt = new PractitionerRole.PractitionerRoleNotAvailableComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasDuring()) {
            tgt.setDuring(VersionConvertor_30_40.convertPeriod(src.getDuring()));
        }
        return tgt;
    }

    public static Provenance convertProvenance(org.hl7.fhir.dstu3.model.Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance tgt = new Provenance();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (Reference t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasPeriod()) {
            tgt.setOccurred((org.hl7.fhir.r4.model.Type)VersionConvertor_30_40.convertPeriod(src.getPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecorded(src.getRecorded());
        }
        for (Reference t : src.getPolicy()) {
            tgt.addPolicy((String)t.getValue());
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (Reference t : src.getReason()) {
            tgt.addReason(VersionConvertor_30_40.convertCodingToCodeableConcept((Coding)t));
        }
        if (src.hasActivity()) {
            tgt.setActivity(VersionConvertor_30_40.convertCodingToCodeableConcept(src.getActivity()));
        }
        for (Reference t : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_40.convertProvenanceAgentComponent((Provenance.ProvenanceAgentComponent)t));
        }
        for (Reference t : src.getEntity()) {
            tgt.addEntity(VersionConvertor_30_40.convertProvenanceEntityComponent((Provenance.ProvenanceEntityComponent)t));
        }
        for (Reference t : src.getSignature()) {
            tgt.addSignature(VersionConvertor_30_40.convertSignature((Signature)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Provenance convertProvenance(Provenance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Provenance tgt = new org.hl7.fhir.dstu3.model.Provenance();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (org.hl7.fhir.r4.model.Reference t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasOccurredPeriod()) {
            tgt.setPeriod(VersionConvertor_30_40.convertPeriod(src.getOccurredPeriod()));
        }
        if (src.hasRecorded()) {
            tgt.setRecorded(src.getRecorded());
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getPolicy()) {
            tgt.addPolicy((String)t.getValue());
        }
        if (src.hasLocation()) {
            tgt.setLocation(VersionConvertor_30_40.convertReference(src.getLocation()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getReason()) {
            for (org.hl7.fhir.r4.model.Coding tc : t.getCoding()) {
                tgt.addReason(VersionConvertor_30_40.convertCoding(tc));
            }
        }
        if (src.hasActivity()) {
            tgt.setActivity(VersionConvertor_30_40.convertCoding(src.getActivity()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_40.convertProvenanceAgentComponent((Provenance.ProvenanceAgentComponent)t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getEntity()) {
            tgt.addEntity(VersionConvertor_30_40.convertProvenanceEntityComponent((Provenance.ProvenanceEntityComponent)t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getSignature()) {
            tgt.addSignature(VersionConvertor_30_40.convertSignature((org.hl7.fhir.r4.model.Signature)t));
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        org.hl7.fhir.r4.model.Type t;
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (CodeableConcept t2 : src.getRole()) {
            tgt.addRole(VersionConvertor_30_40.convertCodeableConcept(t2));
        }
        if (src.hasWho()) {
            t = VersionConvertor_30_40.convertType(src.getWho());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setWho((org.hl7.fhir.r4.model.Reference)t);
            }
            if (t instanceof UriType) {
                tgt.getWho().setReference(t.primitiveValue());
            }
        }
        if (src.hasOnBehalfOf()) {
            t = VersionConvertor_30_40.convertType(src.getOnBehalfOf());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setOnBehalfOf((org.hl7.fhir.r4.model.Reference)t);
            }
            if (t instanceof UriType) {
                tgt.getOnBehalfOf().setReference(t.primitiveValue());
            }
        }
        return tgt;
    }

    public static Provenance.ProvenanceAgentComponent convertProvenanceAgentComponent(Provenance.ProvenanceAgentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceAgentComponent tgt = new Provenance.ProvenanceAgentComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getRole()) {
            tgt.addRole(VersionConvertor_30_40.convertCodeableConcept(t));
        }
        if (src.hasWho()) {
            tgt.setWho(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getWho()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getOnBehalfOf()));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertProvenanceEntityRole(src.getRole()));
        }
        if (src.hasWhat()) {
            org.hl7.fhir.r4.model.Type t = VersionConvertor_30_40.convertType(src.getWhat());
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setWhat((org.hl7.fhir.r4.model.Reference)t);
            } else if (t instanceof Identifier) {
                tgt.getWhat().setIdentifier((Identifier)t);
            } else if (t instanceof UriType) {
                tgt.getWhat().setReference(t.primitiveValue());
            }
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_40.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    public static Provenance.ProvenanceEntityComponent convertProvenanceEntityComponent(Provenance.ProvenanceEntityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Provenance.ProvenanceEntityComponent tgt = new Provenance.ProvenanceEntityComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_40.convertProvenanceEntityRole(src.getRole()));
        }
        if (src.hasWhat()) {
            tgt.setWhat(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getWhat()));
        }
        for (Provenance.ProvenanceAgentComponent t : src.getAgent()) {
            tgt.addAgent(VersionConvertor_30_40.convertProvenanceAgentComponent(t));
        }
        return tgt;
    }

    private static Provenance.ProvenanceEntityRole convertProvenanceEntityRole(Provenance.ProvenanceEntityRole src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DERIVATION: {
                return Provenance.ProvenanceEntityRole.DERIVATION;
            }
            case REVISION: {
                return Provenance.ProvenanceEntityRole.REVISION;
            }
            case QUOTATION: {
                return Provenance.ProvenanceEntityRole.QUOTATION;
            }
            case SOURCE: {
                return Provenance.ProvenanceEntityRole.SOURCE;
            }
            case REMOVAL: {
                return Provenance.ProvenanceEntityRole.REMOVAL;
            }
        }
        return Provenance.ProvenanceEntityRole.NULL;
    }

    private static Provenance.ProvenanceEntityRole convertProvenanceEntityRole(Provenance.ProvenanceEntityRole src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DERIVATION: {
                return Provenance.ProvenanceEntityRole.DERIVATION;
            }
            case REVISION: {
                return Provenance.ProvenanceEntityRole.REVISION;
            }
            case QUOTATION: {
                return Provenance.ProvenanceEntityRole.QUOTATION;
            }
            case SOURCE: {
                return Provenance.ProvenanceEntityRole.SOURCE;
            }
            case REMOVAL: {
                return Provenance.ProvenanceEntityRole.REMOVAL;
            }
        }
        return Provenance.ProvenanceEntityRole.NULL;
    }

    public static Questionnaire convertQuestionnaire(org.hl7.fhir.dstu3.model.Questionnaire src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire tgt = new Questionnaire();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDate(src.getApprovalDate());
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDate(src.getLastReviewDate());
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_40.convertPeriod(src.getEffectivePeriod()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((org.hl7.fhir.dstu3.model.ContactDetail)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding((Coding)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSubjectType()) {
            tgt.addSubjectType((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Questionnaire convertQuestionnaire(Questionnaire src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Questionnaire tgt = new org.hl7.fhir.dstu3.model.Questionnaire();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasApprovalDate()) {
            tgt.setApprovalDate(src.getApprovalDate());
        }
        if (src.hasLastReviewDate()) {
            tgt.setLastReviewDate(src.getLastReviewDate());
        }
        if (src.hasEffectivePeriod()) {
            tgt.setEffectivePeriod(VersionConvertor_30_40.convertPeriod(src.getEffectivePeriod()));
        }
        for (Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((ContactDetail)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Identifier t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        for (Identifier t : src.getSubjectType()) {
            tgt.addSubjectType((String)t.getValue());
        }
        for (Identifier t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLinkId()) {
            tgt.setLinkId(src.getLinkId());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        for (Coding t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasPrefix()) {
            tgt.setPrefix(src.getPrefix());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertQuestionnaireItemType(src.getType()));
        }
        for (Coding t : src.getEnableWhen()) {
            tgt.addEnableWhen(VersionConvertor_30_40.convertQuestionnaireItemEnableWhenComponent((Questionnaire.QuestionnaireItemEnableWhenComponent)t));
        }
        tgt.setEnableBehavior(Questionnaire.EnableWhenBehavior.ANY);
        if (src.hasRequired()) {
            tgt.setRequired(src.getRequired());
        }
        if (src.hasRepeats()) {
            tgt.setRepeats(src.getRepeats());
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnly(src.getReadOnly());
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        if (src.hasOptions()) {
            tgt.setAnswerValueSetElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getOptions()));
        }
        for (Coding t : src.getOption()) {
            tgt.addAnswerOption(VersionConvertor_30_40.convertQuestionnaireItemOptionComponent((Questionnaire.QuestionnaireItemOptionComponent)t));
        }
        if (src.hasInitial()) {
            tgt.addInitial().setValue(VersionConvertor_30_40.convertType(src.getInitial()));
        }
        for (Coding t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        for (Coding t : src.getModifierExtension()) {
            tgt.addModifierExtension(VersionConvertor_30_40.convertExtension((org.hl7.fhir.dstu3.model.Extension)t));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemComponent convertQuestionnaireItemComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLinkId()) {
            tgt.setLinkId(src.getLinkId());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getCode()) {
            tgt.addCode(VersionConvertor_30_40.convertCoding(t));
        }
        if (src.hasPrefix()) {
            tgt.setPrefix(src.getPrefix());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertQuestionnaireItemType(src.getType()));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getEnableWhen()) {
            tgt.addEnableWhen(VersionConvertor_30_40.convertQuestionnaireItemEnableWhenComponent((Questionnaire.QuestionnaireItemEnableWhenComponent)t));
        }
        if (src.hasRequired()) {
            tgt.setRequired(src.getRequired());
        }
        if (src.hasRepeats()) {
            tgt.setRepeats(src.getRepeats());
        }
        if (src.hasReadOnly()) {
            tgt.setReadOnly(src.getReadOnly());
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        if (src.hasAnswerValueSet()) {
            tgt.setOptions(VersionConvertor_30_40.convertCanonicalToReference(src.getAnswerValueSetElement()));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getAnswerOption()) {
            tgt.addOption(VersionConvertor_30_40.convertQuestionnaireItemOptionComponent((Questionnaire.QuestionnaireItemAnswerOptionComponent)t));
        }
        if (src.hasInitial()) {
            tgt.setInitial(VersionConvertor_30_40.convertType(src.getInitialFirstRep().getValue()));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireItemComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    private static Questionnaire.QuestionnaireItemType convertQuestionnaireItemType(Questionnaire.QuestionnaireItemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GROUP: {
                return Questionnaire.QuestionnaireItemType.GROUP;
            }
            case DISPLAY: {
                return Questionnaire.QuestionnaireItemType.DISPLAY;
            }
            case QUESTION: {
                return Questionnaire.QuestionnaireItemType.QUESTION;
            }
            case BOOLEAN: {
                return Questionnaire.QuestionnaireItemType.BOOLEAN;
            }
            case DECIMAL: {
                return Questionnaire.QuestionnaireItemType.DECIMAL;
            }
            case INTEGER: {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case DATE: {
                return Questionnaire.QuestionnaireItemType.DATE;
            }
            case DATETIME: {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
            case TIME: {
                return Questionnaire.QuestionnaireItemType.TIME;
            }
            case STRING: {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case TEXT: {
                return Questionnaire.QuestionnaireItemType.TEXT;
            }
            case URL: {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case CHOICE: {
                return Questionnaire.QuestionnaireItemType.CHOICE;
            }
            case OPENCHOICE: {
                return Questionnaire.QuestionnaireItemType.OPENCHOICE;
            }
            case ATTACHMENT: {
                return Questionnaire.QuestionnaireItemType.ATTACHMENT;
            }
            case REFERENCE: {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case QUANTITY: {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
        }
        return Questionnaire.QuestionnaireItemType.NULL;
    }

    private static Questionnaire.QuestionnaireItemType convertQuestionnaireItemType(Questionnaire.QuestionnaireItemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GROUP: {
                return Questionnaire.QuestionnaireItemType.GROUP;
            }
            case DISPLAY: {
                return Questionnaire.QuestionnaireItemType.DISPLAY;
            }
            case QUESTION: {
                return Questionnaire.QuestionnaireItemType.QUESTION;
            }
            case BOOLEAN: {
                return Questionnaire.QuestionnaireItemType.BOOLEAN;
            }
            case DECIMAL: {
                return Questionnaire.QuestionnaireItemType.DECIMAL;
            }
            case INTEGER: {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case DATE: {
                return Questionnaire.QuestionnaireItemType.DATE;
            }
            case DATETIME: {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
            case TIME: {
                return Questionnaire.QuestionnaireItemType.TIME;
            }
            case STRING: {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case TEXT: {
                return Questionnaire.QuestionnaireItemType.TEXT;
            }
            case URL: {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case CHOICE: {
                return Questionnaire.QuestionnaireItemType.CHOICE;
            }
            case OPENCHOICE: {
                return Questionnaire.QuestionnaireItemType.OPENCHOICE;
            }
            case ATTACHMENT: {
                return Questionnaire.QuestionnaireItemType.ATTACHMENT;
            }
            case REFERENCE: {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case QUANTITY: {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
        }
        return Questionnaire.QuestionnaireItemType.NULL;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasQuestion()) {
            tgt.setQuestion(src.getQuestion());
        }
        if (src.hasHasAnswer()) {
            tgt.setOperator(Questionnaire.QuestionnaireItemOperator.EXISTS);
            tgt.setAnswer(VersionConvertor_30_40.convertType((Type)src.getHasAnswerElement()));
        } else if (src.hasAnswer()) {
            tgt.setOperator(Questionnaire.QuestionnaireItemOperator.EQUAL);
            tgt.setAnswer(VersionConvertor_30_40.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemEnableWhenComponent convertQuestionnaireItemEnableWhenComponent(Questionnaire.QuestionnaireItemEnableWhenComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemEnableWhenComponent tgt = new Questionnaire.QuestionnaireItemEnableWhenComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasQuestion()) {
            tgt.setQuestion(src.getQuestion());
        }
        if (src.hasOperator() && src.getOperator() == Questionnaire.QuestionnaireItemOperator.EXISTS) {
            tgt.setHasAnswer(((Boolean)src.getAnswerBooleanType().getValue()).booleanValue());
        } else if (src.hasAnswer()) {
            tgt.setAnswer(VersionConvertor_30_40.convertType(src.getAnswer()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemAnswerOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemOptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemAnswerOptionComponent tgt = new Questionnaire.QuestionnaireItemAnswerOptionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static Questionnaire.QuestionnaireItemOptionComponent convertQuestionnaireItemOptionComponent(Questionnaire.QuestionnaireItemAnswerOptionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Questionnaire.QuestionnaireItemOptionComponent tgt = new Questionnaire.QuestionnaireItemOptionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.QuestionnaireResponse convertQuestionnaireResponse(QuestionnaireResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.QuestionnaireResponse tgt = new org.hl7.fhir.r4.model.QuestionnaireResponse();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        for (Reference t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(t));
        }
        for (Reference t : src.getParent()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasQuestionnaire()) {
            tgt.setQuestionnaireElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getQuestionnaire()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertQuestionnaireResponseStatus(src.getStatus()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasAuthored()) {
            tgt.setAuthored(src.getAuthored());
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertReference(src.getSource()));
        }
        for (Reference t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireResponseItemComponent((QuestionnaireResponse.QuestionnaireResponseItemComponent)t));
        }
        return tgt;
    }

    public static QuestionnaireResponse convertQuestionnaireResponse(org.hl7.fhir.r4.model.QuestionnaireResponse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse tgt = new QuestionnaireResponse();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getPartOf()) {
            tgt.addParent(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasQuestionnaire()) {
            tgt.setQuestionnaire(VersionConvertor_30_40.convertCanonicalToReference(src.getQuestionnaireElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertQuestionnaireResponseStatus(src.getStatus()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasAuthored()) {
            tgt.setAuthored(src.getAuthored());
        }
        if (src.hasAuthor()) {
            tgt.setAuthor(VersionConvertor_30_40.convertReference(src.getAuthor()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_40.convertReference(src.getSource()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireResponseItemComponent((QuestionnaireResponse.QuestionnaireResponseItemComponent)t));
        }
        return tgt;
    }

    private static QuestionnaireResponse.QuestionnaireResponseStatus convertQuestionnaireResponseStatus(QuestionnaireResponse.QuestionnaireResponseStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS;
            }
            case COMPLETED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED;
            }
            case AMENDED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED;
            }
            case ENTEREDINERROR: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.ENTEREDINERROR;
            }
            case STOPPED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.STOPPED;
            }
        }
        return QuestionnaireResponse.QuestionnaireResponseStatus.NULL;
    }

    private static QuestionnaireResponse.QuestionnaireResponseStatus convertQuestionnaireResponseStatus(QuestionnaireResponse.QuestionnaireResponseStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS;
            }
            case COMPLETED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED;
            }
            case AMENDED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED;
            }
            case ENTEREDINERROR: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.ENTEREDINERROR;
            }
            case STOPPED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.STOPPED;
            }
        }
        return QuestionnaireResponse.QuestionnaireResponseStatus.NULL;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseItemComponent(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasLinkId()) {
            tgt.setLinkId(src.getLinkId());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(VersionConvertor_30_40.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireResponseItemComponent((QuestionnaireResponse.QuestionnaireResponseItemComponent)t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseItemComponent(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasLinkId()) {
            tgt.setLinkId(src.getLinkId());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasText()) {
            tgt.setText(src.getText());
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(VersionConvertor_30_40.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireResponseItemComponent((QuestionnaireResponse.QuestionnaireResponseItemComponent)t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addItem(VersionConvertor_30_40.convertQuestionnaireResponseItemComponent(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.RiskAssessment convertRiskAssessment(RiskAssessment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.RiskAssessment tgt = new org.hl7.fhir.r4.model.RiskAssessment();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasBasedOn()) {
            tgt.setBasedOn(VersionConvertor_30_40.convertReference(src.getBasedOn()));
        }
        if (src.hasParent()) {
            tgt.setParent(VersionConvertor_30_40.convertReference(src.getParent()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertRiskAssessmentStatus(src.getStatus()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        if (src.hasReason()) {
            org.hl7.fhir.r4.model.Type t = VersionConvertor_30_40.convertType(src.getReason());
            if (t instanceof org.hl7.fhir.r4.model.CodeableConcept) {
                tgt.addReasonCode((org.hl7.fhir.r4.model.CodeableConcept)t);
            } else {
                tgt.addReasonReference((org.hl7.fhir.r4.model.Reference)t);
            }
        }
        for (Reference t : src.getBasis()) {
            tgt.addBasis(VersionConvertor_30_40.convertReference(t));
        }
        for (Reference t : src.getPrediction()) {
            tgt.addPrediction(VersionConvertor_30_40.convertRiskAssessmentPredictionComponent((RiskAssessment.RiskAssessmentPredictionComponent)t));
        }
        if (src.hasMitigation()) {
            tgt.setMitigation(src.getMitigation());
        }
        if (src.hasComment()) {
            tgt.addNote().setText(src.getComment());
        }
        return tgt;
    }

    public static RiskAssessment convertRiskAssessment(org.hl7.fhir.r4.model.RiskAssessment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment tgt = new RiskAssessment();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasBasedOn()) {
            tgt.setBasedOn(VersionConvertor_30_40.convertReference(src.getBasedOn()));
        }
        if (src.hasParent()) {
            tgt.setParent(VersionConvertor_30_40.convertReference(src.getParent()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertRiskAssessmentStatus(src.getStatus()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(VersionConvertor_30_40.convertReference(src.getCondition()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        if (src.hasReasonCode()) {
            tgt.setReason(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getReasonCodeFirstRep()));
        }
        if (src.hasReasonReference()) {
            tgt.setReason(VersionConvertor_30_40.convertType((org.hl7.fhir.r4.model.Type)src.getReasonReferenceFirstRep()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getBasis()) {
            tgt.addBasis(VersionConvertor_30_40.convertReference(t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getPrediction()) {
            tgt.addPrediction(VersionConvertor_30_40.convertRiskAssessmentPredictionComponent((RiskAssessment.RiskAssessmentPredictionComponent)t));
        }
        if (src.hasMitigation()) {
            tgt.setMitigation(src.getMitigation());
        }
        if (src.hasNote()) {
            tgt.setComment(src.getNoteFirstRep().getText());
        }
        return tgt;
    }

    private static RiskAssessment.RiskAssessmentStatus convertRiskAssessmentStatus(RiskAssessment.RiskAssessmentStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return RiskAssessment.RiskAssessmentStatus.REGISTERED;
            }
            case PRELIMINARY: {
                return RiskAssessment.RiskAssessmentStatus.PRELIMINARY;
            }
            case FINAL: {
                return RiskAssessment.RiskAssessmentStatus.FINAL;
            }
            case AMENDED: {
                return RiskAssessment.RiskAssessmentStatus.AMENDED;
            }
            case CORRECTED: {
                return RiskAssessment.RiskAssessmentStatus.CORRECTED;
            }
            case CANCELLED: {
                return RiskAssessment.RiskAssessmentStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return RiskAssessment.RiskAssessmentStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return RiskAssessment.RiskAssessmentStatus.UNKNOWN;
            }
        }
        return RiskAssessment.RiskAssessmentStatus.NULL;
    }

    private static RiskAssessment.RiskAssessmentStatus convertRiskAssessmentStatus(RiskAssessment.RiskAssessmentStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return RiskAssessment.RiskAssessmentStatus.REGISTERED;
            }
            case PRELIMINARY: {
                return RiskAssessment.RiskAssessmentStatus.PRELIMINARY;
            }
            case FINAL: {
                return RiskAssessment.RiskAssessmentStatus.FINAL;
            }
            case AMENDED: {
                return RiskAssessment.RiskAssessmentStatus.AMENDED;
            }
            case CORRECTED: {
                return RiskAssessment.RiskAssessmentStatus.CORRECTED;
            }
            case CANCELLED: {
                return RiskAssessment.RiskAssessmentStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return RiskAssessment.RiskAssessmentStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return RiskAssessment.RiskAssessmentStatus.UNKNOWN;
            }
        }
        return RiskAssessment.RiskAssessmentStatus.NULL;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(VersionConvertor_30_40.convertType(src.getProbability()));
        }
        if (src.hasQualitativeRisk()) {
            tgt.setQualitativeRisk(VersionConvertor_30_40.convertCodeableConcept(src.getQualitativeRisk()));
        }
        if (src.hasRelativeRisk()) {
            tgt.setRelativeRisk(src.getRelativeRisk());
        }
        if (src.hasWhen()) {
            tgt.setWhen(VersionConvertor_30_40.convertType(src.getWhen()));
        }
        if (src.hasRationale()) {
            tgt.setRationale(src.getRationale());
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasOutcome()) {
            tgt.setOutcome(VersionConvertor_30_40.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(VersionConvertor_30_40.convertType(src.getProbability()));
        }
        if (src.hasQualitativeRisk()) {
            tgt.setQualitativeRisk(VersionConvertor_30_40.convertCodeableConcept(src.getQualitativeRisk()));
        }
        if (src.hasRelativeRisk()) {
            tgt.setRelativeRisk(src.getRelativeRisk());
        }
        if (src.hasWhen()) {
            tgt.setWhen(VersionConvertor_30_40.convertType(src.getWhen()));
        }
        if (src.hasRationale()) {
            tgt.setRationale(src.getRationale());
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Schedule convertSchedule(Schedule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Schedule tgt = new org.hl7.fhir.r4.model.Schedule();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasServiceCategory()) {
            tgt.addServiceCategory(VersionConvertor_30_40.convertCodeableConcept(src.getServiceCategory()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getActor()) {
            tgt.addActor(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_30_40.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static Schedule convertSchedule(org.hl7.fhir.r4.model.Schedule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Schedule tgt = new Schedule();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasActive()) {
            tgt.setActive(src.getActive());
        }
        if (src.hasServiceCategory()) {
            tgt.setServiceCategory(VersionConvertor_30_40.convertCodeableConcept(src.getServiceCategoryFirstRep()));
        }
        for (Identifier t : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getActor()) {
            tgt.addActor(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasPlanningHorizon()) {
            tgt.setPlanningHorizon(VersionConvertor_30_40.convertPeriod(src.getPlanningHorizon()));
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static SearchParameter convertSearchParameter(org.hl7.fhir.dstu3.model.SearchParameter src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SearchParameter tgt = new SearchParameter();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getBase()) {
            tgt.addBase((String)t.getValue());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertSearchParamType(src.getType()));
        }
        if (src.hasDerivedFrom()) {
            tgt.setDerivedFrom(src.getDerivedFrom());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        if (src.hasXpath()) {
            tgt.setXpath(src.getXpath());
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsage(VersionConvertor_30_40.convertXPathUsageType(src.getXpathUsage()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getTarget()) {
            tgt.addTarget((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getComparator()) {
            tgt.addComparator(VersionConvertor_30_40.convertSearchComparator((SearchParameter.SearchComparator)t.getValue()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getModifier()) {
            tgt.addModifier(VersionConvertor_30_40.convertSearchModifierCode((SearchParameter.SearchModifierCode)t.getValue()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getChain()) {
            tgt.addChain((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail t : src.getComponent()) {
            tgt.addComponent(VersionConvertor_30_40.convertSearchParameterComponentComponent((SearchParameter.SearchParameterComponentComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.SearchParameter convertSearchParameter(SearchParameter src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.SearchParameter tgt = new org.hl7.fhir.dstu3.model.SearchParameter();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail(t));
        }
        for (ContactDetail t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCode()) {
            tgt.setCode(src.getCode());
        }
        for (ContactDetail t : src.getBase()) {
            tgt.addBase((String)t.getValue());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertSearchParamType(src.getType()));
        }
        if (src.hasDerivedFrom()) {
            tgt.setDerivedFrom(src.getDerivedFrom());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        if (src.hasXpath()) {
            tgt.setXpath(src.getXpath());
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsage(VersionConvertor_30_40.convertXPathUsageType(src.getXpathUsage()));
        }
        for (ContactDetail t : src.getTarget()) {
            tgt.addTarget((String)t.getValue());
        }
        for (ContactDetail t : src.getComparator()) {
            tgt.addComparator(VersionConvertor_30_40.convertSearchComparator((SearchParameter.SearchComparator)t.getValue()));
        }
        for (ContactDetail t : src.getModifier()) {
            tgt.addModifier(VersionConvertor_30_40.convertSearchModifierCode((SearchParameter.SearchModifierCode)t.getValue()));
        }
        for (ContactDetail t : src.getChain()) {
            tgt.addChain((String)t.getValue());
        }
        for (ContactDetail t : src.getComponent()) {
            tgt.addComponent(VersionConvertor_30_40.convertSearchParameterComponentComponent((SearchParameter.SearchParameterComponentComponent)t));
        }
        return tgt;
    }

    private static SearchParameter.XPathUsageType convertXPathUsageType(SearchParameter.XPathUsageType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NORMAL: {
                return SearchParameter.XPathUsageType.NORMAL;
            }
            case PHONETIC: {
                return SearchParameter.XPathUsageType.PHONETIC;
            }
            case NEARBY: {
                return SearchParameter.XPathUsageType.NEARBY;
            }
            case DISTANCE: {
                return SearchParameter.XPathUsageType.DISTANCE;
            }
            case OTHER: {
                return SearchParameter.XPathUsageType.OTHER;
            }
        }
        return SearchParameter.XPathUsageType.NULL;
    }

    private static SearchParameter.XPathUsageType convertXPathUsageType(SearchParameter.XPathUsageType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NORMAL: {
                return SearchParameter.XPathUsageType.NORMAL;
            }
            case PHONETIC: {
                return SearchParameter.XPathUsageType.PHONETIC;
            }
            case NEARBY: {
                return SearchParameter.XPathUsageType.NEARBY;
            }
            case DISTANCE: {
                return SearchParameter.XPathUsageType.DISTANCE;
            }
            case OTHER: {
                return SearchParameter.XPathUsageType.OTHER;
            }
        }
        return SearchParameter.XPathUsageType.NULL;
    }

    private static SearchParameter.SearchComparator convertSearchComparator(SearchParameter.SearchComparator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQ: {
                return SearchParameter.SearchComparator.EQ;
            }
            case NE: {
                return SearchParameter.SearchComparator.NE;
            }
            case GT: {
                return SearchParameter.SearchComparator.GT;
            }
            case LT: {
                return SearchParameter.SearchComparator.LT;
            }
            case GE: {
                return SearchParameter.SearchComparator.GE;
            }
            case LE: {
                return SearchParameter.SearchComparator.LE;
            }
            case SA: {
                return SearchParameter.SearchComparator.SA;
            }
            case EB: {
                return SearchParameter.SearchComparator.EB;
            }
            case AP: {
                return SearchParameter.SearchComparator.AP;
            }
        }
        return SearchParameter.SearchComparator.NULL;
    }

    private static SearchParameter.SearchComparator convertSearchComparator(SearchParameter.SearchComparator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQ: {
                return SearchParameter.SearchComparator.EQ;
            }
            case NE: {
                return SearchParameter.SearchComparator.NE;
            }
            case GT: {
                return SearchParameter.SearchComparator.GT;
            }
            case LT: {
                return SearchParameter.SearchComparator.LT;
            }
            case GE: {
                return SearchParameter.SearchComparator.GE;
            }
            case LE: {
                return SearchParameter.SearchComparator.LE;
            }
            case SA: {
                return SearchParameter.SearchComparator.SA;
            }
            case EB: {
                return SearchParameter.SearchComparator.EB;
            }
            case AP: {
                return SearchParameter.SearchComparator.AP;
            }
        }
        return SearchParameter.SearchComparator.NULL;
    }

    private static SearchParameter.SearchModifierCode convertSearchModifierCode(SearchParameter.SearchModifierCode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MISSING: {
                return SearchParameter.SearchModifierCode.MISSING;
            }
            case EXACT: {
                return SearchParameter.SearchModifierCode.EXACT;
            }
            case CONTAINS: {
                return SearchParameter.SearchModifierCode.CONTAINS;
            }
            case NOT: {
                return SearchParameter.SearchModifierCode.NOT;
            }
            case TEXT: {
                return SearchParameter.SearchModifierCode.TEXT;
            }
            case IN: {
                return SearchParameter.SearchModifierCode.IN;
            }
            case NOTIN: {
                return SearchParameter.SearchModifierCode.NOTIN;
            }
            case BELOW: {
                return SearchParameter.SearchModifierCode.BELOW;
            }
            case ABOVE: {
                return SearchParameter.SearchModifierCode.ABOVE;
            }
            case TYPE: {
                return SearchParameter.SearchModifierCode.TYPE;
            }
        }
        return SearchParameter.SearchModifierCode.NULL;
    }

    private static SearchParameter.SearchModifierCode convertSearchModifierCode(SearchParameter.SearchModifierCode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MISSING: {
                return SearchParameter.SearchModifierCode.MISSING;
            }
            case EXACT: {
                return SearchParameter.SearchModifierCode.EXACT;
            }
            case CONTAINS: {
                return SearchParameter.SearchModifierCode.CONTAINS;
            }
            case NOT: {
                return SearchParameter.SearchModifierCode.NOT;
            }
            case TEXT: {
                return SearchParameter.SearchModifierCode.TEXT;
            }
            case IN: {
                return SearchParameter.SearchModifierCode.IN;
            }
            case NOTIN: {
                return SearchParameter.SearchModifierCode.NOTIN;
            }
            case BELOW: {
                return SearchParameter.SearchModifierCode.BELOW;
            }
            case ABOVE: {
                return SearchParameter.SearchModifierCode.ABOVE;
            }
            case TYPE: {
                return SearchParameter.SearchModifierCode.TYPE;
            }
        }
        return SearchParameter.SearchModifierCode.NULL;
    }

    public static SearchParameter.SearchParameterComponentComponent convertSearchParameterComponentComponent(SearchParameter.SearchParameterComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SearchParameter.SearchParameterComponentComponent tgt = new SearchParameter.SearchParameterComponentComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_40.convertReferenceToCanonical(src.getDefinition()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        return tgt;
    }

    public static SearchParameter.SearchParameterComponentComponent convertSearchParameterComponentComponent(SearchParameter.SearchParameterComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SearchParameter.SearchParameterComponentComponent tgt = new SearchParameter.SearchParameterComponentComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_30_40.convertCanonicalToReference(src.getDefinitionElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpression(src.getExpression());
        }
        return tgt;
    }

    public static MolecularSequence convertSequence(Sequence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence tgt = new MolecularSequence();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertSequenceType(src.getType()));
        }
        if (src.hasCoordinateSystem()) {
            tgt.setCoordinateSystem(src.getCoordinateSystem());
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_30_40.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertQuantity(src.getQuantity()));
        }
        if (src.hasReferenceSeq()) {
            tgt.setReferenceSeq(VersionConvertor_30_40.convertSequenceReferenceSeqComponent(src.getReferenceSeq()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getVariant()) {
            tgt.addVariant(VersionConvertor_30_40.convertSequenceVariantComponent((Sequence.SequenceVariantComponent)t));
        }
        if (src.hasObservedSeq()) {
            tgt.setObservedSeq(src.getObservedSeq());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getQuality()) {
            tgt.addQuality(VersionConvertor_30_40.convertSequenceQualityComponent((Sequence.SequenceQualityComponent)t));
        }
        if (src.hasReadCoverage()) {
            tgt.setReadCoverage(src.getReadCoverage());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getRepository()) {
            tgt.addRepository(VersionConvertor_30_40.convertSequenceRepositoryComponent((Sequence.SequenceRepositoryComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getPointer()) {
            tgt.addPointer(VersionConvertor_30_40.convertReference((Reference)t));
        }
        return tgt;
    }

    public static Sequence convertSequence(MolecularSequence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence tgt = new Sequence();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertSequenceType(src.getType()));
        }
        if (src.hasCoordinateSystem()) {
            tgt.setCoordinateSystem(src.getCoordinateSystem());
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasSpecimen()) {
            tgt.setSpecimen(VersionConvertor_30_40.convertReference(src.getSpecimen()));
        }
        if (src.hasDevice()) {
            tgt.setDevice(VersionConvertor_30_40.convertReference(src.getDevice()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(VersionConvertor_30_40.convertReference(src.getPerformer()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertQuantity(src.getQuantity()));
        }
        if (src.hasReferenceSeq()) {
            tgt.setReferenceSeq(VersionConvertor_30_40.convertSequenceReferenceSeqComponent(src.getReferenceSeq()));
        }
        for (Identifier t : src.getVariant()) {
            tgt.addVariant(VersionConvertor_30_40.convertSequenceVariantComponent((MolecularSequence.MolecularSequenceVariantComponent)t));
        }
        if (src.hasObservedSeq()) {
            tgt.setObservedSeq(src.getObservedSeq());
        }
        for (Identifier t : src.getQuality()) {
            tgt.addQuality(VersionConvertor_30_40.convertSequenceQualityComponent((MolecularSequence.MolecularSequenceQualityComponent)t));
        }
        if (src.hasReadCoverage()) {
            tgt.setReadCoverage(src.getReadCoverage());
        }
        for (Identifier t : src.getRepository()) {
            tgt.addRepository(VersionConvertor_30_40.convertSequenceRepositoryComponent((MolecularSequence.MolecularSequenceRepositoryComponent)t));
        }
        for (Identifier t : src.getPointer()) {
            tgt.addPointer(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    private static MolecularSequence.SequenceType convertSequenceType(Sequence.SequenceType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case AA: {
                return MolecularSequence.SequenceType.AA;
            }
            case DNA: {
                return MolecularSequence.SequenceType.DNA;
            }
            case RNA: {
                return MolecularSequence.SequenceType.RNA;
            }
        }
        return MolecularSequence.SequenceType.NULL;
    }

    private static Sequence.SequenceType convertSequenceType(MolecularSequence.SequenceType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case AA: {
                return Sequence.SequenceType.AA;
            }
            case DNA: {
                return Sequence.SequenceType.DNA;
            }
            case RNA: {
                return Sequence.SequenceType.RNA;
            }
        }
        return Sequence.SequenceType.NULL;
    }

    public static MolecularSequence.MolecularSequenceReferenceSeqComponent convertSequenceReferenceSeqComponent(Sequence.SequenceReferenceSeqComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceReferenceSeqComponent tgt = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasChromosome()) {
            tgt.setChromosome(VersionConvertor_30_40.convertCodeableConcept(src.getChromosome()));
        }
        if (src.hasGenomeBuild()) {
            tgt.setGenomeBuild(src.getGenomeBuild());
        }
        if (src.hasReferenceSeqId()) {
            tgt.setReferenceSeqId(VersionConvertor_30_40.convertCodeableConcept(src.getReferenceSeqId()));
        }
        if (src.hasReferenceSeqPointer()) {
            tgt.setReferenceSeqPointer(VersionConvertor_30_40.convertReference(src.getReferenceSeqPointer()));
        }
        if (src.hasReferenceSeqString()) {
            tgt.setReferenceSeqString(src.getReferenceSeqString());
        }
        if (src.hasWindowStart()) {
            tgt.setWindowStart(src.getWindowStart());
        }
        if (src.hasWindowEnd()) {
            tgt.setWindowEnd(src.getWindowEnd());
        }
        return tgt;
    }

    public static Sequence.SequenceReferenceSeqComponent convertSequenceReferenceSeqComponent(MolecularSequence.MolecularSequenceReferenceSeqComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence.SequenceReferenceSeqComponent tgt = new Sequence.SequenceReferenceSeqComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasChromosome()) {
            tgt.setChromosome(VersionConvertor_30_40.convertCodeableConcept(src.getChromosome()));
        }
        if (src.hasGenomeBuild()) {
            tgt.setGenomeBuild(src.getGenomeBuild());
        }
        if (src.hasReferenceSeqId()) {
            tgt.setReferenceSeqId(VersionConvertor_30_40.convertCodeableConcept(src.getReferenceSeqId()));
        }
        if (src.hasReferenceSeqPointer()) {
            tgt.setReferenceSeqPointer(VersionConvertor_30_40.convertReference(src.getReferenceSeqPointer()));
        }
        if (src.hasReferenceSeqString()) {
            tgt.setReferenceSeqString(src.getReferenceSeqString());
        }
        if (src.hasWindowStart()) {
            tgt.setWindowStart(src.getWindowStart());
        }
        if (src.hasWindowEnd()) {
            tgt.setWindowEnd(src.getWindowEnd());
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceVariantComponent convertSequenceVariantComponent(Sequence.SequenceVariantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceVariantComponent tgt = new MolecularSequence.MolecularSequenceVariantComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasObservedAllele()) {
            tgt.setObservedAllele(src.getObservedAllele());
        }
        if (src.hasReferenceAllele()) {
            tgt.setReferenceAllele(src.getReferenceAllele());
        }
        if (src.hasCigar()) {
            tgt.setCigar(src.getCigar());
        }
        if (src.hasVariantPointer()) {
            tgt.setVariantPointer(VersionConvertor_30_40.convertReference(src.getVariantPointer()));
        }
        return tgt;
    }

    public static Sequence.SequenceVariantComponent convertSequenceVariantComponent(MolecularSequence.MolecularSequenceVariantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence.SequenceVariantComponent tgt = new Sequence.SequenceVariantComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasObservedAllele()) {
            tgt.setObservedAllele(src.getObservedAllele());
        }
        if (src.hasReferenceAllele()) {
            tgt.setReferenceAllele(src.getReferenceAllele());
        }
        if (src.hasCigar()) {
            tgt.setCigar(src.getCigar());
        }
        if (src.hasVariantPointer()) {
            tgt.setVariantPointer(VersionConvertor_30_40.convertReference(src.getVariantPointer()));
        }
        return tgt;
    }

    public static MolecularSequence.MolecularSequenceQualityComponent convertSequenceQualityComponent(Sequence.SequenceQualityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceQualityComponent tgt = new MolecularSequence.MolecularSequenceQualityComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertQualityType(src.getType()));
        }
        if (src.hasStandardSequence()) {
            tgt.setStandardSequence(VersionConvertor_30_40.convertCodeableConcept(src.getStandardSequence()));
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasScore()) {
            tgt.setScore(VersionConvertor_30_40.convertQuantity(src.getScore()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasTruthTP()) {
            tgt.setTruthTP(src.getTruthTP());
        }
        if (src.hasQueryTP()) {
            tgt.setQueryTP(src.getQueryTP());
        }
        if (src.hasTruthFN()) {
            tgt.setTruthFN(src.getTruthFN());
        }
        if (src.hasQueryFP()) {
            tgt.setQueryFP(src.getQueryFP());
        }
        if (src.hasGtFP()) {
            tgt.setGtFP(src.getGtFP());
        }
        if (src.hasPrecision()) {
            tgt.setPrecision(src.getPrecision());
        }
        if (src.hasRecall()) {
            tgt.setRecall(src.getRecall());
        }
        if (src.hasFScore()) {
            tgt.setFScore(src.getFScore());
        }
        return tgt;
    }

    public static Sequence.SequenceQualityComponent convertSequenceQualityComponent(MolecularSequence.MolecularSequenceQualityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence.SequenceQualityComponent tgt = new Sequence.SequenceQualityComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertQualityType(src.getType()));
        }
        if (src.hasStandardSequence()) {
            tgt.setStandardSequence(VersionConvertor_30_40.convertCodeableConcept(src.getStandardSequence()));
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasScore()) {
            tgt.setScore(VersionConvertor_30_40.convertQuantity(src.getScore()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasTruthTP()) {
            tgt.setTruthTP(src.getTruthTP());
        }
        if (src.hasQueryTP()) {
            tgt.setQueryTP(src.getQueryTP());
        }
        if (src.hasTruthFN()) {
            tgt.setTruthFN(src.getTruthFN());
        }
        if (src.hasQueryFP()) {
            tgt.setQueryFP(src.getQueryFP());
        }
        if (src.hasGtFP()) {
            tgt.setGtFP(src.getGtFP());
        }
        if (src.hasPrecision()) {
            tgt.setPrecision(src.getPrecision());
        }
        if (src.hasRecall()) {
            tgt.setRecall(src.getRecall());
        }
        if (src.hasFScore()) {
            tgt.setFScore(src.getFScore());
        }
        return tgt;
    }

    private static MolecularSequence.QualityType convertQualityType(Sequence.QualityType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INDEL: {
                return MolecularSequence.QualityType.INDEL;
            }
            case SNP: {
                return MolecularSequence.QualityType.SNP;
            }
            case UNKNOWN: {
                return MolecularSequence.QualityType.UNKNOWN;
            }
        }
        return MolecularSequence.QualityType.NULL;
    }

    private static Sequence.QualityType convertQualityType(MolecularSequence.QualityType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INDEL: {
                return Sequence.QualityType.INDEL;
            }
            case SNP: {
                return Sequence.QualityType.SNP;
            }
            case UNKNOWN: {
                return Sequence.QualityType.UNKNOWN;
            }
        }
        return Sequence.QualityType.NULL;
    }

    public static MolecularSequence.MolecularSequenceRepositoryComponent convertSequenceRepositoryComponent(Sequence.SequenceRepositoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MolecularSequence.MolecularSequenceRepositoryComponent tgt = new MolecularSequence.MolecularSequenceRepositoryComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertRepositoryType(src.getType()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDatasetId()) {
            tgt.setDatasetId(src.getDatasetId());
        }
        if (src.hasVariantsetId()) {
            tgt.setVariantsetId(src.getVariantsetId());
        }
        if (src.hasReadsetId()) {
            tgt.setReadsetId(src.getReadsetId());
        }
        return tgt;
    }

    public static Sequence.SequenceRepositoryComponent convertSequenceRepositoryComponent(MolecularSequence.MolecularSequenceRepositoryComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Sequence.SequenceRepositoryComponent tgt = new Sequence.SequenceRepositoryComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertRepositoryType(src.getType()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDatasetId()) {
            tgt.setDatasetId(src.getDatasetId());
        }
        if (src.hasVariantsetId()) {
            tgt.setVariantsetId(src.getVariantsetId());
        }
        if (src.hasReadsetId()) {
            tgt.setReadsetId(src.getReadsetId());
        }
        return tgt;
    }

    private static MolecularSequence.RepositoryType convertRepositoryType(Sequence.RepositoryType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DIRECTLINK: {
                return MolecularSequence.RepositoryType.DIRECTLINK;
            }
            case OPENAPI: {
                return MolecularSequence.RepositoryType.OPENAPI;
            }
            case LOGIN: {
                return MolecularSequence.RepositoryType.LOGIN;
            }
            case OAUTH: {
                return MolecularSequence.RepositoryType.OAUTH;
            }
            case OTHER: {
                return MolecularSequence.RepositoryType.OTHER;
            }
        }
        return MolecularSequence.RepositoryType.NULL;
    }

    private static Sequence.RepositoryType convertRepositoryType(MolecularSequence.RepositoryType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DIRECTLINK: {
                return Sequence.RepositoryType.DIRECTLINK;
            }
            case OPENAPI: {
                return Sequence.RepositoryType.OPENAPI;
            }
            case LOGIN: {
                return Sequence.RepositoryType.LOGIN;
            }
            case OAUTH: {
                return Sequence.RepositoryType.OAUTH;
            }
            case OTHER: {
                return Sequence.RepositoryType.OTHER;
            }
        }
        return Sequence.RepositoryType.NULL;
    }

    public static Slot convertSlot(org.hl7.fhir.dstu3.model.Slot src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Slot tgt = new Slot();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasServiceCategory()) {
            tgt.addServiceCategory(VersionConvertor_30_40.convertCodeableConcept(src.getServiceCategory()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(VersionConvertor_30_40.convertCodeableConcept(src.getAppointmentType()));
        }
        if (src.hasSchedule()) {
            tgt.setSchedule(VersionConvertor_30_40.convertReference(src.getSchedule()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertSlotStatus(src.getStatus()));
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasOverbooked()) {
            tgt.setOverbooked(src.getOverbooked());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Slot convertSlot(Slot src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Slot tgt = new org.hl7.fhir.dstu3.model.Slot();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasServiceCategory()) {
            tgt.setServiceCategory(VersionConvertor_30_40.convertCodeableConcept(src.getServiceCategoryFirstRep()));
        }
        for (Identifier t : src.getServiceType()) {
            tgt.addServiceType(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getSpecialty()) {
            tgt.addSpecialty(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(VersionConvertor_30_40.convertCodeableConcept(src.getAppointmentType()));
        }
        if (src.hasSchedule()) {
            tgt.setSchedule(VersionConvertor_30_40.convertReference(src.getSchedule()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertSlotStatus(src.getStatus()));
        }
        if (src.hasStart()) {
            tgt.setStart(src.getStart());
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasOverbooked()) {
            tgt.setOverbooked(src.getOverbooked());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    private static Slot.SlotStatus convertSlotStatus(Slot.SlotStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case BUSY: {
                return Slot.SlotStatus.BUSY;
            }
            case FREE: {
                return Slot.SlotStatus.FREE;
            }
            case BUSYUNAVAILABLE: {
                return Slot.SlotStatus.BUSYUNAVAILABLE;
            }
            case BUSYTENTATIVE: {
                return Slot.SlotStatus.BUSYTENTATIVE;
            }
            case ENTEREDINERROR: {
                return Slot.SlotStatus.ENTEREDINERROR;
            }
        }
        return Slot.SlotStatus.NULL;
    }

    private static Slot.SlotStatus convertSlotStatus(Slot.SlotStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case BUSY: {
                return Slot.SlotStatus.BUSY;
            }
            case FREE: {
                return Slot.SlotStatus.FREE;
            }
            case BUSYUNAVAILABLE: {
                return Slot.SlotStatus.BUSYUNAVAILABLE;
            }
            case BUSYTENTATIVE: {
                return Slot.SlotStatus.BUSYTENTATIVE;
            }
            case ENTEREDINERROR: {
                return Slot.SlotStatus.ENTEREDINERROR;
            }
        }
        return Slot.SlotStatus.NULL;
    }

    public static Specimen convertSpecimen(org.hl7.fhir.dstu3.model.Specimen src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen tgt = new Specimen();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasAccessionIdentifier()) {
            tgt.setAccessionIdentifier(VersionConvertor_30_40.convertIdentifier(src.getAccessionIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertSpecimenStatus(src.getStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasReceivedTime()) {
            tgt.setReceivedTime(src.getReceivedTime());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getParent()) {
            tgt.addParent(VersionConvertor_30_40.convertReference((Reference)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getRequest()) {
            tgt.addRequest(VersionConvertor_30_40.convertReference((Reference)t));
        }
        if (src.hasCollection()) {
            tgt.setCollection(VersionConvertor_30_40.convertSpecimenCollectionComponent(src.getCollection()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getProcessing()) {
            tgt.addProcessing(VersionConvertor_30_40.convertSpecimenProcessingComponent((Specimen.SpecimenProcessingComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContainer()) {
            tgt.addContainer(VersionConvertor_30_40.convertSpecimenContainerComponent((Specimen.SpecimenContainerComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((Annotation)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Specimen convertSpecimen(Specimen src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Specimen tgt = new org.hl7.fhir.dstu3.model.Specimen();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasAccessionIdentifier()) {
            tgt.setAccessionIdentifier(VersionConvertor_30_40.convertIdentifier(src.getAccessionIdentifier()));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertSpecimenStatus(src.getStatus()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        if (src.hasReceivedTime()) {
            tgt.setReceivedTime(src.getReceivedTime());
        }
        for (Identifier t : src.getParent()) {
            tgt.addParent(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getRequest()) {
            tgt.addRequest(VersionConvertor_30_40.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasCollection()) {
            tgt.setCollection(VersionConvertor_30_40.convertSpecimenCollectionComponent(src.getCollection()));
        }
        for (Identifier t : src.getProcessing()) {
            tgt.addProcessing(VersionConvertor_30_40.convertSpecimenProcessingComponent((Specimen.SpecimenProcessingComponent)t));
        }
        for (Identifier t : src.getContainer()) {
            tgt.addContainer(VersionConvertor_30_40.convertSpecimenContainerComponent((Specimen.SpecimenContainerComponent)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation((org.hl7.fhir.r4.model.Annotation)t));
        }
        return tgt;
    }

    private static Specimen.SpecimenStatus convertSpecimenStatus(Specimen.SpecimenStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case AVAILABLE: {
                return Specimen.SpecimenStatus.AVAILABLE;
            }
            case UNAVAILABLE: {
                return Specimen.SpecimenStatus.UNAVAILABLE;
            }
            case UNSATISFACTORY: {
                return Specimen.SpecimenStatus.UNSATISFACTORY;
            }
            case ENTEREDINERROR: {
                return Specimen.SpecimenStatus.ENTEREDINERROR;
            }
        }
        return Specimen.SpecimenStatus.NULL;
    }

    private static Specimen.SpecimenStatus convertSpecimenStatus(Specimen.SpecimenStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case AVAILABLE: {
                return Specimen.SpecimenStatus.AVAILABLE;
            }
            case UNAVAILABLE: {
                return Specimen.SpecimenStatus.UNAVAILABLE;
            }
            case UNSATISFACTORY: {
                return Specimen.SpecimenStatus.UNSATISFACTORY;
            }
            case ENTEREDINERROR: {
                return Specimen.SpecimenStatus.ENTEREDINERROR;
            }
        }
        return Specimen.SpecimenStatus.NULL;
    }

    public static Specimen.SpecimenCollectionComponent convertSpecimenCollectionComponent(Specimen.SpecimenCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenCollectionComponent tgt = new Specimen.SpecimenCollectionComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasCollector()) {
            tgt.setCollector(VersionConvertor_30_40.convertReference(src.getCollector()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(VersionConvertor_30_40.convertType(src.getCollected()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        return tgt;
    }

    public static Specimen.SpecimenCollectionComponent convertSpecimenCollectionComponent(Specimen.SpecimenCollectionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenCollectionComponent tgt = new Specimen.SpecimenCollectionComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasCollector()) {
            tgt.setCollector(VersionConvertor_30_40.convertReference(src.getCollector()));
        }
        if (src.hasCollected()) {
            tgt.setCollected(VersionConvertor_30_40.convertType(src.getCollected()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(VersionConvertor_30_40.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(VersionConvertor_30_40.convertCodeableConcept(src.getBodySite()));
        }
        return tgt;
    }

    public static Specimen.SpecimenProcessingComponent convertSpecimenProcessingComponent(Specimen.SpecimenProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenProcessingComponent tgt = new Specimen.SpecimenProcessingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(VersionConvertor_30_40.convertCodeableConcept(src.getProcedure()));
        }
        for (Reference t : src.getAdditive()) {
            tgt.addAdditive(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasTime()) {
            tgt.setTime(VersionConvertor_30_40.convertType(src.getTime()));
        }
        return tgt;
    }

    public static Specimen.SpecimenProcessingComponent convertSpecimenProcessingComponent(Specimen.SpecimenProcessingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenProcessingComponent tgt = new Specimen.SpecimenProcessingComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(VersionConvertor_30_40.convertCodeableConcept(src.getProcedure()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getAdditive()) {
            tgt.addAdditive(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasTime()) {
            tgt.setTime(VersionConvertor_30_40.convertType(src.getTime()));
        }
        return tgt;
    }

    public static Specimen.SpecimenContainerComponent convertSpecimenContainerComponent(Specimen.SpecimenContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenContainerComponent tgt = new Specimen.SpecimenContainerComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(VersionConvertor_30_40.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasSpecimenQuantity()) {
            tgt.setSpecimenQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getSpecimenQuantity()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(VersionConvertor_30_40.convertType(src.getAdditive()));
        }
        return tgt;
    }

    public static Specimen.SpecimenContainerComponent convertSpecimenContainerComponent(Specimen.SpecimenContainerComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Specimen.SpecimenContainerComponent tgt = new Specimen.SpecimenContainerComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasCapacity()) {
            tgt.setCapacity(VersionConvertor_30_40.convertSimpleQuantity(src.getCapacity()));
        }
        if (src.hasSpecimenQuantity()) {
            tgt.setSpecimenQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getSpecimenQuantity()));
        }
        if (src.hasAdditive()) {
            tgt.setAdditive(VersionConvertor_30_40.convertType(src.getAdditive()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.StructureDefinition tgt = new org.hl7.fhir.r4.model.StructureDefinition();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((org.hl7.fhir.dstu3.model.ContactDetail)t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getKeyword()) {
            tgt.addKeyword(VersionConvertor_30_40.convertCoding((Coding)t));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode((String)src.getFhirVersion()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_40.convertStructureDefinitionMappingComponent((StructureDefinition.StructureDefinitionMappingComponent)t));
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertStructureDefinitionKind(src.getKind()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstract(src.getAbstract());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContext()) {
            StructureDefinition.StructureDefinitionContextComponent ec = tgt.addContext();
            ec.setType(VersionConvertor_30_40.convertExtensionContext(src.getContextType()));
            ec.setExpression((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContextInvariant()) {
            tgt.addContextInvariant((String)t.getValue());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinition(src.getBaseDefinition());
        }
        if (src.hasDerivation()) {
            tgt.setDerivation(VersionConvertor_30_40.convertTypeDerivationRule(src.getDerivation()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(VersionConvertor_30_40.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(VersionConvertor_30_40.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        if (tgt.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            for (org.hl7.fhir.r4.model.ElementDefinition ed : tgt.getSnapshot().getElement()) {
                if (ed.hasBase()) continue;
                ed.getBase().setPath(ed.getPath()).setMin(ed.getMin()).setMax(ed.getMax());
            }
        }
        return tgt;
    }

    public static StructureDefinition convertStructureDefinition(org.hl7.fhir.r4.model.StructureDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((ContactDetail)t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Identifier t : src.getKeyword()) {
            tgt.addKeyword(VersionConvertor_30_40.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion().toCode());
        }
        for (Identifier t : src.getMapping()) {
            tgt.addMapping(VersionConvertor_30_40.convertStructureDefinitionMappingComponent((StructureDefinition.StructureDefinitionMappingComponent)t));
        }
        if (src.hasKind()) {
            tgt.setKind(VersionConvertor_30_40.convertStructureDefinitionKind(src.getKind()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstract(src.getAbstract());
        }
        for (Identifier t : src.getContext()) {
            if (!tgt.hasContextType()) {
                tgt.setContextType(VersionConvertor_30_40.convertExtensionContext(t.getType()));
            }
            tgt.addContext(t.getExpression());
        }
        for (Identifier t : src.getContextInvariant()) {
            tgt.addContextInvariant((String)t.getValue());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinition(src.getBaseDefinition());
        }
        if (src.hasDerivation()) {
            tgt.setDerivation(VersionConvertor_30_40.convertTypeDerivationRule(src.getDerivation()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(VersionConvertor_30_40.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(VersionConvertor_30_40.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        return tgt;
    }

    private static StructureDefinition.StructureDefinitionKind convertStructureDefinitionKind(StructureDefinition.StructureDefinitionKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRIMITIVETYPE: {
                return StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
            }
            case COMPLEXTYPE: {
                return StructureDefinition.StructureDefinitionKind.COMPLEXTYPE;
            }
            case RESOURCE: {
                return StructureDefinition.StructureDefinitionKind.RESOURCE;
            }
            case LOGICAL: {
                return StructureDefinition.StructureDefinitionKind.LOGICAL;
            }
        }
        return StructureDefinition.StructureDefinitionKind.NULL;
    }

    private static StructureDefinition.StructureDefinitionKind convertStructureDefinitionKind(StructureDefinition.StructureDefinitionKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRIMITIVETYPE: {
                return StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
            }
            case COMPLEXTYPE: {
                return StructureDefinition.StructureDefinitionKind.COMPLEXTYPE;
            }
            case RESOURCE: {
                return StructureDefinition.StructureDefinitionKind.RESOURCE;
            }
            case LOGICAL: {
                return StructureDefinition.StructureDefinitionKind.LOGICAL;
            }
        }
        return StructureDefinition.StructureDefinitionKind.NULL;
    }

    private static StructureDefinition.ExtensionContextType convertExtensionContext(StructureDefinition.ExtensionContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESOURCE: {
                return StructureDefinition.ExtensionContextType.FHIRPATH;
            }
            case DATATYPE: {
                return StructureDefinition.ExtensionContextType.ELEMENT;
            }
            case EXTENSION: {
                return StructureDefinition.ExtensionContextType.EXTENSION;
            }
        }
        return StructureDefinition.ExtensionContextType.NULL;
    }

    private static StructureDefinition.ExtensionContext convertExtensionContext(StructureDefinition.ExtensionContextType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FHIRPATH: {
                return StructureDefinition.ExtensionContext.RESOURCE;
            }
            case ELEMENT: {
                return StructureDefinition.ExtensionContext.DATATYPE;
            }
            case EXTENSION: {
                return StructureDefinition.ExtensionContext.EXTENSION;
            }
        }
        return StructureDefinition.ExtensionContext.NULL;
    }

    private static StructureDefinition.TypeDerivationRule convertTypeDerivationRule(StructureDefinition.TypeDerivationRule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SPECIALIZATION: {
                return StructureDefinition.TypeDerivationRule.SPECIALIZATION;
            }
            case CONSTRAINT: {
                return StructureDefinition.TypeDerivationRule.CONSTRAINT;
            }
        }
        return StructureDefinition.TypeDerivationRule.NULL;
    }

    private static StructureDefinition.TypeDerivationRule convertTypeDerivationRule(StructureDefinition.TypeDerivationRule src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SPECIALIZATION: {
                return StructureDefinition.TypeDerivationRule.SPECIALIZATION;
            }
            case CONSTRAINT: {
                return StructureDefinition.TypeDerivationRule.CONSTRAINT;
            }
        }
        return StructureDefinition.TypeDerivationRule.NULL;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasIdentity()) {
            tgt.setIdentity(src.getIdentity());
        }
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasIdentity()) {
            tgt.setIdentity(src.getIdentity());
        }
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasComment()) {
            tgt.setComment(src.getComment());
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        for (org.hl7.fhir.r4.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_40.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureMap convertStructureMap(org.hl7.fhir.dstu3.model.StructureMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap tgt = new StructureMap();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((org.hl7.fhir.dstu3.model.ContactDetail)t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((UsageContext)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getStructure()) {
            tgt.addStructure(VersionConvertor_30_40.convertStructureMapStructureComponent((StructureMap.StructureMapStructureComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getImport()) {
            tgt.addImport((String)t.getValue());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getGroup()) {
            tgt.addGroup(VersionConvertor_30_40.convertStructureMapGroupComponent((StructureMap.StructureMapGroupComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.StructureMap convertStructureMap(StructureMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.StructureMap tgt = new org.hl7.fhir.dstu3.model.StructureMap();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasVersion()) {
            tgt.setVersion(src.getVersion());
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasTitle()) {
            tgt.setTitle(src.getTitle());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertPublicationStatus(src.getStatus()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        if (src.hasPublisher()) {
            tgt.setPublisher(src.getPublisher());
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactDetail((ContactDetail)t));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_40.convertUsageContext((org.hl7.fhir.r4.model.UsageContext)t));
        }
        for (Identifier t : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasPurpose()) {
            tgt.setPurpose(src.getPurpose());
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        for (Identifier t : src.getStructure()) {
            tgt.addStructure(VersionConvertor_30_40.convertStructureMapStructureComponent((StructureMap.StructureMapStructureComponent)t));
        }
        for (Identifier t : src.getImport()) {
            tgt.addImport((String)t.getValue());
        }
        for (Identifier t : src.getGroup()) {
            tgt.addGroup(VersionConvertor_30_40.convertStructureMapGroupComponent((StructureMap.StructureMapGroupComponent)t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapStructureComponent convertStructureMapStructureComponent(StructureMap.StructureMapStructureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapStructureComponent tgt = new StructureMap.StructureMapStructureComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertStructureMapModelMode(src.getMode()));
        }
        if (src.hasAlias()) {
            tgt.setAlias(src.getAlias());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static StructureMap.StructureMapStructureComponent convertStructureMapStructureComponent(StructureMap.StructureMapStructureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapStructureComponent tgt = new StructureMap.StructureMapStructureComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertStructureMapModelMode(src.getMode()));
        }
        if (src.hasAlias()) {
            tgt.setAlias(src.getAlias());
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    private static StructureMap.StructureMapModelMode convertStructureMapModelMode(StructureMap.StructureMapModelMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SOURCE: {
                return StructureMap.StructureMapModelMode.SOURCE;
            }
            case QUERIED: {
                return StructureMap.StructureMapModelMode.QUERIED;
            }
            case TARGET: {
                return StructureMap.StructureMapModelMode.TARGET;
            }
            case PRODUCED: {
                return StructureMap.StructureMapModelMode.PRODUCED;
            }
        }
        return StructureMap.StructureMapModelMode.NULL;
    }

    private static StructureMap.StructureMapModelMode convertStructureMapModelMode(StructureMap.StructureMapModelMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SOURCE: {
                return StructureMap.StructureMapModelMode.SOURCE;
            }
            case QUERIED: {
                return StructureMap.StructureMapModelMode.QUERIED;
            }
            case TARGET: {
                return StructureMap.StructureMapModelMode.TARGET;
            }
            case PRODUCED: {
                return StructureMap.StructureMapModelMode.PRODUCED;
            }
        }
        return StructureMap.StructureMapModelMode.NULL;
    }

    public static StructureMap.StructureMapGroupComponent convertStructureMapGroupComponent(StructureMap.StructureMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupComponent tgt = new StructureMap.StructureMapGroupComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasExtends()) {
            tgt.setExtends(src.getExtends());
        }
        if (src.hasTypeMode()) {
            tgt.setTypeMode(VersionConvertor_30_40.convertStructureMapGroupTypeMode(src.getTypeMode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (StructureMap.StructureMapGroupInputComponent t : src.getInput()) {
            tgt.addInput(VersionConvertor_30_40.convertStructureMapGroupInputComponent(t));
        }
        for (StructureMap.StructureMapGroupInputComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_30_40.convertStructureMapGroupRuleComponent((StructureMap.StructureMapGroupRuleComponent)t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupComponent convertStructureMapGroupComponent(StructureMap.StructureMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupComponent tgt = new StructureMap.StructureMapGroupComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasExtends()) {
            tgt.setExtends(src.getExtends());
        }
        if (src.hasTypeMode()) {
            tgt.setTypeMode(VersionConvertor_30_40.convertStructureMapGroupTypeMode(src.getTypeMode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        for (StructureMap.StructureMapGroupInputComponent t : src.getInput()) {
            tgt.addInput(VersionConvertor_30_40.convertStructureMapGroupInputComponent(t));
        }
        for (StructureMap.StructureMapGroupInputComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_30_40.convertStructureMapGroupRuleComponent((StructureMap.StructureMapGroupRuleComponent)t));
        }
        return tgt;
    }

    private static StructureMap.StructureMapGroupTypeMode convertStructureMapGroupTypeMode(StructureMap.StructureMapGroupTypeMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NONE: {
                return StructureMap.StructureMapGroupTypeMode.NONE;
            }
            case TYPES: {
                return StructureMap.StructureMapGroupTypeMode.TYPES;
            }
            case TYPEANDTYPES: {
                return StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES;
            }
        }
        return StructureMap.StructureMapGroupTypeMode.NULL;
    }

    private static StructureMap.StructureMapGroupTypeMode convertStructureMapGroupTypeMode(StructureMap.StructureMapGroupTypeMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NONE: {
                return StructureMap.StructureMapGroupTypeMode.NONE;
            }
            case TYPES: {
                return StructureMap.StructureMapGroupTypeMode.TYPES;
            }
            case TYPEANDTYPES: {
                return StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES;
            }
        }
        return StructureMap.StructureMapGroupTypeMode.NULL;
    }

    public static StructureMap.StructureMapGroupInputComponent convertStructureMapGroupInputComponent(StructureMap.StructureMapGroupInputComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupInputComponent tgt = new StructureMap.StructureMapGroupInputComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertStructureMapInputMode(src.getMode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupInputComponent convertStructureMapGroupInputComponent(StructureMap.StructureMapGroupInputComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupInputComponent tgt = new StructureMap.StructureMapGroupInputComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasMode()) {
            tgt.setMode(VersionConvertor_30_40.convertStructureMapInputMode(src.getMode()));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    private static StructureMap.StructureMapInputMode convertStructureMapInputMode(StructureMap.StructureMapInputMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SOURCE: {
                return StructureMap.StructureMapInputMode.SOURCE;
            }
            case TARGET: {
                return StructureMap.StructureMapInputMode.TARGET;
            }
        }
        return StructureMap.StructureMapInputMode.NULL;
    }

    private static StructureMap.StructureMapInputMode convertStructureMapInputMode(StructureMap.StructureMapInputMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SOURCE: {
                return StructureMap.StructureMapInputMode.SOURCE;
            }
            case TARGET: {
                return StructureMap.StructureMapInputMode.TARGET;
            }
        }
        return StructureMap.StructureMapInputMode.NULL;
    }

    public static StructureMap.StructureMapGroupRuleComponent convertStructureMapGroupRuleComponent(StructureMap.StructureMapGroupRuleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleComponent tgt = new StructureMap.StructureMapGroupRuleComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getSource()) {
            tgt.addSource(VersionConvertor_30_40.convertStructureMapGroupRuleSourceComponent(t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertStructureMapGroupRuleTargetComponent((StructureMap.StructureMapGroupRuleTargetComponent)t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_30_40.convertStructureMapGroupRuleComponent((StructureMap.StructureMapGroupRuleComponent)t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getDependent()) {
            tgt.addDependent(VersionConvertor_30_40.convertStructureMapGroupRuleDependentComponent((StructureMap.StructureMapGroupRuleDependentComponent)t));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleComponent convertStructureMapGroupRuleComponent(StructureMap.StructureMapGroupRuleComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleComponent tgt = new StructureMap.StructureMapGroupRuleComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getSource()) {
            tgt.addSource(VersionConvertor_30_40.convertStructureMapGroupRuleSourceComponent(t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getTarget()) {
            tgt.addTarget(VersionConvertor_30_40.convertStructureMapGroupRuleTargetComponent((StructureMap.StructureMapGroupRuleTargetComponent)t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getRule()) {
            tgt.addRule(VersionConvertor_30_40.convertStructureMapGroupRuleComponent((StructureMap.StructureMapGroupRuleComponent)t));
        }
        for (StructureMap.StructureMapGroupRuleSourceComponent t : src.getDependent()) {
            tgt.addDependent(VersionConvertor_30_40.convertStructureMapGroupRuleDependentComponent((StructureMap.StructureMapGroupRuleDependentComponent)t));
        }
        if (src.hasDocumentation()) {
            tgt.setDocumentation(src.getDocumentation());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleSourceComponent convertStructureMapGroupRuleSourceComponent(StructureMap.StructureMapGroupRuleSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleSourceComponent tgt = new StructureMap.StructureMapGroupRuleSourceComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasContext()) {
            tgt.setContext(src.getContext());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_40.convertType(src.getDefaultValue()));
        }
        if (src.hasElement()) {
            tgt.setElement(src.getElement());
        }
        if (src.hasListMode()) {
            tgt.setListMode(VersionConvertor_30_40.convertStructureMapSourceListMode(src.getListMode()));
        }
        if (src.hasVariable()) {
            tgt.setVariable(src.getVariable());
        }
        if (src.hasCondition()) {
            tgt.setCondition(src.getCondition());
        }
        if (src.hasCheck()) {
            tgt.setCheck(src.getCheck());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleSourceComponent convertStructureMapGroupRuleSourceComponent(StructureMap.StructureMapGroupRuleSourceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleSourceComponent tgt = new StructureMap.StructureMapGroupRuleSourceComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasContext()) {
            tgt.setContext(src.getContext());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(VersionConvertor_30_40.convertType(src.getDefaultValue()));
        }
        if (src.hasElement()) {
            tgt.setElement(src.getElement());
        }
        if (src.hasListMode()) {
            tgt.setListMode(VersionConvertor_30_40.convertStructureMapSourceListMode(src.getListMode()));
        }
        if (src.hasVariable()) {
            tgt.setVariable(src.getVariable());
        }
        if (src.hasCondition()) {
            tgt.setCondition(src.getCondition());
        }
        if (src.hasCheck()) {
            tgt.setCheck(src.getCheck());
        }
        return tgt;
    }

    private static StructureMap.StructureMapSourceListMode convertStructureMapSourceListMode(StructureMap.StructureMapSourceListMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FIRST: {
                return StructureMap.StructureMapSourceListMode.FIRST;
            }
            case NOTFIRST: {
                return StructureMap.StructureMapSourceListMode.NOTFIRST;
            }
            case LAST: {
                return StructureMap.StructureMapSourceListMode.LAST;
            }
            case NOTLAST: {
                return StructureMap.StructureMapSourceListMode.NOTLAST;
            }
            case ONLYONE: {
                return StructureMap.StructureMapSourceListMode.ONLYONE;
            }
        }
        return StructureMap.StructureMapSourceListMode.NULL;
    }

    private static StructureMap.StructureMapSourceListMode convertStructureMapSourceListMode(StructureMap.StructureMapSourceListMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FIRST: {
                return StructureMap.StructureMapSourceListMode.FIRST;
            }
            case NOTFIRST: {
                return StructureMap.StructureMapSourceListMode.NOTFIRST;
            }
            case LAST: {
                return StructureMap.StructureMapSourceListMode.LAST;
            }
            case NOTLAST: {
                return StructureMap.StructureMapSourceListMode.NOTLAST;
            }
            case ONLYONE: {
                return StructureMap.StructureMapSourceListMode.ONLYONE;
            }
        }
        return StructureMap.StructureMapSourceListMode.NULL;
    }

    public static StructureMap.StructureMapGroupRuleTargetComponent convertStructureMapGroupRuleTargetComponent(StructureMap.StructureMapGroupRuleTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetComponent tgt = new StructureMap.StructureMapGroupRuleTargetComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasContext()) {
            tgt.setContext(src.getContext());
        }
        if (src.hasContextType()) {
            tgt.setContextType(VersionConvertor_30_40.convertStructureMapContextType(src.getContextType()));
        }
        if (src.hasElement()) {
            tgt.setElement(src.getElement());
        }
        if (src.hasVariable()) {
            tgt.setVariable(src.getVariable());
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getListMode()) {
            tgt.addListMode(VersionConvertor_30_40.convertStructureMapTargetListMode((StructureMap.StructureMapTargetListMode)t.getValue()));
        }
        if (src.hasListRuleId()) {
            tgt.setListRuleId(src.getListRuleId());
        }
        if (src.hasTransform()) {
            tgt.setTransform(VersionConvertor_30_40.convertStructureMapTransform(src.getTransform()));
        }
        for (org.hl7.fhir.dstu3.model.Enumeration t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_30_40.convertStructureMapGroupRuleTargetParameterComponent((StructureMap.StructureMapGroupRuleTargetParameterComponent)t));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetComponent convertStructureMapGroupRuleTargetComponent(StructureMap.StructureMapGroupRuleTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetComponent tgt = new StructureMap.StructureMapGroupRuleTargetComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasContext()) {
            tgt.setContext(src.getContext());
        }
        if (src.hasContextType()) {
            tgt.setContextType(VersionConvertor_30_40.convertStructureMapContextType(src.getContextType()));
        }
        if (src.hasElement()) {
            tgt.setElement(src.getElement());
        }
        if (src.hasVariable()) {
            tgt.setVariable(src.getVariable());
        }
        for (Enumeration t : src.getListMode()) {
            tgt.addListMode(VersionConvertor_30_40.convertStructureMapTargetListMode((StructureMap.StructureMapTargetListMode)t.getValue()));
        }
        if (src.hasListRuleId()) {
            tgt.setListRuleId(src.getListRuleId());
        }
        if (src.hasTransform()) {
            tgt.setTransform(VersionConvertor_30_40.convertStructureMapTransform(src.getTransform()));
        }
        for (Enumeration t : src.getParameter()) {
            tgt.addParameter(VersionConvertor_30_40.convertStructureMapGroupRuleTargetParameterComponent((StructureMap.StructureMapGroupRuleTargetParameterComponent)t));
        }
        return tgt;
    }

    private static StructureMap.StructureMapContextType convertStructureMapContextType(StructureMap.StructureMapContextType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case TYPE: {
                return StructureMap.StructureMapContextType.TYPE;
            }
            case VARIABLE: {
                return StructureMap.StructureMapContextType.VARIABLE;
            }
        }
        return StructureMap.StructureMapContextType.NULL;
    }

    private static StructureMap.StructureMapContextType convertStructureMapContextType(StructureMap.StructureMapContextType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case TYPE: {
                return StructureMap.StructureMapContextType.TYPE;
            }
            case VARIABLE: {
                return StructureMap.StructureMapContextType.VARIABLE;
            }
        }
        return StructureMap.StructureMapContextType.NULL;
    }

    private static StructureMap.StructureMapTargetListMode convertStructureMapTargetListMode(StructureMap.StructureMapTargetListMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FIRST: {
                return StructureMap.StructureMapTargetListMode.FIRST;
            }
            case SHARE: {
                return StructureMap.StructureMapTargetListMode.SHARE;
            }
            case LAST: {
                return StructureMap.StructureMapTargetListMode.LAST;
            }
            case COLLATE: {
                return StructureMap.StructureMapTargetListMode.COLLATE;
            }
        }
        return StructureMap.StructureMapTargetListMode.NULL;
    }

    private static StructureMap.StructureMapTargetListMode convertStructureMapTargetListMode(StructureMap.StructureMapTargetListMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FIRST: {
                return StructureMap.StructureMapTargetListMode.FIRST;
            }
            case SHARE: {
                return StructureMap.StructureMapTargetListMode.SHARE;
            }
            case LAST: {
                return StructureMap.StructureMapTargetListMode.LAST;
            }
            case COLLATE: {
                return StructureMap.StructureMapTargetListMode.COLLATE;
            }
        }
        return StructureMap.StructureMapTargetListMode.NULL;
    }

    private static StructureMap.StructureMapTransform convertStructureMapTransform(StructureMap.StructureMapTransform src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CREATE: {
                return StructureMap.StructureMapTransform.CREATE;
            }
            case COPY: {
                return StructureMap.StructureMapTransform.COPY;
            }
            case TRUNCATE: {
                return StructureMap.StructureMapTransform.TRUNCATE;
            }
            case ESCAPE: {
                return StructureMap.StructureMapTransform.ESCAPE;
            }
            case CAST: {
                return StructureMap.StructureMapTransform.CAST;
            }
            case APPEND: {
                return StructureMap.StructureMapTransform.APPEND;
            }
            case TRANSLATE: {
                return StructureMap.StructureMapTransform.TRANSLATE;
            }
            case REFERENCE: {
                return StructureMap.StructureMapTransform.REFERENCE;
            }
            case DATEOP: {
                return StructureMap.StructureMapTransform.DATEOP;
            }
            case UUID: {
                return StructureMap.StructureMapTransform.UUID;
            }
            case POINTER: {
                return StructureMap.StructureMapTransform.POINTER;
            }
            case EVALUATE: {
                return StructureMap.StructureMapTransform.EVALUATE;
            }
            case CC: {
                return StructureMap.StructureMapTransform.CC;
            }
            case C: {
                return StructureMap.StructureMapTransform.C;
            }
            case QTY: {
                return StructureMap.StructureMapTransform.QTY;
            }
            case ID: {
                return StructureMap.StructureMapTransform.ID;
            }
            case CP: {
                return StructureMap.StructureMapTransform.CP;
            }
        }
        return StructureMap.StructureMapTransform.NULL;
    }

    private static StructureMap.StructureMapTransform convertStructureMapTransform(StructureMap.StructureMapTransform src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CREATE: {
                return StructureMap.StructureMapTransform.CREATE;
            }
            case COPY: {
                return StructureMap.StructureMapTransform.COPY;
            }
            case TRUNCATE: {
                return StructureMap.StructureMapTransform.TRUNCATE;
            }
            case ESCAPE: {
                return StructureMap.StructureMapTransform.ESCAPE;
            }
            case CAST: {
                return StructureMap.StructureMapTransform.CAST;
            }
            case APPEND: {
                return StructureMap.StructureMapTransform.APPEND;
            }
            case TRANSLATE: {
                return StructureMap.StructureMapTransform.TRANSLATE;
            }
            case REFERENCE: {
                return StructureMap.StructureMapTransform.REFERENCE;
            }
            case DATEOP: {
                return StructureMap.StructureMapTransform.DATEOP;
            }
            case UUID: {
                return StructureMap.StructureMapTransform.UUID;
            }
            case POINTER: {
                return StructureMap.StructureMapTransform.POINTER;
            }
            case EVALUATE: {
                return StructureMap.StructureMapTransform.EVALUATE;
            }
            case CC: {
                return StructureMap.StructureMapTransform.CC;
            }
            case C: {
                return StructureMap.StructureMapTransform.C;
            }
            case QTY: {
                return StructureMap.StructureMapTransform.QTY;
            }
            case ID: {
                return StructureMap.StructureMapTransform.ID;
            }
            case CP: {
                return StructureMap.StructureMapTransform.CP;
            }
        }
        return StructureMap.StructureMapTransform.NULL;
    }

    public static StructureMap.StructureMapGroupRuleTargetParameterComponent convertStructureMapGroupRuleTargetParameterComponent(StructureMap.StructureMapGroupRuleTargetParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetParameterComponent tgt = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleTargetParameterComponent convertStructureMapGroupRuleTargetParameterComponent(StructureMap.StructureMapGroupRuleTargetParameterComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleTargetParameterComponent tgt = new StructureMap.StructureMapGroupRuleTargetParameterComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasValue()) {
            tgt.setValue(VersionConvertor_30_40.convertType(src.getValue()));
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleDependentComponent convertStructureMapGroupRuleDependentComponent(StructureMap.StructureMapGroupRuleDependentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleDependentComponent tgt = new StructureMap.StructureMapGroupRuleDependentComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (StringType t : src.getVariable()) {
            tgt.addVariable((String)t.getValue());
        }
        return tgt;
    }

    public static StructureMap.StructureMapGroupRuleDependentComponent convertStructureMapGroupRuleDependentComponent(StructureMap.StructureMapGroupRuleDependentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureMap.StructureMapGroupRuleDependentComponent tgt = new StructureMap.StructureMapGroupRuleDependentComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getVariable()) {
            tgt.addVariable((String)t.getValue());
        }
        return tgt;
    }

    public static Subscription convertSubscription(org.hl7.fhir.dstu3.model.Subscription src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Subscription tgt = new Subscription();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertSubscriptionStatus(src.getStatus()));
        }
        for (org.hl7.fhir.dstu3.model.ContactPoint t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactPoint(t));
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasReason()) {
            tgt.setReason(src.getReason());
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(src.getCriteria());
        }
        if (src.hasError()) {
            tgt.setError(src.getError());
        }
        if (src.hasChannel()) {
            tgt.setChannel(VersionConvertor_30_40.convertSubscriptionChannelComponent(src.getChannel()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Subscription convertSubscription(Subscription src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Subscription tgt = new org.hl7.fhir.dstu3.model.Subscription();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertSubscriptionStatus(src.getStatus()));
        }
        for (ContactPoint t : src.getContact()) {
            tgt.addContact(VersionConvertor_30_40.convertContactPoint(t));
        }
        if (src.hasEnd()) {
            tgt.setEnd(src.getEnd());
        }
        if (src.hasReason()) {
            tgt.setReason(src.getReason());
        }
        if (src.hasCriteria()) {
            tgt.setCriteria(src.getCriteria());
        }
        if (src.hasError()) {
            tgt.setError(src.getError());
        }
        if (src.hasChannel()) {
            tgt.setChannel(VersionConvertor_30_40.convertSubscriptionChannelComponent(src.getChannel()));
        }
        return tgt;
    }

    private static Subscription.SubscriptionStatus convertSubscriptionStatus(Subscription.SubscriptionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUESTED: {
                return Subscription.SubscriptionStatus.REQUESTED;
            }
            case ACTIVE: {
                return Subscription.SubscriptionStatus.ACTIVE;
            }
            case ERROR: {
                return Subscription.SubscriptionStatus.ERROR;
            }
            case OFF: {
                return Subscription.SubscriptionStatus.OFF;
            }
        }
        return Subscription.SubscriptionStatus.NULL;
    }

    private static Subscription.SubscriptionStatus convertSubscriptionStatus(Subscription.SubscriptionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUESTED: {
                return Subscription.SubscriptionStatus.REQUESTED;
            }
            case ACTIVE: {
                return Subscription.SubscriptionStatus.ACTIVE;
            }
            case ERROR: {
                return Subscription.SubscriptionStatus.ERROR;
            }
            case OFF: {
                return Subscription.SubscriptionStatus.OFF;
            }
        }
        return Subscription.SubscriptionStatus.NULL;
    }

    public static Subscription.SubscriptionChannelComponent convertSubscriptionChannelComponent(Subscription.SubscriptionChannelComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Subscription.SubscriptionChannelComponent tgt = new Subscription.SubscriptionChannelComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertSubscriptionChannelType(src.getType()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        if (src.hasPayload()) {
            tgt.setPayload(src.getPayload());
        }
        for (StringType t : src.getHeader()) {
            tgt.addHeader((String)t.getValue());
        }
        return tgt;
    }

    public static Subscription.SubscriptionChannelComponent convertSubscriptionChannelComponent(Subscription.SubscriptionChannelComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Subscription.SubscriptionChannelComponent tgt = new Subscription.SubscriptionChannelComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertSubscriptionChannelType(src.getType()));
        }
        if (src.hasEndpoint()) {
            tgt.setEndpoint(src.getEndpoint());
        }
        if (src.hasPayload()) {
            tgt.setPayload(src.getPayload());
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getHeader()) {
            tgt.addHeader((String)t.getValue());
        }
        return tgt;
    }

    private static Subscription.SubscriptionChannelType convertSubscriptionChannelType(Subscription.SubscriptionChannelType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESTHOOK: {
                return Subscription.SubscriptionChannelType.RESTHOOK;
            }
            case WEBSOCKET: {
                return Subscription.SubscriptionChannelType.WEBSOCKET;
            }
            case EMAIL: {
                return Subscription.SubscriptionChannelType.EMAIL;
            }
            case SMS: {
                return Subscription.SubscriptionChannelType.SMS;
            }
            case MESSAGE: {
                return Subscription.SubscriptionChannelType.MESSAGE;
            }
        }
        return Subscription.SubscriptionChannelType.NULL;
    }

    private static Subscription.SubscriptionChannelType convertSubscriptionChannelType(Subscription.SubscriptionChannelType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESTHOOK: {
                return Subscription.SubscriptionChannelType.RESTHOOK;
            }
            case WEBSOCKET: {
                return Subscription.SubscriptionChannelType.WEBSOCKET;
            }
            case EMAIL: {
                return Subscription.SubscriptionChannelType.EMAIL;
            }
            case SMS: {
                return Subscription.SubscriptionChannelType.SMS;
            }
            case MESSAGE: {
                return Subscription.SubscriptionChannelType.MESSAGE;
            }
        }
        return Subscription.SubscriptionChannelType.NULL;
    }

    public static Substance convertSubstance(org.hl7.fhir.dstu3.model.Substance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance tgt = new Substance();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertFHIRSubstanceStatus(src.getStatus()));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getInstance()) {
            tgt.addInstance(VersionConvertor_30_40.convertSubstanceInstanceComponent((Substance.SubstanceInstanceComponent)t));
        }
        for (org.hl7.fhir.dstu3.model.Identifier t : src.getIngredient()) {
            tgt.addIngredient(VersionConvertor_30_40.convertSubstanceIngredientComponent((Substance.SubstanceIngredientComponent)t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Substance convertSubstance(Substance src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Substance tgt = new org.hl7.fhir.dstu3.model.Substance();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertFHIRSubstanceStatus(src.getStatus()));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_40.convertCodeableConcept(src.getCode()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (Identifier t : src.getInstance()) {
            tgt.addInstance(VersionConvertor_30_40.convertSubstanceInstanceComponent((Substance.SubstanceInstanceComponent)t));
        }
        for (Identifier t : src.getIngredient()) {
            tgt.addIngredient(VersionConvertor_30_40.convertSubstanceIngredientComponent((Substance.SubstanceIngredientComponent)t));
        }
        return tgt;
    }

    private static Substance.FHIRSubstanceStatus convertFHIRSubstanceStatus(Substance.FHIRSubstanceStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Substance.FHIRSubstanceStatus.ACTIVE;
            }
            case INACTIVE: {
                return Substance.FHIRSubstanceStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return Substance.FHIRSubstanceStatus.ENTEREDINERROR;
            }
        }
        return Substance.FHIRSubstanceStatus.NULL;
    }

    private static Substance.FHIRSubstanceStatus convertFHIRSubstanceStatus(Substance.FHIRSubstanceStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Substance.FHIRSubstanceStatus.ACTIVE;
            }
            case INACTIVE: {
                return Substance.FHIRSubstanceStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return Substance.FHIRSubstanceStatus.ENTEREDINERROR;
            }
        }
        return Substance.FHIRSubstanceStatus.NULL;
    }

    public static Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExpiry()) {
            tgt.setExpiry(src.getExpiry());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }

    public static Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasExpiry()) {
            tgt.setExpiry(src.getExpiry());
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        return tgt;
    }

    public static Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertRatio(src.getQuantity()));
        }
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_30_40.convertType(src.getSubstance()));
        }
        return tgt;
    }

    public static Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertRatio(src.getQuantity()));
        }
        if (src.hasSubstance()) {
            tgt.setSubstance(VersionConvertor_30_40.convertType(src.getSubstance()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.SupplyDelivery convertSupplyDelivery(SupplyDelivery src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.SupplyDelivery tgt = new org.hl7.fhir.r4.model.SupplyDelivery();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        for (Reference t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(t));
        }
        for (Reference t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertSupplyDeliveryStatus(src.getStatus()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSuppliedItem()) {
            tgt.setSuppliedItem(VersionConvertor_30_40.convertSupplyDeliverySuppliedItemComponent(src.getSuppliedItem()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasSupplier()) {
            tgt.setSupplier(VersionConvertor_30_40.convertReference(src.getSupplier()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_40.convertReference(src.getDestination()));
        }
        for (Reference t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    public static SupplyDelivery convertSupplyDelivery(org.hl7.fhir.r4.model.SupplyDelivery src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery tgt = new SupplyDelivery();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifierFirstRep()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(t));
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertSupplyDeliveryStatus(src.getStatus()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_40.convertReference(src.getPatient()));
        }
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertCodeableConcept(src.getType()));
        }
        if (src.hasSuppliedItem()) {
            tgt.setSuppliedItem(VersionConvertor_30_40.convertSupplyDeliverySuppliedItemComponent(src.getSuppliedItem()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(VersionConvertor_30_40.convertType(src.getOccurrence()));
        }
        if (src.hasSupplier()) {
            tgt.setSupplier(VersionConvertor_30_40.convertReference(src.getSupplier()));
        }
        if (src.hasDestination()) {
            tgt.setDestination(VersionConvertor_30_40.convertReference(src.getDestination()));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getReceiver()) {
            tgt.addReceiver(VersionConvertor_30_40.convertReference(t));
        }
        return tgt;
    }

    private static SupplyDelivery.SupplyDeliveryStatus convertSupplyDeliveryStatus(SupplyDelivery.SupplyDeliveryStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return SupplyDelivery.SupplyDeliveryStatus.INPROGRESS;
            }
            case COMPLETED: {
                return SupplyDelivery.SupplyDeliveryStatus.COMPLETED;
            }
            case ABANDONED: {
                return SupplyDelivery.SupplyDeliveryStatus.ABANDONED;
            }
            case ENTEREDINERROR: {
                return SupplyDelivery.SupplyDeliveryStatus.ENTEREDINERROR;
            }
        }
        return SupplyDelivery.SupplyDeliveryStatus.NULL;
    }

    private static SupplyDelivery.SupplyDeliveryStatus convertSupplyDeliveryStatus(SupplyDelivery.SupplyDeliveryStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return SupplyDelivery.SupplyDeliveryStatus.INPROGRESS;
            }
            case COMPLETED: {
                return SupplyDelivery.SupplyDeliveryStatus.COMPLETED;
            }
            case ABANDONED: {
                return SupplyDelivery.SupplyDeliveryStatus.ABANDONED;
            }
            case ENTEREDINERROR: {
                return SupplyDelivery.SupplyDeliveryStatus.ENTEREDINERROR;
            }
        }
        return SupplyDelivery.SupplyDeliveryStatus.NULL;
    }

    public static SupplyDelivery.SupplyDeliverySuppliedItemComponent convertSupplyDeliverySuppliedItemComponent(SupplyDelivery.SupplyDeliverySuppliedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery.SupplyDeliverySuppliedItemComponent tgt = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItem()));
        }
        return tgt;
    }

    public static SupplyDelivery.SupplyDeliverySuppliedItemComponent convertSupplyDeliverySuppliedItemComponent(SupplyDelivery.SupplyDeliverySuppliedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SupplyDelivery.SupplyDeliverySuppliedItemComponent tgt = new SupplyDelivery.SupplyDeliverySuppliedItemComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasQuantity()) {
            tgt.setQuantity(VersionConvertor_30_40.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasItem()) {
            tgt.setItem(VersionConvertor_30_40.convertType(src.getItem()));
        }
        return tgt;
    }

    public static TestReport convertTestReport(org.hl7.fhir.dstu3.model.TestReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport tgt = new TestReport();
        VersionConvertor_30_40.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertTestReportStatus(src.getStatus()));
        }
        if (src.hasTestScript()) {
            tgt.setTestScript(VersionConvertor_30_40.convertReference(src.getTestScript()));
        }
        if (src.hasResult()) {
            tgt.setResult(VersionConvertor_30_40.convertTestReportResult(src.getResult()));
        }
        if (src.hasScore()) {
            tgt.setScore(src.getScore());
        }
        if (src.hasTester()) {
            tgt.setTester(src.getTester());
        }
        if (src.hasIssued()) {
            tgt.setIssued(src.getIssued());
        }
        for (TestReport.TestReportParticipantComponent t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertTestReportParticipantComponent(t));
        }
        if (src.hasSetup()) {
            tgt.setSetup(VersionConvertor_30_40.convertTestReportSetupComponent(src.getSetup()));
        }
        for (TestReport.TestReportParticipantComponent t : src.getTest()) {
            tgt.addTest(VersionConvertor_30_40.convertTestReportTestComponent((TestReport.TestReportTestComponent)t));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(VersionConvertor_30_40.convertTestReportTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.TestReport convertTestReport(TestReport src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.TestReport tgt = new org.hl7.fhir.dstu3.model.TestReport();
        VersionConvertor_30_40.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_40.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasStatus()) {
            tgt.setStatus(VersionConvertor_30_40.convertTestReportStatus(src.getStatus()));
        }
        if (src.hasTestScript()) {
            tgt.setTestScript(VersionConvertor_30_40.convertReference(src.getTestScript()));
        }
        if (src.hasResult()) {
            tgt.setResult(VersionConvertor_30_40.convertTestReportResult(src.getResult()));
        }
        if (src.hasScore()) {
            tgt.setScore(src.getScore());
        }
        if (src.hasTester()) {
            tgt.setTester(src.getTester());
        }
        if (src.hasIssued()) {
            tgt.setIssued(src.getIssued());
        }
        for (TestReport.TestReportParticipantComponent t : src.getParticipant()) {
            tgt.addParticipant(VersionConvertor_30_40.convertTestReportParticipantComponent(t));
        }
        if (src.hasSetup()) {
            tgt.setSetup(VersionConvertor_30_40.convertTestReportSetupComponent(src.getSetup()));
        }
        for (TestReport.TestReportParticipantComponent t : src.getTest()) {
            tgt.addTest(VersionConvertor_30_40.convertTestReportTestComponent((TestReport.TestReportTestComponent)t));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(VersionConvertor_30_40.convertTestReportTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    private static TestReport.TestReportStatus convertTestReportStatus(TestReport.TestReportStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case COMPLETED: {
                return TestReport.TestReportStatus.COMPLETED;
            }
            case INPROGRESS: {
                return TestReport.TestReportStatus.INPROGRESS;
            }
            case WAITING: {
                return TestReport.TestReportStatus.WAITING;
            }
            case STOPPED: {
                return TestReport.TestReportStatus.STOPPED;
            }
            case ENTEREDINERROR: {
                return TestReport.TestReportStatus.ENTEREDINERROR;
            }
        }
        return TestReport.TestReportStatus.NULL;
    }

    private static TestReport.TestReportStatus convertTestReportStatus(TestReport.TestReportStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case COMPLETED: {
                return TestReport.TestReportStatus.COMPLETED;
            }
            case INPROGRESS: {
                return TestReport.TestReportStatus.INPROGRESS;
            }
            case WAITING: {
                return TestReport.TestReportStatus.WAITING;
            }
            case STOPPED: {
                return TestReport.TestReportStatus.STOPPED;
            }
            case ENTEREDINERROR: {
                return TestReport.TestReportStatus.ENTEREDINERROR;
            }
        }
        return TestReport.TestReportStatus.NULL;
    }

    private static TestReport.TestReportResult convertTestReportResult(TestReport.TestReportResult src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PASS: {
                return TestReport.TestReportResult.PASS;
            }
            case FAIL: {
                return TestReport.TestReportResult.FAIL;
            }
            case PENDING: {
                return TestReport.TestReportResult.PENDING;
            }
        }
        return TestReport.TestReportResult.NULL;
    }

    private static TestReport.TestReportResult convertTestReportResult(TestReport.TestReportResult src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PASS: {
                return TestReport.TestReportResult.PASS;
            }
            case FAIL: {
                return TestReport.TestReportResult.FAIL;
            }
            case PENDING: {
                return TestReport.TestReportResult.PENDING;
            }
        }
        return TestReport.TestReportResult.NULL;
    }

    public static TestReport.TestReportParticipantComponent convertTestReportParticipantComponent(TestReport.TestReportParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportParticipantComponent tgt = new TestReport.TestReportParticipantComponent();
        VersionConvertor_30_40.copyElement((org.hl7.fhir.dstu3.model.Element)src, (Element)tgt);
        if (src.hasType()) {
            tgt.setType(VersionConvertor_30_40.convertTestReportParticipantType(src.getType()));
        }
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasDisplay()) {
            tgt.setDisplay(src.getDisplay());
        }
        return tgt;
    }

    public static TestReport.TestReportParticipantComponent convertTestReportParticipantComponent(TestReport.TestReportParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestReport.TestReportParticipantComponent tgt = new TestReport.TestReportParticipantComponent();
        VersionConvertor_30_40.copyElement((Element)src, (org.hl7.fhir.dstu3.model.Element)tgt);
        if (src.hasType()) {
