/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.IAuthorizationServerCallback;
import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttpDecoder;
import ca.uhn.hl7v2.hoh.encoder.AuthorizationFailureException;
import ca.uhn.hl7v2.hoh.encoder.NoMessageReceivedException;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hl7OverHttpRequestDecoder
extends AbstractHl7OverHttpDecoder {
    private IAuthorizationServerCallback myAuthorizationCallback;
    private String myActionLine;
    private static final Logger ourLog = LoggerFactory.getLogger(Hl7OverHttpRequestDecoder.class);

    protected void authorize() throws AuthorizationFailureException {
        if (this.myAuthorizationCallback != null) {
            if (!this.myAuthorizationCallback.authorize(this.getUri(), this.getUsername(), this.getPassword())) {
                throw new AuthorizationFailureException("Authorization failed for user: " + this.getUsername());
            }
        } else if (StringUtils.isNotBlank(this.getUsername()) || StringUtils.isNotBlank(this.getPassword())) {
            ourLog.warn("Request contains username and/or password, but no authorization callback has been set so credentials can not be validated");
        }
    }

    protected String readActionLineAndDecode(InputStream theInputStream) throws DecodeException, IOException, NoMessageReceivedException {
        if (this.myActionLine == null) {
            String firstLine = this.readFirstLine(theInputStream);
            if (firstLine == null || StringUtils.isBlank(firstLine)) {
                throw new NoMessageReceivedException();
            }
            if (!firstLine.startsWith("POST ")) {
                throw new DecodeException("HTTP request line message is not valid. Only POST action is supported. Request line was: " + firstLine);
            }
            int nextSpace = (firstLine = firstLine.substring(5)).indexOf(32);
            if (nextSpace == -1) {
                throw new DecodeException("HTTP request line message is not valid. Not HTTP version found. Request line was: " + firstLine);
            }
            this.setUri(firstLine.substring(0, nextSpace));
            if (StringUtils.isBlank(this.getUri())) {
                throw new DecodeException("HTTP request line message is not valid. No request URI found. Request line was: " + firstLine);
            }
            String protocolVersion = firstLine.substring(nextSpace + 1);
            if (!"HTTP/1.1".equals(protocolVersion)) {
                throw new DecodeException("HTTP request line message is not valid. HTTP version not supported. Request line was: " + firstLine);
            }
            this.myActionLine = firstLine;
        }
        return this.myActionLine;
    }

    public void setAuthorizationCallback(IAuthorizationServerCallback theAuthorizationCallback) {
        this.myAuthorizationCallback = theAuthorizationCallback;
    }
}

