/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.encoder;

import ca.uhn.hl7v2.hoh.encoder.ResponseCode;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.message.ADT_A05;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.Parser;
import org.junit.Assert;
import org.junit.Test;

public class ResponseCodeTest {
    @Test
    public void testDetectEr7() throws Exception {
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ADT_A05 a05 = new ADT_A05();
        a05.parse(message);
        Message ack = a05.generateACK("AA", null);
        String ackString = ack.encode();
        Assert.assertEquals((Object)((Object)ResponseCode.HTTP_200_OK), (Object)((Object)ResponseCode.detect(ackString)));
        ack = a05.generateACK("AE", null);
        ackString = ack.encode();
        Assert.assertEquals((Object)((Object)ResponseCode.HTTP_500_INTERNAL_SERVER_ERROR), (Object)((Object)ResponseCode.detect(ackString)));
        ack = a05.generateACK("AR", null);
        ackString = ack.encode();
        Assert.assertEquals((Object)((Object)ResponseCode.HTTP_400_BAD_REQUEST), (Object)((Object)ResponseCode.detect(ackString)));
    }

    @Test
    public void testDetectXml() throws Exception {
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ADT_A05 a05 = new ADT_A05();
        a05.parse(message);
        a05.setParser((Parser)new DefaultXMLParser());
        String encoded = a05.encode();
        Assert.assertTrue((String)encoded, (boolean)encoded.contains("<MSH"));
        Message ack = a05.generateACK("AA", null);
        String ackString = ack.encode();
        Assert.assertTrue((String)ackString, (boolean)ackString.contains("<MSH"));
        Assert.assertEquals((Object)((Object)ResponseCode.HTTP_200_OK), (Object)((Object)ResponseCode.detect(ackString)));
        ack = a05.generateACK("AE", null);
        ackString = ack.encode();
        Assert.assertEquals((Object)((Object)ResponseCode.HTTP_500_INTERNAL_SERVER_ERROR), (Object)((Object)ResponseCode.detect(ackString)));
        ack = a05.generateACK("AR", null);
        ackString = ack.encode();
        Assert.assertEquals((Object)((Object)ResponseCode.HTTP_400_BAD_REQUEST), (Object)((Object)ResponseCode.detect(ackString)));
    }
}

