/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.hapi.client;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.api.ISendable;
import ca.uhn.hl7v2.hoh.hapi.api.MessageReceivable;
import ca.uhn.hl7v2.hoh.raw.client.HohRawClientSimple;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.Parser;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HohClientSimple
extends HohRawClientSimple {
    private Parser myParser;

    public HohClientSimple(String theHost, int thePort, String theUri, Parser theParser) {
        super(theHost, thePort, theUri);
        this.myParser = theParser;
        if (this.myParser == null) {
            throw new NullPointerException("Parser may not be null");
        }
    }

    public IReceivable<Message> sendAndReceiveMessage(ISendable theMessageToSend) throws DecodeException, IOException, EncodeException, EncodingNotSupportedException, HL7Exception {
        IReceivable<String> response = super.doSendAndReceive(theMessageToSend);
        return new MessageReceivable(this.myParser.parse(response.getMessage()));
    }
}

