/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.llp;

import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.IAuthorizationServerCallback;
import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttpDecoder;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestDecoder;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpResponseDecoder;
import ca.uhn.hl7v2.hoh.encoder.NoMessageReceivedException;
import ca.uhn.hl7v2.hoh.llp.Hl7OverHttpLowerLayerProtocol;
import ca.uhn.hl7v2.hoh.llp.HohLlpWriter;
import ca.uhn.hl7v2.hoh.sign.SignatureVerificationException;
import ca.uhn.hl7v2.hoh.util.HTTPUtils;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.LLPException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HohLlpReader
implements HL7Reader {
    private static final Logger ourLog = LoggerFactory.getLogger(HohLlpReader.class);
    private InputStream myInputStream;
    private Hl7OverHttpLowerLayerProtocol myProtocol;
    private HohLlpWriter myWriter;

    public HohLlpReader(Hl7OverHttpLowerLayerProtocol theProtocol) {
        this.myProtocol = theProtocol;
    }

    public void close() throws IOException {
        this.myInputStream.close();
    }

    public String getMessage() throws LLPException, IOException {
        AbstractHl7OverHttpDecoder decoder;
        if (this.myProtocol.getRole() == ServerRoleEnum.CLIENT) {
            decoder = new Hl7OverHttpResponseDecoder();
        } else {
            Hl7OverHttpRequestDecoder requestDecoder = new Hl7OverHttpRequestDecoder();
            requestDecoder.setAuthorizationCallback(this.myProtocol.getAuthorizationServerCallback());
            decoder = requestDecoder;
            decoder.setSigner(this.myProtocol.getSigner());
        }
        try {
            decoder.readHeadersAndContentsFromInputStreamAndDecode(this.myInputStream);
        }
        catch (DecodeException e) {
            if (this.myProtocol.getRole() == ServerRoleEnum.CLIENT) {
                throw new LLPException("Failed to process response", (Exception)e);
            }
            ourLog.info("Failed to read contents", (Throwable)e);
            HTTPUtils.write400BadRequest(this.myWriter.getOutputStream(), e.getMessage());
            this.myInputStream.close();
            this.myWriter.getOutputStream().close();
            throw new LLPException("Failed to read message", (Exception)e);
        }
        catch (NoMessageReceivedException e) {
            return null;
        }
        catch (SignatureVerificationException e) {
            throw new LLPException("Failed to verify message signature", (Exception)e);
        }
        if (this.myProtocol.getRole() == ServerRoleEnum.SERVER) {
            boolean auth;
            Charset charset = decoder.getCharset();
            this.myWriter.setCharsetForNextMessage(charset);
            IAuthorizationServerCallback authorizationCallback = this.myProtocol.getAuthorizationServerCallback();
            if (authorizationCallback != null && !(auth = authorizationCallback.authorize(decoder.getUri(), decoder.getUsername(), decoder.getPassword()))) {
                HTTPUtils.write401Unauthorized(this.myWriter.getOutputStream());
                throw new LLPException("Authorization at URI[" + decoder.getUri() + "] failed for user[" + decoder.getUsername() + "]");
            }
        }
        return decoder.getMessage();
    }

    public void setInputStream(InputStream theInputStream) throws IOException {
        this.myInputStream = theInputStream;
    }

    void setWriter(HohLlpWriter theWriter) {
        this.myWriter = theWriter;
    }
}

