/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.llp;

import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.encoder.AbstractHl7OverHttpEncoder;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestEncoder;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpResponseEncoder;
import ca.uhn.hl7v2.hoh.llp.Hl7OverHttpLowerLayerProtocol;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

class HohLlpWriter
implements HL7Writer {
    private OutputStream myOutputStream;
    private Charset myPreferredCharset;
    private Hl7OverHttpLowerLayerProtocol myProtocol;
    private Charset myCharsetForNextMessage;

    public HohLlpWriter(Hl7OverHttpLowerLayerProtocol theProtocol) {
        this.myProtocol = theProtocol;
    }

    public void close() throws IOException {
        this.myOutputStream.close();
    }

    OutputStream getOutputStream() {
        return this.myOutputStream;
    }

    public Charset getPreferredCharset() {
        return this.myPreferredCharset;
    }

    public void setOutputStream(OutputStream theOutputStream) throws IOException {
        this.myOutputStream = theOutputStream;
    }

    public void setPreferredCharset(Charset thePreferredCharset) {
        this.myPreferredCharset = thePreferredCharset;
    }

    public void writeMessage(String theRawMessage) throws LLPException, IOException {
        AbstractHl7OverHttpEncoder e;
        if (this.myProtocol.getRole() == ServerRoleEnum.CLIENT) {
            e = new Hl7OverHttpRequestEncoder();
            if (this.myProtocol.getAuthorizationClientCallback() != null) {
                e.setUsername(this.myProtocol.getAuthorizationClientCallback().provideUsername(this.myProtocol.getUriPath()));
                e.setPassword(this.myProtocol.getAuthorizationClientCallback().providePassword(this.myProtocol.getUriPath()));
            }
        } else {
            e = new Hl7OverHttpResponseEncoder();
        }
        if (this.myProtocol.getRole() == ServerRoleEnum.CLIENT) {
            e.setSigner(this.myProtocol.getSigner());
        }
        e.setMessage(theRawMessage);
        if (this.myCharsetForNextMessage != null) {
            e.setCharset(this.myCharsetForNextMessage);
            this.myCharsetForNextMessage = null;
        } else if (this.getPreferredCharset() != null) {
            e.setCharset(this.getPreferredCharset());
        }
        e.setUri(this.myProtocol.getUriPath());
        DataOutputStream dos = new DataOutputStream(this.myOutputStream);
        try {
            e.encodeToOutputStream(dos);
        }
        catch (EncodeException e1) {
            throw new LLPException("Failed to encode message", (Exception)e1);
        }
        dos.flush();
    }

    void setCharsetForNextMessage(Charset theCharset) {
        this.myCharsetForNextMessage = theCharset;
    }
}

