/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.server;

import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.IAuthorizationServerCallback;
import ca.uhn.hl7v2.hoh.api.IMessageHandler;
import ca.uhn.hl7v2.hoh.api.IResponseSendable;
import ca.uhn.hl7v2.hoh.api.MessageMetadataKeys;
import ca.uhn.hl7v2.hoh.api.MessageProcessingException;
import ca.uhn.hl7v2.hoh.encoder.AuthorizationFailureException;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestDecoder;
import ca.uhn.hl7v2.hoh.raw.api.RawReceivable;
import ca.uhn.hl7v2.hoh.sign.ISigner;
import ca.uhn.hl7v2.hoh.sign.SignatureVerificationException;
import ca.uhn.hl7v2.hoh.util.HTTPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HohRawServlet
extends HttpServlet {
    private static final Logger ourLog = LoggerFactory.getLogger(HohRawServlet.class);
    private static final long serialVersionUID = 1L;
    private IAuthorizationServerCallback myAuthorizationCallback;
    private IMessageHandler<String> myMessageHandler;
    private ISigner mySigner;

    protected void doGet(HttpServletRequest theReq, HttpServletResponse theResp) throws ServletException, IOException {
        theResp.setStatus(400);
        theResp.setContentType("text/html");
        String message = "GET method is not supported by this server";
        HTTPUtils.write400BadRequest((OutputStream)theResp.getOutputStream(), message, false);
    }

    protected void doPost(HttpServletRequest theReq, HttpServletResponse theResp) throws ServletException, IOException {
        IResponseSendable<String> response;
        Hl7OverHttpRequestDecoder decoder = new Hl7OverHttpRequestDecoder();
        decoder.setHeaders(new LinkedHashMap<String, String>());
        Enumeration headerNames = theReq.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String nextName = (String)headerNames.nextElement();
            decoder.getHeaders().put(nextName, theReq.getHeader(nextName));
        }
        decoder.setUri(theReq.getRequestURI());
        decoder.setAuthorizationCallback(this.myAuthorizationCallback);
        decoder.setSigner(this.mySigner);
        try {
            decoder.readContentsFromInputStreamAndDecode((InputStream)theReq.getInputStream());
        }
        catch (AuthorizationFailureException e) {
            ourLog.error("Authorization failed on request for {}", (Object)theReq.getRequestURI());
            theResp.setStatus(401);
            HTTPUtils.write401Unauthorized((OutputStream)theResp.getOutputStream(), false);
            return;
        }
        catch (DecodeException e) {
            ourLog.error("Request failure for " + theReq.getRequestURI(), (Object)e.getMessage(), (Object)e);
            theResp.setStatus(400);
            HTTPUtils.write400BadRequest((OutputStream)theResp.getOutputStream(), e.getMessage(), false);
            return;
        }
        catch (SignatureVerificationException e) {
            ourLog.error("Signature verification failed on request for {}", (Object)theReq.getRequestURI());
            theResp.setStatus(400);
            HTTPUtils.write400SignatureVerificationFailed((OutputStream)theResp.getOutputStream(), false);
            return;
        }
        Charset charset = decoder.getCharset();
        ourLog.debug("Message charset is {}", (Object)charset.displayName());
        RawReceivable rawMessage = new RawReceivable(decoder.getMessage());
        rawMessage.addMetadata(MessageMetadataKeys.REMOTE_HOST_ADDRESS.name(), theReq.getRemoteAddr());
        try {
            response = this.myMessageHandler.messageReceived(rawMessage);
        }
        catch (MessageProcessingException e) {
            ourLog.error("Processing problem for " + theReq.getRequestURI(), (Object)e.getMessage(), (Object)e);
            theResp.setStatus(500);
            HTTPUtils.write500InternalServerError(theResp.getOutputStream(), e.getMessage(), false);
            return;
        }
        theResp.setCharacterEncoding(charset.name());
        theResp.setContentType(response.getEncodingStyle().getContentType());
        theResp.setStatus(response.getResponseCode().getCode());
        response.writeMessage(theResp.getWriter());
        theResp.flushBuffer();
    }

    public void setAuthorizationCallback(IAuthorizationServerCallback theAuthorizationCallback) {
        this.myAuthorizationCallback = theAuthorizationCallback;
    }

    public void setMessageHandler(IMessageHandler<String> theMessageHandler) {
        this.myMessageHandler = theMessageHandler;
    }

    public void setSigner(ISigner theSigner) {
        this.mySigner = theSigner;
    }
}

