/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.server;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.hoh.api.IAuthorizationServerCallback;
import ca.uhn.hl7v2.hoh.api.IMessageHandler;
import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.api.IResponseSendable;
import ca.uhn.hl7v2.hoh.api.MessageProcessingException;
import ca.uhn.hl7v2.hoh.encoder.EncodingStyle;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestEncoder;
import ca.uhn.hl7v2.hoh.llp.Hl7OverHttpLowerLayerProtocol;
import ca.uhn.hl7v2.hoh.raw.api.RawSendable;
import ca.uhn.hl7v2.hoh.raw.server.HohRawServlet;
import ca.uhn.hl7v2.hoh.util.RandomServerPortProvider;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v25.message.ADT_A05;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.GenericParser;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.Servlet;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HohRawServletTest
implements IAuthorizationServerCallback,
IMessageHandler<String> {
    private static DefaultHapiContext ourHapiContext;
    private static final Logger ourLog;
    private String myExpectedPassword;
    private String myExpectedUri;
    private String myExpectedUsername;
    private String myMessage;
    private String myResponse;
    private int myPort;
    private Server myServer;

    static {
        ourLog = LoggerFactory.getLogger(HohRawServletTest.class);
    }

    @After
    public void after() throws Exception {
        this.myServer.stop();
    }

    @Override
    public boolean authorize(String theUri, String theUsername, String thePassword) {
        if (this.myExpectedUsername == null) {
            return true;
        }
        if (!StringUtils.equals(this.myExpectedUri, theUri)) {
            return false;
        }
        if (!StringUtils.equals(this.myExpectedUsername, theUsername)) {
            return false;
        }
        return StringUtils.equals(this.myExpectedPassword, thePassword);
    }

    @Before
    public void before() throws Exception {
        this.myPort = RandomServerPortProvider.findFreePort();
        this.myServer = new Server(this.myPort);
        Context context = new Context((HandlerContainer)this.myServer, "/", 1);
        HohRawServlet servlet = new HohRawServlet();
        servlet.setAuthorizationCallback(this);
        servlet.setMessageHandler(this);
        context.addServlet(new ServletHolder((Servlet)servlet), "/*");
        this.myServer.start();
        while (this.myServer.isStarting()) {
            ourLog.info("Waiting for server to start...");
            Thread.sleep(100L);
        }
        this.myResponse = null;
    }

    @Override
    public IResponseSendable<String> messageReceived(IReceivable<String> theMessage) throws MessageProcessingException {
        this.myMessage = theMessage.getMessage();
        try {
            if (this.myResponse == null) {
                this.myResponse = GenericParser.getInstanceWithNoValidation().parse(this.myMessage).generateACK().encode();
            }
            return new RawSendable(this.myResponse);
        }
        catch (EncodingNotSupportedException e) {
            throw new MessageProcessingException(e);
        }
        catch (HL7Exception e) {
            throw new MessageProcessingException(e);
        }
        catch (IOException e) {
            throw new MessageProcessingException(e);
        }
    }

    @Test
    public void testServlet() throws Exception {
        String line;
        InputStream is;
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ADT_A05 msg = new ADT_A05();
        msg.parse(message);
        Hl7OverHttpLowerLayerProtocol llp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        String charsetName = "ISO-8859-2";
        llp.setPreferredCharset(Charset.forName(charsetName));
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName(charsetName));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        try {
            is = conn.getInputStream();
        }
        catch (IOException e) {
            if (conn.getResponseCode() == 400 || conn.getResponseCode() == 500) {
                is = conn.getErrorStream();
            }
            throw e;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)conn.getHeaderField("Content-Type").replaceAll(";.*", ""));
        Assert.assertEquals((Object)charsetName, (Object)conn.getHeaderField("Content-Type").replaceAll(".*;.*charset=", ""));
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage);
        Assert.assertEquals((Object)this.myResponse, (Object)responseString);
    }

    @Test
    public void testServletAR() throws Exception {
        String line;
        InputStream is;
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ADT_A05 msg = new ADT_A05();
        msg.parse(message);
        this.myResponse = msg.generateACK("AR", new HL7Exception("ewrerwe")).encode();
        Hl7OverHttpLowerLayerProtocol llp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        String charsetName = "ISO-8859-2";
        llp.setPreferredCharset(Charset.forName(charsetName));
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName(charsetName));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        try {
            is = conn.getInputStream();
        }
        catch (IOException e) {
            if (conn.getResponseCode() == 400 || conn.getResponseCode() == 500) {
                is = conn.getErrorStream();
            }
            throw e;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)conn.getHeaderField("Content-Type").replaceAll(";.*", ""));
        Assert.assertEquals((Object)charsetName, (Object)conn.getHeaderField("Content-Type").replaceAll(".*;.*charset=", ""));
        Assert.assertEquals((long)400L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage);
        Assert.assertEquals((Object)this.myResponse, (Object)responseString);
    }

    @Test
    public void testServletAE() throws Exception {
        String line;
        InputStream is;
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ADT_A05 msg = new ADT_A05();
        msg.parse(message);
        this.myResponse = msg.generateACK("AE", new HL7Exception("ewrerwe")).encode();
        Hl7OverHttpLowerLayerProtocol llp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        String charsetName = "ISO-8859-2";
        llp.setPreferredCharset(Charset.forName(charsetName));
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName(charsetName));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        try {
            is = conn.getInputStream();
        }
        catch (IOException e) {
            if (conn.getResponseCode() == 400 || conn.getResponseCode() == 500) {
                is = conn.getErrorStream();
            }
            throw e;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((Object)EncodingStyle.ER7.getContentType(), (Object)conn.getHeaderField("Content-Type").replaceAll(";.*", ""));
        Assert.assertEquals((Object)charsetName, (Object)conn.getHeaderField("Content-Type").replaceAll(".*;.*charset=", ""));
        Assert.assertEquals((long)500L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage);
        Assert.assertEquals((Object)this.myResponse, (Object)responseString);
    }

    @Test
    public void testServletSimpleXml() throws Exception {
        String line;
        InputStream is;
        String message = "MSH|^~\\&|||||200803051508||ADT^A31|2|P|2.5\rEVN||200803051509\rPID|||ZZZZZZ83M64Z148R^^^SSN^SSN^^20070103\r";
        ADT_A05 msg = new ADT_A05();
        msg.parse(message);
        message = DefaultXMLParser.getInstanceWithNoValidation().encode((Message)msg);
        Hl7OverHttpLowerLayerProtocol llp = new Hl7OverHttpLowerLayerProtocol(ServerRoleEnum.CLIENT);
        String charsetName = "ISO-8859-2";
        llp.setPreferredCharset(Charset.forName(charsetName));
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setCharset(Charset.forName(charsetName));
        enc.setUsername("hello");
        enc.setPassword("world");
        enc.setMessage(message);
        enc.encode();
        String urlString = "http://localhost:" + this.myPort + "/";
        ourLog.info("URL: {}", (Object)urlString);
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("POST");
        conn.setUseCaches(false);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        for (Map.Entry<String, String> next : enc.getHeaders().entrySet()) {
            conn.setRequestProperty(next.getKey(), next.getValue());
        }
        DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
        wr.write(enc.getData());
        wr.flush();
        try {
            is = conn.getInputStream();
        }
        catch (IOException e) {
            if (conn.getResponseCode() == 400 || conn.getResponseCode() == 500) {
                is = conn.getErrorStream();
            }
            throw e;
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        StringBuffer response = new StringBuffer();
        while ((line = rd.readLine()) != null) {
            response.append(line);
            response.append('\r');
        }
        String responseString = response.toString();
        ourLog.info("Response:\n{}", (Object)responseString);
        Assert.assertEquals((Object)EncodingStyle.XML.getContentType(), (Object)conn.getHeaderField("Content-Type").replaceAll(";.*", ""));
        Assert.assertEquals((Object)charsetName, (Object)conn.getHeaderField("Content-Type").replaceAll(".*;.*charset=", ""));
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)message, (Object)this.myMessage);
        Assert.assertEquals((Object)this.myResponse.replaceAll("(\\r|\\n)+", " "), (Object)responseString.replaceAll("(\\r|\\n)+", " "));
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        ourHapiContext.getExecutorService().shutdown();
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("DEBUG", "true");
        ourHapiContext = new DefaultHapiContext();
    }
}

