/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.sign;

import ca.uhn.hl7v2.hoh.sign.BouncyCastleCmsMessageSigner;
import ca.uhn.hl7v2.hoh.sign.SignatureFailureException;
import ca.uhn.hl7v2.hoh.sign.SignatureVerificationException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleCmsMessageSignerTest {
    private static final String HELLO_WORLD = "HELLO WORLD!!!!!aa";
    private static final Logger ourLog = LoggerFactory.getLogger(BouncyCastleCmsMessageSignerTest.class);

    @Test
    public void testSignAndVerify() throws Exception {
        BouncyCastleCmsMessageSigner signer = BouncyCastleCmsMessageSignerTest.createSigner();
        String signed = signer.sign(HELLO_WORLD.getBytes("US-ASCII"));
        ourLog.info("Signed ({} bytes): {}", (Object)signed.length(), (Object)signed);
        signer = BouncyCastleCmsMessageSignerTest.createVerifier();
        signer.verify(HELLO_WORLD.getBytes("US-ASCII"), signed);
    }

    public static BouncyCastleCmsMessageSigner createVerifier() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        BouncyCastleCmsMessageSigner signer = new BouncyCastleCmsMessageSigner();
        signer.setKeyStore(BouncyCastleCmsMessageSignerTest.loadTrustStore());
        signer.setKeyAlias(BouncyCastleCmsMessageSignerTest.getKeystoreKeyAlias());
        signer.setAliasPassword(BouncyCastleCmsMessageSignerTest.getKeystoreKeyAliasPassword());
        return signer;
    }

    public static BouncyCastleCmsMessageSigner createSigner() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        BouncyCastleCmsMessageSigner signer = new BouncyCastleCmsMessageSigner();
        signer.setKeyStore(BouncyCastleCmsMessageSignerTest.getKeystore());
        signer.setKeyAlias(BouncyCastleCmsMessageSignerTest.getKeystoreKeyAlias());
        signer.setAliasPassword(BouncyCastleCmsMessageSignerTest.getKeystoreKeyAliasPassword());
        return signer;
    }

    private static KeyStore loadTrustStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustStore = KeyStore.getInstance("JKS");
        InputStream trustStream = BouncyCastleCmsMessageSignerTest.class.getResourceAsStream("/truststore.jks");
        trustStore.load(trustStream, BouncyCastleCmsMessageSignerTest.getKeystoreKeyAliasPassword().toCharArray());
        return trustStore;
    }

    private static String getKeystoreKeyAliasPassword() {
        return "changeit";
    }

    private static String getKeystoreKeyAlias() {
        return "testcert";
    }

    private static KeyStore getKeystore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("JKS");
        InputStream ksStream = BouncyCastleCmsMessageSignerTest.class.getResourceAsStream("/keystore.jks");
        keyStore.load(ksStream, BouncyCastleCmsMessageSignerTest.getKeystoreKeyAliasPassword().toCharArray());
        return keyStore;
    }

    @Test
    public void testTryToSignWithPublicKey() throws Exception {
        BouncyCastleCmsMessageSigner signer = BouncyCastleCmsMessageSignerTest.createSigner();
        signer.setKeyStore(BouncyCastleCmsMessageSignerTest.loadTrustStore());
        try {
            signer.sign(HELLO_WORLD.getBytes("US-ASCII"));
            Assert.fail();
        }
        catch (SignatureFailureException e) {
            Assert.assertTrue((String)e.toString(), (boolean)e.getMessage().contains("Key is not a private key: "));
        }
    }

    @Test
    public void testSignAndVerifyStringChanged() throws Exception {
        BouncyCastleCmsMessageSigner signer = BouncyCastleCmsMessageSignerTest.createSigner();
        String signed = signer.sign(HELLO_WORLD.getBytes("US-ASCII"));
        ourLog.info("Signed ({} bytes): {}", (Object)signed.length(), (Object)signed);
        signer = BouncyCastleCmsMessageSignerTest.createVerifier();
        try {
            signer.verify("HELLO WORLD....".getBytes("US-ASCII"), signed);
            Assert.fail();
        }
        catch (SignatureVerificationException signatureVerificationException) {
            // empty catch block
        }
    }
}

