/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_OSP (occurence span) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>occurrence span code (ID)
 * <li>occurrence span start date (DT)
 * <li>occurrence span stop date (DT)
 * </ul>
 */
public class CM_OSP extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_OSP type
     */
    public CM_OSP(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new ID(getMessage(), 0);
        data[1] = new DT(getMessage());
        data[2] = new DT(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns occurrence span code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getOccurrenceSpanCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns occurrence span code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCm_osp1_OccurrenceSpanCode() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns occurrence span start date (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getOccurrenceSpanStartDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns occurrence span start date (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getCm_osp2_OccurrenceSpanStartDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns occurrence span stop date (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getOccurrenceSpanStopDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns occurrence span stop date (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getCm_osp3_OccurrenceSpanStopDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

