/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CM_PARENT_RESULT (undefined CM data type) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>observation identifier (OBX-3) of parent result (CE)
 * <li>sub-ID (OBX-4) of parent result (ST)
 * <li>result (OBX-5) from parent (CE)
 * </ul>
 */
public class CM_PARENT_RESULT extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CM_PARENT_RESULT type
     */
    public CM_PARENT_RESULT(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new CE(getMessage());
        data[1] = new ST(getMessage());
        data[2] = new CE(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns observation identifier (OBX-3) of parent result (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getObservationIdentifierOBX3OfParentResult() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns observation identifier (OBX-3) of parent result (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getCm_parent_result1_ObservationIdentifierOBX3OfParentResult() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns sub-ID (OBX-4) of parent result (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSubIDOBX4OfParentResult() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns sub-ID (OBX-4) of parent result (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCm_parent_result2_SubIDOBX4OfParentResult() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns result (OBX-5) from parent (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getResultOBX5FromParent() {
       CE ret = null;
       try {
          ret = (CE)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns result (OBX-5) from parent (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getCm_parent_result3_ResultOBX5FromParent() {
       CE ret = null;
       try {
          ret = (CE)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

