/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 CN (CN für Ärzte) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>ID number (ID)
 * <li>family name (ST)
 * <li>given name (ST)
 * <li>middle initial or name (ST)
 * <li>suffix (e.g. JR or III) (ST)
 * <li>prefix (e.g. DR) (ST)
 * <li>degree (e.g. MD) (ST)
 * <li>source table id (ID)
 * <li>Adresse (AD)
 * <li>Telefon (TN)
 * <li>Faxnummer (TN)
 * <li>Online-Nummer (TN)
 * <li>E-Mail (ST)
 * </ul>
 */
public class CN extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new CN type
     */
    public CN(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[13];    
        data[0] = new ID(getMessage(), 0);
        data[1] = new ST(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new ST(getMessage());
        data[4] = new ST(getMessage());
        data[5] = new ST(getMessage());
        data[6] = new ST(getMessage());
        data[7] = new ID(getMessage(), 0);
        data[8] = new AD(getMessage());
        data[9] = new TN(getMessage());
        data[10] = new TN(getMessage());
        data[11] = new TN(getMessage());
        data[12] = new ST(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns ID number (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getIDNumber() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns ID number (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCn1_IDNumber() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns family name (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getFamilyName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns family name (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCn2_FamilyName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns given name (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getGivenName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns given name (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCn3_GivenName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns middle initial or name (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getMiddleInitialOrName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns middle initial or name (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCn4_MiddleInitialOrName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns suffix (e.g. JR or III) (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSuffixEgJRorIII() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns suffix (e.g. JR or III) (component #5).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCn5_SuffixEgJRorIII() {
       ST ret = null;
       try {
          ret = (ST)getComponent(4);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns prefix (e.g. DR) (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getPrefixEgDR() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns prefix (e.g. DR) (component #6).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCn6_PrefixEgDR() {
       ST ret = null;
       try {
          ret = (ST)getComponent(5);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns degree (e.g. MD) (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getDegreeEgMD() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns degree (e.g. MD) (component #7).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCn7_DegreeEgMD() {
       ST ret = null;
       try {
          ret = (ST)getComponent(6);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns source table id (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getSourceTableId() {
       ID ret = null;
       try {
          ret = (ID)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns source table id (component #8).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getCn8_SourceTableId() {
       ID ret = null;
       try {
          ret = (ID)getComponent(7);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Adresse (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public AD getAdresse() {
       AD ret = null;
       try {
          ret = (AD)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Adresse (component #9).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public AD getCn9_Adresse() {
       AD ret = null;
       try {
          ret = (AD)getComponent(8);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Telefon (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TN getTelefon() {
       TN ret = null;
       try {
          ret = (TN)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Telefon (component #10).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TN getCn10_Telefon() {
       TN ret = null;
       try {
          ret = (TN)getComponent(9);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Faxnummer (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TN getFaxnummer() {
       TN ret = null;
       try {
          ret = (TN)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Faxnummer (component #11).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TN getCn11_Faxnummer() {
       TN ret = null;
       try {
          ret = (TN)getComponent(10);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns Online-Nummer (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TN getOnlineNummer() {
       TN ret = null;
       try {
          ret = (TN)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns Online-Nummer (component #12).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public TN getCn12_OnlineNummer() {
       TN ret = null;
       try {
          ret = (TN)getComponent(11);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns E-Mail (component #13).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getEMail() {
       ST ret = null;
       try {
          ret = (ST)getComponent(12);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns E-Mail (component #13).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getCn13_EMail() {
       ST ret = null;
       try {
          ret = (ST)getComponent(12);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

