/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.message;

import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a ORF_R04 message structure (see chapter ?). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (MESSAGE HEADER) <b> </b></li>
                 * <li>2: MSA (MESSAGE ACKNOWLEDGMENT) <b> </b></li>
                 * <li>3: ORF_R04_QUERY_RESPONSE (a Group object) <b> repeating</b></li>
                 * <li>4: ORF_R04_ORDER (a Group object) <b> repeating</b></li>
                 * <li>5: DSC (CONTINUATION POINTER) <b>optional </b></li>
 * </ul>
 */
public class ORF_R04 extends AbstractMessage  {

    /** 
     * Creates a new ORF_R04 message with custom ModelClassFactory.
     */
    public ORF_R04(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new ORF_R04 message with DefaultModelClassFactory. 
     */ 
    public ORF_R04() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ORF_R04_QUERY_RESPONSE.class, true, true);
                          this.add(ORF_R04_ORDER.class, true, true);
                          this.add(DSC.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORF_R04 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.2"
     */
    public String getVersion() {
       return "2.2";
    }



    /**
     * Returns
     * MSH (MESSAGE HEADER) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (MESSAGE ACKNOWLEDGMENT) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * QUERY_RESPONSE (a Group object) - creates it if necessary
     */
    public ORF_R04_QUERY_RESPONSE getQUERY_RESPONSE() { 
       ORF_R04_QUERY_RESPONSE ret = null;
       try {
          ret = (ORF_R04_QUERY_RESPONSE)this.get("QUERY_RESPONSE");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * QUERY_RESPONSE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORF_R04_QUERY_RESPONSE getQUERY_RESPONSE(int rep) { 
       ORF_R04_QUERY_RESPONSE ret = null;
       try {
          ret = (ORF_R04_QUERY_RESPONSE)this.get("QUERY_RESPONSE", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of QUERY_RESPONSE 
     */ 
    public int getQUERY_RESPONSEReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("QUERY_RESPONSE").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of QUERY_RESPONSE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertQUERY_RESPONSE(ORF_R04_QUERY_RESPONSE structure, int rep) throws HL7Exception { 
       super.insertRepetition( "QUERY_RESPONSE", structure, rep);
    }


    /**
     * Inserts a specific repetition of QUERY_RESPONSE (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ORF_R04_QUERY_RESPONSE insertQUERY_RESPONSE(int rep) throws HL7Exception { 
       return (ORF_R04_QUERY_RESPONSE)super.insertRepetition("QUERY_RESPONSE", rep);
    }


    /**
     * Removes a specific repetition of QUERY_RESPONSE (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ORF_R04_QUERY_RESPONSE removeQUERY_RESPONSE(int rep) throws HL7Exception { 
       return (ORF_R04_QUERY_RESPONSE)super.removeRepetition("QUERY_RESPONSE", rep);
    }



    /**
     * Returns
     * the first repetition of 
     * ORDER (a Group object) - creates it if necessary
     */
    public ORF_R04_ORDER getORDER() { 
       ORF_R04_ORDER ret = null;
       try {
          ret = (ORF_R04_ORDER)this.get("ORDER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ORDER (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ORF_R04_ORDER getORDER(int rep) { 
       ORF_R04_ORDER ret = null;
       try {
          ret = (ORF_R04_ORDER)this.get("ORDER", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ORDER 
     */ 
    public int getORDERReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ORDER").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ORDER (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertORDER(ORF_R04_ORDER structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ORDER", structure, rep);
    }


    /**
     * Inserts a specific repetition of ORDER (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ORF_R04_ORDER insertORDER(int rep) throws HL7Exception { 
       return (ORF_R04_ORDER)super.insertRepetition("ORDER", rep);
    }


    /**
     * Removes a specific repetition of ORDER (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ORF_R04_ORDER removeORDER(int rep) throws HL7Exception { 
       return (ORF_R04_ORDER)super.removeRepetition("ORDER", rep);
    }



    /**
     * Returns
     * DSC (CONTINUATION POINTER) - creates it if necessary
     */
    public DSC getDSC() { 
       DSC ret = null;
       try {
          ret = (DSC)this.get("DSC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

