/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 MRG message segment (MERGE PATIENT INFORMATION). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>MRG-1: Prior Patient ID - Internal (CM_PAT_ID) <b> </b>
     * <li>MRG-2: Prior Alternate Patient ID (CM_PAT_ID) <b>optional </b>
     * <li>MRG-3: Prior Patient Account Number (CK) <b>optional </b>
     * <li>MRG-4: Prior Patient ID - External (CK) <b>optional </b>
 * </ul>
 */
public class MRG extends AbstractSegment {

    /** 
     * Creates a new MRG segment
     */
    public MRG(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CM_PAT_ID.class, true, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Prior Patient ID - Internal");
                                  this.add(CM_PAT_ID.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Prior Alternate Patient ID");
                                  this.add(CK.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Prior Patient Account Number");
                                  this.add(CK.class, false, 1, 16, new Object[]{ getMessage(), new Integer(0) }, "Prior Patient ID - External");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MRG - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * MRG-1: "Prior Patient ID - Internal" - creates it if necessary
     */
    public CM_PAT_ID getPriorPatientIDInternal() { 
        CM_PAT_ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CM_PAT_ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-1: "Prior Patient ID - Internal" - creates it if necessary
     */
    public CM_PAT_ID getMrg1_PriorPatientIDInternal() { 
        CM_PAT_ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CM_PAT_ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-2: "Prior Alternate Patient ID" - creates it if necessary
     */
    public CM_PAT_ID getPriorAlternatePatientID() { 
        CM_PAT_ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CM_PAT_ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-2: "Prior Alternate Patient ID" - creates it if necessary
     */
    public CM_PAT_ID getMrg2_PriorAlternatePatientID() { 
        CM_PAT_ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CM_PAT_ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-3: "Prior Patient Account Number" - creates it if necessary
     */
    public CK getPriorPatientAccountNumber() { 
        CK ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-3: "Prior Patient Account Number" - creates it if necessary
     */
    public CK getMrg3_PriorPatientAccountNumber() { 
        CK ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MRG-4: "Prior Patient ID - External" - creates it if necessary
     */
    public CK getPriorPatientIDExternal() { 
        CK ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MRG-4: "Prior Patient ID - External" - creates it if necessary
     */
    public CK getMrg4_PriorPatientIDExternal() { 
        CK ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CK)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CM_PAT_ID(getMessage());
          case 1: return new CM_PAT_ID(getMessage());
          case 2: return new CK(getMessage());
          case 3: return new CK(getMessage());
          default: return null;
       }
   }


}

