/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 MSH message segment (MESSAGE HEADER). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>MSH-1: Field separator (ST) <b> </b>
     * <li>MSH-2: Encoding characters (ST) <b> </b>
     * <li>MSH-3: Sending application (ST) <b>optional </b>
     * <li>MSH-4: Sending facility (ST) <b>optional </b>
     * <li>MSH-5: Receiving application (ST) <b>optional </b>
     * <li>MSH-6: Receiving facility (ST) <b>optional </b>
     * <li>MSH-7: Date / Time of message (TS) <b>optional </b>
     * <li>MSH-8: Security (ST) <b>optional </b>
     * <li>MSH-9: Message type (CM_MSG) <b> </b>
     * <li>MSH-10: Message Control ID (ST) <b> </b>
     * <li>MSH-11: Processing ID (ID) <b> </b>
     * <li>MSH-12: Version ID (ID) <b> </b>
     * <li>MSH-13: Sequence number (NM) <b>optional </b>
     * <li>MSH-14: Continuation pointer (ST) <b>optional </b>
     * <li>MSH-15: Accept acknowledgement type (ID) <b>optional </b>
     * <li>MSH-16: Application acknowledgement type (ID) <b>optional </b>
     * <li>MSH-17: Country code (ID) <b>optional </b>
 * </ul>
 */
public class MSH extends AbstractSegment {

    /** 
     * Creates a new MSH segment
     */
    public MSH(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, true, 1, 1, new Object[]{ getMessage(), new Integer(0) }, "Field separator");
                                  this.add(ST.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Encoding characters");
                                  this.add(ST.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Sending application");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Sending facility");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "Receiving application");
                                  this.add(ST.class, false, 1, 30, new Object[]{ getMessage(), new Integer(0) }, "Receiving facility");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Date / Time of message");
                                  this.add(ST.class, false, 1, 40, new Object[]{ getMessage(), new Integer(0) }, "Security");
                                  this.add(CM_MSG.class, true, 1, 7, new Object[]{ getMessage(), new Integer(76) }, "Message type");
                                  this.add(ST.class, true, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Message Control ID");
                                  this.add(ID.class, true, 1, 1, new Object[]{ getMessage() }, "Processing ID");
                                  this.add(ID.class, true, 1, 8, new Object[]{ getMessage() }, "Version ID");
                                  this.add(NM.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Sequence number");
                                  this.add(ST.class, false, 1, 180, new Object[]{ getMessage(), new Integer(0) }, "Continuation pointer");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Accept acknowledgement type");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Application acknowledgement type");
                                  this.add(ID.class, false, 1, 2, new Object[]{ getMessage() }, "Country code");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MSH - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * MSH-1: "Field separator" - creates it if necessary
     */
    public ST getFieldSeparator() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-1: "Field separator" - creates it if necessary
     */
    public ST getMsh1_FieldSeparator() { 
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-2: "Encoding characters" - creates it if necessary
     */
    public ST getEncodingCharacters() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-2: "Encoding characters" - creates it if necessary
     */
    public ST getMsh2_EncodingCharacters() { 
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-3: "Sending application" - creates it if necessary
     */
    public ST getSendingApplication() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-3: "Sending application" - creates it if necessary
     */
    public ST getMsh3_SendingApplication() { 
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-4: "Sending facility" - creates it if necessary
     */
    public ST getSendingFacility() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-4: "Sending facility" - creates it if necessary
     */
    public ST getMsh4_SendingFacility() { 
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-5: "Receiving application" - creates it if necessary
     */
    public ST getReceivingApplication() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-5: "Receiving application" - creates it if necessary
     */
    public ST getMsh5_ReceivingApplication() { 
        ST ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-6: "Receiving facility" - creates it if necessary
     */
    public ST getReceivingFacility() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-6: "Receiving facility" - creates it if necessary
     */
    public ST getMsh6_ReceivingFacility() { 
        ST ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-7: "Date / Time of message" - creates it if necessary
     */
    public TS getDateTimeOfMessage() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-7: "Date / Time of message" - creates it if necessary
     */
    public TS getMsh7_DateTimeOfMessage() { 
        TS ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-8: "Security" - creates it if necessary
     */
    public ST getSecurity() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-8: "Security" - creates it if necessary
     */
    public ST getMsh8_Security() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-9: "Message type" - creates it if necessary
     */
    public CM_MSG getMessageType() { 
        CM_MSG ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CM_MSG)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-9: "Message type" - creates it if necessary
     */
    public CM_MSG getMsh9_MessageType() { 
        CM_MSG ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CM_MSG)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-10: "Message Control ID" - creates it if necessary
     */
    public ST getMessageControlID() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-10: "Message Control ID" - creates it if necessary
     */
    public ST getMsh10_MessageControlID() { 
        ST ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-11: "Processing ID" - creates it if necessary
     */
    public ID getProcessingID() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-11: "Processing ID" - creates it if necessary
     */
    public ID getMsh11_ProcessingID() { 
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-12: "Version ID" - creates it if necessary
     */
    public ID getVersionID() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-12: "Version ID" - creates it if necessary
     */
    public ID getMsh12_VersionID() { 
        ID ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-13: "Sequence number" - creates it if necessary
     */
    public NM getSequenceNumber() { 
        NM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-13: "Sequence number" - creates it if necessary
     */
    public NM getMsh13_SequenceNumber() { 
        NM ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-14: "Continuation pointer" - creates it if necessary
     */
    public ST getContinuationPointer() { 
        ST ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-14: "Continuation pointer" - creates it if necessary
     */
    public ST getMsh14_ContinuationPointer() { 
        ST ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-15: "Accept acknowledgement type" - creates it if necessary
     */
    public ID getAcceptAcknowledgementType() { 
        ID ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-15: "Accept acknowledgement type" - creates it if necessary
     */
    public ID getMsh15_AcceptAcknowledgementType() { 
        ID ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-16: "Application acknowledgement type" - creates it if necessary
     */
    public ID getApplicationAcknowledgementType() { 
        ID ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-16: "Application acknowledgement type" - creates it if necessary
     */
    public ID getMsh16_ApplicationAcknowledgementType() { 
        ID ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * MSH-17: "Country code" - creates it if necessary
     */
    public ID getCountryCode() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * MSH-17: "Country code" - creates it if necessary
     */
    public ID getMsh17_CountryCode() { 
        ID ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new ST(getMessage());
          case 2: return new ST(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new ST(getMessage());
          case 6: return new TS(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new CM_MSG(getMessage());
          case 9: return new ST(getMessage());
          case 10: return new ID(getMessage(), new Integer( 103 ));
          case 11: return new ID(getMessage(), new Integer( 104 ));
          case 12: return new NM(getMessage());
          case 13: return new ST(getMessage());
          case 14: return new ID(getMessage(), new Integer( 155 ));
          case 15: return new ID(getMessage(), new Integer( 155 ));
          case 16: return new ID(getMessage(), new Integer( 0 ));
          default: return null;
       }
   }


}

