/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v22.segment;

// import ca.uhn.hl7v2.model.v22.group.*;
import ca.uhn.hl7v2.model.v22.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 RXE message segment (PHARMACY ENCODED ORDER). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>RXE-1: Quantity / timing (TQ) <b>optional repeating</b>
     * <li>RXE-2: Give Code (CE) <b> </b>
     * <li>RXE-3: Give Amount - Minimum (NM) <b> </b>
     * <li>RXE-4: Give Amount - Maximum (NM) <b>optional </b>
     * <li>RXE-5: Give Units (CE) <b> </b>
     * <li>RXE-6: Give Dosage Form (CE) <b>optional </b>
     * <li>RXE-7: Provider's Administration Instructions (CE) <b>optional repeating</b>
     * <li>RXE-8: Deliver-to location (CM_LA1) <b>optional </b>
     * <li>RXE-9: Substitution Status (ID) <b>optional </b>
     * <li>RXE-10: Dispense Amount (NM) <b>optional </b>
     * <li>RXE-11: Dispense Units (CE) <b>optional </b>
     * <li>RXE-12: Number of Refills (NM) <b>optional </b>
     * <li>RXE-13: Ordering Provider's DEA Number (CN) <b>optional </b>
     * <li>RXE-14: Pharmacist Verifier ID (CN) <b>optional </b>
     * <li>RXE-15: Prescription Number (ST) <b> </b>
     * <li>RXE-16: Number of Refills Remaining (NM) <b>optional </b>
     * <li>RXE-17: Number of refills / doses dispensed (NM) <b>optional </b>
     * <li>RXE-18: Date / time of most recent refill or dose dispensed (TS) <b>optional </b>
     * <li>RXE-19: Total Daily Dose (CQ_QUANTITY) <b>optional </b>
     * <li>RXE-20: Needs Human Review (ID) <b>optional </b>
     * <li>RXE-21: Pharmacy Special Dispensing Instructions (CE) <b>optional </b>
     * <li>RXE-22: Give Per (Time Unit) (ST) <b>optional </b>
     * <li>RXE-23: Give Rate Amount (CE) <b>optional </b>
     * <li>RXE-24: Give Rate Units (CE) <b>optional </b>
 * </ul>
 */
public class RXE extends AbstractSegment {

    /** 
     * Creates a new RXE segment
     */
    public RXE(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(TQ.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Quantity / timing");
                                  this.add(CE.class, true, 1, 100, new Object[]{ getMessage(), new Integer(0) }, "Give Code");
                                  this.add(NM.class, true, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Give Amount - Minimum");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Give Amount - Maximum");
                                  this.add(CE.class, true, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Give Units");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Give Dosage Form");
                                  this.add(CE.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Provider's Administration Instructions");
                                  this.add(CM_LA1.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Deliver-to location");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Substitution Status");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Dispense Amount");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Dispense Units");
                                  this.add(NM.class, false, 1, 3, new Object[]{ getMessage(), new Integer(0) }, "Number of Refills");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Ordering Provider's DEA Number");
                                  this.add(CN.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Pharmacist Verifier ID");
                                  this.add(ST.class, true, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Prescription Number");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Number of Refills Remaining");
                                  this.add(NM.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Number of refills / doses dispensed");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Date / time of most recent refill or dose dispensed");
                                  this.add(CQ_QUANTITY.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Total Daily Dose");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Needs Human Review");
                                  this.add(CE.class, false, 1, 200, new Object[]{ getMessage(), new Integer(0) }, "Pharmacy Special Dispensing Instructions");
                                  this.add(ST.class, false, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Give Per (Time Unit)");
                                  this.add(CE.class, false, 1, 6, new Object[]{ getMessage(), new Integer(0) }, "Give Rate Amount");
                                  this.add(CE.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Give Rate Units");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RXE - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Quantity / timing (RXE-1).
     */
    public TQ[] getQuantityTiming() {
        TQ[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new TQ[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (TQ)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Quantity / timing (RXE-1).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getQuantityTimingReps() {
        TQ[] ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * RXE-1: "Quantity / timing" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TQ getQuantityTiming(int rep) { 
        TQ ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (TQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RXE-1: "Quantity / timing" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public TQ getRxe1_QuantityTiming(int rep) { 
        TQ ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (TQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Quantity / timing (RXE-1).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getRxe1_QuantityTimingReps() {
        TQ[] ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * RXE-1: "Quantity / timing" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TQ insertQuantityTiming(int rep) throws HL7Exception { 
        return (TQ) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * RXE-1: "Quantity / timing" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TQ insertRxe1_QuantityTiming(int rep) throws HL7Exception { 
        return (TQ) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * RXE-1: "Quantity / timing" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TQ removeQuantityTiming(int rep) throws HL7Exception { 
        return (TQ) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * RXE-1: "Quantity / timing" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public TQ removeRxe1_QuantityTiming(int rep) throws HL7Exception { 
        return (TQ) super.removeRepetition(1, rep);
    }




    /**
     * Returns
     * RXE-2: "Give Code" - creates it if necessary
     */
    public CE getGiveCode() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-2: "Give Code" - creates it if necessary
     */
    public CE getRxe2_GiveCode() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-3: "Give Amount - Minimum" - creates it if necessary
     */
    public NM getGiveAmountMinimum() { 
        NM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-3: "Give Amount - Minimum" - creates it if necessary
     */
    public NM getRxe3_GiveAmountMinimum() { 
        NM ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-4: "Give Amount - Maximum" - creates it if necessary
     */
    public NM getGiveAmountMaximum() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-4: "Give Amount - Maximum" - creates it if necessary
     */
    public NM getRxe4_GiveAmountMaximum() { 
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-5: "Give Units" - creates it if necessary
     */
    public CE getGiveUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-5: "Give Units" - creates it if necessary
     */
    public CE getRxe5_GiveUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-6: "Give Dosage Form" - creates it if necessary
     */
    public CE getGiveDosageForm() { 
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-6: "Give Dosage Form" - creates it if necessary
     */
    public CE getRxe6_GiveDosageForm() { 
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Provider's Administration Instructions (RXE-7).
     */
    public CE[] getProviderSAdministrationInstructions() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Provider's Administration Instructions (RXE-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getProviderSAdministrationInstructionsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * RXE-7: "Provider's Administration Instructions" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getProviderSAdministrationInstructions(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * RXE-7: "Provider's Administration Instructions" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getRxe7_ProviderSAdministrationInstructions(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Provider's Administration Instructions (RXE-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getRxe7_ProviderSAdministrationInstructionsReps() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * RXE-7: "Provider's Administration Instructions" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertProviderSAdministrationInstructions(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * RXE-7: "Provider's Administration Instructions" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * RXE-7: "Provider's Administration Instructions" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeProviderSAdministrationInstructions(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * RXE-7: "Provider's Administration Instructions" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeRxe7_ProviderSAdministrationInstructions(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * RXE-8: "Deliver-to location" - creates it if necessary
     */
    public CM_LA1 getDeliverToLocation() { 
        CM_LA1 ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CM_LA1)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-8: "Deliver-to location" - creates it if necessary
     */
    public CM_LA1 getRxe8_DeliverToLocation() { 
        CM_LA1 ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (CM_LA1)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-9: "Substitution Status" - creates it if necessary
     */
    public ID getSubstitutionStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-9: "Substitution Status" - creates it if necessary
     */
    public ID getRxe9_SubstitutionStatus() { 
        ID ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-10: "Dispense Amount" - creates it if necessary
     */
    public NM getDispenseAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-10: "Dispense Amount" - creates it if necessary
     */
    public NM getRxe10_DispenseAmount() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-11: "Dispense Units" - creates it if necessary
     */
    public CE getDispenseUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-11: "Dispense Units" - creates it if necessary
     */
    public CE getRxe11_DispenseUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-12: "Number of Refills" - creates it if necessary
     */
    public NM getNumberOfRefills() { 
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-12: "Number of Refills" - creates it if necessary
     */
    public NM getRxe12_NumberOfRefills() { 
        NM ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-13: "Ordering Provider's DEA Number" - creates it if necessary
     */
    public CN getOrderingProviderSDEANumber() { 
        CN ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-13: "Ordering Provider's DEA Number" - creates it if necessary
     */
    public CN getRxe13_OrderingProviderSDEANumber() { 
        CN ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-14: "Pharmacist Verifier ID" - creates it if necessary
     */
    public CN getPharmacistVerifierID() { 
        CN ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-14: "Pharmacist Verifier ID" - creates it if necessary
     */
    public CN getRxe14_PharmacistVerifierID() { 
        CN ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-15: "Prescription Number" - creates it if necessary
     */
    public ST getPrescriptionNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-15: "Prescription Number" - creates it if necessary
     */
    public ST getRxe15_PrescriptionNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-16: "Number of Refills Remaining" - creates it if necessary
     */
    public NM getNumberOfRefillsRemaining() { 
        NM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-16: "Number of Refills Remaining" - creates it if necessary
     */
    public NM getRxe16_NumberOfRefillsRemaining() { 
        NM ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-17: "Number of refills / doses dispensed" - creates it if necessary
     */
    public NM getNumberOfRefillsDosesDispensed() { 
        NM ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-17: "Number of refills / doses dispensed" - creates it if necessary
     */
    public NM getRxe17_NumberOfRefillsDosesDispensed() { 
        NM ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-18: "Date / time of most recent refill or dose dispensed" - creates it if necessary
     */
    public TS getDateTimeOfMostRecentRefillOrDoseDispensed() { 
        TS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-18: "Date / time of most recent refill or dose dispensed" - creates it if necessary
     */
    public TS getRxe18_DateTimeOfMostRecentRefillOrDoseDispensed() { 
        TS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-19: "Total Daily Dose" - creates it if necessary
     */
    public CQ_QUANTITY getTotalDailyDose() { 
        CQ_QUANTITY ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CQ_QUANTITY)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-19: "Total Daily Dose" - creates it if necessary
     */
    public CQ_QUANTITY getRxe19_TotalDailyDose() { 
        CQ_QUANTITY ret = null;
        try {
            Type t = this.getField(19, 0);
            ret = (CQ_QUANTITY)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-20: "Needs Human Review" - creates it if necessary
     */
    public ID getNeedsHumanReview() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-20: "Needs Human Review" - creates it if necessary
     */
    public ID getRxe20_NeedsHumanReview() { 
        ID ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-21: "Pharmacy Special Dispensing Instructions" - creates it if necessary
     */
    public CE getPharmacySpecialDispensingInstructions() { 
        CE ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-21: "Pharmacy Special Dispensing Instructions" - creates it if necessary
     */
    public CE getRxe21_PharmacySpecialDispensingInstructions() { 
        CE ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-22: "Give Per (Time Unit)" - creates it if necessary
     */
    public ST getGivePerTimeUnit() { 
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-22: "Give Per (Time Unit)" - creates it if necessary
     */
    public ST getRxe22_GivePerTimeUnit() { 
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-23: "Give Rate Amount" - creates it if necessary
     */
    public CE getGiveRateAmount() { 
        CE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-23: "Give Rate Amount" - creates it if necessary
     */
    public CE getRxe23_GiveRateAmount() { 
        CE ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * RXE-24: "Give Rate Units" - creates it if necessary
     */
    public CE getGiveRateUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * RXE-24: "Give Rate Units" - creates it if necessary
     */
    public CE getRxe24_GiveRateUnits() { 
        CE ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new TQ(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new NM(getMessage());
          case 3: return new NM(getMessage());
          case 4: return new CE(getMessage());
          case 5: return new CE(getMessage());
          case 6: return new CE(getMessage());
          case 7: return new CM_LA1(getMessage());
          case 8: return new ID(getMessage(), new Integer( 167 ));
          case 9: return new NM(getMessage());
          case 10: return new CE(getMessage());
          case 11: return new NM(getMessage());
          case 12: return new CN(getMessage());
          case 13: return new CN(getMessage());
          case 14: return new ST(getMessage());
          case 15: return new NM(getMessage());
          case 16: return new NM(getMessage());
          case 17: return new TS(getMessage());
          case 18: return new CQ_QUANTITY(getMessage());
          case 19: return new ID(getMessage(), new Integer( 0 ));
          case 20: return new CE(getMessage());
          case 21: return new ST(getMessage());
          case 22: return new CE(getMessage());
          case 23: return new CE(getMessage());
          default: return null;
       }
   }


}

