/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v22.group.ORU_R03_OBSERVATION;
import ca.uhn.hl7v2.model.v22.segment.NTE;
import ca.uhn.hl7v2.model.v22.segment.OBR;
import ca.uhn.hl7v2.model.v22.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORU_R03_ORDER_OBSERVATION
extends AbstractGroup {
    public ORU_R03_ORDER_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(ORU_R03_OBSERVATION.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating ORU_R03_ORDER_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.2";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public ORU_R03_OBSERVATION getOBSERVATION() {
        ORU_R03_OBSERVATION ret = null;
        try {
            ret = (ORU_R03_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORU_R03_OBSERVATION getOBSERVATION(int rep) {
        ORU_R03_OBSERVATION ret = null;
        try {
            ret = (ORU_R03_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<ORU_R03_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", ORU_R03_OBSERVATION.class);
    }

    public void insertOBSERVATION(ORU_R03_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public ORU_R03_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R03_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public ORU_R03_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (ORU_R03_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

