/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CQ_QUANTITY;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class OM4
extends AbstractSegment {
    public OM4(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, false, 1, 3, new Object[]{this.getMessage()}, "Segment Type ID");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/ Observation Master File");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(170)}, "Derived Specimen");
            this.add(TX.class, false, 1, 60, new Object[]{this.getMessage()}, "Container Description");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Container Volume");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Container Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Specimen");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Additive");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Preparation");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Special Handling Requirements");
            this.add(CQ_QUANTITY.class, false, 1, 20, new Object[]{this.getMessage()}, "Normal Collection Volume");
            this.add(CQ_QUANTITY.class, false, 1, 20, new Object[]{this.getMessage()}, "Minimum Collection Volume");
            this.add(TX.class, false, 1, 10240, new Object[]{this.getMessage()}, "Specimen Requirements");
            this.add(ID.class, false, 0, 60, new Object[]{this.getMessage(), new Integer(27)}, "Specimen Priorities");
            this.add(CQ_QUANTITY.class, false, 1, 20, new Object[]{this.getMessage()}, "Specimen Retention Time");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OM4 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ST getSegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getOm41_SegmentTypeID() {
        ST retVal = (ST)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getOm42_SequenceNumberTestObservationMasterFile() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getDerivedSpecimen() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getOm43_DerivedSpecimen() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public TX getContainerDescription() {
        TX retVal = (TX)this.getTypedField(4, 0);
        return retVal;
    }

    public TX getOm44_ContainerDescription() {
        TX retVal = (TX)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getContainerVolume() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getOm45_ContainerVolume() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getContainerUnits() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getOm46_ContainerUnits() {
        CE retVal = (CE)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getSpecimen() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getOm47_Specimen() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getAdditive() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getOm48_Additive() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public TX getPreparation() {
        TX retVal = (TX)this.getTypedField(9, 0);
        return retVal;
    }

    public TX getOm49_Preparation() {
        TX retVal = (TX)this.getTypedField(9, 0);
        return retVal;
    }

    public TX getSpecialHandlingRequirements() {
        TX retVal = (TX)this.getTypedField(10, 0);
        return retVal;
    }

    public TX getOm410_SpecialHandlingRequirements() {
        TX retVal = (TX)this.getTypedField(10, 0);
        return retVal;
    }

    public CQ_QUANTITY getNormalCollectionVolume() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ_QUANTITY getOm411_NormalCollectionVolume() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(11, 0);
        return retVal;
    }

    public CQ_QUANTITY getMinimumCollectionVolume() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(12, 0);
        return retVal;
    }

    public CQ_QUANTITY getOm412_MinimumCollectionVolume() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(12, 0);
        return retVal;
    }

    public TX getSpecimenRequirements() {
        TX retVal = (TX)this.getTypedField(13, 0);
        return retVal;
    }

    public TX getOm413_SpecimenRequirements() {
        TX retVal = (TX)this.getTypedField(13, 0);
        return retVal;
    }

    public ID[] getSpecimenPriorities() {
        ID[] retVal = (ID[])this.getTypedField(14, (Type[])new ID[0]);
        return retVal;
    }

    public ID[] getOm414_SpecimenPriorities() {
        ID[] retVal = (ID[])this.getTypedField(14, (Type[])new ID[0]);
        return retVal;
    }

    public int getSpecimenPrioritiesReps() {
        return this.getReps(14);
    }

    public ID getSpecimenPriorities(int rep) {
        ID retVal = (ID)this.getTypedField(14, rep);
        return retVal;
    }

    public ID getOm414_SpecimenPriorities(int rep) {
        ID retVal = (ID)this.getTypedField(14, rep);
        return retVal;
    }

    public int getOm414_SpecimenPrioritiesReps() {
        return this.getReps(14);
    }

    public ID insertSpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(14, rep);
    }

    public ID insertOm414_SpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(14, rep);
    }

    public ID removeSpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(14, rep);
    }

    public ID removeOm414_SpecimenPriorities(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(14, rep);
    }

    public CQ_QUANTITY getSpecimenRetentionTime() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(15, 0);
        return retVal;
    }

    public CQ_QUANTITY getOm415_SpecimenRetentionTime() {
        CQ_QUANTITY retVal = (CQ_QUANTITY)this.getTypedField(15, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(170));
            }
            case 3: {
                return new TX(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new TX(this.getMessage());
            }
            case 9: {
                return new TX(this.getMessage());
            }
            case 10: {
                return new CQ_QUANTITY(this.getMessage());
            }
            case 11: {
                return new CQ_QUANTITY(this.getMessage());
            }
            case 12: {
                return new TX(this.getMessage());
            }
            case 13: {
                return new ID(this.getMessage(), new Integer(27));
            }
            case 14: {
                return new CQ_QUANTITY(this.getMessage());
            }
        }
        return null;
    }
}

