/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.HD;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.ST;

public class XON
extends AbstractComposite {
    private Type[] data;

    public XON(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[8];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new IS(this.getMessage(), 0);
        this.data[2] = new NM(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ID(this.getMessage(), 0);
        this.data[5] = new HD(this.getMessage());
        this.data[6] = new IS(this.getMessage(), 0);
        this.data[7] = new HD(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getOrganizationName() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getXon1_OrganizationName() {
        return (ST)this.getTyped(0, ST.class);
    }

    public IS getOrganizationNameTypeCode() {
        return (IS)this.getTyped(1, IS.class);
    }

    public IS getXon2_OrganizationNameTypeCode() {
        return (IS)this.getTyped(1, IS.class);
    }

    public NM getIDNumber() {
        return (NM)this.getTyped(2, NM.class);
    }

    public NM getXon3_IDNumber() {
        return (NM)this.getTyped(2, NM.class);
    }

    public ST getCheckDigit() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getXon4_CheckDigit() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ID getCodeIdentifyingTheCheckDigitSchemeEmployed() {
        return (ID)this.getTyped(4, ID.class);
    }

    public ID getXon5_CodeIdentifyingTheCheckDigitSchemeEmployed() {
        return (ID)this.getTyped(4, ID.class);
    }

    public HD getAssigningAuthority() {
        return (HD)this.getTyped(5, HD.class);
    }

    public HD getXon6_AssigningAuthority() {
        return (HD)this.getTyped(5, HD.class);
    }

    public IS getIdentifierTypeCode() {
        return (IS)this.getTyped(6, IS.class);
    }

    public IS getXon7_IdentifierTypeCode() {
        return (IS)this.getTyped(6, IS.class);
    }

    public HD getAssigningFacilityID() {
        return (HD)this.getTyped(7, HD.class);
    }

    public HD getXon8_AssigningFacilityID() {
        return (HD)this.getTyped(7, HD.class);
    }
}

