/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.CSU_C09_RXARXR;
import ca.uhn.hl7v2.model.v231.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSU_C09_ORCRXARXR
extends AbstractGroup {
    public CSU_C09_ORCRXARXR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(CSU_C09_RXARXR.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating CSU_C09_ORCRXARXR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_RXARXR getRXARXR() {
        CSU_C09_RXARXR ret = null;
        try {
            ret = (CSU_C09_RXARXR)this.get("RXARXR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_RXARXR getRXARXR(int rep) {
        CSU_C09_RXARXR ret = null;
        try {
            ret = (CSU_C09_RXARXR)this.get("RXARXR", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXARXRReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXARXR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CSU_C09_RXARXR> getRXARXRAll() throws HL7Exception {
        return this.getAllAsList("RXARXR", CSU_C09_RXARXR.class);
    }

    public void insertRXARXR(CSU_C09_RXARXR structure, int rep) throws HL7Exception {
        super.insertRepetition("RXARXR", (Structure)structure, rep);
    }

    public CSU_C09_RXARXR insertRXARXR(int rep) throws HL7Exception {
        return (CSU_C09_RXARXR)super.insertRepetition("RXARXR", rep);
    }

    public CSU_C09_RXARXR removeRXARXR(int rep) throws HL7Exception {
        return (CSU_C09_RXARXR)super.removeRepetition("RXARXR", rep);
    }
}

