/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.group.RAS_O01_OBXNTE;
import ca.uhn.hl7v2.model.v231.group.RAS_O01_RXERXRRXC;
import ca.uhn.hl7v2.model.v231.group.RAS_O01_RXONTERXRRXCNTE;
import ca.uhn.hl7v2.model.v231.segment.CTI;
import ca.uhn.hl7v2.model.v231.segment.ORC;
import ca.uhn.hl7v2.model.v231.segment.RXA;
import ca.uhn.hl7v2.model.v231.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI
extends AbstractGroup {
    public RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RAS_O01_RXONTERXRRXCNTE.class, false, false);
            this.add(RAS_O01_RXERXRRXC.class, false, false);
            this.add(RXA.class, true, true);
            this.add(RXR.class, true, false);
            this.add(RAS_O01_OBXNTE.class, false, true);
            this.add(CTI.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating RAS_O01_ORCRXONTERXRRXCNTERXERXRRXCRXARXROBXNTECTI - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_RXONTERXRRXCNTE getRXONTERXRRXCNTE() {
        RAS_O01_RXONTERXRRXCNTE ret = null;
        try {
            ret = (RAS_O01_RXONTERXRRXCNTE)this.get("RXONTERXRRXCNTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_RXERXRRXC getRXERXRRXC() {
        RAS_O01_RXERXRRXC ret = null;
        try {
            ret = (RAS_O01_RXERXRRXC)this.get("RXERXRRXC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXA getRXA() {
        RXA ret = null;
        try {
            ret = (RXA)this.get("RXA");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXA getRXA(int rep) {
        RXA ret = null;
        try {
            ret = (RXA)this.get("RXA", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXAReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXA").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RXA> getRXAAll() throws HL7Exception {
        return this.getAllAsList("RXA", RXA.class);
    }

    public void insertRXA(RXA structure, int rep) throws HL7Exception {
        super.insertRepetition("RXA", (Structure)structure, rep);
    }

    public RXA insertRXA(int rep) throws HL7Exception {
        return (RXA)super.insertRepetition("RXA", rep);
    }

    public RXA removeRXA(int rep) throws HL7Exception {
        return (RXA)super.removeRepetition("RXA", rep);
    }

    public RXR getRXR() {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_OBXNTE getOBXNTE() {
        RAS_O01_OBXNTE ret = null;
        try {
            ret = (RAS_O01_OBXNTE)this.get("OBXNTE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_OBXNTE getOBXNTE(int rep) {
        RAS_O01_OBXNTE ret = null;
        try {
            ret = (RAS_O01_OBXNTE)this.get("OBXNTE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBXNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBXNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<RAS_O01_OBXNTE> getOBXNTEAll() throws HL7Exception {
        return this.getAllAsList("OBXNTE", RAS_O01_OBXNTE.class);
    }

    public void insertOBXNTE(RAS_O01_OBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("OBXNTE", (Structure)structure, rep);
    }

    public RAS_O01_OBXNTE insertOBXNTE(int rep) throws HL7Exception {
        return (RAS_O01_OBXNTE)super.insertRepetition("OBXNTE", rep);
    }

    public RAS_O01_OBXNTE removeOBXNTE(int rep) throws HL7Exception {
        return (RAS_O01_OBXNTE)super.removeRepetition("OBXNTE", rep);
    }

    public CTI getCTI() {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTI getCTI(int rep) {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

