/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.NM;
import ca.uhn.hl7v2.model.v231.datatype.SCV;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.slf4j.LoggerFactory;

public class APR
extends AbstractSegment {
    public APR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SCV.class, false, 0, 80, new Object[]{this.getMessage()}, "Time Selection Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{this.getMessage()}, "Resource Selection Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{this.getMessage()}, "Location Selection Criteria");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Slot Spacing Criteria");
            this.add(SCV.class, false, 0, 80, new Object[]{this.getMessage()}, "Filler Override Criteria");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating APR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SCV[] getTimeSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(1);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getTimeSelectionCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV getTimeSelectionCriteria(int rep) {
        SCV ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SCV getApr1_TimeSelectionCriteria(int rep) {
        SCV ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getApr1_TimeSelectionCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(1);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertTimeSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(1, rep);
    }

    public SCV insertApr1_TimeSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(1, rep);
    }

    public SCV removeTimeSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(1, rep);
    }

    public SCV removeApr1_TimeSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(1, rep);
    }

    public SCV[] getResourceSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getResourceSelectionCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV getResourceSelectionCriteria(int rep) {
        SCV ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SCV getApr2_ResourceSelectionCriteria(int rep) {
        SCV ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getApr2_ResourceSelectionCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertResourceSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(2, rep);
    }

    public SCV insertApr2_ResourceSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(2, rep);
    }

    public SCV removeResourceSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(2, rep);
    }

    public SCV removeApr2_ResourceSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(2, rep);
    }

    public SCV[] getLocationSelectionCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getLocationSelectionCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV getLocationSelectionCriteria(int rep) {
        SCV ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SCV getApr3_LocationSelectionCriteria(int rep) {
        SCV ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getApr3_LocationSelectionCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertLocationSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(3, rep);
    }

    public SCV insertApr3_LocationSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(3, rep);
    }

    public SCV removeLocationSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(3, rep);
    }

    public SCV removeApr3_LocationSelectionCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(3, rep);
    }

    public NM getSlotSpacingCriteria() {
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getApr4_SlotSpacingCriteria() {
        NM ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SCV[] getFillerOverrideCriteria() {
        SCV[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new SCV[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SCV)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFillerOverrideCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV getFillerOverrideCriteria(int rep) {
        SCV ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SCV getApr5_FillerOverrideCriteria(int rep) {
        SCV ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SCV)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getApr5_FillerOverrideCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public SCV insertFillerOverrideCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(5, rep);
    }

    public SCV insertApr5_FillerOverrideCriteria(int rep) throws HL7Exception {
        return (SCV)super.insertRepetition(5, rep);
    }

    public SCV removeFillerOverrideCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(5, rep);
    }

    public SCV removeApr5_FillerOverrideCriteria(int rep) throws HL7Exception {
        return (SCV)super.removeRepetition(5, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SCV(this.getMessage());
            }
            case 1: {
                return new SCV(this.getMessage());
            }
            case 2: {
                return new SCV(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new SCV(this.getMessage());
            }
        }
        return null;
    }
}

