/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.CE;
import ca.uhn.hl7v2.model.v231.datatype.DLT;
import ca.uhn.hl7v2.model.v231.datatype.NM;
import ca.uhn.hl7v2.model.v231.datatype.NR;
import ca.uhn.hl7v2.model.v231.datatype.RFR;
import ca.uhn.hl7v2.model.v231.datatype.TX;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import org.slf4j.LoggerFactory;

public class OM2
extends AbstractSegment {
    public OM2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Sequence Number - Test/Observation Master File");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Units of Measure");
            this.add(NM.class, false, 0, 10, new Object[]{this.getMessage()}, "Range of Decimal Precision");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Corresponding SI Units of Measure");
            this.add(TX.class, false, 1, 60, new Object[]{this.getMessage()}, "SI Conversion Factor");
            this.add(RFR.class, false, 1, 200, new Object[]{this.getMessage()}, "Reference (Normal) Range - Ordinal & Continuous Obs");
            this.add(NR.class, false, 1, 200, new Object[]{this.getMessage()}, "Critical Range for Ordinal & Continuous Obs");
            this.add(RFR.class, false, 1, 200, new Object[]{this.getMessage()}, "Absolute Range for Ordinal & Continuous Obs");
            this.add(DLT.class, false, 0, 200, new Object[]{this.getMessage()}, "Delta Check Criteria");
            this.add(NM.class, false, 1, 20, new Object[]{this.getMessage()}, "Minimum Meaningful Increments");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating OM2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getSequenceNumberTestObservationMasterFile() {
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getOm21_SequenceNumberTestObservationMasterFile() {
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getUnitsOfMeasure() {
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getOm22_UnitsOfMeasure() {
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM[] getRangeOfDecimalPrecision() {
        NM[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new NM[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (NM)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRangeOfDecimalPrecisionReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public NM getRangeOfDecimalPrecision(int rep) {
        NM ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getOm23_RangeOfDecimalPrecision(int rep) {
        NM ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getOm23_RangeOfDecimalPrecisionReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public NM insertRangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(3, rep);
    }

    public NM insertOm23_RangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.insertRepetition(3, rep);
    }

    public NM removeRangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(3, rep);
    }

    public NM removeOm23_RangeOfDecimalPrecision(int rep) throws HL7Exception {
        return (NM)super.removeRepetition(3, rep);
    }

    public CE getCorrespondingSIUnitsOfMeasure() {
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getOm24_CorrespondingSIUnitsOfMeasure() {
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TX getSIConversionFactor() {
        TX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TX getOm25_SIConversionFactor() {
        TX ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (TX)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RFR getReferenceNormalRangeOrdinalContinuousObs() {
        RFR ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (RFR)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RFR getOm26_ReferenceNormalRangeOrdinalContinuousObs() {
        RFR ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (RFR)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NR getCriticalRangeForOrdinalContinuousObs() {
        NR ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NR)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NR getOm27_CriticalRangeForOrdinalContinuousObs() {
        NR ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (NR)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RFR getAbsoluteRangeForOrdinalContinuousObs() {
        RFR ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (RFR)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public RFR getOm28_AbsoluteRangeForOrdinalContinuousObs() {
        RFR ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (RFR)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DLT[] getDeltaCheckCriteria() {
        DLT[] ret = null;
        try {
            Type[] t = this.getField(9);
            ret = new DLT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (DLT)t[i];
            }
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getDeltaCheckCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public DLT getDeltaCheckCriteria(int rep) {
        DLT ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (DLT)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DLT getOm29_DeltaCheckCriteria(int rep) {
        DLT ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (DLT)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getOm29_DeltaCheckCriteriaReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
    }

    public DLT insertDeltaCheckCriteria(int rep) throws HL7Exception {
        return (DLT)super.insertRepetition(9, rep);
    }

    public DLT insertOm29_DeltaCheckCriteria(int rep) throws HL7Exception {
        return (DLT)super.insertRepetition(9, rep);
    }

    public DLT removeDeltaCheckCriteria(int rep) throws HL7Exception {
        return (DLT)super.removeRepetition(9, rep);
    }

    public DLT removeOm29_DeltaCheckCriteria(int rep) throws HL7Exception {
        return (DLT)super.removeRepetition(9, rep);
    }

    public NM getMinimumMeaningfulIncrements() {
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getOm210_MinimumMeaningfulIncrements() {
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected problem obtaining field value.  This is a bug.", (Throwable)he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new TX(this.getMessage());
            }
            case 5: {
                return new RFR(this.getMessage());
            }
            case 6: {
                return new NR(this.getMessage());
            }
            case 7: {
                return new RFR(this.getMessage());
            }
            case 8: {
                return new DLT(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
        }
        return null;
    }
}

